/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.openlineage.client.ConfigPathProvider;
import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClientException;
import io.openlineage.client.OpenLineageYaml;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenLineageClientUtils {
    private static final Logger log = LoggerFactory.getLogger(OpenLineageClientUtils.class);
    private static final ObjectMapper MAPPER = OpenLineageClientUtils.newObjectMapper();
    private static final ObjectMapper YML = new ObjectMapper(new YAMLFactory());
    private static final ObjectMapper JSON = new ObjectMapper(new JsonFactory());

    private OpenLineageClientUtils() {
    }

    public static ObjectMapper newObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule(new Jdk8Module());
        mapper.registerModule(new JavaTimeModule());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return mapper;
    }

    public static void configureObjectMapper(String ... disableFacets) {
        if (disableFacets == null) {
            return;
        }
        SimpleFilterProvider simpleFilterProvider = new SimpleFilterProvider().addFilter("disabledFacets", SimpleBeanPropertyFilter.serializeAllExcept(disableFacets));
        MAPPER.setFilterProvider(simpleFilterProvider);
        MAPPER.addMixIn(Object.class, DisabledFacetsMixin.class);
    }

    public static String toJson(@NonNull Object value) throws UncheckedIOException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        try {
            return MAPPER.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> T fromJson(@NonNull String json, @NonNull TypeReference<T> type) throws UncheckedIOException {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        try {
            return MAPPER.readValue(json, type);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static OpenLineage.RunEvent runEventFromJson(@NonNull String json) throws UncheckedIOException {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        return OpenLineageClientUtils.fromJson(json, new TypeReference<OpenLineage.RunEvent>(){});
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return MAPPER.convertValue(fromValue, toValueType);
    }

    public static <T, F> T mergeFacets(Map<String, F> facetsMap, T facetsContainer, Class<T> klass) {
        if (facetsContainer == null) {
            return MAPPER.convertValue(facetsMap, klass);
        }
        Map targetMap = (Map)MAPPER.convertValue(facetsContainer, new TypeReference<Map<String, F>>(){});
        targetMap.putAll(facetsMap);
        return MAPPER.convertValue((Object)targetMap, klass);
    }

    public static URI toUri(@NonNull String urlString) throws OpenLineageClientException {
        if (urlString == null) {
            throw new NullPointerException("urlString is marked non-null but is null");
        }
        try {
            String urlStringWithNoTrailingSlash = urlString.endsWith("/") ? urlString.substring(0, urlString.length() - 1) : urlString;
            return new URI(urlStringWithNoTrailingSlash);
        }
        catch (URISyntaxException e) {
            throw new OpenLineageClientException("Malformed URI: " + urlString, e);
        }
    }

    public static OpenLineageYaml loadOpenLineageYaml(ConfigPathProvider configPathProvider) throws OpenLineageClientException {
        try {
            Objects.requireNonNull(configPathProvider);
            List<Path> paths = configPathProvider.getPaths();
            for (Path path : paths) {
                if (!Files.exists(path, new LinkOption[0])) continue;
                return YML.readValue(path.toFile(), OpenLineageYaml.class);
            }
            String concatenatedPaths = paths.stream().map(Path::toString).collect(Collectors.joining(";", "[", "]"));
            throw new FileNotFoundException("No OpenLineage configuration file found at provided paths, looked in: " + concatenatedPaths);
        }
        catch (NullPointerException e) {
            throw new OpenLineageClientException("ConfigPathProvider was null");
        }
        catch (FileNotFoundException e) {
            throw new OpenLineageClientException("No OpenLineage configuration file found");
        }
        catch (IOException e) {
            throw new OpenLineageClientException(e);
        }
    }

    public static OpenLineageYaml loadOpenLineageYaml(InputStream inputStream) throws OpenLineageClientException {
        try {
            return OpenLineageClientUtils.deserializeInputStream(YML, inputStream);
        }
        catch (IOException e) {
            log.warn("Error deserializing OpenLineage YAML, falling back to JSON", e);
            return OpenLineageClientUtils.loadOpenLineageJson(inputStream);
        }
    }

    public static OpenLineageYaml loadOpenLineageJson(InputStream inputStream) throws OpenLineageClientException {
        try {
            return OpenLineageClientUtils.deserializeInputStream(JSON, inputStream);
        }
        catch (IOException e) {
            throw new OpenLineageClientException(e);
        }
    }

    private static OpenLineageYaml deserializeInputStream(ObjectMapper deserializer, InputStream inputStream) throws IOException {
        return deserializer.readValue(inputStream, OpenLineageYaml.class);
    }

    @JsonFilter(value="disabledFacets")
    public class DisabledFacetsMixin {
    }
}

