/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.transports;

import io.openlineage.client.transports.KafkaConfig;
import io.openlineage.client.transports.KafkaTransport;
import io.openlineage.client.transports.Transport;
import io.openlineage.client.transports.TransportBuilder;
import io.openlineage.client.transports.TransportConfig;

public class KafkaTransportBuilder
implements TransportBuilder {
    private static final String DEFAULT_LINEAGE_SOURCE = "openlineage-java";

    @Override
    public TransportConfig getConfig() {
        return new KafkaConfig();
    }

    @Override
    public Transport build(TransportConfig config) {
        KafkaConfig kafkaConfig = (KafkaConfig)config;
        if (!kafkaConfig.hasLocalServerId()) {
            kafkaConfig.setLocalServerId(DEFAULT_LINEAGE_SOURCE);
        }
        kafkaConfig.getProperties().put("server.id", kafkaConfig.getLocalServerId());
        return new KafkaTransport(kafkaConfig);
    }

    @Override
    public String getType() {
        return "kafka";
    }
}

