/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.transports;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClientException;
import io.openlineage.client.Utils;
import io.openlineage.client.transports.ApiKeyTokenProvider;
import io.openlineage.client.transports.HttpConfig;
import io.openlineage.client.transports.TokenProvider;
import io.openlineage.client.transports.Transport;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpTransport
extends Transport
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(HttpTransport.class);
    private static final String API_V1 = "/api/v1";
    private final HttpClient http;
    private final URI uri;
    @Nullable
    private final TokenProvider tokenProvider;

    public HttpTransport(@NonNull HttpConfig httpConfig) {
        this((HttpClient)HttpClientBuilder.create().build(), httpConfig);
        if (httpConfig == null) {
            throw new NullPointerException("httpConfig is marked non-null but is null");
        }
    }

    public HttpTransport(@NonNull HttpClient httpClient, @NonNull HttpConfig httpConfig) {
        super(Transport.Type.HTTP);
        if (httpClient == null) {
            throw new NullPointerException("httpClient is marked non-null but is null");
        }
        if (httpConfig == null) {
            throw new NullPointerException("httpConfig is marked non-null but is null");
        }
        this.http = httpClient;
        try {
            this.uri = new URIBuilder(httpConfig.getUrl()).setPath(httpConfig.getUrl().getPath() + API_V1 + "/lineage").build();
        }
        catch (URISyntaxException e) {
            throw new OpenLineageClientException(e);
        }
        this.tokenProvider = httpConfig.getAuth();
    }

    @Override
    public void emit(@NonNull OpenLineage.RunEvent runEvent) {
        if (runEvent == null) {
            throw new NullPointerException("runEvent is marked non-null but is null");
        }
        String eventAsJson = Utils.toJson(runEvent);
        log.debug("POST {}: {}", (Object)this.uri, (Object)eventAsJson);
        try {
            HttpPost request = new HttpPost();
            request.setURI(this.uri);
            request.addHeader("Accept", ContentType.APPLICATION_JSON.toString());
            request.addHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
            request.setEntity((HttpEntity)new StringEntity(eventAsJson, ContentType.APPLICATION_JSON));
            if (this.tokenProvider != null) {
                request.addHeader("Authorization", this.tokenProvider.getToken());
            }
            HttpResponse response = this.http.execute((HttpUriRequest)request);
            this.throwOnHttpError(response);
        }
        catch (IOException e) {
            throw new OpenLineageClientException(e);
        }
    }

    private void throwOnHttpError(@NonNull HttpResponse response) throws IOException {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        int code = response.getStatusLine().getStatusCode();
        if (code >= 400 && code < 600) {
            throw new OpenLineageClientException(EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.http instanceof Closeable) {
            ((Closeable)this.http).close();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final URI DEFAULT_OPENLINEAGE_URI = Utils.toUri("http://localhost:8080");
        private URI uri = DEFAULT_OPENLINEAGE_URI;
        @Nullable
        private HttpClient httpClient;
        @Nullable
        private TokenProvider tokenProvider;

        private Builder() {
        }

        public Builder uri(@NonNull String urlAsString) {
            if (urlAsString == null) {
                throw new NullPointerException("urlAsString is marked non-null but is null");
            }
            return this.uri(Utils.toUri(urlAsString));
        }

        public Builder uri(@NonNull String urlAsString, @NonNull Map<String, String> queryParams) {
            if (urlAsString == null) {
                throw new NullPointerException("urlAsString is marked non-null but is null");
            }
            if (queryParams == null) {
                throw new NullPointerException("queryParams is marked non-null but is null");
            }
            return this.uri(Utils.toUri(urlAsString), queryParams);
        }

        public Builder uri(@NonNull URI uri) {
            if (uri == null) {
                throw new NullPointerException("uri is marked non-null but is null");
            }
            return this.uri(uri, Collections.emptyMap());
        }

        public Builder uri(@NonNull URI uri, @NonNull Map<String, String> queryParams) {
            if (uri == null) {
                throw new NullPointerException("uri is marked non-null but is null");
            }
            if (queryParams == null) {
                throw new NullPointerException("queryParams is marked non-null but is null");
            }
            try {
                URIBuilder builder = new URIBuilder(uri);
                queryParams.forEach((arg_0, arg_1) -> ((URIBuilder)builder).addParameter(arg_0, arg_1));
                this.uri = builder.build();
            }
            catch (URISyntaxException e) {
                throw new OpenLineageClientException(e);
            }
            return this;
        }

        public Builder http(@NonNull HttpClient httpClient) {
            if (httpClient == null) {
                throw new NullPointerException("httpClient is marked non-null but is null");
            }
            this.httpClient = httpClient;
            return this;
        }

        public Builder tokenProvider(@Nullable TokenProvider tokenProvider) {
            this.tokenProvider = tokenProvider;
            return this;
        }

        public Builder apiKey(@Nullable String apiKey) {
            ApiKeyTokenProvider apiKeyTokenProvider = new ApiKeyTokenProvider();
            apiKeyTokenProvider.setApiKey(apiKey);
            this.tokenProvider = apiKeyTokenProvider;
            return this;
        }

        public HttpTransport build() {
            HttpConfig httpConfig = new HttpConfig();
            httpConfig.setUrl(this.uri);
            httpConfig.setAuth(this.tokenProvider);
            if (this.httpClient != null) {
                return new HttpTransport(this.httpClient, httpConfig);
            }
            return new HttpTransport(httpConfig);
        }
    }
}

