/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.server;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class OpenLineage {

    @JsonPropertyOrder(value={"_producer", "_schemaURL"})
    public static final class JobFacet
    implements BaseFacet {
        private final URI _producer;
        private final URI _schemaURL;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public JobFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="_schemaURL") URI _schemaURL) {
            this._producer = _producer;
            this._schemaURL = _schemaURL;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    @JsonPropertyOrder(value={"_producer", "_schemaURL"})
    public static final class InputDatasetFacet
    implements BaseFacet {
        private final URI _producer;
        private final URI _schemaURL;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public InputDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="_schemaURL") URI _schemaURL) {
            this._producer = _producer;
            this._schemaURL = _schemaURL;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    @JsonPropertyOrder(value={"namespace", "name", "facets"})
    public static final class Job {
        private final String namespace;
        private final String name;
        private final JobFacets facets;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public Job(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name, @JsonProperty(value="facets") JobFacets facets) {
            this.namespace = namespace;
            this.name = name;
            this.facets = facets;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public JobFacets getFacets() {
            return this.facets;
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    @JsonPropertyOrder(value={"namespace", "name", "facets", "inputFacets"})
    public static final class InputDataset
    implements Dataset {
        private final String namespace;
        private final String name;
        private final DatasetFacets facets;
        private final InputDatasetInputFacets inputFacets;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public InputDataset(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name, @JsonProperty(value="facets") DatasetFacets facets, @JsonProperty(value="inputFacets") InputDatasetInputFacets inputFacets) {
            this.namespace = namespace;
            this.name = name;
            this.facets = facets;
            this.inputFacets = inputFacets;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DatasetFacets getFacets() {
            return this.facets;
        }

        public InputDatasetInputFacets getInputFacets() {
            return this.inputFacets;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public static interface BaseFacet {
        public URI get_producer();

        public URI get_schemaURL();

        public Map<String, Object> getAdditionalProperties();
    }

    @JsonPropertyOrder(value={"namespace", "name", "facets", "outputFacets"})
    public static final class OutputDataset
    implements Dataset {
        private final String namespace;
        private final String name;
        private final DatasetFacets facets;
        private final OutputDatasetOutputFacets outputFacets;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public OutputDataset(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name, @JsonProperty(value="facets") DatasetFacets facets, @JsonProperty(value="outputFacets") OutputDatasetOutputFacets outputFacets) {
            this.namespace = namespace;
            this.name = name;
            this.facets = facets;
            this.outputFacets = outputFacets;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DatasetFacets getFacets() {
            return this.facets;
        }

        public OutputDatasetOutputFacets getOutputFacets() {
            return this.outputFacets;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    @JsonPropertyOrder(value={"_producer", "_schemaURL"})
    public static final class RunFacet
    implements BaseFacet {
        private final URI _producer;
        private final URI _schemaURL;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public RunFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="_schemaURL") URI _schemaURL) {
            this._producer = _producer;
            this._schemaURL = _schemaURL;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    @JsonPropertyOrder
    public static final class OutputDatasetOutputFacets {
        @JsonAnySetter
        private final Map<String, OutputDatasetFacet> additionalProperties = new LinkedHashMap<String, OutputDatasetFacet>();

        @JsonCreator
        public OutputDatasetOutputFacets() {
        }

        @JsonAnyGetter
        public Map<String, OutputDatasetFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public static interface Dataset {
        public String getNamespace();

        public String getName();

        public DatasetFacets getFacets();

        public Map<String, Object> getAdditionalProperties();
    }

    @JsonPropertyOrder(value={"runId", "facets"})
    public static final class Run {
        private final UUID runId;
        private final RunFacets facets;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public Run(@JsonProperty(value="runId") UUID runId, @JsonProperty(value="facets") RunFacets facets) {
            this.runId = runId;
            this.facets = facets;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        public UUID getRunId() {
            return this.runId;
        }

        public RunFacets getFacets() {
            return this.facets;
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    @JsonPropertyOrder
    public static final class DatasetFacets {
        @JsonAnySetter
        private final Map<String, DatasetFacet> additionalProperties = new LinkedHashMap<String, DatasetFacet>();

        @JsonCreator
        public DatasetFacets() {
        }

        @JsonAnyGetter
        public Map<String, DatasetFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    @JsonPropertyOrder(value={"_producer", "_schemaURL"})
    public static final class OutputDatasetFacet
    implements BaseFacet {
        private final URI _producer;
        private final URI _schemaURL;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public OutputDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="_schemaURL") URI _schemaURL) {
            this._producer = _producer;
            this._schemaURL = _schemaURL;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    @JsonPropertyOrder(value={"_producer", "_schemaURL"})
    public static final class DatasetFacet
    implements BaseFacet {
        private final URI _producer;
        private final URI _schemaURL;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public DatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="_schemaURL") URI _schemaURL) {
            this._producer = _producer;
            this._schemaURL = _schemaURL;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    @JsonPropertyOrder
    public static final class InputDatasetInputFacets {
        @JsonAnySetter
        private final Map<String, InputDatasetFacet> additionalProperties = new LinkedHashMap<String, InputDatasetFacet>();

        @JsonCreator
        public InputDatasetInputFacets() {
        }

        @JsonAnyGetter
        public Map<String, InputDatasetFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    @JsonPropertyOrder
    public static final class JobFacets {
        @JsonAnySetter
        private final Map<String, JobFacet> additionalProperties = new LinkedHashMap<String, JobFacet>();

        @JsonCreator
        public JobFacets() {
        }

        @JsonAnyGetter
        public Map<String, JobFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    @JsonPropertyOrder(value={"eventType", "eventTime", "run", "job", "inputs", "outputs", "producer", "schemaURL"})
    public static final class RunEvent {
        private final String eventType;
        private final ZonedDateTime eventTime;
        private final Run run;
        private final Job job;
        private final List<InputDataset> inputs;
        private final List<OutputDataset> outputs;
        private final URI producer;
        private final URI schemaURL;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public RunEvent(@JsonProperty(value="eventType") String eventType, @JsonProperty(value="eventTime") ZonedDateTime eventTime, @JsonProperty(value="run") Run run, @JsonProperty(value="job") Job job, @JsonProperty(value="inputs") List<InputDataset> inputs, @JsonProperty(value="outputs") List<OutputDataset> outputs, @JsonProperty(value="producer") URI producer, @JsonProperty(value="schemaURL") URI schemaURL) {
            this.eventType = eventType;
            this.eventTime = eventTime;
            this.run = run;
            this.job = job;
            this.inputs = inputs;
            this.outputs = outputs;
            this.producer = producer;
            this.schemaURL = schemaURL;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        public String getEventType() {
            return this.eventType;
        }

        public ZonedDateTime getEventTime() {
            return this.eventTime;
        }

        public Run getRun() {
            return this.run;
        }

        public Job getJob() {
            return this.job;
        }

        public List<InputDataset> getInputs() {
            return this.inputs;
        }

        public List<OutputDataset> getOutputs() {
            return this.outputs;
        }

        public URI getProducer() {
            return this.producer;
        }

        public URI getSchemaURL() {
            return this.schemaURL;
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    @JsonPropertyOrder
    public static final class RunFacets {
        @JsonAnySetter
        private final Map<String, RunFacet> additionalProperties = new LinkedHashMap<String, RunFacet>();

        @JsonCreator
        public RunFacets() {
        }

        @JsonAnyGetter
        public Map<String, RunFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public static interface Builder<T> {
        public T build();
    }
}

