/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class OpenLineage {
    private final URI producer;

    public OpenLineage(URI producer) {
        this.producer = producer;
    }

    public RunFacets newRunFacets(ParentRunFacet parent, NominalTimeRunFacet nominalTime) {
        return new RunFacets(parent, nominalTime);
    }

    public RunFacetsBuilder newRunFacetsBuilder() {
        return new RunFacetsBuilder();
    }

    public RunEvent newRunEvent(String eventType, ZonedDateTime eventTime, Run run, Job job, List<InputDataset> inputs, List<OutputDataset> outputs) {
        return new RunEvent(eventType, eventTime, run, job, inputs, outputs, this.producer);
    }

    public RunEventBuilder newRunEventBuilder() {
        return new RunEventBuilder();
    }

    public SchemaDatasetFacetFields newSchemaDatasetFacetFields(String name, String type, String description) {
        return new SchemaDatasetFacetFields(name, type, description);
    }

    public SchemaDatasetFacetFieldsBuilder newSchemaDatasetFacetFieldsBuilder() {
        return new SchemaDatasetFacetFieldsBuilder();
    }

    public SchemaDatasetFacet newSchemaDatasetFacet(List<SchemaDatasetFacetFields> fields) {
        return new SchemaDatasetFacet(this.producer, fields);
    }

    public SchemaDatasetFacetBuilder newSchemaDatasetFacetBuilder() {
        return new SchemaDatasetFacetBuilder();
    }

    public DocumentationDatasetFacet newDocumentationDatasetFacet(String description) {
        return new DocumentationDatasetFacet(this.producer, description);
    }

    public DocumentationDatasetFacetBuilder newDocumentationDatasetFacetBuilder() {
        return new DocumentationDatasetFacetBuilder();
    }

    public ParentRunFacet newParentRunFacet(ParentRunFacetRun run, ParentRunFacetJob job) {
        return new ParentRunFacet(this.producer, run, job);
    }

    public ParentRunFacetBuilder newParentRunFacetBuilder() {
        return new ParentRunFacetBuilder();
    }

    public OutputStatisticsOutputDatasetFacet newOutputStatisticsOutputDatasetFacet(Long rowCount, Long size) {
        return new OutputStatisticsOutputDatasetFacet(this.producer, rowCount, size);
    }

    public OutputStatisticsOutputDatasetFacetBuilder newOutputStatisticsOutputDatasetFacetBuilder() {
        return new OutputStatisticsOutputDatasetFacetBuilder();
    }

    public SourceCodeLocationJobFacet newSourceCodeLocationJobFacet(String type, URI url, String repoUrl, String path, String version, String tag, String branch) {
        return new SourceCodeLocationJobFacet(this.producer, type, url, repoUrl, path, version, tag, branch);
    }

    public SourceCodeLocationJobFacetBuilder newSourceCodeLocationJobFacetBuilder() {
        return new SourceCodeLocationJobFacetBuilder();
    }

    public DataQualityAssertionsDatasetFacet newDataQualityAssertionsDatasetFacet(List<DataQualityAssertionsDatasetFacetAssertions> assertions) {
        return new DataQualityAssertionsDatasetFacet(this.producer, assertions);
    }

    public DataQualityAssertionsDatasetFacetBuilder newDataQualityAssertionsDatasetFacetBuilder() {
        return new DataQualityAssertionsDatasetFacetBuilder();
    }

    public Run newRun(UUID runId, RunFacets facets) {
        return new Run(runId, facets);
    }

    public RunBuilder newRunBuilder() {
        return new RunBuilder();
    }

    public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles newDataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles() {
        return new DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles();
    }

    public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantilesBuilder newDataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantilesBuilder() {
        return new DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantilesBuilder();
    }

    public OutputDatasetOutputFacets newOutputDatasetOutputFacets(OutputStatisticsOutputDatasetFacet outputStatistics) {
        return new OutputDatasetOutputFacets(outputStatistics);
    }

    public OutputDatasetOutputFacetsBuilder newOutputDatasetOutputFacetsBuilder() {
        return new OutputDatasetOutputFacetsBuilder();
    }

    public NominalTimeRunFacet newNominalTimeRunFacet(ZonedDateTime nominalStartTime, ZonedDateTime nominalEndTime) {
        return new NominalTimeRunFacet(this.producer, nominalStartTime, nominalEndTime);
    }

    public NominalTimeRunFacetBuilder newNominalTimeRunFacetBuilder() {
        return new NominalTimeRunFacetBuilder();
    }

    public RunFacet newRunFacet() {
        return new DefaultRunFacet(this.producer);
    }

    public Job newJob(String namespace, String name, JobFacets facets) {
        return new Job(namespace, name, facets);
    }

    public JobBuilder newJobBuilder() {
        return new JobBuilder();
    }

    public InputDatasetFacet newInputDatasetFacet() {
        return new DefaultInputDatasetFacet(this.producer);
    }

    public DataQualityMetricsInputDatasetFacetColumnMetricsAdditional newDataQualityMetricsInputDatasetFacetColumnMetricsAdditional(Long nullCount, Long distinctCount, Double sum, Double count, Double min, Double max, DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles quantiles) {
        return new DataQualityMetricsInputDatasetFacetColumnMetricsAdditional(nullCount, distinctCount, sum, count, min, max, quantiles);
    }

    public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder newDataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder() {
        return new DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder();
    }

    public DataQualityMetricsInputDatasetFacetColumnMetrics newDataQualityMetricsInputDatasetFacetColumnMetrics() {
        return new DataQualityMetricsInputDatasetFacetColumnMetrics();
    }

    public DataQualityMetricsInputDatasetFacetColumnMetricsBuilder newDataQualityMetricsInputDatasetFacetColumnMetricsBuilder() {
        return new DataQualityMetricsInputDatasetFacetColumnMetricsBuilder();
    }

    public DataQualityAssertionsDatasetFacetAssertions newDataQualityAssertionsDatasetFacetAssertions(String assertion, Boolean success, String column) {
        return new DataQualityAssertionsDatasetFacetAssertions(assertion, success, column);
    }

    public DataQualityAssertionsDatasetFacetAssertionsBuilder newDataQualityAssertionsDatasetFacetAssertionsBuilder() {
        return new DataQualityAssertionsDatasetFacetAssertionsBuilder();
    }

    public DataQualityMetricsInputDatasetFacet newDataQualityMetricsInputDatasetFacet(Long rowCount, Long bytes, DataQualityMetricsInputDatasetFacetColumnMetrics columnMetrics) {
        return new DataQualityMetricsInputDatasetFacet(this.producer, rowCount, bytes, columnMetrics);
    }

    public DataQualityMetricsInputDatasetFacetBuilder newDataQualityMetricsInputDatasetFacetBuilder() {
        return new DataQualityMetricsInputDatasetFacetBuilder();
    }

    public ParentRunFacetRun newParentRunFacetRun(UUID runId) {
        return new ParentRunFacetRun(runId);
    }

    public ParentRunFacetRunBuilder newParentRunFacetRunBuilder() {
        return new ParentRunFacetRunBuilder();
    }

    public DocumentationJobFacet newDocumentationJobFacet(String description) {
        return new DocumentationJobFacet(this.producer, description);
    }

    public DocumentationJobFacetBuilder newDocumentationJobFacetBuilder() {
        return new DocumentationJobFacetBuilder();
    }

    public JobFacets newJobFacets(SourceCodeLocationJobFacet sourceCodeLocation, SQLJobFacet sql, DocumentationJobFacet documentation) {
        return new JobFacets(sourceCodeLocation, sql, documentation);
    }

    public JobFacetsBuilder newJobFacetsBuilder() {
        return new JobFacetsBuilder();
    }

    public InputDatasetInputFacets newInputDatasetInputFacets(DataQualityAssertionsDatasetFacet dataQualityAssertions, DataQualityMetricsInputDatasetFacet dataQualityMetrics) {
        return new InputDatasetInputFacets(dataQualityAssertions, dataQualityMetrics);
    }

    public InputDatasetInputFacetsBuilder newInputDatasetInputFacetsBuilder() {
        return new InputDatasetInputFacetsBuilder();
    }

    public DatasetFacet newDatasetFacet() {
        return new DefaultDatasetFacet(this.producer);
    }

    public OutputDatasetFacet newOutputDatasetFacet() {
        return new DefaultOutputDatasetFacet(this.producer);
    }

    public SQLJobFacet newSQLJobFacet(String query) {
        return new SQLJobFacet(this.producer, query);
    }

    public SQLJobFacetBuilder newSQLJobFacetBuilder() {
        return new SQLJobFacetBuilder();
    }

    public DatasetFacets newDatasetFacets(DocumentationDatasetFacet documentation, DatasourceDatasetFacet dataSource, SchemaDatasetFacet schema) {
        return new DatasetFacets(documentation, dataSource, schema);
    }

    public DatasetFacetsBuilder newDatasetFacetsBuilder() {
        return new DatasetFacetsBuilder();
    }

    public ParentRunFacetJob newParentRunFacetJob(String namespace, String name) {
        return new ParentRunFacetJob(namespace, name);
    }

    public ParentRunFacetJobBuilder newParentRunFacetJobBuilder() {
        return new ParentRunFacetJobBuilder();
    }

    public OutputDataset newOutputDataset(String namespace, String name, DatasetFacets facets, OutputDatasetOutputFacets outputFacets) {
        return new OutputDataset(namespace, name, facets, outputFacets);
    }

    public OutputDatasetBuilder newOutputDatasetBuilder() {
        return new OutputDatasetBuilder();
    }

    public InputDataset newInputDataset(String namespace, String name, DatasetFacets facets, InputDatasetInputFacets inputFacets) {
        return new InputDataset(namespace, name, facets, inputFacets);
    }

    public InputDatasetBuilder newInputDatasetBuilder() {
        return new InputDatasetBuilder();
    }

    public DatasourceDatasetFacet newDatasourceDatasetFacet(String name, URI uri) {
        return new DatasourceDatasetFacet(this.producer, name, uri);
    }

    public DatasourceDatasetFacetBuilder newDatasourceDatasetFacetBuilder() {
        return new DatasourceDatasetFacetBuilder();
    }

    public JobFacet newJobFacet() {
        return new DefaultJobFacet(this.producer);
    }

    @JsonDeserialize(as=DefaultJobFacet.class)
    public static interface JobFacet {
        public URI get_producer();

        public URI get_schemaURL();

        public Map<String, Object> getAdditionalProperties();
    }

    public static class DefaultJobFacet
    implements JobFacet {
        private final URI _producer;
        private final URI _schemaURL;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public DefaultJobFacet(@JsonProperty(value="_producer") URI _producer) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/1-0-2/OpenLineage.json#/$defs/JobFacet");
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public final class DatasourceDatasetFacetBuilder {
        private String name;
        private URI uri;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public DatasourceDatasetFacetBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DatasourceDatasetFacetBuilder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public DatasourceDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        public DatasourceDatasetFacet build() {
            DatasourceDatasetFacet __result = new DatasourceDatasetFacet(OpenLineage.this.producer, this.name, this.uri);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DatasourceDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "name", "uri"})
    public static final class DatasourceDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final String name;
        private final URI uri;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private DatasourceDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="name") String name, @JsonProperty(value="uri") URI uri) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/DatasourceDatasetFacet.json#/$defs/DatasourceDatasetFacet");
            this.name = name;
            this.uri = uri;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public String getName() {
            return this.name;
        }

        public URI getUri() {
            return this.uri;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public static final class InputDatasetBuilder {
        private String namespace;
        private String name;
        private DatasetFacets facets;
        private InputDatasetInputFacets inputFacets;

        public InputDatasetBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public InputDatasetBuilder name(String name) {
            this.name = name;
            return this;
        }

        public InputDatasetBuilder facets(DatasetFacets facets) {
            this.facets = facets;
            return this;
        }

        public InputDatasetBuilder inputFacets(InputDatasetInputFacets inputFacets) {
            this.inputFacets = inputFacets;
            return this;
        }

        public InputDataset build() {
            InputDataset __result = new InputDataset(this.namespace, this.name, this.facets, this.inputFacets);
            return __result;
        }
    }

    @JsonDeserialize(as=InputDataset.class)
    @JsonPropertyOrder(value={"namespace", "name", "facets", "inputFacets"})
    public static final class InputDataset
    implements Dataset {
        private final String namespace;
        private final String name;
        private final DatasetFacets facets;
        private final InputDatasetInputFacets inputFacets;

        @JsonCreator
        private InputDataset(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name, @JsonProperty(value="facets") DatasetFacets facets, @JsonProperty(value="inputFacets") InputDatasetInputFacets inputFacets) {
            this.namespace = namespace;
            this.name = name;
            this.facets = facets;
            this.inputFacets = inputFacets;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DatasetFacets getFacets() {
            return this.facets;
        }

        public InputDatasetInputFacets getInputFacets() {
            return this.inputFacets;
        }
    }

    public static final class OutputDatasetBuilder {
        private String namespace;
        private String name;
        private DatasetFacets facets;
        private OutputDatasetOutputFacets outputFacets;

        public OutputDatasetBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public OutputDatasetBuilder name(String name) {
            this.name = name;
            return this;
        }

        public OutputDatasetBuilder facets(DatasetFacets facets) {
            this.facets = facets;
            return this;
        }

        public OutputDatasetBuilder outputFacets(OutputDatasetOutputFacets outputFacets) {
            this.outputFacets = outputFacets;
            return this;
        }

        public OutputDataset build() {
            OutputDataset __result = new OutputDataset(this.namespace, this.name, this.facets, this.outputFacets);
            return __result;
        }
    }

    @JsonDeserialize(as=OutputDataset.class)
    @JsonPropertyOrder(value={"namespace", "name", "facets", "outputFacets"})
    public static final class OutputDataset
    implements Dataset {
        private final String namespace;
        private final String name;
        private final DatasetFacets facets;
        private final OutputDatasetOutputFacets outputFacets;

        @JsonCreator
        private OutputDataset(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name, @JsonProperty(value="facets") DatasetFacets facets, @JsonProperty(value="outputFacets") OutputDatasetOutputFacets outputFacets) {
            this.namespace = namespace;
            this.name = name;
            this.facets = facets;
            this.outputFacets = outputFacets;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DatasetFacets getFacets() {
            return this.facets;
        }

        public OutputDatasetOutputFacets getOutputFacets() {
            return this.outputFacets;
        }
    }

    public static final class ParentRunFacetJobBuilder {
        private String namespace;
        private String name;

        public ParentRunFacetJobBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ParentRunFacetJobBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ParentRunFacetJob build() {
            ParentRunFacetJob __result = new ParentRunFacetJob(this.namespace, this.name);
            return __result;
        }
    }

    @JsonDeserialize(as=ParentRunFacetJob.class)
    @JsonPropertyOrder(value={"namespace", "name"})
    public static final class ParentRunFacetJob {
        private final String namespace;
        private final String name;

        @JsonCreator
        private ParentRunFacetJob(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name) {
            this.namespace = namespace;
            this.name = name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }
    }

    public static final class DatasetFacetsBuilder {
        private DocumentationDatasetFacet documentation;
        private DatasourceDatasetFacet dataSource;
        private SchemaDatasetFacet schema;
        private final Map<String, DatasetFacet> additionalProperties = new LinkedHashMap<String, DatasetFacet>();

        public DatasetFacetsBuilder documentation(DocumentationDatasetFacet documentation) {
            this.documentation = documentation;
            return this;
        }

        public DatasetFacetsBuilder dataSource(DatasourceDatasetFacet dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public DatasetFacetsBuilder schema(SchemaDatasetFacet schema) {
            this.schema = schema;
            return this;
        }

        public DatasetFacetsBuilder put(String key, DatasetFacet value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        public DatasetFacets build() {
            DatasetFacets __result = new DatasetFacets(this.documentation, this.dataSource, this.schema);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DatasetFacets.class)
    @JsonPropertyOrder(value={"documentation", "dataSource", "schema"})
    public static final class DatasetFacets {
        private final DocumentationDatasetFacet documentation;
        private final DatasourceDatasetFacet dataSource;
        private final SchemaDatasetFacet schema;
        @JsonAnySetter
        private final Map<String, DatasetFacet> additionalProperties;

        @JsonCreator
        private DatasetFacets(@JsonProperty(value="documentation") DocumentationDatasetFacet documentation, @JsonProperty(value="dataSource") DatasourceDatasetFacet dataSource, @JsonProperty(value="schema") SchemaDatasetFacet schema) {
            this.documentation = documentation;
            this.dataSource = dataSource;
            this.schema = schema;
            this.additionalProperties = new LinkedHashMap<String, DatasetFacet>();
        }

        public DocumentationDatasetFacet getDocumentation() {
            return this.documentation;
        }

        public DatasourceDatasetFacet getDataSource() {
            return this.dataSource;
        }

        public SchemaDatasetFacet getSchema() {
            return this.schema;
        }

        @JsonAnyGetter
        public Map<String, DatasetFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public final class SQLJobFacetBuilder {
        private String query;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public SQLJobFacetBuilder query(String query) {
            this.query = query;
            return this;
        }

        public SQLJobFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        public SQLJobFacet build() {
            SQLJobFacet __result = new SQLJobFacet(OpenLineage.this.producer, this.query);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=SQLJobFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "query"})
    public static final class SQLJobFacet
    implements JobFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final String query;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private SQLJobFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="query") String query) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/SQLJobFacet.json#/$defs/SQLJobFacet");
            this.query = query;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public String getQuery() {
            return this.query;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    @JsonDeserialize(as=DefaultOutputDatasetFacet.class)
    public static interface OutputDatasetFacet {
        public URI get_producer();

        public URI get_schemaURL();

        public Map<String, Object> getAdditionalProperties();
    }

    public static class DefaultOutputDatasetFacet
    implements OutputDatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public DefaultOutputDatasetFacet(@JsonProperty(value="_producer") URI _producer) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/1-0-2/OpenLineage.json#/$defs/OutputDatasetFacet");
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    @JsonDeserialize(as=DefaultDatasetFacet.class)
    public static interface DatasetFacet {
        public URI get_producer();

        public URI get_schemaURL();

        public Map<String, Object> getAdditionalProperties();
    }

    public static class DefaultDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public DefaultDatasetFacet(@JsonProperty(value="_producer") URI _producer) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/1-0-2/OpenLineage.json#/$defs/DatasetFacet");
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public static final class InputDatasetInputFacetsBuilder {
        private DataQualityAssertionsDatasetFacet dataQualityAssertions;
        private DataQualityMetricsInputDatasetFacet dataQualityMetrics;
        private final Map<String, InputDatasetFacet> additionalProperties = new LinkedHashMap<String, InputDatasetFacet>();

        public InputDatasetInputFacetsBuilder dataQualityAssertions(DataQualityAssertionsDatasetFacet dataQualityAssertions) {
            this.dataQualityAssertions = dataQualityAssertions;
            return this;
        }

        public InputDatasetInputFacetsBuilder dataQualityMetrics(DataQualityMetricsInputDatasetFacet dataQualityMetrics) {
            this.dataQualityMetrics = dataQualityMetrics;
            return this;
        }

        public InputDatasetInputFacetsBuilder put(String key, InputDatasetFacet value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        public InputDatasetInputFacets build() {
            InputDatasetInputFacets __result = new InputDatasetInputFacets(this.dataQualityAssertions, this.dataQualityMetrics);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=InputDatasetInputFacets.class)
    @JsonPropertyOrder(value={"dataQualityAssertions", "dataQualityMetrics"})
    public static final class InputDatasetInputFacets {
        private final DataQualityAssertionsDatasetFacet dataQualityAssertions;
        private final DataQualityMetricsInputDatasetFacet dataQualityMetrics;
        @JsonAnySetter
        private final Map<String, InputDatasetFacet> additionalProperties;

        @JsonCreator
        private InputDatasetInputFacets(@JsonProperty(value="dataQualityAssertions") DataQualityAssertionsDatasetFacet dataQualityAssertions, @JsonProperty(value="dataQualityMetrics") DataQualityMetricsInputDatasetFacet dataQualityMetrics) {
            this.dataQualityAssertions = dataQualityAssertions;
            this.dataQualityMetrics = dataQualityMetrics;
            this.additionalProperties = new LinkedHashMap<String, InputDatasetFacet>();
        }

        public DataQualityAssertionsDatasetFacet getDataQualityAssertions() {
            return this.dataQualityAssertions;
        }

        public DataQualityMetricsInputDatasetFacet getDataQualityMetrics() {
            return this.dataQualityMetrics;
        }

        @JsonAnyGetter
        public Map<String, InputDatasetFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public static final class JobFacetsBuilder {
        private SourceCodeLocationJobFacet sourceCodeLocation;
        private SQLJobFacet sql;
        private DocumentationJobFacet documentation;
        private final Map<String, JobFacet> additionalProperties = new LinkedHashMap<String, JobFacet>();

        public JobFacetsBuilder sourceCodeLocation(SourceCodeLocationJobFacet sourceCodeLocation) {
            this.sourceCodeLocation = sourceCodeLocation;
            return this;
        }

        public JobFacetsBuilder sql(SQLJobFacet sql) {
            this.sql = sql;
            return this;
        }

        public JobFacetsBuilder documentation(DocumentationJobFacet documentation) {
            this.documentation = documentation;
            return this;
        }

        public JobFacetsBuilder put(String key, JobFacet value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        public JobFacets build() {
            JobFacets __result = new JobFacets(this.sourceCodeLocation, this.sql, this.documentation);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=JobFacets.class)
    @JsonPropertyOrder(value={"sourceCodeLocation", "sql", "documentation"})
    public static final class JobFacets {
        private final SourceCodeLocationJobFacet sourceCodeLocation;
        private final SQLJobFacet sql;
        private final DocumentationJobFacet documentation;
        @JsonAnySetter
        private final Map<String, JobFacet> additionalProperties;

        @JsonCreator
        private JobFacets(@JsonProperty(value="sourceCodeLocation") SourceCodeLocationJobFacet sourceCodeLocation, @JsonProperty(value="sql") SQLJobFacet sql, @JsonProperty(value="documentation") DocumentationJobFacet documentation) {
            this.sourceCodeLocation = sourceCodeLocation;
            this.sql = sql;
            this.documentation = documentation;
            this.additionalProperties = new LinkedHashMap<String, JobFacet>();
        }

        public SourceCodeLocationJobFacet getSourceCodeLocation() {
            return this.sourceCodeLocation;
        }

        public SQLJobFacet getSql() {
            return this.sql;
        }

        public DocumentationJobFacet getDocumentation() {
            return this.documentation;
        }

        @JsonAnyGetter
        public Map<String, JobFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public final class DocumentationJobFacetBuilder {
        private String description;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public DocumentationJobFacetBuilder description(String description) {
            this.description = description;
            return this;
        }

        public DocumentationJobFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        public DocumentationJobFacet build() {
            DocumentationJobFacet __result = new DocumentationJobFacet(OpenLineage.this.producer, this.description);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DocumentationJobFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "description"})
    public static final class DocumentationJobFacet
    implements JobFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final String description;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private DocumentationJobFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="description") String description) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/DocumentationJobFacet.json#/$defs/DocumentationJobFacet");
            this.description = description;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public static final class ParentRunFacetRunBuilder {
        private UUID runId;

        public ParentRunFacetRunBuilder runId(UUID runId) {
            this.runId = runId;
            return this;
        }

        public ParentRunFacetRun build() {
            ParentRunFacetRun __result = new ParentRunFacetRun(this.runId);
            return __result;
        }
    }

    @JsonDeserialize(as=ParentRunFacetRun.class)
    @JsonPropertyOrder(value={"runId"})
    public static final class ParentRunFacetRun {
        private final UUID runId;

        @JsonCreator
        private ParentRunFacetRun(@JsonProperty(value="runId") UUID runId) {
            this.runId = runId;
        }

        public UUID getRunId() {
            return this.runId;
        }
    }

    public final class DataQualityMetricsInputDatasetFacetBuilder {
        private Long rowCount;
        private Long bytes;
        private DataQualityMetricsInputDatasetFacetColumnMetrics columnMetrics;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public DataQualityMetricsInputDatasetFacetBuilder rowCount(Long rowCount) {
            this.rowCount = rowCount;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetBuilder bytes(Long bytes) {
            this.bytes = bytes;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetBuilder columnMetrics(DataQualityMetricsInputDatasetFacetColumnMetrics columnMetrics) {
            this.columnMetrics = columnMetrics;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        public DataQualityMetricsInputDatasetFacet build() {
            DataQualityMetricsInputDatasetFacet __result = new DataQualityMetricsInputDatasetFacet(OpenLineage.this.producer, this.rowCount, this.bytes, this.columnMetrics);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DataQualityMetricsInputDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "rowCount", "bytes", "columnMetrics"})
    public static final class DataQualityMetricsInputDatasetFacet
    implements InputDatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Long rowCount;
        private final Long bytes;
        private final DataQualityMetricsInputDatasetFacetColumnMetrics columnMetrics;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private DataQualityMetricsInputDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="rowCount") Long rowCount, @JsonProperty(value="bytes") Long bytes, @JsonProperty(value="columnMetrics") DataQualityMetricsInputDatasetFacetColumnMetrics columnMetrics) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/DataQualityMetricsInputDatasetFacet.json#/$defs/DataQualityMetricsInputDatasetFacet");
            this.rowCount = rowCount;
            this.bytes = bytes;
            this.columnMetrics = columnMetrics;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public Long getRowCount() {
            return this.rowCount;
        }

        public Long getBytes() {
            return this.bytes;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetrics getColumnMetrics() {
            return this.columnMetrics;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public static final class DataQualityAssertionsDatasetFacetAssertionsBuilder {
        private String assertion;
        private Boolean success;
        private String column;

        public DataQualityAssertionsDatasetFacetAssertionsBuilder assertion(String assertion) {
            this.assertion = assertion;
            return this;
        }

        public DataQualityAssertionsDatasetFacetAssertionsBuilder success(Boolean success) {
            this.success = success;
            return this;
        }

        public DataQualityAssertionsDatasetFacetAssertionsBuilder column(String column) {
            this.column = column;
            return this;
        }

        public DataQualityAssertionsDatasetFacetAssertions build() {
            DataQualityAssertionsDatasetFacetAssertions __result = new DataQualityAssertionsDatasetFacetAssertions(this.assertion, this.success, this.column);
            return __result;
        }
    }

    @JsonDeserialize(as=DataQualityAssertionsDatasetFacetAssertions.class)
    @JsonPropertyOrder(value={"assertion", "success", "column"})
    public static final class DataQualityAssertionsDatasetFacetAssertions {
        private final String assertion;
        private final Boolean success;
        private final String column;

        @JsonCreator
        private DataQualityAssertionsDatasetFacetAssertions(@JsonProperty(value="assertion") String assertion, @JsonProperty(value="success") Boolean success, @JsonProperty(value="column") String column) {
            this.assertion = assertion;
            this.success = success;
            this.column = column;
        }

        public String getAssertion() {
            return this.assertion;
        }

        public Boolean getSuccess() {
            return this.success;
        }

        public String getColumn() {
            return this.column;
        }
    }

    public static final class DataQualityMetricsInputDatasetFacetColumnMetricsBuilder {
        private final Map<String, DataQualityMetricsInputDatasetFacetColumnMetricsAdditional> additionalProperties = new LinkedHashMap<String, DataQualityMetricsInputDatasetFacetColumnMetricsAdditional>();

        public DataQualityMetricsInputDatasetFacetColumnMetricsBuilder put(String key, DataQualityMetricsInputDatasetFacetColumnMetricsAdditional value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetrics build() {
            DataQualityMetricsInputDatasetFacetColumnMetrics __result = new DataQualityMetricsInputDatasetFacetColumnMetrics();
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DataQualityMetricsInputDatasetFacetColumnMetrics.class)
    @JsonPropertyOrder
    public static final class DataQualityMetricsInputDatasetFacetColumnMetrics {
        @JsonAnySetter
        private final Map<String, DataQualityMetricsInputDatasetFacetColumnMetricsAdditional> additionalProperties = new LinkedHashMap<String, DataQualityMetricsInputDatasetFacetColumnMetricsAdditional>();

        @JsonCreator
        private DataQualityMetricsInputDatasetFacetColumnMetrics() {
        }

        @JsonAnyGetter
        public Map<String, DataQualityMetricsInputDatasetFacetColumnMetricsAdditional> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public static final class DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder {
        private Long nullCount;
        private Long distinctCount;
        private Double sum;
        private Double count;
        private Double min;
        private Double max;
        private DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles quantiles;

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder nullCount(Long nullCount) {
            this.nullCount = nullCount;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder distinctCount(Long distinctCount) {
            this.distinctCount = distinctCount;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder count(Double count) {
            this.count = count;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder min(Double min) {
            this.min = min;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder max(Double max) {
            this.max = max;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalBuilder quantiles(DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles quantiles) {
            this.quantiles = quantiles;
            return this;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditional build() {
            DataQualityMetricsInputDatasetFacetColumnMetricsAdditional __result = new DataQualityMetricsInputDatasetFacetColumnMetricsAdditional(this.nullCount, this.distinctCount, this.sum, this.count, this.min, this.max, this.quantiles);
            return __result;
        }
    }

    @JsonDeserialize(as=DataQualityMetricsInputDatasetFacetColumnMetricsAdditional.class)
    @JsonPropertyOrder(value={"nullCount", "distinctCount", "sum", "count", "min", "max", "quantiles"})
    public static final class DataQualityMetricsInputDatasetFacetColumnMetricsAdditional {
        private final Long nullCount;
        private final Long distinctCount;
        private final Double sum;
        private final Double count;
        private final Double min;
        private final Double max;
        private final DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles quantiles;

        @JsonCreator
        private DataQualityMetricsInputDatasetFacetColumnMetricsAdditional(@JsonProperty(value="nullCount") Long nullCount, @JsonProperty(value="distinctCount") Long distinctCount, @JsonProperty(value="sum") Double sum, @JsonProperty(value="count") Double count, @JsonProperty(value="min") Double min, @JsonProperty(value="max") Double max, @JsonProperty(value="quantiles") DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles quantiles) {
            this.nullCount = nullCount;
            this.distinctCount = distinctCount;
            this.sum = sum;
            this.count = count;
            this.min = min;
            this.max = max;
            this.quantiles = quantiles;
        }

        public Long getNullCount() {
            return this.nullCount;
        }

        public Long getDistinctCount() {
            return this.distinctCount;
        }

        public Double getSum() {
            return this.sum;
        }

        public Double getCount() {
            return this.count;
        }

        public Double getMin() {
            return this.min;
        }

        public Double getMax() {
            return this.max;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles getQuantiles() {
            return this.quantiles;
        }
    }

    @JsonDeserialize(as=DefaultInputDatasetFacet.class)
    public static interface InputDatasetFacet {
        public URI get_producer();

        public URI get_schemaURL();

        public Map<String, Object> getAdditionalProperties();
    }

    public static class DefaultInputDatasetFacet
    implements InputDatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public DefaultInputDatasetFacet(@JsonProperty(value="_producer") URI _producer) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/1-0-2/OpenLineage.json#/$defs/InputDatasetFacet");
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public static final class JobBuilder {
        private String namespace;
        private String name;
        private JobFacets facets;

        public JobBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public JobBuilder name(String name) {
            this.name = name;
            return this;
        }

        public JobBuilder facets(JobFacets facets) {
            this.facets = facets;
            return this;
        }

        public Job build() {
            Job __result = new Job(this.namespace, this.name, this.facets);
            return __result;
        }
    }

    @JsonDeserialize(as=Job.class)
    @JsonPropertyOrder(value={"namespace", "name", "facets"})
    public static final class Job {
        private final String namespace;
        private final String name;
        private final JobFacets facets;

        @JsonCreator
        private Job(@JsonProperty(value="namespace") String namespace, @JsonProperty(value="name") String name, @JsonProperty(value="facets") JobFacets facets) {
            this.namespace = namespace;
            this.name = name;
            this.facets = facets;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public JobFacets getFacets() {
            return this.facets;
        }
    }

    public static interface BaseFacet {
        public URI get_producer();

        public URI get_schemaURL();

        public Map<String, Object> getAdditionalProperties();
    }

    @JsonDeserialize(as=DefaultRunFacet.class)
    public static interface RunFacet {
        public URI get_producer();

        public URI get_schemaURL();

        public Map<String, Object> getAdditionalProperties();
    }

    public static class DefaultRunFacet
    implements RunFacet {
        private final URI _producer;
        private final URI _schemaURL;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        public DefaultRunFacet(@JsonProperty(value="_producer") URI _producer) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/1-0-2/OpenLineage.json#/$defs/RunFacet");
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public final class NominalTimeRunFacetBuilder {
        private ZonedDateTime nominalStartTime;
        private ZonedDateTime nominalEndTime;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public NominalTimeRunFacetBuilder nominalStartTime(ZonedDateTime nominalStartTime) {
            this.nominalStartTime = nominalStartTime;
            return this;
        }

        public NominalTimeRunFacetBuilder nominalEndTime(ZonedDateTime nominalEndTime) {
            this.nominalEndTime = nominalEndTime;
            return this;
        }

        public NominalTimeRunFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        public NominalTimeRunFacet build() {
            NominalTimeRunFacet __result = new NominalTimeRunFacet(OpenLineage.this.producer, this.nominalStartTime, this.nominalEndTime);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=NominalTimeRunFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "nominalStartTime", "nominalEndTime"})
    public static final class NominalTimeRunFacet
    implements RunFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final ZonedDateTime nominalStartTime;
        private final ZonedDateTime nominalEndTime;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private NominalTimeRunFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="nominalStartTime") ZonedDateTime nominalStartTime, @JsonProperty(value="nominalEndTime") ZonedDateTime nominalEndTime) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/NominalTimeRunFacet.json#/$defs/NominalTimeRunFacet");
            this.nominalStartTime = nominalStartTime;
            this.nominalEndTime = nominalEndTime;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public ZonedDateTime getNominalStartTime() {
            return this.nominalStartTime;
        }

        public ZonedDateTime getNominalEndTime() {
            return this.nominalEndTime;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public static final class OutputDatasetOutputFacetsBuilder {
        private OutputStatisticsOutputDatasetFacet outputStatistics;
        private final Map<String, OutputDatasetFacet> additionalProperties = new LinkedHashMap<String, OutputDatasetFacet>();

        public OutputDatasetOutputFacetsBuilder outputStatistics(OutputStatisticsOutputDatasetFacet outputStatistics) {
            this.outputStatistics = outputStatistics;
            return this;
        }

        public OutputDatasetOutputFacetsBuilder put(String key, OutputDatasetFacet value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        public OutputDatasetOutputFacets build() {
            OutputDatasetOutputFacets __result = new OutputDatasetOutputFacets(this.outputStatistics);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=OutputDatasetOutputFacets.class)
    @JsonPropertyOrder(value={"outputStatistics"})
    public static final class OutputDatasetOutputFacets {
        private final OutputStatisticsOutputDatasetFacet outputStatistics;
        @JsonAnySetter
        private final Map<String, OutputDatasetFacet> additionalProperties;

        @JsonCreator
        private OutputDatasetOutputFacets(@JsonProperty(value="outputStatistics") OutputStatisticsOutputDatasetFacet outputStatistics) {
            this.outputStatistics = outputStatistics;
            this.additionalProperties = new LinkedHashMap<String, OutputDatasetFacet>();
        }

        public OutputStatisticsOutputDatasetFacet getOutputStatistics() {
            return this.outputStatistics;
        }

        @JsonAnyGetter
        public Map<String, OutputDatasetFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public static interface Dataset {
        public String getNamespace();

        public String getName();

        public DatasetFacets getFacets();
    }

    public static final class DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantilesBuilder {
        private final Map<String, Double> additionalProperties = new LinkedHashMap<String, Double>();

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantilesBuilder put(String key, Double value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        public DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles build() {
            DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles __result = new DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles();
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles.class)
    @JsonPropertyOrder
    public static final class DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles {
        @JsonAnySetter
        private final Map<String, Double> additionalProperties = new LinkedHashMap<String, Double>();

        @JsonCreator
        private DataQualityMetricsInputDatasetFacetColumnMetricsAdditionalQuantiles() {
        }

        @JsonAnyGetter
        public Map<String, Double> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public static final class RunBuilder {
        private UUID runId;
        private RunFacets facets;

        public RunBuilder runId(UUID runId) {
            this.runId = runId;
            return this;
        }

        public RunBuilder facets(RunFacets facets) {
            this.facets = facets;
            return this;
        }

        public Run build() {
            Run __result = new Run(this.runId, this.facets);
            return __result;
        }
    }

    @JsonDeserialize(as=Run.class)
    @JsonPropertyOrder(value={"runId", "facets"})
    public static final class Run {
        private final UUID runId;
        private final RunFacets facets;

        @JsonCreator
        private Run(@JsonProperty(value="runId") UUID runId, @JsonProperty(value="facets") RunFacets facets) {
            this.runId = runId;
            this.facets = facets;
        }

        public UUID getRunId() {
            return this.runId;
        }

        public RunFacets getFacets() {
            return this.facets;
        }
    }

    public final class DataQualityAssertionsDatasetFacetBuilder {
        private List<DataQualityAssertionsDatasetFacetAssertions> assertions;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public DataQualityAssertionsDatasetFacetBuilder assertions(List<DataQualityAssertionsDatasetFacetAssertions> assertions) {
            this.assertions = assertions;
            return this;
        }

        public DataQualityAssertionsDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        public DataQualityAssertionsDatasetFacet build() {
            DataQualityAssertionsDatasetFacet __result = new DataQualityAssertionsDatasetFacet(OpenLineage.this.producer, this.assertions);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DataQualityAssertionsDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "assertions"})
    public static final class DataQualityAssertionsDatasetFacet
    implements InputDatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final List<DataQualityAssertionsDatasetFacetAssertions> assertions;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private DataQualityAssertionsDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="assertions") List<DataQualityAssertionsDatasetFacetAssertions> assertions) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/DataQualityAssertionsDatasetFacet.json#/$defs/DataQualityAssertionsDatasetFacet");
            this.assertions = assertions;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public List<DataQualityAssertionsDatasetFacetAssertions> getAssertions() {
            return this.assertions;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public final class SourceCodeLocationJobFacetBuilder {
        private String type;
        private URI url;
        private String repoUrl;
        private String path;
        private String version;
        private String tag;
        private String branch;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public SourceCodeLocationJobFacetBuilder type(String type) {
            this.type = type;
            return this;
        }

        public SourceCodeLocationJobFacetBuilder url(URI url) {
            this.url = url;
            return this;
        }

        public SourceCodeLocationJobFacetBuilder repoUrl(String repoUrl) {
            this.repoUrl = repoUrl;
            return this;
        }

        public SourceCodeLocationJobFacetBuilder path(String path) {
            this.path = path;
            return this;
        }

        public SourceCodeLocationJobFacetBuilder version(String version) {
            this.version = version;
            return this;
        }

        public SourceCodeLocationJobFacetBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public SourceCodeLocationJobFacetBuilder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public SourceCodeLocationJobFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        public SourceCodeLocationJobFacet build() {
            SourceCodeLocationJobFacet __result = new SourceCodeLocationJobFacet(OpenLineage.this.producer, this.type, this.url, this.repoUrl, this.path, this.version, this.tag, this.branch);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=SourceCodeLocationJobFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "type", "url", "repoUrl", "path", "version", "tag", "branch"})
    public static final class SourceCodeLocationJobFacet
    implements JobFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final String type;
        private final URI url;
        private final String repoUrl;
        private final String path;
        private final String version;
        private final String tag;
        private final String branch;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private SourceCodeLocationJobFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="type") String type, @JsonProperty(value="url") URI url, @JsonProperty(value="repoUrl") String repoUrl, @JsonProperty(value="path") String path, @JsonProperty(value="version") String version, @JsonProperty(value="tag") String tag, @JsonProperty(value="branch") String branch) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/SourceCodeLocationJobFacet.json#/$defs/SourceCodeLocationJobFacet");
            this.type = type;
            this.url = url;
            this.repoUrl = repoUrl;
            this.path = path;
            this.version = version;
            this.tag = tag;
            this.branch = branch;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public String getType() {
            return this.type;
        }

        public URI getUrl() {
            return this.url;
        }

        public String getRepoUrl() {
            return this.repoUrl;
        }

        public String getPath() {
            return this.path;
        }

        public String getVersion() {
            return this.version;
        }

        public String getTag() {
            return this.tag;
        }

        public String getBranch() {
            return this.branch;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public final class OutputStatisticsOutputDatasetFacetBuilder {
        private Long rowCount;
        private Long size;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public OutputStatisticsOutputDatasetFacetBuilder rowCount(Long rowCount) {
            this.rowCount = rowCount;
            return this;
        }

        public OutputStatisticsOutputDatasetFacetBuilder size(Long size) {
            this.size = size;
            return this;
        }

        public OutputStatisticsOutputDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        public OutputStatisticsOutputDatasetFacet build() {
            OutputStatisticsOutputDatasetFacet __result = new OutputStatisticsOutputDatasetFacet(OpenLineage.this.producer, this.rowCount, this.size);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=OutputStatisticsOutputDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "rowCount", "size"})
    public static final class OutputStatisticsOutputDatasetFacet
    implements OutputDatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final Long rowCount;
        private final Long size;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private OutputStatisticsOutputDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="rowCount") Long rowCount, @JsonProperty(value="size") Long size) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/OutputStatisticsOutputDatasetFacet.json#/$defs/OutputStatisticsOutputDatasetFacet");
            this.rowCount = rowCount;
            this.size = size;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public Long getRowCount() {
            return this.rowCount;
        }

        public Long getSize() {
            return this.size;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public final class ParentRunFacetBuilder {
        private ParentRunFacetRun run;
        private ParentRunFacetJob job;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public ParentRunFacetBuilder run(ParentRunFacetRun run) {
            this.run = run;
            return this;
        }

        public ParentRunFacetBuilder job(ParentRunFacetJob job) {
            this.job = job;
            return this;
        }

        public ParentRunFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        public ParentRunFacet build() {
            ParentRunFacet __result = new ParentRunFacet(OpenLineage.this.producer, this.run, this.job);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=ParentRunFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "run", "job"})
    public static final class ParentRunFacet
    implements RunFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final ParentRunFacetRun run;
        private final ParentRunFacetJob job;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private ParentRunFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="run") ParentRunFacetRun run, @JsonProperty(value="job") ParentRunFacetJob job) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/ParentRunFacet.json#/$defs/ParentRunFacet");
            this.run = run;
            this.job = job;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public ParentRunFacetRun getRun() {
            return this.run;
        }

        public ParentRunFacetJob getJob() {
            return this.job;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public final class DocumentationDatasetFacetBuilder {
        private String description;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public DocumentationDatasetFacetBuilder description(String description) {
            this.description = description;
            return this;
        }

        public DocumentationDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        public DocumentationDatasetFacet build() {
            DocumentationDatasetFacet __result = new DocumentationDatasetFacet(OpenLineage.this.producer, this.description);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=DocumentationDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "description"})
    public static final class DocumentationDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final String description;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private DocumentationDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="description") String description) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/DocumentationDatasetFacet.json#/$defs/DocumentationDatasetFacet");
            this.description = description;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public final class SchemaDatasetFacetBuilder {
        private List<SchemaDatasetFacetFields> fields;
        private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        public SchemaDatasetFacetBuilder fields(List<SchemaDatasetFacetFields> fields) {
            this.fields = fields;
            return this;
        }

        public SchemaDatasetFacetBuilder put(String key, Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        public SchemaDatasetFacet build() {
            SchemaDatasetFacet __result = new SchemaDatasetFacet(OpenLineage.this.producer, this.fields);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=SchemaDatasetFacet.class)
    @JsonPropertyOrder(value={"_producer", "_schemaURL", "fields"})
    public static final class SchemaDatasetFacet
    implements DatasetFacet {
        private final URI _producer;
        private final URI _schemaURL;
        private final List<SchemaDatasetFacetFields> fields;
        @JsonAnySetter
        private final Map<String, Object> additionalProperties;

        @JsonCreator
        private SchemaDatasetFacet(@JsonProperty(value="_producer") URI _producer, @JsonProperty(value="fields") List<SchemaDatasetFacetFields> fields) {
            this._producer = _producer;
            this._schemaURL = URI.create("https://openlineage.io/spec/facets/1-0-0/SchemaDatasetFacet.json#/$defs/SchemaDatasetFacet");
            this.fields = fields;
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }

        @Override
        public URI get_producer() {
            return this._producer;
        }

        @Override
        public URI get_schemaURL() {
            return this._schemaURL;
        }

        public List<SchemaDatasetFacetFields> getFields() {
            return this.fields;
        }

        @Override
        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }

    public static final class SchemaDatasetFacetFieldsBuilder {
        private String name;
        private String type;
        private String description;

        public SchemaDatasetFacetFieldsBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SchemaDatasetFacetFieldsBuilder type(String type) {
            this.type = type;
            return this;
        }

        public SchemaDatasetFacetFieldsBuilder description(String description) {
            this.description = description;
            return this;
        }

        public SchemaDatasetFacetFields build() {
            SchemaDatasetFacetFields __result = new SchemaDatasetFacetFields(this.name, this.type, this.description);
            return __result;
        }
    }

    @JsonDeserialize(as=SchemaDatasetFacetFields.class)
    @JsonPropertyOrder(value={"name", "type", "description"})
    public static final class SchemaDatasetFacetFields {
        private final String name;
        private final String type;
        private final String description;

        @JsonCreator
        private SchemaDatasetFacetFields(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="description") String description) {
            this.name = name;
            this.type = type;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public final class RunEventBuilder {
        private String eventType;
        private ZonedDateTime eventTime;
        private Run run;
        private Job job;
        private List<InputDataset> inputs;
        private List<OutputDataset> outputs;

        public RunEventBuilder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public RunEventBuilder eventTime(ZonedDateTime eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public RunEventBuilder run(Run run) {
            this.run = run;
            return this;
        }

        public RunEventBuilder job(Job job) {
            this.job = job;
            return this;
        }

        public RunEventBuilder inputs(List<InputDataset> inputs) {
            this.inputs = inputs;
            return this;
        }

        public RunEventBuilder outputs(List<OutputDataset> outputs) {
            this.outputs = outputs;
            return this;
        }

        public RunEvent build() {
            RunEvent __result = new RunEvent(this.eventType, this.eventTime, this.run, this.job, this.inputs, this.outputs, OpenLineage.this.producer);
            return __result;
        }
    }

    @JsonDeserialize(as=RunEvent.class)
    @JsonPropertyOrder(value={"eventType", "eventTime", "run", "job", "inputs", "outputs", "producer", "schemaURL"})
    public static final class RunEvent {
        private final String eventType;
        private final ZonedDateTime eventTime;
        private final Run run;
        private final Job job;
        private final List<InputDataset> inputs;
        private final List<OutputDataset> outputs;
        private final URI producer;
        private final URI schemaURL;

        @JsonCreator
        private RunEvent(@JsonProperty(value="eventType") String eventType, @JsonProperty(value="eventTime") ZonedDateTime eventTime, @JsonProperty(value="run") Run run, @JsonProperty(value="job") Job job, @JsonProperty(value="inputs") List<InputDataset> inputs, @JsonProperty(value="outputs") List<OutputDataset> outputs, @JsonProperty(value="producer") URI producer) {
            this.eventType = eventType;
            this.eventTime = eventTime;
            this.run = run;
            this.job = job;
            this.inputs = inputs;
            this.outputs = outputs;
            this.producer = producer;
            this.schemaURL = URI.create("https://openlineage.io/spec/1-0-2/OpenLineage.json#/$defs/RunEvent");
        }

        public String getEventType() {
            return this.eventType;
        }

        public ZonedDateTime getEventTime() {
            return this.eventTime;
        }

        public Run getRun() {
            return this.run;
        }

        public Job getJob() {
            return this.job;
        }

        public List<InputDataset> getInputs() {
            return this.inputs;
        }

        public List<OutputDataset> getOutputs() {
            return this.outputs;
        }

        public URI getProducer() {
            return this.producer;
        }

        public URI getSchemaURL() {
            return this.schemaURL;
        }
    }

    public static final class RunFacetsBuilder {
        private ParentRunFacet parent;
        private NominalTimeRunFacet nominalTime;
        private final Map<String, RunFacet> additionalProperties = new LinkedHashMap<String, RunFacet>();

        public RunFacetsBuilder parent(ParentRunFacet parent) {
            this.parent = parent;
            return this;
        }

        public RunFacetsBuilder nominalTime(NominalTimeRunFacet nominalTime) {
            this.nominalTime = nominalTime;
            return this;
        }

        public RunFacetsBuilder put(String key, RunFacet value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        public RunFacets build() {
            RunFacets __result = new RunFacets(this.parent, this.nominalTime);
            __result.getAdditionalProperties().putAll(this.additionalProperties);
            return __result;
        }
    }

    @JsonDeserialize(as=RunFacets.class)
    @JsonPropertyOrder(value={"parent", "nominalTime"})
    public static final class RunFacets {
        private final ParentRunFacet parent;
        private final NominalTimeRunFacet nominalTime;
        @JsonAnySetter
        private final Map<String, RunFacet> additionalProperties;

        @JsonCreator
        private RunFacets(@JsonProperty(value="parent") ParentRunFacet parent, @JsonProperty(value="nominalTime") NominalTimeRunFacet nominalTime) {
            this.parent = parent;
            this.nominalTime = nominalTime;
            this.additionalProperties = new LinkedHashMap<String, RunFacet>();
        }

        public ParentRunFacet getParent() {
            return this.parent;
        }

        public NominalTimeRunFacet getNominalTime() {
            return this.nominalTime;
        }

        @JsonAnyGetter
        public Map<String, RunFacet> getAdditionalProperties() {
            return this.additionalProperties;
        }
    }
}

