/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.transports;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClientException;
import io.openlineage.client.OpenLineageClientUtils;
import io.openlineage.client.transports.ApiKeyTokenProvider;
import io.openlineage.client.transports.HttpConfig;
import io.openlineage.client.transports.TokenProvider;
import io.openlineage.client.transports.Transport;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpTransport
extends Transport
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(HttpTransport.class);
    private static final String API_V1 = "/api/v1";
    private final CloseableHttpClient http;
    private final URI uri;
    @Nullable
    private final TokenProvider tokenProvider;
    private final Map<String, String> headers;

    public HttpTransport(@NonNull HttpConfig httpConfig) {
        this(HttpTransport.withTimeout(httpConfig.getTimeout()), httpConfig);
        if (httpConfig == null) {
            throw new NullPointerException("httpConfig is marked non-null but is null");
        }
    }

    private static CloseableHttpClient withTimeout(Double timeout) {
        int timeoutMs = timeout == null ? 5000 : (int)(timeout * 1000.0);
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeoutMs).setConnectionRequestTimeout(timeoutMs).setSocketTimeout(timeoutMs).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    public HttpTransport(@NonNull CloseableHttpClient httpClient, @NonNull HttpConfig httpConfig) {
        super(Transport.Type.HTTP);
        if (httpClient == null) {
            throw new NullPointerException("httpClient is marked non-null but is null");
        }
        if (httpConfig == null) {
            throw new NullPointerException("httpConfig is marked non-null but is null");
        }
        this.http = httpClient;
        try {
            this.uri = this.getUri(httpConfig);
        }
        catch (URISyntaxException e) {
            throw new OpenLineageClientException(e);
        }
        this.tokenProvider = httpConfig.getAuth();
        this.headers = httpConfig.getHeaders() != null ? httpConfig.getHeaders() : new HashMap<String, String>();
    }

    private URI getUri(HttpConfig httpConfig) throws URISyntaxException {
        URI url = httpConfig.getUrl();
        if (url == null) {
            throw new OpenLineageClientException("url can't be null, try setting openlineage.transport.host in config");
        }
        URIBuilder builder = new URIBuilder(url);
        if (StringUtils.isNotBlank((CharSequence)url.getPath())) {
            if (StringUtils.isNotBlank((CharSequence)httpConfig.getEndpoint())) {
                throw new OpenLineageClientException("You can't pass both uri and endpoint parameters.");
            }
        } else {
            String endpoint = StringUtils.isNotBlank((CharSequence)httpConfig.getEndpoint()) ? httpConfig.getEndpoint() : "/api/v1/lineage";
            builder.setPath(endpoint);
        }
        if (httpConfig.getUrlParams() != null) {
            httpConfig.getUrlParams().entrySet().stream().forEach(e -> builder.addParameter(((String)e.getKey()).replace("url.param.", ""), (String)e.getValue()));
        }
        return builder.build();
    }

    @Override
    public void emit(@NonNull OpenLineage.RunEvent runEvent) {
        if (runEvent == null) {
            throw new NullPointerException("runEvent is marked non-null but is null");
        }
        String eventAsJson = OpenLineageClientUtils.toJson(runEvent);
        this.emit(eventAsJson);
    }

    @Override
    public void emit(String eventAsJson) {
        log.debug("POST event on URL {}", (Object)this.uri);
        try {
            HttpPost request = new HttpPost();
            request.setURI(this.uri);
            this.setHeaders(request);
            request.setEntity((HttpEntity)new StringEntity(eventAsJson, ContentType.APPLICATION_JSON));
            try (CloseableHttpResponse response = this.http.execute((HttpUriRequest)request);){
                this.throwOnHttpError((HttpResponse)response);
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
        catch (IOException e) {
            throw new OpenLineageClientException(e);
        }
    }

    private void setHeaders(HttpPost request) {
        this.headers.put("Accept", ContentType.APPLICATION_JSON.toString());
        this.headers.put("Content-Type", ContentType.APPLICATION_JSON.toString());
        if (this.tokenProvider != null) {
            this.headers.put("Authorization", this.tokenProvider.getToken());
        }
        this.headers.forEach((arg_0, arg_1) -> ((HttpPost)request).addHeader(arg_0, arg_1));
    }

    private void throwOnHttpError(@NonNull HttpResponse response) throws IOException {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        int code = response.getStatusLine().getStatusCode();
        if (code >= 400 && code < 600) {
            String message = String.format("code: %d, response: %s", code, EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8));
            throw new OpenLineageClientException(message);
        }
    }

    @Override
    public void close() throws IOException {
        this.http.close();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public static final class Builder {
        private static final URI DEFAULT_OPENLINEAGE_URI = OpenLineageClientUtils.toUri("http://localhost:8080");
        @Nullable
        private CloseableHttpClient httpClient;
        private final HttpConfig httpConfig = new HttpConfig();

        private Builder() {
            this.httpConfig.setUrl(DEFAULT_OPENLINEAGE_URI);
        }

        public Builder uri(@NonNull String urlAsString) {
            if (urlAsString == null) {
                throw new NullPointerException("urlAsString is marked non-null but is null");
            }
            return this.uri(OpenLineageClientUtils.toUri(urlAsString));
        }

        public Builder uri(@NonNull String urlAsString, @NonNull Map<String, String> queryParams) {
            if (urlAsString == null) {
                throw new NullPointerException("urlAsString is marked non-null but is null");
            }
            if (queryParams == null) {
                throw new NullPointerException("queryParams is marked non-null but is null");
            }
            return this.uri(OpenLineageClientUtils.toUri(urlAsString), queryParams);
        }

        public Builder uri(@NonNull URI uri) {
            if (uri == null) {
                throw new NullPointerException("uri is marked non-null but is null");
            }
            return this.uri(uri, Collections.emptyMap());
        }

        public Builder uri(@NonNull URI uri, @NonNull Map<String, String> queryParams) {
            if (uri == null) {
                throw new NullPointerException("uri is marked non-null but is null");
            }
            if (queryParams == null) {
                throw new NullPointerException("queryParams is marked non-null but is null");
            }
            try {
                URIBuilder builder = new URIBuilder(uri);
                queryParams.forEach((arg_0, arg_1) -> ((URIBuilder)builder).addParameter(arg_0, arg_1));
                this.httpConfig.setUrl(builder.build());
            }
            catch (URISyntaxException e) {
                throw new OpenLineageClientException(e);
            }
            return this;
        }

        public Builder timeout(@Nullable Double timeout) {
            this.httpConfig.setTimeout(timeout);
            return this;
        }

        public Builder http(@NonNull CloseableHttpClient httpClient) {
            if (httpClient == null) {
                throw new NullPointerException("httpClient is marked non-null but is null");
            }
            this.httpClient = httpClient;
            return this;
        }

        public Builder tokenProvider(@Nullable TokenProvider tokenProvider) {
            this.httpConfig.setAuth(tokenProvider);
            return this;
        }

        public Builder apiKey(@Nullable String apiKey) {
            ApiKeyTokenProvider apiKeyTokenProvider = new ApiKeyTokenProvider();
            apiKeyTokenProvider.setApiKey(apiKey);
            return this.tokenProvider(apiKeyTokenProvider);
        }

        public HttpTransport build() {
            if (this.httpClient != null) {
                return new HttpTransport(this.httpClient, this.httpConfig);
            }
            return new HttpTransport(this.httpConfig);
        }

        public HttpConfig withUrl(URI url) {
            return this.httpConfig.withUrl(url);
        }

        public HttpConfig withEndpoint(String endpoint) {
            return this.httpConfig.withEndpoint(endpoint);
        }

        public HttpConfig withTimeout(Double timeout) {
            return this.httpConfig.withTimeout(timeout);
        }

        public HttpConfig withAuth(TokenProvider auth) {
            return this.httpConfig.withAuth(auth);
        }

        public HttpConfig withUrlParams(Map<String, String> urlParams) {
            return this.httpConfig.withUrlParams(urlParams);
        }

        public HttpConfig withHeaders(Map<String, String> headers) {
            return this.httpConfig.withHeaders(headers);
        }

        public URI getUrl() {
            return this.httpConfig.getUrl();
        }

        public void setUrl(URI url) {
            this.httpConfig.setUrl(url);
        }

        public String getEndpoint() {
            return this.httpConfig.getEndpoint();
        }

        public void setEndpoint(String endpoint) {
            this.httpConfig.setEndpoint(endpoint);
        }

        public Double getTimeout() {
            return this.httpConfig.getTimeout();
        }

        public void setTimeout(Double timeout) {
            this.httpConfig.setTimeout(timeout);
        }

        public TokenProvider getAuth() {
            return this.httpConfig.getAuth();
        }

        public void setAuth(TokenProvider auth) {
            this.httpConfig.setAuth(auth);
        }

        public Map<String, String> getUrlParams() {
            return this.httpConfig.getUrlParams();
        }

        public void setUrlParams(Map<String, String> urlParams) {
            this.httpConfig.setUrlParams(urlParams);
        }

        public Map<String, String> getHeaders() {
            return this.httpConfig.getHeaders();
        }

        public void setHeaders(Map<String, String> headers) {
            this.httpConfig.setHeaders(headers);
        }
    }
}

