/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.transports;

import io.openlineage.client.transports.ConsoleConfig;
import io.openlineage.client.transports.ConsoleTransport;
import io.openlineage.client.transports.HttpConfig;
import io.openlineage.client.transports.HttpTransport;
import io.openlineage.client.transports.KafkaConfig;
import io.openlineage.client.transports.KafkaTransport;
import io.openlineage.client.transports.KinesisConfig;
import io.openlineage.client.transports.KinesisTransport;
import io.openlineage.client.transports.Transport;
import io.openlineage.client.transports.TransportConfig;
import lombok.NonNull;

public final class TransportFactory {
    private static final String DEFAULT_LINEAGE_SOURCE = "openlineage-java";
    private final TransportConfig transportConfig;

    public TransportFactory(@NonNull TransportConfig transportConfig) {
        if (transportConfig == null) {
            throw new NullPointerException("transportConfig is marked non-null but is null");
        }
        this.transportConfig = transportConfig;
    }

    public Transport build() {
        if (this.transportConfig instanceof ConsoleConfig) {
            return new ConsoleTransport();
        }
        if (this.transportConfig instanceof HttpConfig) {
            return new HttpTransport((HttpConfig)this.transportConfig);
        }
        if (this.transportConfig instanceof KafkaConfig) {
            KafkaConfig kafkaConfig = (KafkaConfig)this.transportConfig;
            if (!kafkaConfig.hasLocalServerId()) {
                kafkaConfig.setLocalServerId(DEFAULT_LINEAGE_SOURCE);
            }
            kafkaConfig.getProperties().put("server.id", kafkaConfig.getLocalServerId());
            return new KafkaTransport(kafkaConfig);
        }
        if (this.transportConfig instanceof KinesisConfig) {
            KinesisConfig config = (KinesisConfig)this.transportConfig;
            return new KinesisTransport(config);
        }
        throw new IllegalArgumentException("Transport must be of type 'Console', 'HTTP', 'Kafka' or 'Kinesis'.");
    }
}

