/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.transports;

import io.openlineage.client.transports.TokenProvider;
import io.openlineage.client.transports.TransportConfig;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nullable;

public final class HttpConfig
implements TransportConfig {
    private URI url;
    @Nullable
    private String endpoint;
    @Nullable
    private Double timeout;
    @Nullable
    private TokenProvider auth;
    @Nullable
    private Map<String, String> urlParams;

    public HttpConfig() {
    }

    public HttpConfig(URI url, @Nullable String endpoint, @Nullable Double timeout, @Nullable TokenProvider auth, @Nullable Map<String, String> urlParams) {
        this.url = url;
        this.endpoint = endpoint;
        this.timeout = timeout;
        this.auth = auth;
        this.urlParams = urlParams;
    }

    public String toString() {
        return "HttpConfig(url=" + this.getUrl() + ", endpoint=" + this.getEndpoint() + ", timeout=" + this.getTimeout() + ", auth=" + this.getAuth() + ", urlParams=" + this.getUrlParams() + ")";
    }

    public HttpConfig withUrl(URI url) {
        return this.url == url ? this : new HttpConfig(url, this.endpoint, this.timeout, this.auth, this.urlParams);
    }

    public HttpConfig withEndpoint(@Nullable String endpoint) {
        return this.endpoint == endpoint ? this : new HttpConfig(this.url, endpoint, this.timeout, this.auth, this.urlParams);
    }

    public HttpConfig withTimeout(@Nullable Double timeout) {
        return this.timeout == timeout ? this : new HttpConfig(this.url, this.endpoint, timeout, this.auth, this.urlParams);
    }

    public HttpConfig withAuth(@Nullable TokenProvider auth) {
        return this.auth == auth ? this : new HttpConfig(this.url, this.endpoint, this.timeout, auth, this.urlParams);
    }

    public HttpConfig withUrlParams(@Nullable Map<String, String> urlParams) {
        return this.urlParams == urlParams ? this : new HttpConfig(this.url, this.endpoint, this.timeout, this.auth, urlParams);
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    @Nullable
    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(@Nullable String endpoint) {
        this.endpoint = endpoint;
    }

    @Nullable
    public Double getTimeout() {
        return this.timeout;
    }

    public void setTimeout(@Nullable Double timeout) {
        this.timeout = timeout;
    }

    @Nullable
    public TokenProvider getAuth() {
        return this.auth;
    }

    public void setAuth(@Nullable TokenProvider auth) {
        this.auth = auth;
    }

    @Nullable
    public Map<String, String> getUrlParams() {
        return this.urlParams;
    }

    public void setUrlParams(@Nullable Map<String, String> urlParams) {
        this.urlParams = urlParams;
    }
}

