/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClientUtils;
import io.openlineage.client.transports.ConsoleTransport;
import io.openlineage.client.transports.Transport;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenLineageClient {
    private static final Logger log = LoggerFactory.getLogger(OpenLineageClient.class);
    final Transport transport;
    final String[] disabledFacets;

    public OpenLineageClient() {
        this(new ConsoleTransport());
    }

    public OpenLineageClient(@NonNull Transport transport) {
        this(transport, new String[0]);
        if (transport == null) {
            throw new NullPointerException("transport is marked non-null but is null");
        }
    }

    public OpenLineageClient(@NonNull Transport transport, String[] disabledFacets) {
        if (transport == null) {
            throw new NullPointerException("transport is marked non-null but is null");
        }
        this.transport = transport;
        this.disabledFacets = disabledFacets;
        OpenLineageClientUtils.configureObjectMapper(disabledFacets);
    }

    public void emit(@NonNull OpenLineage.RunEvent runEvent) {
        if (runEvent == null) {
            throw new NullPointerException("runEvent is marked non-null but is null");
        }
        this.transport.emit(runEvent);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final Transport DEFAULT_TRANSPORT = new ConsoleTransport();
        private Transport transport = DEFAULT_TRANSPORT;
        private String[] disabledFacets = new String[0];

        private Builder() {
        }

        public Builder transport(@NonNull Transport transport) {
            if (transport == null) {
                throw new NullPointerException("transport is marked non-null but is null");
            }
            this.transport = transport;
            return this;
        }

        public Builder disableFacets(@NonNull String[] disabledFacets) {
            if (disabledFacets == null) {
                throw new NullPointerException("disabledFacets is marked non-null but is null");
            }
            this.disabledFacets = disabledFacets;
            return this;
        }

        public OpenLineageClient build() {
            return new OpenLineageClient(this.transport, this.disabledFacets);
        }
    }
}

