/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.transports;

import io.openlineage.client.transports.TokenProvider;
import io.openlineage.client.transports.TransportConfig;
import java.net.URI;
import javax.annotation.Nullable;

public final class HttpConfig
implements TransportConfig {
    private URI url;
    @Nullable
    private String endpoint;
    @Nullable
    private Double timeout;
    @Nullable
    private TokenProvider auth;

    public HttpConfig() {
    }

    public HttpConfig(URI url, @Nullable String endpoint, @Nullable Double timeout, @Nullable TokenProvider auth) {
        this.url = url;
        this.endpoint = endpoint;
        this.timeout = timeout;
        this.auth = auth;
    }

    public String toString() {
        return "HttpConfig(url=" + this.getUrl() + ", endpoint=" + this.getEndpoint() + ", timeout=" + this.getTimeout() + ", auth=" + this.getAuth() + ")";
    }

    public HttpConfig withUrl(URI url) {
        return this.url == url ? this : new HttpConfig(url, this.endpoint, this.timeout, this.auth);
    }

    public HttpConfig withEndpoint(@Nullable String endpoint) {
        return this.endpoint == endpoint ? this : new HttpConfig(this.url, endpoint, this.timeout, this.auth);
    }

    public HttpConfig withTimeout(@Nullable Double timeout) {
        return this.timeout == timeout ? this : new HttpConfig(this.url, this.endpoint, timeout, this.auth);
    }

    public HttpConfig withAuth(@Nullable TokenProvider auth) {
        return this.auth == auth ? this : new HttpConfig(this.url, this.endpoint, this.timeout, auth);
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    @Nullable
    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(@Nullable String endpoint) {
        this.endpoint = endpoint;
    }

    @Nullable
    public Double getTimeout() {
        return this.timeout;
    }

    public void setTimeout(@Nullable Double timeout) {
        this.timeout = timeout;
    }

    @Nullable
    public TokenProvider getAuth() {
        return this.auth;
    }

    public void setAuth(@Nullable TokenProvider auth) {
        this.auth = auth;
    }
}

