/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.transports;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClientUtils;
import io.openlineage.client.transports.KafkaConfig;
import io.openlineage.client.transports.Transport;
import lombok.NonNull;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafkaTransport
extends Transport {
    private static final Logger log = LoggerFactory.getLogger(KafkaTransport.class);
    private final String topicName;
    private final String localServerId;
    private final KafkaProducer<String, String> producer;

    public KafkaTransport(@NonNull KafkaConfig kafkaConfig) {
        this((KafkaProducer<String, String>)new KafkaProducer(kafkaConfig.getProperties()), kafkaConfig);
        if (kafkaConfig == null) {
            throw new NullPointerException("kafkaConfig is marked non-null but is null");
        }
    }

    public KafkaTransport(@NonNull KafkaProducer<String, String> kafkaProducer, @NonNull KafkaConfig kafkaConfig) {
        super(Transport.Type.KAFKA);
        if (kafkaProducer == null) {
            throw new NullPointerException("kafkaProducer is marked non-null but is null");
        }
        if (kafkaConfig == null) {
            throw new NullPointerException("kafkaConfig is marked non-null but is null");
        }
        this.topicName = kafkaConfig.getTopicName();
        this.localServerId = kafkaConfig.getLocalServerId();
        this.producer = kafkaProducer;
    }

    @Override
    public void emit(@NonNull OpenLineage.RunEvent runEvent) {
        if (runEvent == null) {
            throw new NullPointerException("runEvent is marked non-null but is null");
        }
        String eventAsJson = OpenLineageClientUtils.toJson(runEvent);
        log.debug("Received lineage event: {}", (Object)eventAsJson);
        ProducerRecord record = new ProducerRecord(this.topicName, (Object)this.localServerId, (Object)eventAsJson);
        try {
            this.producer.send(record);
        }
        catch (Exception e) {
            log.error("Failed to collect lineage event: {}", (Object)eventAsJson, (Object)e);
        }
    }
}

