/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client;

import io.openlineage.client.ConfigPathProvider;
import io.openlineage.client.DefaultConfigPathProvider;
import io.openlineage.client.Environment;
import io.openlineage.client.OpenLineageClient;
import io.openlineage.client.OpenLineageClientUtils;
import io.openlineage.client.OpenLineageYaml;
import io.openlineage.client.transports.NoopTransport;
import io.openlineage.client.transports.Transport;
import io.openlineage.client.transports.TransportFactory;

public final class Clients {
    private Clients() {
    }

    public static OpenLineageClient newClient() {
        return Clients.newClient(new DefaultConfigPathProvider());
    }

    public static OpenLineageClient newClient(ConfigPathProvider configPathProvider) {
        String isDisabled = Environment.getEnvironmentVariable("OPENLINEAGE_DISABLED");
        if (Boolean.parseBoolean(isDisabled)) {
            return OpenLineageClient.builder().transport(new NoopTransport()).build();
        }
        OpenLineageYaml openLineageYaml = OpenLineageClientUtils.loadOpenLineageYaml(configPathProvider);
        TransportFactory factory = new TransportFactory(openLineageYaml.getTransportConfig());
        Transport transport = factory.build();
        return OpenLineageClient.builder().transport(transport).build();
    }
}

