/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.shaded.org.apache.http.impl.conn;

import io.openlineage.client.shaded.org.apache.http.annotation.Contract;
import io.openlineage.client.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.openlineage.client.shaded.org.apache.http.conn.ManagedHttpClientConnection;
import io.openlineage.client.shaded.org.apache.http.conn.routing.HttpRoute;
import io.openlineage.client.shaded.org.apache.http.impl.conn.CPoolEntry;
import io.openlineage.client.shaded.org.apache.http.pool.AbstractConnPool;
import io.openlineage.client.shaded.org.apache.http.pool.ConnFactory;
import io.openlineage.client.shaded.org.apache.http.pool.PoolEntryCallback;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Contract(threading=ThreadingBehavior.SAFE)
class CPool
extends AbstractConnPool<HttpRoute, ManagedHttpClientConnection, CPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();
    private final Log log = LogFactory.getLog(CPool.class);
    private final long timeToLive;
    private final TimeUnit timeUnit;

    public CPool(ConnFactory<HttpRoute, ManagedHttpClientConnection> connFactory, int defaultMaxPerRoute, int maxTotal, long timeToLive, TimeUnit timeUnit) {
        super(connFactory, defaultMaxPerRoute, maxTotal);
        this.timeToLive = timeToLive;
        this.timeUnit = timeUnit;
    }

    @Override
    protected CPoolEntry createEntry(HttpRoute route, ManagedHttpClientConnection conn) {
        String id = Long.toString(COUNTER.getAndIncrement());
        return new CPoolEntry(this.log, id, route, conn, this.timeToLive, this.timeUnit);
    }

    @Override
    protected boolean validate(CPoolEntry entry) {
        return !((ManagedHttpClientConnection)entry.getConnection()).isStale();
    }

    @Override
    protected void enumAvailable(PoolEntryCallback<HttpRoute, ManagedHttpClientConnection> callback) {
        super.enumAvailable(callback);
    }

    @Override
    protected void enumLeased(PoolEntryCallback<HttpRoute, ManagedHttpClientConnection> callback) {
        super.enumLeased(callback);
    }
}

