/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.servlet.response;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.websphere.servlet.response.CollectionEnumerationHybrid;
import com.ibm.websphere.servlet.response.DummyResponse;
import com.ibm.websphere.servlet.response.HttpServletResponseProxy;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.websphere.servlet.response.ResponseErrorReport;
import com.ibm.websphere.servlet.response.StoredHeader;
import com.ibm.websphere.servlet.response.StoredResponseCompat;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.servlet.IncludedResponse;
import com.ibm.ws.webcontainer.srt.SRTOutputStream;
import com.ibm.ws.webcontainer.srt.SRTServletResponse;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import com.ibm.wsspi.webcontainer.servlet.IOutputMethodListener;
import com.ibm.wsspi.webcontainer.servlet.ServletResponseExtended;
import com.ibm.wsspi.webcontainer.util.ByteBufferOutputStream;
import com.ibm.wsspi.webcontainer.util.EncodingUtils;
import com.ibm.wsspi.webcontainer.util.FFDCWrapper;
import com.ibm.wsspi.webcontainer.util.IOutputStreamObserver;
import com.ibm.wsspi.webcontainer.util.IResponseOutput;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class StoredResponse
extends HttpServletResponseWrapper
implements StoredResponseCompat<CollectionEnumerationHybrid<String>>,
HttpServletResponse,
Serializable,
IResponseOutput,
IExtendedResponse,
IOutputStreamObserver {
    private static final long serialVersionUID = 3257847662609707832L;
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.websphere.servlet.response");
    private static final String CLASS_NAME = "com.ibm.websphere.servlet.response.StoredResponse";
    protected static final TraceNLS nls = TraceNLS.getTraceNLS(StoredResponse.class, (String)"com.ibm.ws.webcontainer.resources.Messages");
    private static final int DEFAULT_STATUS_CODE = 200;
    protected PrintWriter _writer;
    private SRTOutputStream _outInternal;
    protected ServletOutputStream _out;
    private ByteBufferOutputStream _bbOutInternal;
    protected ServletOutputStream _bbOut;
    private boolean _isFinished;
    private byte[] _outputBuffer;
    private int _statusCode;
    private String _statusMessage;
    private String _redirectURI;
    private Cookie[] _cookies;
    private long _lastModified;
    private ResponseErrorReport _error;
    private StoredHeader _header;
    protected boolean _writerObtained;
    protected boolean _outputStreamObtained;
    private static final String _defaultEncoding = "ISO-8859-1";
    private String _contentType;
    private String _encoding;
    private Locale _locale;
    private Locale _defaultLocale;
    protected int bufferSize;
    private boolean isCommitted;
    private List<WsByteBuffer> _bbList;
    private IOutputMethodListener outputMethodListener;
    protected boolean isInclude;
    private Vector[] headerTable;
    protected boolean outputWritten;
    private boolean internalHeaderSettable;
    private boolean outputFlushed;
    private boolean finishedOutput;
    protected boolean dummyResponse;
    private IExtendedResponse extResponse;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StoredResponse() {
        super((HttpServletResponse)new DummyResponse());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[0]);
        }
        this._statusCode = 200;
        this._cookies = new Cookie[0];
        this._writerObtained = false;
        this._outputStreamObtained = false;
        this._contentType = null;
        this.bufferSize = 4096;
        this.isCommitted = false;
        this._bbList = null;
        this.isInclude = false;
        this.dummyResponse = true;
        this.init();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StoredResponse(boolean isInclude) {
        super((HttpServletResponse)new DummyResponse());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{isInclude});
        }
        this._statusCode = 200;
        this._cookies = new Cookie[0];
        this._writerObtained = false;
        this._outputStreamObtained = false;
        this._contentType = null;
        this.bufferSize = 4096;
        this.isCommitted = false;
        this._bbList = null;
        this.isInclude = false;
        this.dummyResponse = true;
        this.isInclude = isInclude;
        this.init();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StoredResponse(ServletResponseExtended extResponse, boolean isInclude) {
        super((HttpServletResponse)extResponse);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{extResponse, isInclude});
        }
        this._statusCode = 200;
        this._cookies = new Cookie[0];
        this._writerObtained = false;
        this._outputStreamObtained = false;
        this._contentType = null;
        this.bufferSize = 4096;
        this.isCommitted = false;
        this._bbList = null;
        this.isInclude = false;
        this.dummyResponse = true;
        this.extResponse = (IExtendedResponse)extResponse;
        this.dummyResponse = false;
        this.isInclude = isInclude;
        this.init();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void init() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "init", new Object[0]);
        }
        if (this.dummyResponse) {
            this._header = new StoredHeader();
        }
        if (!this.isInclude) {
            this.setContentType("text/html");
            this._encoding = _defaultEncoding;
            this._locale = this._defaultLocale = Locale.getDefault();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "init");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void initOutputStream() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "initOutputStream", new Object[0]);
        }
        this._bbOutInternal = new ByteBufferOutputStream();
        this._outInternal = new SRTOutputStream();
        this._out = this._outInternal;
        this._bbOut = this._bbOutInternal;
        this._outInternal.init((OutputStream)this._bbOutInternal);
        this._bbOutInternal.setObserver((IOutputStreamObserver)this);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "initOutputStream");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean writerObtained() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "writerObtained", new Object[0]);
        }
        boolean bl = this._writerObtained;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "writerObtained", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean outputStreamObtained() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "outputStreamObtained", new Object[0]);
        }
        boolean bl = this._outputStreamObtained;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "outputStreamObtained", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addCookie(Cookie cookie) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "addCookie", new Object[]{cookie});
        }
        if (!this.dummyResponse) {
            super.addCookie(cookie);
        } else if (this.isInclude) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addCookie", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "addCookie cookie --> " + cookie.getName());
            }
        } else {
            Cookie[] newCookies = new Cookie[this._cookies.length + 1];
            System.arraycopy(this._cookies, 0, newCookies, 0, this._cookies.length);
            newCookies[this._cookies.length] = cookie;
            this._cookies = newCookies;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "addCookie");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public IResponse getIResponse() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getIResponse", new Object[0]);
        }
        if (!this.dummyResponse) {
            IResponse iResponse = this.extResponse.getIResponse();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                iResponse = iResponse;
                logger.exiting(CLASS_NAME, "getIResponse", iResponse);
            }
            return iResponse;
        }
        IResponse iResponse = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iResponse = iResponse;
            logger.exiting(CLASS_NAME, "getIResponse", iResponse);
        }
        return iResponse;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ServletOutputStream getOutputStream() throws IllegalStateException, IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getOutputStream", new Object[0]);
        }
        if (this._writerObtained) {
            throw new IllegalStateException("Writer as already been obtained for this Response object");
        }
        if (this._outputStreamObtained) {
            SRTOutputStream sRTOutputStream = this._outInternal;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                sRTOutputStream = sRTOutputStream;
                logger.exiting(CLASS_NAME, "getOutputStream", sRTOutputStream);
            }
            return sRTOutputStream;
        }
        this.initOutputStream();
        this._outputStreamObtained = true;
        this.fireOutputStreamRetrievedEvent((ServletOutputStream)this._outInternal);
        SRTOutputStream sRTOutputStream = this._outInternal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            sRTOutputStream = sRTOutputStream;
            logger.exiting(CLASS_NAME, "getOutputStream", sRTOutputStream);
        }
        return sRTOutputStream;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setContentLength(int len) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setContentLength", new Object[]{len});
        }
        if (!this.dummyResponse) {
            super.setContentLength(len);
        } else if (this.isInclude) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setContentLength", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setContentLength length --> " + len);
            }
        } else {
            this.setIntHeader("content-length", len);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setContentLength");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setContentType(String type) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setContentType", new Object[]{type});
        }
        if (!this.dummyResponse) {
            super.setContentType(type);
        } else if (this.isInclude) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setContentType", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setContentType type --> " + type);
            }
        } else {
            this.setHeader("content-type", type);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setContentType");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setBufferSize(int size) throws IllegalStateException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setBufferSize", new Object[]{size});
        }
        if (this._writer != null) {
            this._writer.flush();
        }
        if (this._bbOutInternal != null) {
            this._bbOutInternal.reset();
        }
        if (this.outputWritten) {
            throw new IllegalStateException("Cannot set buffer size after write");
        }
        if (!this.dummyResponse) {
            super.setBufferSize(size);
        } else {
            this.bufferSize = size;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setBufferSize");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getBufferSize() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getBufferSize", new Object[0]);
        }
        if (!this.dummyResponse) {
            int n = super.getBufferSize();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                n = n;
                logger.exiting(CLASS_NAME, "getBufferSize", n);
            }
            return n;
        }
        int n = this.bufferSize;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting(CLASS_NAME, "getBufferSize", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void flushBuffer() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "flushBuffer", new Object[0]);
        }
        this.flushBuffer(true);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "flushBuffer");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void flushBuffer(boolean flushToWire) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "flushBuffer", new Object[]{flushToWire});
        }
        if (this._writer != null) {
            this._writer.flush();
        }
        if (this._outInternal != null) {
            this._outInternal.flush();
        }
        this.isCommitted = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "flushBuffer");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isCommitted() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isCommitted", new Object[0]);
        }
        boolean bl = this.isCommitted;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isCommitted", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void reset() throws IllegalStateException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "reset", new Object[0]);
        }
        if (this.isCommitted) {
            throw new IllegalStateException("Response cannot be reset after it has been committed");
        }
        if (!this.dummyResponse) {
            super.reset();
        }
        if (this._writer != null) {
            this._writer.flush();
        }
        if (this._bbOutInternal != null) {
            this._bbOutInternal.reset();
        }
        this.isCommitted = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "reset");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Vector[] getHeaderTable() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getHeaderTable", new Object[0]);
        }
        if (!this.dummyResponse) {
            Vector[] vectorArray = this.extResponse.getHeaderTable();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                vectorArray = vectorArray;
                logger.exiting(CLASS_NAME, "getHeaderTable", vectorArray);
            }
            return vectorArray;
        }
        Vector[] vectorArray = this.headerTable;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            vectorArray = vectorArray;
            logger.exiting(CLASS_NAME, "getHeaderTable", vectorArray);
        }
        return vectorArray;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addSessionCookie(Cookie cookie) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "addSessionCookie", new Object[]{cookie});
        }
        if (this.dummyResponse) {
            if (this.isInclude) {
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "addSessionCookie", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "addSessionCookie cookie --> " + cookie);
                }
                throw new IllegalStateException("cannot add session from a stored/async response");
            }
            throw new IllegalStateException("This method is not supported, use HttpServletResponse.addCookie(Cookie cookie) instead");
        }
        this.extResponse.addSessionCookie(cookie);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "addSessionCookie");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setLocale(Locale loc) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setLocale", new Object[]{loc});
        }
        if (!this.dummyResponse) {
            super.setLocale(loc);
        } else if (this.isInclude) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setLocale", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setLocale locale --> " + loc);
            }
        } else {
            this._locale = loc;
            this.setCharacterEncoding(EncodingUtils.getEncodingFromLocale((Locale)this._locale));
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setLocale");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setCharacterEncoding(String encoding) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setCharacterEncoding", new Object[]{encoding});
        }
        if (!this.dummyResponse) {
            super.setCharacterEncoding(encoding);
        } else if (this.isInclude) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setCharacterEncoding", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setCharacterEncoding encoding --> " + encoding);
            }
        } else {
            if (encoding != null) {
                if (encoding.startsWith("\"") || encoding.startsWith("'")) {
                    encoding = encoding.substring(1);
                }
                if (encoding.endsWith("\"") || encoding.endsWith("'")) {
                    encoding = encoding.substring(0, encoding.length() - 1);
                }
            }
            this._encoding = encoding;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setCharacterEncoding");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Locale getLocale() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getLocale", new Object[0]);
        }
        if (!this.dummyResponse) {
            Locale locale = super.getLocale();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                locale = locale;
                logger.exiting(CLASS_NAME, "getLocale", locale);
            }
            return locale;
        }
        Locale locale = this._locale;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            locale = locale;
            logger.exiting(CLASS_NAME, "getLocale", locale);
        }
        return locale;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addDateHeader(String name, long date) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "addDateHeader", new Object[]{name, date});
        }
        if (!this.dummyResponse) {
            super.addDateHeader(name, date);
        } else if (this.isInclude && com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addDateHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "name->" + name + ", date->" + date);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "addDateHeader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addHeader(String name, String value) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "addHeader", new Object[]{name, value});
        }
        if (!this.dummyResponse) {
            super.addHeader(name, value);
        } else if (this.isInclude && com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "name->" + name + ", value->" + value);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "addHeader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addIntHeader(String name, int value) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "addIntHeader", new Object[]{name, value});
        }
        if (!this.dummyResponse) {
            super.addIntHeader(name, value);
        } else if (this.isInclude && com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addIntHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "name->" + name + ", value->" + value);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "addIntHeader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setHeader(String name, String value) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setHeader", new Object[]{name, value});
        }
        this.setHeader(name, value, true);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setHeader");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setInternalHeader(String name, String value) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setInternalHeader", new Object[]{name, value});
        }
        if (!this.internalHeaderSettable) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setInternalHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "name->" + name + ", value->" + value);
            }
        } else {
            this.setHeader(name, value, false);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setInternalHeader");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setHeader(String name, String value, boolean checkInclude) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setHeader", new Object[]{name, value, checkInclude});
        }
        if (checkInclude && this.isInclude) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "name->" + name + ", value->" + value + ", checkInclude->" + checkInclude);
            }
        } else if (!this.dummyResponse) {
            this.extResponse.setHeader(name, value, false);
            if (name.equalsIgnoreCase("content-type")) {
                this._encoding = super.getCharacterEncoding();
            }
        } else {
            this._header.setHeader(name, value);
            if (name.toLowerCase().equals("content-type")) {
                String val;
                int index;
                if (value != null && (index = (val = value.toLowerCase()).indexOf("charset=")) != -1) {
                    String encoding = val.substring(index + 8);
                    if (encoding.startsWith("\"") || encoding.startsWith("'")) {
                        encoding = encoding.substring(1);
                    }
                    if (encoding.endsWith("\"") || encoding.endsWith("'")) {
                        encoding = encoding.substring(0, encoding.length() - 1);
                    }
                    this.setCharacterEncoding(encoding);
                    value = val.substring(0, index + 8) + encoding;
                }
                this._contentType = value;
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setHeader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setIntHeader(String name, int value) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setIntHeader", new Object[]{name, value});
        }
        if (this.isInclude) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setIntHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "name->" + name + ", value->" + value);
            }
        } else {
            this._header.setIntHeader(name, value);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setIntHeader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setDateHeader(String name, long value) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setDateHeader", new Object[]{name, value});
        }
        if (this.isInclude) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setDateHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "name->" + name + ", value->" + value);
            }
        } else {
            this._header.setDateHeader(name, value);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setDateHeader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean containsHeader(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "containsHeader", new Object[]{name});
        }
        if (!this.dummyResponse) {
            boolean bl = super.containsHeader(name);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "containsHeader", bl);
            }
            return bl;
        }
        if (this._header != null && this._header.containsHeader(name)) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "containsHeader", bl);
            }
            return bl;
        }
        if (this.headerTable != null && this.headerTable[0].contains(name)) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "containsHeader", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "containsHeader", bl);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public PrintWriter getWriter() throws IOException, IllegalStateException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getWriter", new Object[0]);
        }
        if (this._outputStreamObtained) {
            throw new IllegalStateException("OutputStream already obtained for this Response object");
        }
        if (this._writerObtained) {
            PrintWriter printWriter = this._writer;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                printWriter = printWriter;
                logger.exiting(CLASS_NAME, "getWriter", printWriter);
            }
            return printWriter;
        }
        this.initOutputStream();
        OutputStreamWriter _outWriter = null;
        try {
            String encoding = this.getCharacterEncoding();
            _outWriter = encoding == null ? new OutputStreamWriter((OutputStream)this._outInternal) : new OutputStreamWriter((OutputStream)this._outInternal, encoding);
        }
        catch (UnsupportedEncodingException encoding) {
            void e;
            FFDCFilter.processException((Throwable)encoding, (String)CLASS_NAME, (String)"521", (Object)this, (Object[])new Object[0]);
            FFDCWrapper.processException((Throwable)e, (String)"com.ibm.websphere.servlet.response.StoredResponse.getWriter", (String)"248", (Object)this);
            _outWriter = new OutputStreamWriter((OutputStream)this._outInternal);
        }
        this._writer = new PrintWriter(_outWriter);
        _outWriter = null;
        this._writerObtained = true;
        this.fireWriterRetrievedEvent(this._writer);
        PrintWriter printWriter = this._writer;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            printWriter = printWriter;
            logger.exiting(CLASS_NAME, "getWriter", printWriter);
        }
        return printWriter;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setStatus(int sc) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setStatus", new Object[]{sc});
        }
        if (this.isInclude) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setStatus", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "status->" + sc);
            }
        } else {
            this._statusCode = sc;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setStatus");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setStatus(int sc, String message) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setStatus", new Object[]{sc, message});
        }
        if (this.isInclude) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setStatus", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "status->" + sc + ", message->" + message);
            }
        } else {
            this._statusCode = sc;
            this._statusMessage = message;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setStatus");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void sendError(int sc) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "sendError", new Object[]{sc});
        }
        if (!this.dummyResponse) {
            super.sendError(sc);
        } else if (this.isInclude) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sendError", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "status->" + sc);
            }
        } else {
            this._error = new ResponseErrorReport();
            this._error.setErrorCode(sc);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "sendError");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void sendError(int sc, String message) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "sendError", new Object[]{sc, message});
        }
        if (!this.dummyResponse) {
            super.sendError(sc, message);
        } else if (this.isInclude) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sendError", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "status->" + sc + ", message->" + message);
            }
        } else {
            this._error = new ResponseErrorReport(message);
            this._error.setErrorCode(sc);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "sendError");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String encodeURL(String url) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "encodeURL", new Object[]{url});
        }
        if (!this.dummyResponse) {
            String string = super.encodeURL(url);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "encodeURL", string);
            }
            return string;
        }
        String string = url;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "encodeURL", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String encodeUrl(String url) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "encodeUrl", new Object[]{url});
        }
        if (!this.dummyResponse) {
            String string = super.encodeUrl(url);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "encodeUrl", string);
            }
            return string;
        }
        String string = this.encodeUrl(url);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "encodeUrl", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void sendRedirect(String uri) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "sendRedirect", new Object[]{uri});
        }
        if (this.isInclude) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sendRedirect", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "uri->" + uri);
            }
        } else {
            this._redirectURI = uri;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "sendRedirect");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void sendRedirect303(String uri) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "sendRedirect303", new Object[]{uri});
        }
        if (this.isInclude) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sendRedirect303", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "uri->" + uri);
            }
        } else {
            this._redirectURI = uri;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "sendRedirect303");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String encodeRedirectURL(String url) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "encodeRedirectURL", new Object[]{url});
        }
        if (!this.dummyResponse) {
            String string = super.encodeRedirectURL(url);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "encodeRedirectURL", string);
            }
            return string;
        }
        String string = url;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "encodeRedirectURL", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String encodeRedirectUrl(String url) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "encodeRedirectUrl", new Object[]{url});
        }
        if (!this.dummyResponse) {
            String string = super.encodeRedirectUrl(url);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "encodeRedirectUrl", string);
            }
            return string;
        }
        String string = url;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "encodeRedirectUrl", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void finishOutput(boolean toByteArray) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "finishOutput", new Object[]{toByteArray});
        }
        if (!this.finishedOutput) {
            this.finishedOutput = true;
            if (this._writer != null) {
                this._writer.flush();
            }
            if (this._outInternal != null) {
                this._outInternal.close();
                this._bbOutInternal.flushBuffer();
                if (toByteArray) {
                    this._outputBuffer = this._bbOutInternal.toByteArray();
                    this._bbOutInternal.reset();
                } else {
                    this._bbList = this._bbOutInternal.getByteBufferList();
                }
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "finishOutput");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void finish() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "finish", new Object[0]);
        }
        this._finish();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "finish");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void _finish() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "_finish", new Object[0]);
        }
        if (this._isFinished) {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting(CLASS_NAME, "_finish");
            }
            return;
        }
        StoredResponse storedResponse = this;
        synchronized (storedResponse) {
            block11: {
                if (!this._isFinished) break block11;
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var1_1
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    logger.exiting(CLASS_NAME, "_finish");
                }
                return;
            }
            this._isFinished = true;
            this.finishOutput(true);
            if (!this.isInclude && this._outputBuffer != null) {
                this.setContentLength(this._outputBuffer.length);
            }
            if (this._header != null) {
                this._lastModified = this._header.getDateHeader("last-modified");
            }
            this._writer = null;
            this._outInternal = null;
            this._bbOutInternal = null;
            this._out = null;
            this._bbOut = null;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "_finish");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void close() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "close", new Object[0]);
        }
        this._finish();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "close");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public byte[] getOutputBuffer() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getOutputBuffer", new Object[0]);
        }
        this.finishOutput(true);
        byte[] byArray = this._outputBuffer;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            byArray = byArray;
            logger.exiting(CLASS_NAME, "getOutputBuffer", byArray);
        }
        return byArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<WsByteBuffer> getByteBufferList() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getByteBufferList", new Object[0]);
        }
        this.finishOutput(false);
        List<WsByteBuffer> list = this._bbList;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting(CLASS_NAME, "getByteBufferList", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getOutputBufferAsString() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getOutputBufferAsString", new Object[0]);
        }
        byte[] buffer = this.getOutputBuffer();
        if (buffer != null) {
            String string = new String(buffer, this.getCharacterEncoding());
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "getOutputBufferAsString", string);
            }
            return string;
        }
        String string = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getOutputBufferAsString", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public CollectionEnumerationHybrid<String> getHeaderNames() {
        Enumeration tempEnum;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getHeaderNames", new Object[0]);
        }
        CollectionEnumerationHybrid<String> colEnumHybrid = new CollectionEnumerationHybrid<String>();
        if (this._header != null) {
            tempEnum = this._header.getHeaderNames();
            while (tempEnum.hasMoreElements()) {
                colEnumHybrid.add((String)tempEnum.nextElement());
            }
        }
        if (this.headerTable != null) {
            tempEnum = this.headerTable[0].elements();
            while (tempEnum.hasMoreElements()) {
                colEnumHybrid.add((String)tempEnum.nextElement());
            }
        }
        CollectionEnumerationHybrid<String> collectionEnumerationHybrid = colEnumHybrid;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            collectionEnumerationHybrid = collectionEnumerationHybrid;
            logger.exiting(CLASS_NAME, "getHeaderNames", collectionEnumerationHybrid);
        }
        return collectionEnumerationHybrid;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Enumeration getAddedHeaderNames() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getAddedHeaderNames", new Object[0]);
        }
        if (this._header != null) {
            Enumeration enumeration = this._header.getHeaderNames();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                enumeration = enumeration;
                logger.exiting(CLASS_NAME, "getAddedHeaderNames", enumeration);
            }
            return enumeration;
        }
        Enumeration enumeration = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            enumeration = enumeration;
            logger.exiting(CLASS_NAME, "getAddedHeaderNames", enumeration);
        }
        return enumeration;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getHeader(String name) {
        String strVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getHeader", new Object[]{name});
        }
        if (this._header != null && (strVal = this._header.getHeader(name)) != null) {
            String string = strVal;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "getHeader", string);
            }
            return string;
        }
        if (this.headerTable != null) {
            int i = 0;
            for (Object obj : this.headerTable[0]) {
                String strVal2 = (String)obj;
                if (name.equals(strVal2)) {
                    String string = (String)this.headerTable[1].get(i);
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        string = string;
                        logger.exiting(CLASS_NAME, "getHeader", string);
                    }
                    return string;
                }
                ++i;
            }
        }
        String string = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getHeader", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getIntHeader(String name) {
        int headerVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getIntHeader", new Object[]{name});
        }
        if (this._header != null && (headerVal = this._header.getIntHeader(name)) != -1) {
            int n = headerVal;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                n = n;
                logger.exiting(CLASS_NAME, "getIntHeader", n);
            }
            return n;
        }
        if (this.headerTable != null) {
            int i = 0;
            for (Object obj : this.headerTable[0]) {
                String strVal = (String)obj;
                if (name.equals(strVal)) {
                    int n = Integer.valueOf((String)this.headerTable[1].get(i));
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        n = n;
                        logger.exiting(CLASS_NAME, "getIntHeader", n);
                    }
                    return n;
                }
                ++i;
            }
        }
        int n = -1;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting(CLASS_NAME, "getIntHeader", n);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getDateHeader(String name) {
        long longVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getDateHeader", new Object[]{name});
        }
        if (this._header != null && (longVal = this._header.getDateHeader(name)) != -1L) {
            long l = longVal;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                l = l;
                logger.exiting(CLASS_NAME, "getDateHeader", l);
            }
            return l;
        }
        if (this.headerTable != null) {
            int i = 0;
            for (Object obj : this.headerTable[0]) {
                String strVal = (String)obj;
                if (name.equals(strVal)) {
                    long l;
                    try {
                        l = Long.valueOf((String)this.headerTable[1].get(i));
                    }
                    catch (NumberFormatException numberFormatException) {
                        void nfe;
                        FFDCFilter.processException((Throwable)numberFormatException, (String)CLASS_NAME, (String)"906", (Object)this, (Object[])new Object[]{name});
                        throw new IllegalArgumentException((Throwable)nfe);
                    }
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        l = l;
                        logger.exiting(CLASS_NAME, "getDateHeader", l);
                    }
                    return l;
                }
                ++i;
            }
        }
        long l = -1L;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting(CLASS_NAME, "getDateHeader", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean containsError() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "containsError", new Object[0]);
        }
        boolean bl = this._error != null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "containsError", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ServletErrorReport getError() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getError", new Object[0]);
        }
        ResponseErrorReport responseErrorReport = this._error;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            responseErrorReport = responseErrorReport;
            logger.exiting(CLASS_NAME, "getError", (Object)responseErrorReport);
        }
        return responseErrorReport;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getErrorMessage() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getErrorMessage", new Object[0]);
        }
        if (this.containsError()) {
            String string = this.getError().getMessage();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "getErrorMessage", string);
            }
            return string;
        }
        String string = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getErrorMessage", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getErrorStatusCode() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getErrorStatusCode", new Object[0]);
        }
        if (!this.containsError()) {
            throw new IllegalStateException("sendError() was not called");
        }
        int n = this.getError().getErrorCode();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting(CLASS_NAME, "getErrorStatusCode", n);
        }
        return n;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getStatusCode() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getStatusCode", new Object[0]);
        }
        int n = this._statusCode;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            n = n;
            logger.exiting(CLASS_NAME, "getStatusCode", n);
        }
        return n;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getStatusMessage() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getStatusMessage", new Object[0]);
        }
        String string = this._statusMessage;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getStatusMessage", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getRedirectURI() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getRedirectURI", new Object[0]);
        }
        if (!this.isRedirected()) {
            throw new IllegalStateException("sendRedirect() was not called");
        }
        String string = this._redirectURI;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getRedirectURI", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isRedirected() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isRedirected", new Object[0]);
        }
        boolean bl = this._redirectURI != null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isRedirected", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getCharacterEncoding() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getCharacterEncoding", new Object[0]);
        }
        if (!this.dummyResponse) {
            String string = super.getCharacterEncoding();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "getCharacterEncoding", string);
            }
            return string;
        }
        String string = this._encoding;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getCharacterEncoding", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getContentType() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getContentType", new Object[0]);
        }
        if (!this.dummyResponse) {
            String string = super.getContentType();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "getContentType", string);
            }
            return string;
        }
        String string = this._contentType;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getContentType", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Cookie[] getCookies() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getCookies", new Object[0]);
        }
        Cookie[] cookieArray = this._cookies;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            cookieArray = cookieArray;
            logger.exiting(CLASS_NAME, "getCookies", cookieArray);
        }
        return cookieArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getLastModified() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getLastModified", new Object[0]);
        }
        long l = this._lastModified;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting(CLASS_NAME, "getLastModified", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isExpired() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isExpired", new Object[0]);
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isExpired", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void transferResponse(HttpServletResponse target) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "transferResponse", new Object[]{target});
        }
        this._finish();
        if (this.containsError()) {
            String message = this.getErrorMessage();
            int sc = this.getErrorStatusCode();
            if (message == null) {
                target.sendError(sc);
            } else {
                target.sendError(sc, message);
            }
        } else if (this.isRedirected()) {
            Cookie[] cookies = this.getCookies();
            for (int i = 0; i < cookies.length; ++i) {
                target.addCookie(cookies[i]);
            }
            target.sendRedirect(this.getRedirectURI());
        } else {
            if (this.getStatusMessage() == null) {
                target.setStatus(this.getStatusCode());
            } else {
                target.setStatus(this.getStatusCode(), this.getStatusMessage());
            }
            this._header.transferHeader(target);
            Cookie[] cookies = this.getCookies();
            for (int i = 0; i < cookies.length; ++i) {
                target.addCookie(cookies[i]);
            }
            if (this.getOutputBuffer() != null) {
                ServletOutputStream out;
                try {
                    out = target.getOutputStream();
                }
                catch (IllegalStateException illegalStateException) {
                    FFDCFilter.processException((Throwable)illegalStateException, (String)CLASS_NAME, (String)"1124", (Object)this, (Object[])new Object[]{target});
                    while (!(target instanceof StoredResponse)) {
                        while (target instanceof HttpServletResponseWrapper) {
                            target = (HttpServletResponse)((HttpServletResponseWrapper)target).getResponse();
                        }
                        while (target instanceof HttpServletResponseProxy) {
                            target = ((HttpServletResponseProxy)target).getProxiedHttpServletResponse();
                        }
                        while (target instanceof IncludedResponse) {
                            target = ((IncludedResponse)target).getProxiedHttpServletResponse();
                        }
                        if (!(target instanceof SRTServletResponse)) continue;
                        target.getWriter().write(this.getOutputBufferAsString().toCharArray());
                        if (logger != null && logger.isLoggable(Level.FINER)) {
                            logger.exiting(CLASS_NAME, "transferResponse");
                        }
                        return;
                    }
                    StoredResponse s = (StoredResponse)target;
                    out = s._outInternal;
                }
                out.write(this.getOutputBuffer());
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "transferResponse");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void resetBuffer() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "resetBuffer", new Object[0]);
        }
        if (this._writer != null) {
            this._writer.flush();
        }
        if (this._bbOutInternal != null) {
            this._bbOutInternal.reset();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "resetBuffer");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void fireOutputStreamRetrievedEvent(ServletOutputStream sos) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "fireOutputStreamRetrievedEvent", new Object[]{sos});
        }
        if (this.outputMethodListener != null) {
            this.outputMethodListener.notifyOutputStreamRetrieved(sos);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "fireOutputStreamRetrievedEvent");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void fireWriterRetrievedEvent(PrintWriter pw) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "fireWriterRetrievedEvent", new Object[]{pw});
        }
        if (this.outputMethodListener != null) {
            this.outputMethodListener.notifyWriterRetrieved(pw);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "fireWriterRetrievedEvent");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void registerOutputMethodListener(IOutputMethodListener listener) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "registerOutputMethodListener", new Object[]{listener});
        }
        this.outputMethodListener = listener;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "registerOutputMethodListener");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void destroy() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "destroy", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "destroy");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void initForNextResponse(IResponse res) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "initForNextResponse", new Object[]{res});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "initForNextResponse");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void start() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "start", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "start");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setInclude(boolean isInclude) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setInclude", new Object[]{isInclude});
        }
        this.isInclude = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setInclude");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setInternalHeaderSettable(boolean internalHeaderSettable) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setInternalHeaderSettable", new Object[]{internalHeaderSettable});
        }
        this.internalHeaderSettable = internalHeaderSettable;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setInternalHeaderSettable");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void buildResponseData(ServletResponseExtended response) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "buildResponseData", new Object[]{response});
        }
        this.headerTable = (Vector[])response.getHeaderTable().clone();
        this.buildWriterData(response);
        this._contentType = response.getContentType();
        this._locale = response.getLocale();
        this._statusCode = response.getStatusCode();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "buildResponseData");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void buildWriterData(ServletResponseExtended response) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "buildWriterData", new Object[]{response});
        }
        this.isCommitted = response.isCommitted();
        this._encoding = response.getCharacterEncoding();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "buildWriterData");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void alertClose() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "alertClose", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "alertClose");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void alertException() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "alertException", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "alertException");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void alertFirstFlush() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "alertFirstFlush", new Object[0]);
        }
        this.isCommitted = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "alertFirstFlush");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void alertFirstWrite() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "alertFirstWrite", new Object[0]);
        }
        this.outputWritten = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "alertFirstWrite");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void closeResponseOutput(boolean b) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "closeResponseOutput", new Object[]{b});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "closeResponseOutput");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void removeCookie(String cookieName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "removeCookie", new Object[]{cookieName});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "removeCookie");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isOutputWritten() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isOutputWritten", new Object[0]);
        }
        boolean bl = this.outputWritten;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isOutputWritten", bl);
        }
        return bl;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class InnerEnumeration
    implements Enumeration {
        private Enumeration enum1;
        private Enumeration enum2;
        static final long serialVersionUID = -2756305668762768471L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public InnerEnumeration(Enumeration enum1, Enumeration enum2) {
            this.enum1 = enum1;
            this.enum2 = enum2;
        }

        @Override
        public boolean hasMoreElements() {
            return this.enum1.hasMoreElements() || this.enum2.hasMoreElements();
        }

        public Object nextElement() {
            if (this.enum1.hasMoreElements()) {
                return this.enum1.nextElement();
            }
            if (this.enum2.hasMoreElements()) {
                return this.enum2.nextElement();
            }
            throw new NoSuchElementException();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.websphere.servlet.response.StoredResponse$InnerEnumeration", InnerEnumeration.class, null, null);
        }
    }
}

