/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.logging.hpel.reader;

import com.ibm.websphere.logging.hpel.reader.HpelFormatter;
import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;

public abstract class HpelPlainFormatter
extends HpelFormatter {
    @Override
    public String[] getHeader() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.customHeader.length > 0) {
            for (HpelFormatter.CustomHeaderLine line : this.customHeader) {
                String formattedLine = line.formatLine(this.headerProps);
                if (formattedLine == null) continue;
                result.add(formattedLine);
            }
        } else {
            for (String prop : this.headerProps.stringPropertyNames()) {
                result.add(prop + " = " + this.headerProps.getProperty(prop));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    protected void createEventTimeStamp(RepositoryLogRecord record, StringBuilder buffer) {
        if (null == record) {
            throw new IllegalArgumentException("Record cannot be null");
        }
        if (null == buffer) {
            throw new IllegalArgumentException("Buffer cannot be null");
        }
        buffer.append('[');
        Date eventDate = new Date(record.getMillis());
        this.dateFormat.setTimeZone(this.timeZone);
        buffer.append(this.dateFormat.format(eventDate));
        buffer.append("] ");
    }

    protected static String mapLevelToType(RepositoryLogRecord logRecord) {
        String id;
        if (null == logRecord) {
            return " Z ";
        }
        Level l = logRecord.getLevel();
        if (null == l) {
            return " Z ";
        }
        String s = logRecord.getLoggerName();
        if (s != null) {
            if (s.equals("SystemOut")) {
                return " O ";
            }
            if (s.equals("SystemErr")) {
                return " R ";
            }
        }
        if ((id = (String)customLevels.get(l)) != null) {
            return " " + id + " ";
        }
        if (l == Level.SEVERE) {
            return " E ";
        }
        if (l == Level.WARNING) {
            return " W ";
        }
        if (l == Level.INFO) {
            return " I ";
        }
        if (l == Level.CONFIG) {
            return " C ";
        }
        if (l == Level.FINE) {
            return " 1 ";
        }
        if (l == Level.FINER) {
            String message = logRecord.getRawMessage();
            if (message != null) {
                if (message.indexOf("Entry") != -1 || message.indexOf("ENTRY") != -1) {
                    return " > ";
                }
                if (message.indexOf("Exit") != -1 || message.indexOf("RETURN") != -1) {
                    return " < ";
                }
            }
            return " 2 ";
        }
        if (l == Level.FINEST) {
            return " 3 ";
        }
        return " Z ";
    }
}

