/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.merge;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.merge.ModelType;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ModelEquality {
    static final long serialVersionUID = 3747030273930934553L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static boolean equals(Object a, Object b) {
        return ModelEquality.equalsImpl(a, b);
    }

    @Trivial
    private static boolean equalsImpl(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        Optional<ModelType> modelObject = ModelType.getModelObject(a.getClass());
        if (modelObject.isPresent()) {
            return ModelEquality.equalsModelObject(modelObject.get(), a, b);
        }
        if (a instanceof List) {
            if (!(b instanceof List)) {
                return false;
            }
            return ModelEquality.equalsList((List)a, (List)b);
        }
        if (a instanceof Map) {
            if (!(b instanceof Map)) {
                return false;
            }
            return ModelEquality.equalsMap((Map)a, (Map)b);
        }
        return Objects.equals(a, b);
    }

    @Trivial
    private static boolean equalsMap(Map<?, ?> a, Map<?, ?> b) {
        if (!Objects.equals(a.keySet(), b.keySet())) {
            return false;
        }
        for (Map.Entry<?, ?> entry : a.entrySet()) {
            if (ModelEquality.equalsImpl(entry.getValue(), b.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Trivial
    private static boolean equalsList(List<?> a, List<?> b) {
        if (a.size() != b.size()) {
            return false;
        }
        Iterator<?> ai = a.iterator();
        Iterator<?> bi = b.iterator();
        while (ai.hasNext()) {
            if (ModelEquality.equalsImpl(ai.next(), bi.next())) continue;
            return false;
        }
        return true;
    }

    @Trivial
    private static boolean equalsModelObject(ModelType modelType, Object a, Object b) {
        if (!modelType.isInstance(b)) {
            return false;
        }
        for (ModelType.ModelParameter p : modelType.getParameters()) {
            if (ModelEquality.equalsImpl(p.get(a), p.get(b))) continue;
            return false;
        }
        return true;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi20.internal.merge.ModelEquality", ModelEquality.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    }
}

