/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.reporting.internal;

import com.ibm.websphere.kernel.server.ServerInfoMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.feature.FeatureDefinition;
import com.ibm.ws.kernel.feature.FeatureProvisioner;
import com.ibm.ws.kernel.feature.FixManager;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.productinfo.DuplicateProductInfoException;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.kernel.productinfo.ProductInfoReplaceException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.reporting.internal.DataCollectorException;
import io.openliberty.reporting.internal.utils.HashUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DataCollector {
    private final String uniqueID;
    private String javaVendor = "";
    private final String javaRuntimeInfo;
    private final Set<String> installedFeatures = new HashSet<String>();
    private final String productVersion;
    private final String productEdition;
    private final String productName = "Liberty";
    private final Set<String> iFixSet = new HashSet<String>();
    private final String os;
    private final String osArch;
    static final long serialVersionUID = 2803912248650780723L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Map<String, String> getData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("id", this.uniqueID);
        data.put("productEdition", this.productEdition);
        data.put("productVersion", this.productVersion);
        data.put("productName", "Liberty");
        data.put("features", String.join((CharSequence)",", this.installedFeatures));
        data.put("javaVendor", this.javaVendor);
        data.put("javaVersion", this.javaRuntimeInfo);
        data.put("iFixes", String.join((CharSequence)",", this.iFixSet));
        data.put("osArch", this.osArch);
        data.put("os", this.os);
        return data;
    }

    /*
     * WARNING - void declaration
     */
    public DataCollector(FeatureProvisioner featureProvisioner, FixManager FixManager2, ServerInfoMBean serverInfo) throws IOException, DataCollectorException {
        try {
            Map allProductInfo = ProductInfo.getAllProductInfo();
            this.uniqueID = HashUtils.hashString(serverInfo.getInstallDirectory());
            this.javaRuntimeInfo = serverInfo.getJavaRuntimeVersion();
            this.installedFeatures.addAll(this.getPublicFeatures(featureProvisioner));
            String javaVM = System.getProperty("java.vendor").toLowerCase();
            if (javaVM == null) {
                javaVM = System.getProperty("java.vm.name", "unknown").toLowerCase();
            }
            this.javaVendor = javaVM;
            this.iFixSet.addAll(FixManager2.getIFixes());
            this.os = System.getProperty("os.name");
            this.osArch = System.getProperty("os.arch");
            if (allProductInfo.containsKey("com.ibm.websphere.appserver")) {
                this.productVersion = ((ProductInfo)allProductInfo.get("com.ibm.websphere.appserver")).getVersion();
                this.productEdition = ((ProductInfo)allProductInfo.get("com.ibm.websphere.appserver")).getEdition();
            } else {
                this.productVersion = ((ProductInfo)allProductInfo.get("io.openliberty")).getVersion();
                this.productEdition = ((ProductInfo)allProductInfo.get("io.openliberty")).getEdition();
            }
        }
        catch (DuplicateProductInfoException | ProductInfoParseException | ProductInfoReplaceException javaVM) {
            void e;
            FFDCFilter.processException((Throwable)javaVM, (String)"io.openliberty.reporting.internal.DataCollector", (String)"126", (Object)this, (Object[])new Object[]{featureProvisioner, FixManager2, serverInfo});
            throw new DataCollectorException("Unable to parse Product Info", (Throwable)e);
        }
    }

    private Set<String> getPublicFeatures(FeatureProvisioner featureProvisioner) {
        TreeSet<String> publicFeatures = new TreeSet<String>();
        for (String feature : featureProvisioner.getInstalledFeatures()) {
            FeatureDefinition fd = featureProvisioner.getFeatureDefinition(feature);
            if (fd == null || fd.getVisibility() != Visibility.PUBLIC || fd.getSymbolicName().contains("versionless") || fd.getFeatureName().contains(":")) continue;
            publicFeatures.add(fd.getFeatureName());
        }
        return publicFeatures;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.reporting.internal.DataCollector", DataCollector.class, (String)"cveReporting", (String)"io.openliberty.reporting.internal.resources.CVEReporting");
    }
}

