/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.osgi.request;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.request.extended.IRequestExtended;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.webcontainer.util.ListEnumeration;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.wsspi.http.HttpCookie;
import com.ibm.wsspi.http.HttpInboundConnection;
import com.ibm.wsspi.http.HttpRequest;
import com.ibm.wsspi.http.SSLContext;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.VersionValues;
import com.ibm.wsspi.http.ee7.HttpInboundConnectionExtended;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import io.openliberty.http.ext.HttpRequestExt;
import jakarta.servlet.http.Cookie;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.security.cert.CertificateFactory;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;

public class IRequestImpl
implements IRequestExtended {
    private static final TraceComponent tc = Tr.register(IRequestImpl.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    private HttpInboundConnection conn = null;
    protected HttpRequest request = null;
    private boolean startAsync;
    private ReentrantLock asyncLock;
    private String serverName = null;
    private int serverPort = -1;
    private boolean isHttpsIndicatorSecure;
    private boolean isHttpsIndicatorSecureSet;
    private String normalizedURI = null;
    private String contentType;
    private String scheme;
    private Boolean isSSL;
    private static boolean normalizeRequestURI = WCCustomProperties.NORMALIZE_REQUEST_URI;

    public IRequestImpl(HttpInboundConnection connection) {
        this.conn = connection;
        this.request = connection.getRequest();
    }

    @Override
    public void clearHeaders() {
    }

    @Override
    public List<String> getAllCookieValues(String cookieName) {
        List cookies = this.request.getCookies(cookieName);
        ArrayList<String> values = new ArrayList<String>(cookies.size());
        for (HttpCookie cookie : cookies) {
            values.add(cookie.getValue());
        }
        return values;
    }

    @Override
    public String getAuthType() {
        String type = this.getTrustedHeader(HttpHeaderKeys.HDR_$WSAT);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("type=" + type), (Object[])new Object[0]);
        }
        return type;
    }

    @Override
    public String getCipherSuite() {
        if (this.conn.useTrustedHeaders()) {
            String csHdr = this.getHeader(HttpHeaderKeys.HDR_$WSCS);
            if (csHdr != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getCipherSuite isTrusted --> true suite --> " + csHdr), (Object[])new Object[0]);
                }
                return csHdr;
            }
            if (this.getHeader(HttpHeaderKeys.HDR_$WSRA) != null) {
                return null;
            }
        }
        return this.getConnectionCipherSuite();
    }

    public String getConnectionCipherSuite() {
        String suite = null;
        SSLContext ssl = this.conn.getSSLContext();
        if (null != ssl && ssl.getSession() != null) {
            suite = ssl.getSession().getCipherSuite();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getConnectionCipherSuite suite --> " + suite), (Object[])new Object[0]);
        }
        return suite;
    }

    public Boolean checkForDirectConnection() {
        boolean direct = true;
        if (((HttpRequestExt)this.request).getHeader(HttpHeaderKeys.HDR_$WSRA) != null) {
            direct = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("checkForDirectConnection return --> " + direct), (Object[])new Object[0]);
        }
        return direct;
    }

    @Override
    public int getContentLength() {
        long rc = this.request.getContentLength();
        if (rc > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)rc;
    }

    @Override
    public String getContentType() {
        if (this.contentType == null) {
            this.contentType = ((HttpRequestExt)this.request).getHeader(HttpHeaderKeys.HDR_CONTENT_TYPE);
        }
        return this.contentType;
    }

    @Override
    public byte[] getCookieValue(String cookieName) {
        HttpCookie cookie = this.request.getCookie(cookieName);
        if (null != cookie) {
            return cookie.getValue().getBytes();
        }
        return null;
    }

    @Override
    public Cookie[] getCookies() {
        List cookies;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getCookies ENTRY", (Object[])new Object[0]);
        }
        if ((cookies = this.request.getCookies()).size() == 0) {
            return null;
        }
        Cookie[] rc = new Cookie[cookies.size()];
        int i = 0;
        int t = 0;
        for (HttpCookie cookie : cookies) {
            Cookie newCookie;
            try {
                newCookie = new Cookie(cookie.getName(), cookie.getValue());
            }
            catch (IllegalArgumentException iae) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Invalid cookie name: " + cookie.getName()), (Object[])new Object[0]);
                }
                ++t;
                continue;
            }
            if (cookie.getDomain() != null && !cookie.getDomain().equals("")) {
                newCookie.setDomain(cookie.getDomain());
            }
            newCookie.setComment(cookie.getComment());
            newCookie.setHttpOnly(cookie.isHttpOnly());
            newCookie.setMaxAge(cookie.getMaxAge());
            newCookie.setPath(cookie.getPath());
            newCookie.setVersion(cookie.getVersion());
            newCookie.setSecure(cookie.isSecure());
            rc[i++] = newCookie;
        }
        if (t == 0) {
            return rc;
        }
        if (t == cookies.size()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No valid cookies", (Object[])new Object[0]);
            }
            return null;
        }
        Cookie[] ca = new Cookie[cookies.size() - t];
        System.arraycopy(rc, 0, ca, 0, ca.length);
        return ca;
    }

    @Override
    @FFDCIgnore(value={ParseException.class})
    public long getDateHeader(String name) {
        String value = this.request.getHeader(name);
        if (null != value) {
            try {
                Date rc = this.conn.getDateFormatter().parseTime(value);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(name + " " + rc.getTime()), (Object[])new Object[0]);
                }
                return rc.getTime();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(value, e);
            }
        }
        return -1L;
    }

    @Override
    public String getHeader(String headerName) {
        return this.request.getHeader(headerName);
    }

    public String getHeader(HttpHeaderKeys key) {
        return ((HttpRequestExt)this.request).getHeader(key);
    }

    private String getTrustedHeader(HttpHeaderKeys key) {
        if (this.conn.useTrustedHeaders() && this.request != null) {
            return ((HttpRequestExt)this.request).getHeader(key);
        }
        return null;
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        Set names = ((HttpRequestExt)this.request).getHeaderNamesSet();
        return Collections.enumeration(names);
    }

    @Override
    public Enumeration<String> getHeaders(String headerName) {
        List values = this.request.getHeaders(headerName);
        return values.size() == 0 ? Collections.emptyEnumeration() : new ListEnumeration(values);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.request.getBody();
    }

    @Override
    public int getIntHeader(String name) {
        int rc = -1;
        String value = this.request.getHeader(name);
        if (null != value) {
            rc = Integer.parseInt(value.trim());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(name + " " + rc), (Object[])new Object[0]);
        }
        return rc;
    }

    @Override
    public String getLocalAddr() {
        return this.conn.getLocalHostAddress();
    }

    @Override
    public String getLocalName() {
        return this.conn.getLocalHostName(true);
    }

    @Override
    public int getLocalPort() {
        return this.conn.getLocalPort();
    }

    @Override
    public String getMethod() {
        return this.request.getMethod();
    }

    private java.security.cert.X509Certificate[] convertCertToChain(java.security.cert.X509Certificate rootCert) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"convertCertToChain", (Object[])new Object[]{""});
        }
        java.security.cert.X509Certificate[] chain = null;
        if (rootCert != null) {
            chain = new java.security.cert.X509Certificate[]{rootCert};
        }
        return chain;
    }

    private String armor(String str) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"armor", (Object[])new Object[]{"Enter"});
        }
        String buffer = null;
        if (str.indexOf("BEGIN") != -1) {
            if (str.indexOf("%") != -1) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"armor", (Object[])new Object[]{"Armored certificate is encoded. Returning a decoded armor"});
                    }
                    buffer = URLDecoder.decode(str, "UTF-8");
                }
                catch (Exception e) {
                    Tr.debug((TraceComponent)tc, (String)"armor", (Object[])new Object[]{"Can not decode armored certificate. Return as-is"});
                    buffer = str;
                }
            } else {
                buffer = str;
            }
        } else {
            StringBuffer sb = new StringBuffer();
            sb.append("-----BEGIN CERTIFICATE-----\r\n");
            for (int begin = 0; begin < str.length(); begin += 76) {
                int end = Math.min(begin + 76, str.length());
                sb.append(str.substring(begin, end) + "\r\n");
            }
            sb.append("-----END CERTIFICATE-----\r\n");
            buffer = sb.toString();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"armor", (Object[])new Object[]{"Exit [" + buffer + "]"});
        }
        return buffer;
    }

    @Override
    @FFDCIgnore(value={SSLPeerUnverifiedException.class})
    public java.security.cert.X509Certificate[] getPeerCertificates() {
        try {
            java.security.cert.X509Certificate[] chain = null;
            if (this.conn.useTrustedHeaders()) {
                String clientCertificate = ((HttpRequestExt)this.request).getHeader(HttpHeaderKeys.HDR_$WSCC);
                if (clientCertificate != null) {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream inStream = new ByteArrayInputStream(this.armor(clientCertificate).getBytes());
                    java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)cf.generateCertificate(inStream);
                    chain = this.convertCertToChain(cert);
                    return chain;
                }
                if (((HttpRequestExt)this.request).getHeader(HttpHeaderKeys.HDR_$WSRA) != null) {
                    return null;
                }
            }
            chain = this.getConnectionPeerCertificates();
            return chain;
        }
        catch (Exception exc) {
            FFDCFilter.processException((Throwable)exc, (String)this.getClass().getName(), (String)"peercerts", (Object[])new Object[]{this});
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                TraceComponent tc_twas = Tr.register(IRequestImpl.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.Messages");
                Tr.error((TraceComponent)tc_twas, (String)"invalid.peer.certificate", (Object[])new Object[]{exc.toString()});
            }
            return null;
        }
    }

    public java.security.cert.X509Certificate[] getConnectionPeerCertificates() throws Exception {
        java.security.cert.X509Certificate[] rc;
        block7: {
            rc = null;
            SSLContext ssl = this.conn.getSSLContext();
            if (null != ssl && (ssl.getNeedClientAuth() || ssl.getWantClientAuth())) {
                try {
                    Object[] objs = ssl.getSession().getPeerCertificates();
                    if (objs != null) {
                        rc = (java.security.cert.X509Certificate[])objs;
                    } else {
                        objs = ssl.getSession().getPeerCertificateChain();
                        if (objs != null) {
                            rc = this.convertCertificateChain((X509Certificate[])objs);
                        }
                    }
                }
                catch (SSLPeerUnverifiedException e) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug((TraceComponent)tc, (String)"No certificates in the SSLSession", (Object[])new Object[0]);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"certs->", (Object[])rc);
        }
        return rc;
    }

    private java.security.cert.X509Certificate[] convertCertificateChain(X509Certificate[] inChain) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"convertCertificateChain", (Object[])new Object[]{""});
        }
        java.security.cert.X509Certificate[] outChain = new java.security.cert.X509Certificate[inChain.length];
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        for (int idx = 0; idx < inChain.length; ++idx) {
            outChain[idx] = (java.security.cert.X509Certificate)cf.generateCertificate(new ByteArrayInputStream(inChain[idx].getEncoded()));
        }
        return outChain;
    }

    @Override
    public String getProtocol() {
        String protocol;
        block7: {
            protocol = this.getTrustedHeader(HttpHeaderKeys.HDR_$WSPR);
            if (protocol != null) {
                try {
                    VersionValues value = VersionValues.match((String)protocol, (int)0, (int)protocol.length());
                    if (value != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("getProtocol isTrusted --> true, $WSPR protocol --> " + protocol), (Object[])new Object[0]);
                        }
                        return protocol;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getProtocol isTrusted --> true, invalid $WSPR protocol --> " + protocol), (Object[])new Object[0]);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                    Tr.debug((TraceComponent)tc, (String)("getProtocol isTrusted --> true, invalid $WSPR protocol --> " + protocol), (Object[])new Object[0]);
                }
            }
        }
        protocol = this.request.getVersion();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getProtocol protocol --> " + protocol), (Object[])new Object[0]);
        }
        return protocol;
    }

    @Override
    public String getQueryString() {
        return this.request.getQuery();
    }

    @Override
    public String getRemoteAddr() {
        return this.conn.getRemoteHostAddress();
    }

    @Override
    public String getRemoteHost() {
        return this.conn.getRemoteHostName(true);
    }

    @Override
    public int getRemotePort() {
        return this.conn.getRemotePort();
    }

    @Override
    public String getRemoteUser() {
        String user = this.getTrustedHeader(HttpHeaderKeys.HDR_$WSRU);
        return user;
    }

    @Override
    public String getRequestURI() {
        String uri = null;
        if (normalizeRequestURI) {
            if (this.normalizedURI != null) {
                uri = this.normalizedURI;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getRequestURI", (Object[])new Object[]{"Use previously normalized request uri --> " + this.normalizedURI});
                }
            } else {
                uri = this.request.getURI();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getRequestURI", (Object[])new Object[]{"normalize request uri --> ", uri});
                }
                this.normalizedURI = uri = WebApp.normalize(uri);
            }
        } else {
            uri = this.request.getURI();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getRequestURI", (Object[])new Object[]{" uri --> " + uri});
        }
        return uri;
    }

    @Override
    public byte[] getSSLSessionID() {
        byte[] rc = null;
        String sslHdr = this.getTrustedHeader(HttpHeaderKeys.HDR_$WSSI);
        if (sslHdr != null) {
            rc = sslHdr.getBytes();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getSSLSessionID , trusted found " + sslHdr), (Object[])new Object[0]);
            }
            return rc;
        }
        SSLContext ssl = this.conn.getSSLContext();
        if (null != ssl) {
            rc = ssl.getSession().getId();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getSSLSessionID , trusted not found", (Object[])new Object[0]);
        }
        return rc;
    }

    @Override
    public String getScheme() {
        if (this.scheme == null) {
            HttpInboundConnectionExtended ice;
            boolean useForwarded = false;
            if (this.conn instanceof HttpInboundConnectionExtended && (ice = (HttpInboundConnectionExtended)this.conn).useForwardedHeaders()) {
                useForwarded = true;
                String forwardedProto = ice.getRemoteProto();
                if (forwardedProto != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(" isTrusted --> true --> containsHeader --> X-Forwarded-Proto or Forwarded proto parameter --> scheme --> " + forwardedProto), (Object[])new Object[0]);
                    }
                    this.scheme = forwardedProto;
                    return this.scheme;
                }
            }
            if (this.conn.useTrustedHeaders()) {
                String WSIS_header;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getScheme: useTrustedHeaders is true", (Object[])new Object[0]);
                }
                if (this.isHttpsIndicatorSecure()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)" isTrusted --> true, isHttpsIndicatorSecure --> true, scheme --> https", (Object[])new Object[0]);
                    }
                    this.scheme = "https";
                    return this.scheme;
                }
                String WSSC_header = this.getHeader(HttpHeaderKeys.HDR_$WSSC);
                if (WSSC_header != null) {
                    if (this.validateProto(WSSC_header)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)(" isTrusted --> true, containsHeader --> $WSSC, scheme --> " + WSSC_header), (Object[])new Object[0]);
                        }
                        this.scheme = WSSC_header;
                        return this.scheme;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(" isTrusted --> true, containsHeader --> $WSSC, invalid scheme --> " + WSSC_header), (Object[])new Object[0]);
                    }
                }
                if ((WSIS_header = this.getHeader(HttpHeaderKeys.HDR_$WSIS)) != null) {
                    if (WSIS_header.equalsIgnoreCase("true")) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)" isTrusted --> true --> containsHeader --> $WSIS  --> scheme --> https", (Object[])new Object[0]);
                        }
                        this.scheme = "https";
                        return this.scheme;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)" isTrusted --> true --> containsHeader --> $WSIS  --> scheme --> http", (Object[])new Object[0]);
                    }
                    this.scheme = "http";
                    return this.scheme;
                }
                String FORWARDED_PROTO_header = this.getHeader(HttpHeaderKeys.HDR_X_FORWARDED_PROTO);
                if (FORWARDED_PROTO_header != null && !useForwarded) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(" isTrusted --> true --> containsHeader --> X-Forwarded-Proto  --> scheme --> " + FORWARDED_PROTO_header), (Object[])new Object[0]);
                    }
                    this.scheme = FORWARDED_PROTO_header;
                    return this.scheme;
                }
            }
            this.scheme = this.request.getScheme();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("scheme --> " + this.scheme), (Object[])new Object[0]);
        }
        return this.scheme;
    }

    private boolean validateProto(String forwardedProto) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateProto", (Object[])new Object[0]);
        }
        char[] a = forwardedProto.toCharArray();
        boolean valid = true;
        char c = a[0];
        boolean bl = valid = c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
        if (valid) {
            for (int i = 1; i < a.length; ++i) {
                c = a[i];
                boolean bl2 = valid = c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '+' || c == '-' || c == '.';
                if (!valid) break;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ValidateProto value is valid: " + valid), (Object[])new Object[0]);
            Tr.exit((TraceComponent)tc, (String)"validateProto");
        }
        return valid;
    }

    @Override
    public String getServerName() {
        String name = this.serverName;
        if (null == name) {
            name = this.serverName = this.conn.getRequestedHost();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("name=" + name), (Object[])new Object[0]);
        }
        return name;
    }

    @Override
    public int getServerPort() {
        int port = this.serverPort;
        if (-1 == port) {
            port = this.serverPort = this.conn.getRequestedPort();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("port=" + port), (Object[])new Object[0]);
        }
        return port;
    }

    private boolean isHttpsIndicatorSecure() {
        if (!this.isHttpsIndicatorSecureSet) {
            if (WCCustomProperties.HTTPS_INDICATOR_HEADER != null && this.getHeader(WCCustomProperties.HTTPS_INDICATOR_HEADER) != null) {
                this.isHttpsIndicatorSecure = true;
                String host = this.getHeader(HttpHeaderKeys.HDR_HOST);
                if (host != null) {
                    int idx = host.indexOf(58);
                    if (idx != -1) {
                        int len = host.length();
                        int sp = 0;
                        for (int i = idx + 1; i < len; ++i) {
                            sp = sp * 10 + host.charAt(i) - 48;
                        }
                        this.serverPort = sp;
                    } else {
                        this.serverPort = 443;
                    }
                }
            } else {
                this.isHttpsIndicatorSecure = false;
            }
            this.isHttpsIndicatorSecureSet = true;
        }
        return this.isHttpsIndicatorSecure;
    }

    @Override
    public String getSessionID() {
        return null;
    }

    @Override
    public boolean getShouldDestroy() {
        return false;
    }

    @Override
    public IResponse getWCCResponse() {
        return null;
    }

    @Override
    public boolean isProxied() {
        return false;
    }

    @Override
    public boolean isSSL() {
        if (this.isSSL == null) {
            HttpInboundConnectionExtended ice;
            boolean useForwarded = false;
            if (this.conn instanceof HttpInboundConnectionExtended && (ice = (HttpInboundConnectionExtended)this.conn).useForwardedHeaders()) {
                useForwarded = true;
                String forwardedProto = ice.getRemoteProto();
                if ("https".equalsIgnoreCase(forwardedProto) || "wss".equalsIgnoreCase(forwardedProto)) {
                    this.isSSL = Boolean.TRUE;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(" isTrusted --> true --> containsHeader --> X-Forwarded-Proto or Forwarded proto parameter --> " + forwardedProto + " ssl --> " + this.isSSL), (Object[])new Object[0]);
                    }
                    return true;
                }
            }
            if (this.conn.useTrustedHeaders()) {
                String FORWARDED_PROTO_header;
                if (this.isHttpsIndicatorSecure()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)" isTrusted --> true, isHttpsIndicatorSecure --> true ssl --> true", (Object[])new Object[0]);
                    }
                    this.isSSL = Boolean.TRUE;
                    return true;
                }
                String WSIS_header = this.getHeader(HttpHeaderKeys.HDR_$WSIS);
                if (WSIS_header != null) {
                    Boolean bl = this.isSSL = WSIS_header.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(" isTrusted --> true ssl --> " + this.isSSL), (Object[])new Object[0]);
                    }
                    return this.isSSL;
                }
                if (!useForwarded && (FORWARDED_PROTO_header = this.getHeader(HttpHeaderKeys.HDR_X_FORWARDED_PROTO)) != null && (FORWARDED_PROTO_header.equalsIgnoreCase("https") || FORWARDED_PROTO_header.equalsIgnoreCase("wss"))) {
                    this.isSSL = Boolean.TRUE;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(" isTrusted --> true --> containsHeader --> X-Forwarded-Proto  --> " + FORWARDED_PROTO_header + " ssl --> " + this.isSSL), (Object[])new Object[0]);
                    }
                    return true;
                }
            }
            Boolean bl = this.isSSL = this.conn.getSSLContext() != null ? Boolean.TRUE : Boolean.FALSE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" ssl --> " + this.isSSL), (Object[])new Object[0]);
        }
        return this.isSSL;
    }

    @Override
    public boolean isStartAsync() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)String.valueOf(this.startAsync), (Object[])new Object[0]);
        }
        return this.startAsync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() {
        IRequestImpl iRequestImpl = this;
        synchronized (iRequestImpl) {
            if (this.asyncLock == null) {
                this.asyncLock = new ReentrantLock();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("lock asyncLock: " + this.asyncLock), (Object[])new Object[0]);
        }
        this.asyncLock.lock();
    }

    @Override
    public void removeHeader(String headerName) {
    }

    @Override
    public void setShouldClose(boolean flag) {
    }

    @Override
    public void setShouldDestroy(boolean shouldDestroy) {
    }

    @Override
    public void setShouldReuse(boolean flag) {
    }

    @Override
    public void startAsync() {
        this.startAsync = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)String.valueOf(this.startAsync), (Object[])new Object[0]);
        }
    }

    @Override
    public void unlock() {
        if (this.asyncLock != null && this.asyncLock.isHeldByCurrentThread()) {
            this.asyncLock.unlock();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unlock asyncLock: " + this.asyncLock), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public ThreadPool getThreadPool() {
        return null;
    }

    @Override
    public HttpInboundConnection getHttpInboundConnection() {
        return this.conn;
    }
}

