/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.webcontainer60.session.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.session.SessionApplicationParameters;
import com.ibm.ws.session.SessionContext;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.SessionStoreService;
import com.ibm.ws.session.http.AbstractHttpSession;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.ws.webcontainer31.session.impl.HttpSessionContext31Impl;
import com.ibm.wsspi.session.ISession;
import com.ibm.wsspi.session.SessionAffinityContext;
import io.openliberty.session.impl.SessionCookieConfigImpl60;
import io.openliberty.webcontainer60.session.impl.WCHttpSessionImpl60;
import jakarta.servlet.ServletContext;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.logging.Level;

public class HttpSessionContextImpl60
extends HttpSessionContext31Impl {
    private static final String methodClassName = "HttpSessionContextImpl60";

    public HttpSessionContextImpl60(SessionManagerConfig smc, SessionApplicationParameters sap, SessionStoreService sessionStoreService) {
        super(smc, sap, sessionStoreService);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINE, "HttpSessionContextImpl60 Constructor");
        }
        if (sap.getSessionCookieConfig() == null) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINE, "HttpSessionContextImpl60 Constructor , WebAppConfiguration does not have SCC; create SCC 60 version and set to SMC");
            }
            SessionCookieConfig scc = smc.getSessionCookieConfig();
            smc.setClonedCookieConfig((SessionCookieConfig)new SessionCookieConfigImpl60(scc.getName(), scc.getDomain(), scc.getPath(), scc.getComment(), scc.getMaxAge(), scc.isHttpOnly(), scc.isSecure()));
        }
    }

    public Object createSessionObject(ISession isess, ServletContext servCtx) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINE, "HttpSessionContextImpl60 createSessionObject");
        }
        return new WCHttpSessionImpl60(isess, (SessionContext)this, servCtx);
    }

    public HttpSession generateNewId(HttpServletRequest request, HttpServletResponse response, HttpSession existingSession) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINE, "HttpSessionContextImpl60 generateNewId");
        }
        SessionAffinityContext sac = this.getSessionAffinityContext(request);
        HttpSession session = (HttpSession)this._coreHttpSessionManager.generateNewId(request, response, sac, ((AbstractHttpSession)existingSession).getISession());
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINE, "HttpSessionContextImpl60 generateNewId [" + session.getId() + "]");
        }
        return session;
    }
}

