/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

public class PublicKeyEncSessionPacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    public static final int VERSION_3 = 3;
    public static final int VERSION_6 = 6;
    private int version;
    private long keyID;
    private int algorithm;
    private byte[][] data;
    private int keyVersion;
    private byte[] keyFingerprint;

    PublicKeyEncSessionPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this.version = bCPGInputStream.read();
        if (this.version == 3) {
            this.keyID |= (long)bCPGInputStream.read() << 56;
            this.keyID |= (long)bCPGInputStream.read() << 48;
            this.keyID |= (long)bCPGInputStream.read() << 40;
            this.keyID |= (long)bCPGInputStream.read() << 32;
            this.keyID |= (long)bCPGInputStream.read() << 24;
            this.keyID |= (long)bCPGInputStream.read() << 16;
            this.keyID |= (long)bCPGInputStream.read() << 8;
            this.keyID |= (long)bCPGInputStream.read();
        } else if (this.version == 6) {
            int n = bCPGInputStream.read();
            if (n == 0) {
                this.keyVersion = 0;
                this.keyFingerprint = new byte[0];
            } else {
                this.keyVersion = bCPGInputStream.read();
                this.keyFingerprint = new byte[n - 1];
                bCPGInputStream.readFully(this.keyFingerprint);
            }
        } else {
            throw new UnsupportedPacketVersionException("Unsupported PGP public key encrypted session key packet version encountered: " + this.version);
        }
        this.algorithm = bCPGInputStream.read();
        switch (this.algorithm) {
            case 1: 
            case 2: {
                this.data = new byte[1][];
                this.data[0] = new MPInteger(bCPGInputStream).getEncoded();
                break;
            }
            case 16: 
            case 20: {
                this.data = new byte[2][];
                this.data[0] = new MPInteger(bCPGInputStream).getEncoded();
                this.data[1] = new MPInteger(bCPGInputStream).getEncoded();
                break;
            }
            case 18: {
                this.data = new byte[1][];
                this.data[0] = Streams.readAll(bCPGInputStream);
                break;
            }
            default: {
                throw new IOException("unknown PGP public key algorithm encountered");
            }
        }
    }

    public PublicKeyEncSessionPacket(long l, int n, byte[][] byArray) {
        this.version = 3;
        this.keyID = l;
        this.algorithm = n;
        this.data = new byte[byArray.length][];
        for (int i = 0; i != byArray.length; ++i) {
            this.data[i] = Arrays.clone(byArray[i]);
        }
    }

    public PublicKeyEncSessionPacket(int n, byte[] byArray, int n2, byte[][] byArray2) {
        this.version = 6;
        this.keyVersion = n;
        this.keyFingerprint = Arrays.clone(byArray);
        this.algorithm = n2;
        this.data = new byte[byArray2.length][];
        for (int i = 0; i < byArray2.length; ++i) {
            this.data[i] = Arrays.clone(byArray2[i]);
        }
    }

    public static PublicKeyEncSessionPacket createV3PKESKPacket(long l, int n, byte[][] byArray) {
        return new PublicKeyEncSessionPacket(l, n, byArray);
    }

    public static PublicKeyEncSessionPacket createV6PKESKPacket(int n, byte[] byArray, int n2, byte[][] byArray2) {
        return new PublicKeyEncSessionPacket(n, byArray, n2, byArray2);
    }

    public int getVersion() {
        return this.version;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public byte[] getKeyFingerprint() {
        return Arrays.clone(this.keyFingerprint);
    }

    public int getKeyVersion() {
        return this.keyVersion;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public byte[][] getEncSessionKey() {
        return this.data;
    }

    @Override
    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BCPGOutputStream bCPGOutputStream2 = new BCPGOutputStream(byteArrayOutputStream);
        bCPGOutputStream2.write(this.version);
        if (this.version == 3) {
            bCPGOutputStream2.write((byte)(this.keyID >> 56));
            bCPGOutputStream2.write((byte)(this.keyID >> 48));
            bCPGOutputStream2.write((byte)(this.keyID >> 40));
            bCPGOutputStream2.write((byte)(this.keyID >> 32));
            bCPGOutputStream2.write((byte)(this.keyID >> 24));
            bCPGOutputStream2.write((byte)(this.keyID >> 16));
            bCPGOutputStream2.write((byte)(this.keyID >> 8));
            bCPGOutputStream2.write((byte)this.keyID);
        } else if (this.version == 6) {
            bCPGOutputStream2.write(this.keyFingerprint.length + 1);
            bCPGOutputStream2.write(this.keyVersion);
            bCPGOutputStream2.write(this.keyFingerprint);
        }
        bCPGOutputStream2.write(this.algorithm);
        for (int i = 0; i != this.data.length; ++i) {
            bCPGOutputStream2.write(this.data[i]);
        }
        bCPGOutputStream2.close();
        bCPGOutputStream.writePacket(1, byteArrayOutputStream.toByteArray());
    }
}

