/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ssl.SSLConfig;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.ssl.core.WSPKCSInKeyStore;
import com.ibm.ws.ssl.core.WSPKCSInKeyStoreList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class KeyStoreManager {
    protected static final TraceComponent tc = Tr.register(KeyStoreManager.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    private final Map<String, WSKeyStore> keyStoreMap = new HashMap<String, WSKeyStore>();
    private static WSPKCSInKeyStoreList pkcsStoreList = new WSPKCSInKeyStoreList();
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private KeyStoreManager() {
    }

    public static KeyStoreManager getInstance() {
        return Singleton.INSTANCE;
    }

    public void loadKeyStores(Map<String, WSKeyStore> config) {
        for (Map.Entry<String, WSKeyStore> current : config.entrySet()) {
            try {
                String name = current.getKey();
                WSKeyStore keystore = current.getValue();
                this.addKeyStoreToMap(name, keystore);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"loadKeyStores", (Object[])new Object[]{this, config});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("Error loading keystore; " + current.getKey() + " " + e), (Object[])new Object[0]);
            }
        }
    }

    public void addKeyStoreToMap(String keyStoreName, WSKeyStore ks) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addKeyStoreToMap", (Object[])new Object[]{"name=" + keyStoreName + ", ks=" + ks});
        }
        if (this.keyStoreMap.containsKey(keyStoreName)) {
            this.keyStoreMap.remove(keyStoreName);
        }
        this.keyStoreMap.put(keyStoreName, ks);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addKeyStoreToMap");
        }
    }

    public boolean checkIfSignerAlreadyExistsInTrustStore(X509Certificate signer, KeyStore trustStore) {
        block8: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"checkIfSignerAlreadyExistsInTrustStore", (Object[])new Object[0]);
            }
            try {
                String signerMD5Digest = this.generateDigest("MD5", signer);
                if (signerMD5Digest == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"checkIfSignerAlreadyExistsInTrustStore -> false (could not generate digest)");
                    }
                    return false;
                }
                Enumeration<String> aliases = trustStore.aliases();
                while (aliases.hasMoreElements()) {
                    X509Certificate cert;
                    String certMD5Digest;
                    String alias = aliases.nextElement();
                    if (!trustStore.containsAlias(alias) || !signerMD5Digest.equals(certMD5Digest = this.generateDigest("MD5", cert = (X509Certificate)trustStore.getCertificate(alias)))) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"checkIfSignerAlreadyExistsInTrustStore -> true (digest matches)");
                    }
                    return true;
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"checkIfSignerAlreadyExistsInTrustStore", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block8;
                Tr.debug((TraceComponent)tc, (String)("Exception checking if signer already exists; " + e), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkIfSignerAlreadyExistsInTrustStore -> false (no digest matches)");
        }
        return false;
    }

    public WSKeyStore getKeyStore(String keyStoreName) {
        WSKeyStore ks = this.keyStoreMap.get(keyStoreName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (ks != null) {
                Tr.debug((TraceComponent)tc, (String)("Returning a keyStore for name: " + keyStoreName), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)("Cannot find a keyStore for name: " + keyStoreName), (Object[])new Object[0]);
            }
        }
        return ks;
    }

    public String[] getKeyStoreAliases() {
        Set<String> set = this.keyStoreMap.keySet();
        return set.toArray(new String[set.size()]);
    }

    public int getKeyStoreCount() {
        HashSet<String> uniqueIds = new HashSet<String>();
        Iterator<Map.Entry<String, WSKeyStore>> it = this.keyStoreMap.entrySet().iterator();
        while (it.hasNext()) {
            uniqueIds.add(it.next().getValue().getName());
        }
        return uniqueIds.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getKeyStore(String name, String type, String provider, String fileName, String password, boolean create, SSLConfig sslConfig) throws Exception {
        WSKeyStore keystore;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getKeyStore", (Object[])new Object[]{name, type, provider, fileName, create, SSLConfigManager.mask(password)});
        }
        if (name != null && !create && (keystore = this.keyStoreMap.get(name)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getKeyStore (from WSKeyStore)");
            }
            return keystore.getKeyStore(false, false);
        }
        KeyStore keyStore = null;
        InputStream inputStream = null;
        boolean not_finished = true;
        int retry_count = 0;
        boolean fileBased = true;
        ArrayList<Object> keyStoreTypes = new ArrayList();
        while (not_finished) {
            fileBased = !"JCERACFKS".equals(type) && !"JCECCARACFKS".equals(type) && !"JCEHYBRIDRACFKS".equals(type);
            char[] passphrase = null;
            keyStore = KeyStore.getInstance(type);
            if (password != null) {
                passphrase = WSKeyStore.decodePassword(password).toCharArray();
            }
            try {
                if ("PKCS11".equals(type)) {
                    WSPKCSInKeyStore pKS;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Creating PKCS11 keystore.", (Object[])new Object[0]);
                    }
                    if ((pKS = pkcsStoreList.insert(type, fileName, password, false, provider)) == null) continue;
                    keyStore = pKS.getKS();
                    not_finished = false;
                    continue;
                }
                if (null == fileName) {
                    keyStore.load(null, passphrase);
                    not_finished = false;
                    continue;
                }
                File f = new File(fileName);
                FileExistsAction action = new FileExistsAction(f);
                Boolean fileExists = AccessController.doPrivileged(action);
                if (!fileExists.booleanValue() && fileBased) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getKeyStore created new KeyStore: " + fileName), (Object[])new Object[0]);
                    }
                    keyStore.load(null, passphrase);
                    not_finished = false;
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getKeyStore created a new inputStream: " + fileName), (Object[])new Object[0]);
                }
                inputStream = this.getInputStream(fileName, create);
                keyStore.load(inputStream, passphrase);
                not_finished = false;
            }
            catch (IOException e) {
                if (e.getMessage().equalsIgnoreCase("Invalid keystore format") || e.getMessage().indexOf("DerInputStream.getLength()") != -1) {
                    if (retry_count == 0) {
                        String alias = "unknown";
                        if (sslConfig != null) {
                            alias = sslConfig.getProperty("com.ibm.ssl.alias");
                        }
                        Tr.warning((TraceComponent)tc, (String)"ssl.keystore.type.invalid.CWPKI0018W", (Object[])new Object[]{type, alias});
                        keyStoreTypes = new ArrayList<String>(Security.getAlgorithms("KeyStore"));
                    }
                    if (retry_count >= keyStoreTypes.size()) {
                        throw e;
                    }
                    if (!(type = (String)keyStoreTypes.get(retry_count++)).equals("PKCS11") && !type.equals("IBMCMSKS")) continue;
                    type = (String)keyStoreTypes.get(retry_count++);
                    continue;
                }
                throw e;
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getKeyStore (from SSLConfig properties)");
        }
        return keyStore;
    }

    public InputStream getInputStream(String fileName, boolean create) throws MalformedURLException, IOException {
        try {
            GetKeyStoreInputStreamAction action = new GetKeyStoreInputStreamAction(fileName, create);
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getInputStream", (Object[])new Object[]{fileName, create, this});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception opening keystore; " + ex), (Object[])new Object[0]);
            }
            if (ex instanceof MalformedURLException) {
                throw (MalformedURLException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex.getMessage());
        }
    }

    public OutputStream getOutputStream(String fileName) throws MalformedURLException, IOException {
        try {
            GetKeyStoreOutputStreamAction action = new GetKeyStoreOutputStreamAction(fileName);
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            Exception ex = e.getException();
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"getOutputStream", (Object[])new Object[]{fileName, this});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception opening keystore; " + ex), (Object[])new Object[0]);
            }
            if (ex instanceof MalformedURLException) {
                throw (MalformedURLException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex.getMessage());
        }
    }

    public String generateDigest(String algorithmName, X509Certificate cert) {
        String rc;
        block10: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("generateDigest: " + algorithmName), (Object[])new Object[0]);
            }
            rc = null;
            if (cert != null) {
                try {
                    MessageDigest md = MessageDigest.getInstance(algorithmName);
                    md.update(cert.getEncoded());
                    byte[] data = md.digest();
                    StringBuilder buffer = new StringBuilder(3 * data.length);
                    int i = 0;
                    buffer.append(HEX_CHARS[data[i] >> 4 & 0xF]);
                    buffer.append(HEX_CHARS[data[i] % 16 & 0xF]);
                    ++i;
                    while (i < data.length) {
                        buffer.append(':');
                        buffer.append(HEX_CHARS[data[i] >> 4 & 0xF]);
                        buffer.append(HEX_CHARS[data[i] % 16 & 0xF]);
                        ++i;
                    }
                    rc = buffer.toString();
                }
                catch (NoClassDefFoundError e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Error finding a class: " + e), (Object[])new Object[0]);
                    }
                    break block10;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"generateDigest", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Error generating digest: " + e), (Object[])new Object[0]);
                    }
                    break block10;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Ignoring null certificate", (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("generateDigest: " + rc));
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearKSMap() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Clearing keystore maps", (Object[])new Object[0]);
        }
        Map<String, WSKeyStore> map = this.keyStoreMap;
        synchronized (map) {
            this.keyStoreMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearKeyStoreFromMap(String keyStoreName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("clearKeyStoreFromMap: " + keyStoreName), (Object[])new Object[0]);
        }
        Map<String, WSKeyStore> map = this.keyStoreMap;
        synchronized (map) {
            this.keyStoreMap.remove(keyStoreName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearJavaKeyStoresFromKeyStoreMap() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"clearJavaKeyStoresFromKeyStoreMap", (Object[])new Object[0]);
        }
        Map<String, WSKeyStore> map = this.keyStoreMap;
        synchronized (map) {
            for (Map.Entry<String, WSKeyStore> entry : this.keyStoreMap.entrySet()) {
                WSKeyStore ws = entry.getValue();
                if (ws == null) continue;
                ws.clearJavaKeyStore();
            }
        }
    }

    public void clearJavaKeyStoresFromKeyStoreMap(Collection<File> modifiedFiles) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"clearJavaKeyStoresFromKeyStoreMap ", (Object[])new Object[]{modifiedFiles});
        }
        String filePath = null;
        for (File modifiedKeystoreFile : modifiedFiles) {
            try {
                filePath = modifiedKeystoreFile.getCanonicalPath();
            }
            catch (IOException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Exception comparing file path.", (Object[])new Object[0]);
                continue;
            }
            this.findKeyStoreInMapAndClear(filePath);
        }
    }

    public void findKeyStoreInMapAndClear(String keyStorePath) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"findKeyStoreInMapAndClear ", (Object[])new Object[]{keyStorePath});
        }
        for (Map.Entry<String, WSKeyStore> entry : this.keyStoreMap.entrySet()) {
            WSKeyStore ws = entry.getValue();
            if (!WSKeyStore.getCannonicalPath(ws.getLocation(), ws.getFileBased()).equals(keyStorePath)) continue;
            ws.clearJavaKeyStore();
        }
    }

    public static String expandHostNameVariable(String subjectDN, String nodeHostName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"expandHostNameVariable", (Object[])new Object[]{subjectDN, nodeHostName});
        }
        String expandedSubjectDN = subjectDN;
        int index1 = subjectDN.indexOf("${hostname}");
        if (index1 != -1) {
            String firstPart = subjectDN.substring(0, index1);
            String lastPart = subjectDN.substring(index1 + "${hostname}".length());
            if (!firstPart.equals("") && !lastPart.equals("")) {
                expandedSubjectDN = firstPart + nodeHostName + lastPart;
            } else if (!firstPart.equals("")) {
                expandedSubjectDN = firstPart + nodeHostName;
            } else if (!lastPart.equals("")) {
                expandedSubjectDN = nodeHostName + lastPart;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("expandHostNameVariable -> " + expandedSubjectDN));
        }
        return expandedSubjectDN;
    }

    public static String stripLastSlash(String inputString) {
        char lastChar;
        if (null == inputString) {
            return null;
        }
        String rc = inputString.trim();
        int len = rc.length();
        if (0 < len && ('/' == (lastChar = rc.charAt(len - 1)) || '\\' == lastChar)) {
            rc = rc.substring(0, len - 1);
        }
        return rc;
    }

    public KeyStore getJavaKeyStore(String keyStoreName) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getJavaKeyStore: " + keyStoreName), (Object[])new Object[0]);
        }
        if (keyStoreName == null || keyStoreName.trim().isEmpty()) {
            throw new SSLException("No keystore name provided.");
        }
        KeyStore javaKeyStore = null;
        WSKeyStore ks = this.keyStoreMap.get(keyStoreName);
        if (ks != null) {
            javaKeyStore = ks.getKeyStore(false, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getJavaKeyStore: " + javaKeyStore));
        }
        return javaKeyStore;
    }

    public WSKeyStore getWSKeyStore(String keyStoreName) throws SSLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getWSKeyStore: " + keyStoreName), (Object[])new Object[0]);
        }
        if (keyStoreName == null) {
            throw new SSLException("No keystore name provided.");
        }
        WSKeyStore ks = this.keyStoreMap.get(keyStoreName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getWSKeyStore: " + ks));
        }
        return ks;
    }

    private static class Singleton {
        static final KeyStoreManager INSTANCE = new KeyStoreManager();

        private Singleton() {
        }
    }

    private static class FileExistsAction
    implements PrivilegedAction<Boolean> {
        private File file = null;

        public FileExistsAction(File input_file) {
            this.file = input_file;
        }

        @Override
        public Boolean run() {
            try {
                return this.file.exists();
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
    }

    private static class GetKeyStoreInputStreamAction
    implements PrivilegedExceptionAction<InputStream> {
        private String file = null;
        private boolean createStream = false;

        public GetKeyStoreInputStreamAction(String fileName, boolean create) {
            this.file = fileName;
            this.createStream = create;
        }

        @Override
        public InputStream run() throws MalformedURLException, IOException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("GetKeyStoreInputStreamAction.run: " + this.file), (Object[])new Object[0]);
            }
            InputStream fis = null;
            URL urlFile = null;
            File kfile = new File(this.file);
            if (this.createStream && !kfile.exists()) {
                if (!kfile.createNewFile()) {
                    throw new IOException("Unable to create file");
                }
                urlFile = kfile.toURI().toURL();
            } else {
                if (kfile.exists() && kfile.length() == 0L) {
                    throw new IOException("Keystore file exists, but is empty: " + this.file);
                }
                urlFile = !kfile.exists() ? new URL(this.file) : kfile.toURI().toURL();
            }
            fis = urlFile.openStream();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"GetKeyStoreInputStreamAction.run");
            }
            return fis;
        }
    }

    private static class GetKeyStoreOutputStreamAction
    implements PrivilegedExceptionAction<OutputStream> {
        private String file = null;

        public GetKeyStoreOutputStreamAction(String fileName) {
            this.file = fileName;
        }

        @Override
        public OutputStream run() throws MalformedURLException, IOException {
            File kfile;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("GetKeyStoreOutputStreamAction.run: " + this.file), (Object[])new Object[0]);
            }
            OutputStream fos = null;
            if (this.file.startsWith("safkeyring://")) {
                URL ring = new URL(this.file);
                URLConnection ringConnect = ring.openConnection();
                fos = ringConnect.getOutputStream();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"GetKeyStoreOutputStreamAction.run (safkeyring)");
                }
                return fos;
            }
            try {
                URL conversionURL = new URL(this.file);
                this.file = conversionURL.getFile();
                while (this.file.startsWith("/")) {
                    this.file = this.file.substring(1);
                }
            }
            catch (MalformedURLException conversionURL) {
                // empty catch block
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("File path for OutputStream: " + this.file), (Object[])new Object[0]);
            }
            if ((kfile = new File(this.file)).exists() && !kfile.canWrite()) {
                throw new IOException("Cannot write to KeyStore file: " + this.file);
            }
            fos = new FileOutputStream(kfile);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"GetKeyStoreOutputStreamAction.run");
            }
            return fos;
        }
    }
}

