/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CertificateEnvHelper {
    private static final TraceComponent tc = Tr.register(CertificateEnvHelper.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");

    public List<Certificate> getCertificatesForKeyStore(String keyStoreName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getCertificatesForKeyStore", (Object[])new Object[]{keyStoreName});
        }
        String envKey = "cert_" + keyStoreName;
        InputStream inputStream = null;
        ArrayList<Certificate> envCerts = new ArrayList<Certificate>();
        String envVal = System.getenv(envKey);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("value return from the environment for " + envKey + " is " + envVal), (Object[])new Object[0]);
        }
        if (envVal != null && !envVal.isEmpty()) {
            try {
                inputStream = this.getInputStreamForCert(envVal);
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> certs = factory.generateCertificates(inputStream);
                for (Certificate certificate : certs) {
                    envCerts.add(certificate);
                }
            }
            catch (Exception e) {
                String extendedMsg = e.getMessage();
                Tr.warning((TraceComponent)tc, (String)"ssl.environment.cert.error.CWPKI0826W", (Object[])new Object[]{envKey, keyStoreName, extendedMsg});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getCertificatesForKeyStore", (Object)new Object[]{envCerts});
        }
        return envCerts;
    }

    private InputStream getInputStreamForCert(String env_Value) throws Exception {
        String certBeginTag = "-----BEGIN CERTIFICATE-----";
        InputStream inputStream = null;
        if (env_Value.startsWith(certBeginTag)) {
            inputStream = new ByteArrayInputStream(env_Value.getBytes(Charset.forName("UTF-8")));
        } else {
            File certFile;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"The value from the environment did not start with -----BEGIN CERTIFICATE----- so treating it like a file", (Object[])new Object[0]);
            }
            if ((certFile = new File(env_Value)).isFile()) {
                inputStream = new FileInputStream(certFile);
            } else {
                throw new Exception("A valid file or certificate is not specified on the environment variable.");
            }
        }
        return inputStream;
    }
}

