/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.cdi40.internal.weld;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.internal.interfaces.SecurityContextStore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.WSContextService;
import io.openliberty.cdi40.internal.weld.CDI40SecurityContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.weld.security.spi.SecurityContext;
import org.jboss.weld.security.spi.SecurityServices;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="io.openliberty.cdi40.internal.weld.DefaultCDI40SecurityService", property={"service.vendor=IBM", "service.ranking:Integer=50"})
public class DefaultCDI40SecurityService
implements SecurityServices {
    private static final TraceComponent tc = Tr.register(DefaultCDI40SecurityService.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    private final ConcurrentServiceReferenceSet<SecurityContextStore> securityContextStores = new ConcurrentServiceReferenceSet("securityContextStore");
    private SecurityContext mySecurityContext = null;
    @Reference
    private WSContextService contextService;
    private static final Map<String, ?>[] THREAD_CONTEXT_PROVIDERS = new Map[]{Collections.singletonMap("threadContextProvider", "com.ibm.ws.security.context.provider")};
    static final long serialVersionUID = -8608917424142406633L;

    protected void activate(ComponentContext compcontext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Activating" + this.getClass().getName()), (Object[])new Object[0]);
        }
        this.securityContextStores.activate(compcontext);
    }

    protected void deactivate(ComponentContext compcontext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Deactivating" + this.getClass().getName()), (Object[])new Object[0]);
        }
        this.securityContextStores.deactivate(compcontext);
    }

    @Reference(name="securityContextStore", service=SecurityContextStore.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.AT_LEAST_ONE)
    protected void addSecurityContextStore(ServiceReference<SecurityContextStore> ref) {
        this.securityContextStores.addReference(ref);
    }

    protected void removeSecurityContextStore(ServiceReference<SecurityContextStore> ref) {
        this.securityContextStores.removeReference(ref);
    }

    public Principal getPrincipal() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getPrincipal" + this.getClass().getName()), (Object[])new Object[0]);
        }
        Principal principal = AccessController.doPrivileged(new PrivilegedAction<Principal>(){
            static final long serialVersionUID = -3990330368887494499L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Principal run() {
                Principal principal = null;
                Iterator contextStores = DefaultCDI40SecurityService.this.securityContextStores.getServices();
                while (contextStores.hasNext() && principal == null) {
                    SecurityContextStore securityContextStore = (SecurityContextStore)contextStores.next();
                    if (securityContextStore == null) continue;
                    principal = securityContextStore.getCurrentPrincipal();
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Principal from " + securityContextStore + ": " + principal), (Object[])new Object[0]);
                }
                return principal;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.cdi40.internal.weld.DefaultCDI40SecurityService$1", 1.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
            }
        });
        return principal;
    }

    public SecurityContext getSecurityContext() {
        ThreadContextDescriptor threadContext = null;
        if (this.contextService != null) {
            threadContext = this.contextService.captureThreadContext(new HashMap(), (Map[])THREAD_CONTEXT_PROVIDERS);
        }
        this.mySecurityContext = new CDI40SecurityContext(threadContext);
        return this.mySecurityContext;
    }

    public void cleanup() {
    }
}

