/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.org.jboss.resteasy.server.component;

import com.ibm.websphere.jaxrs.server.IBMRestServlet;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.annotation.HandlesTypes;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.ext.Provider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.resteasy.plugins.servlet.ResteasyServletInitializer;
import org.jboss.resteasy.util.Encode;

@Trivial
@HandlesTypes(value={Application.class, Path.class, Provider.class})
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class RESTfulServletContainerInitializer
extends ResteasyServletInitializer
implements ServletContainerInitializer {
    private static final TraceComponent tc = Tr.register(RESTfulServletContainerInitializer.class, (String)"JAXRS");
    private static final String RESTEASY_MAPPING_PREFIX = "resteasy.servlet.mapping.prefix";
    private static final String IBM_REST_SERVLET_NAME = "com.ibm.websphere.jaxrs.server.IBMRestServlet";
    private static final String RESTEASY_DISPATCHER_NAME = "org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher";
    private static final String RESTEASY_DISPATCHER_30_NAME = "org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher";
    private static final String APPLICATION = "jakarta.ws.rs.Application";
    private static final String EE8_APP_CLASS_NAME = "javax.ws.rs.core.Application";
    static final long serialVersionUID = 918556558192268705L;

    @Override
    public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"onStartup ", (Object[])new Object[]{classes, servletContext});
        }
        if (classes == null) {
            return;
        }
        HashSet appClasses = new HashSet();
        HashSet providers = new HashSet();
        HashSet resources = new HashSet();
        for (Class<?> clazz : classes) {
            if (clazz.isInterface()) continue;
            if (clazz.isAnnotationPresent(Path.class)) {
                resources.add(clazz);
            }
            if (clazz.isAnnotationPresent(Provider.class)) {
                providers.add(clazz);
            }
            if (!Application.class.isAssignableFrom(clazz)) continue;
            if (!this.getServletsForApplication(clazz, servletContext, false).isEmpty() || clazz.isAnnotationPresent(ApplicationPath.class)) {
                appClasses.add(clazz);
                continue;
            }
            Tr.warning((TraceComponent)tc, (String)"UNMAPPED_APPLICATION_CWWKW1302W", (Object[])new Object[]{servletContext.getServletContextName(), clazz.getName()});
        }
        if (appClasses.size() == 0 && resources.size() == 0) {
            return;
        }
        if (appClasses.size() == 0) {
            appClasses.add(Application.class);
        }
        this.addMappingParam(servletContext, appClasses);
        for (Class<Object> clazz : appClasses) {
            this.register(clazz, providers, resources, servletContext);
        }
    }

    private Set<ServletRegistration> getServletsForApplication(Class<?> applicationClass, ServletContext servletContext, boolean includeAppClass) {
        HashSet<ServletRegistration> set = new HashSet<ServletRegistration>();
        ServletRegistration reg = servletContext.getServletRegistration(applicationClass.getName());
        if (reg != null) {
            set.add(reg);
        } else if (includeAppClass && Application.class.equals(applicationClass) && (reg = servletContext.getServletRegistration(EE8_APP_CLASS_NAME)) != null) {
            set.add(reg);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"App {0} is using older (<=EE8) style app class name with javax package name", (Object[])new Object[]{servletContext.getServletContextName()});
            }
        }
        for (ServletRegistration sr : servletContext.getServletRegistrations().values()) {
            String appClassName = sr.getInitParameter(APPLICATION);
            if (!applicationClass.getName().equals(appClassName)) continue;
            set.add(sr);
        }
        return set;
    }

    @Override
    protected void register(Class<?> applicationClass, Set<Class<?>> providers, Set<Class<?>> resources, ServletContext servletContext) {
        String prefix;
        Set<ServletRegistration> servletsForApp = this.getServletsForApplication(applicationClass, servletContext, true);
        if (!servletsForApp.isEmpty()) {
            for (ServletRegistration servletReg : servletsForApp) {
                String servletClassName = servletReg.getClassName();
                if (servletClassName == null) {
                    ServletRegistration.Dynamic dynReg = servletContext.addServlet(servletReg.getName(), IBMRestServlet.class);
                    dynReg.setAsyncSupported(true);
                    dynReg.setInitParameter(APPLICATION, applicationClass.getName());
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("register - mapping app " + applicationClass.getName() + " via web.xml servlet, " + servletReg.getName()), (Object[])new Object[0]);
                }
                this.registerResourcesAndProviders(servletReg, providers, resources);
            }
            return;
        }
        ApplicationPath path = applicationClass.getAnnotation(ApplicationPath.class);
        if (path == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("register - no @ApplicationPath and no servlet mapping for " + applicationClass.getName()), (Object[])new Object[0]);
            }
            return;
        }
        Object mapping = Encode.decode((String)path.value());
        if (!((String)mapping).startsWith("/")) {
            mapping = "/" + (String)mapping;
        }
        if (!(prefix = mapping).equals("/") && prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (!((String)mapping).endsWith("/*")) {
            mapping = ((String)mapping).endsWith("/") ? (String)mapping + "*" : (String)mapping + "/*";
        }
        ServletRegistration.Dynamic reg = servletContext.addServlet(applicationClass.getName(), IBMRestServlet.class);
        reg.setLoadOnStartup(1);
        reg.setAsyncSupported(true);
        reg.addMapping(new String[]{mapping});
        reg.setInitParameter(APPLICATION, applicationClass.getName());
        reg.setInitParameter(RESTEASY_MAPPING_PREFIX, prefix);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("register - mapping app " + applicationClass.getName() + " to " + (String)mapping), (Object[])new Object[0]);
        }
        this.registerResourcesAndProviders((ServletRegistration)reg, providers, resources);
    }

    private void registerResourcesAndProviders(ServletRegistration reg, Set<Class<?>> providers, Set<Class<?>> resources) {
        boolean first;
        StringBuilder builder;
        reg.setInitParameter("resteasy.proxy.implement.all.interfaces", "true");
        String unwrappedExceptions = reg.getInitParameter("resteasy.unwrapped.exceptions");
        if (unwrappedExceptions == null) {
            reg.setInitParameter("resteasy.unwrapped.exceptions", "jakarta.ejb.EJBException");
        } else if (!unwrappedExceptions.contains("jakarta.ejb.EJBException")) {
            reg.setInitParameter("resteasy.unwrapped.exceptions", unwrappedExceptions + ",jakarta.ejb.EJBException");
        }
        if (resources.size() > 0) {
            builder = new StringBuilder();
            first = true;
            for (Class<?> resource : resources) {
                if (first) {
                    first = false;
                } else {
                    builder.append(",");
                }
                builder.append(resource.getName());
            }
            reg.setInitParameter("resteasy.scanned.resources", builder.toString());
        }
        if (providers.size() > 0) {
            builder = new StringBuilder();
            first = true;
            for (Class<?> provider : providers) {
                if (first) {
                    first = false;
                } else {
                    builder.append(",");
                }
                builder.append(provider.getName());
            }
            reg.setInitParameter("resteasy.scanned.providers", builder.toString());
        }
    }

    private void addMappingParam(ServletContext ctx, Set<Class<?>> appClasses) {
        boolean globallyMapped = false;
        if (ctx.getInitParameter(RESTEASY_MAPPING_PREFIX) != null) {
            globallyMapped = true;
        }
        HashSet<String> mappedServletNames = new HashSet<String>();
        Map servletRegistrationMap = ctx.getServletRegistrations();
        for (Map.Entry entry : servletRegistrationMap.entrySet()) {
            String mapping;
            Collection mappings;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("addMappingParam servletRegistrations " + (String)entry.getKey() + " = " + entry.getValue()), (Object[])new Object[0]);
            }
            ServletRegistration reg = (ServletRegistration)entry.getValue();
            String servletName = reg.getName();
            String servletClassName = reg.getClassName();
            if (!IBM_REST_SERVLET_NAME.equals(servletClassName) && !RESTEASY_DISPATCHER_NAME.equals(servletClassName) && !RESTEASY_DISPATCHER_30_NAME.equals(servletClassName) && !Application.class.getName().equals(servletName) && !EE8_APP_CLASS_NAME.equals(servletName) && !appClasses.stream().anyMatch(c -> c.getName().equals(servletName))) continue;
            if (mappedServletNames.contains(servletName)) {
                Tr.warning((TraceComponent)tc, (String)"MULTIPLE_REST_SERVLETS_CWWKW1300W", (Object[])new Object[]{ctx.getServletContextName()});
            }
            if ((mappings = reg.getMappings()).size() < 1) continue;
            if (mappings.size() > 1) {
                Tr.warning((TraceComponent)tc, (String)"MULTIPLE_REST_SERVLET_MAPPINGS_CWWKW1301W", (Object[])new Object[]{ctx.getServletContextName()});
            }
            for (mapping = (String)mappings.iterator().next(); mapping != null && mapping.length() > 0 && (mapping.endsWith("*") || mapping.endsWith("/")); mapping = mapping.substring(0, mapping.length() - 1)) {
            }
            if (mapping == null) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("addMappingParam using mapping: " + mapping), (Object[])new Object[0]);
            }
            if (!globallyMapped) {
                reg.setInitParameter(RESTEASY_MAPPING_PREFIX, mapping);
            }
            mappedServletNames.add(servletName);
        }
    }
}

