/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.targets.cache.internal;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.anno.jandex.internal.Jandex_Utils;
import com.ibm.ws.annocache.service.internal.AnnotationCacheServiceImpl_Logging;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory;
import com.ibm.ws.annocache.targets.internal.TargetsTableAnnotationsImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableClassesMultiImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableTimeStampImpl;
import com.ibm.ws.annocache.util.internal.UtilImpl_BidirectionalMap;
import com.ibm.ws.annocache.util.internal.UtilImpl_Utils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.annocache.targets.cache.TargetCache_InternalConstants;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.jandex.Index;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class TargetCacheImpl_Writer
implements TargetCache_InternalConstants {
    private static final String CLASS_NAME = TargetCacheImpl_Writer.class.getSimpleName();
    protected static final Logger logger = AnnotationCacheServiceImpl_Logging.ANNO_LOGGER;
    protected final TargetCacheImpl_Factory factory;
    protected final String path;
    protected final OutputStream stream;
    protected final String encoding;
    protected final OutputStreamWriter writer;
    protected final BufferedWriter bufferedWriter;
    private static final String SPACES = "                                                                                ";
    public static final int MAX_SPACES = 80;
    static final long serialVersionUID = 1345657663897954915L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getTimeStamp() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "getTimeStamp", new Object[0]);
        }
        String string = UtilImpl_Utils.getDateAndTime();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "getTimeStamp", string);
        }
        return string;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static String policiesText(int policies) {
        if (policies == 0) {
            return "";
        }
        if (policies == ClassSource_Aggregate.ScanPolicy.SEED.getValue()) {
            return ClassSource_Aggregate.ScanPolicy.SEED.toString();
        }
        if (policies == ClassSource_Aggregate.ScanPolicy.PARTIAL.getValue()) {
            return ClassSource_Aggregate.ScanPolicy.PARTIAL.toString();
        }
        if (policies == ClassSource_Aggregate.ScanPolicy.PARTIAL.getValue()) {
            return ClassSource_Aggregate.ScanPolicy.PARTIAL.toString();
        }
        if (policies == ClassSource_Aggregate.ScanPolicy.EXCLUDED.getValue()) {
            return ClassSource_Aggregate.ScanPolicy.EXCLUDED.toString();
        }
        if (policies == ClassSource_Aggregate.ScanPolicy.EXTERNAL.getValue()) {
            return ClassSource_Aggregate.ScanPolicy.EXTERNAL.toString();
        }
        if (policies == (ClassSource_Aggregate.ScanPolicy.SEED.getValue() & ClassSource_Aggregate.ScanPolicy.PARTIAL.getValue())) {
            return ClassSource_Aggregate.ScanPolicy.SEED.toString() + ", " + ClassSource_Aggregate.ScanPolicy.PARTIAL.toString();
        }
        StringBuilder builder = new StringBuilder();
        for (ClassSource_Aggregate.ScanPolicy policy : ClassSource_Aggregate.ScanPolicy.values()) {
            if ((policies & policy.getValue()) == 0) continue;
            if (builder.length() > 0) {
                builder.append(',');
                builder.append(' ');
            }
            builder.append(policy.toString());
        }
        return builder.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_Writer(TargetCacheImpl_Factory factory, String path, OutputStream stream, String encoding) throws UnsupportedEncodingException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "<init>", new Object[]{factory, path, stream, encoding});
        }
        this.factory = factory;
        this.path = path;
        this.stream = stream;
        this.encoding = encoding;
        this.writer = new OutputStreamWriter(stream, encoding);
        this.bufferedWriter = new BufferedWriter(this.writer);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "<init>", this);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_Factory getFactory() {
        return this.factory;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getPath() {
        return this.path;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public OutputStream getStream() {
        return this.stream;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getEncoding() {
        return this.encoding;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public OutputStreamWriter getWriter() {
        return this.writer;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BufferedWriter getBufferedWriter() {
        return this.bufferedWriter;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeLine(String methodName, String outputLine) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeLine", new Object[]{methodName, outputLine});
        }
        this.bufferedWriter.append(outputLine);
        this.bufferedWriter.newLine();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeLine");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void close() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "close", new Object[0]);
        }
        String methodName = "close";
        try {
            this.bufferedWriter.close();
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", (String)"169", (Object)this, (Object[])new Object[0]);
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_TARGETS_CACHE_EXCEPTION", e.getMessage());
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "close");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void flush() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "flush", new Object[0]);
        }
        String methodName = "flush";
        try {
            this.bufferedWriter.flush();
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", (String)"180", (Object)this, (Object[])new Object[0]);
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_TARGETS_CACHE_EXCEPTION", e.getMessage());
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "Cache error", (Throwable)e);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "flush");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void write(TargetsTableContainersImpl containerTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "write", new Object[]{containerTable});
        }
        this.writeHeader("Container", "1.0");
        this.writeComment("============================================================");
        this.writeComment("Containers:");
        for (String name : containerTable.getNames()) {
            ClassSource_Aggregate.ScanPolicy policy = containerTable.getPolicy(name);
            String writeName = name.equals("/") ? "root" : name;
            this.writeValue("Name", writeName);
            this.writeValue("Policy", policy.toString());
        }
        this.writeTrailer();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "write");
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeResolvedRefs(Collection<String> resolvedClassNames) throws IOException {
        this.writeHeader("Resolved References", "1.0");
        this.writeComment("============================================================");
        this.writeComment("Resolved class references:");
        for (String className : resolvedClassNames) {
            this.writeValue("Class", className);
        }
        this.writeTrailer();
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeUnresolvedRefs(Collection<String> unresolvedClassNames) throws IOException {
        this.writeHeader("Unresolved References", "1.0");
        this.writeComment("============================================================");
        this.writeComment("Unresolved class references:");
        for (String className : unresolvedClassNames) {
            this.writeValue("Class", className);
        }
        this.writeTrailer();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void write(TargetsTableTimeStampImpl stampTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "write", new Object[]{stampTable});
        }
        this.writeHeader("Stamp", "1.0");
        this.writeValue("Name", stampTable.getName());
        this.writeValue("Stamp", stampTable.getStamp(), 60);
        this.writeTrailer();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "write");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void write(TargetsTableClassesImpl classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "write", new Object[]{classTable});
        }
        this.writeHeader("Classes", "1.0");
        this.writePackages(classTable);
        this.writeClasses(classTable);
        this.writeTrailer();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "write");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writePackages(TargetsTableClassesImpl classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writePackages", new Object[]{classTable});
        }
        this.writeComment("============================================================");
        this.writeComment("Packages:");
        for (String i_packageName : classTable.i_getPackageNames()) {
            this.writeValue("Package", i_packageName);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writePackages");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeClasses(TargetsTableClassesImpl classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeClasses", new Object[]{classTable});
        }
        this.writeComment("============================================================");
        this.writeComment("Classes:");
        for (String i_className : classTable.i_getClassNames()) {
            String i_superClassName = classTable.i_getSuperclassName(i_className);
            String[] i_interfaces = classTable.i_getInterfaceNames(i_className);
            Integer modifiers = classTable.i_getModifiers(i_className);
            this.writeClass(i_className, i_superClassName, i_interfaces, modifiers);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeClasses");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeClass(String className, String superClassName, String[] interfaceNames, Integer modifiers) throws IOException {
        int modifiersValue;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeClass", new Object[]{className, superClassName, interfaceNames, modifiers});
        }
        this.writeValue("Class", className);
        if (superClassName != null) {
            this.writeSubValue("Superclass", superClassName);
        }
        if (interfaceNames != null) {
            for (String interfaceName : interfaceNames) {
                this.writeSubValue("Interface", interfaceName);
            }
        }
        if (modifiers != null && (modifiersValue = modifiers.intValue()) != 0) {
            String modifiersText = "0x" + Integer.toHexString(modifiersValue) + " " + OpcodeTag.asText(modifiersValue);
            this.writeSubValue("Modifiers", modifiersText);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeClass");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void write(TargetsTableClassesMultiImpl classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "write", new Object[]{classTable});
        }
        this.writeHeader("Classes", "1.0");
        this.writePackages(classTable);
        this.writeClasses(classTable);
        this.writeTrailer();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "write");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writePackages(TargetsTableClassesMultiImpl classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writePackages", new Object[]{classTable});
        }
        this.writeComment("============================================================");
        this.writeComment("Packages:");
        for (Map.Entry<String, String> i_packageEntry : classTable.i_getPackageNameClassSourceMap().entrySet()) {
            String i_packageName = i_packageEntry.getKey();
            String classSourceName = i_packageEntry.getValue();
            this.writeValue("Package", i_packageName);
            this.writeSubValue("Class Source", classSourceName);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writePackages");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeClasses(TargetsTableClassesMultiImpl classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeClasses", new Object[]{classTable});
        }
        this.writeComment("============================================================");
        this.writeComment("Classes:");
        for (Map.Entry<String, String> i_classEntry : classTable.i_getClassNameClassSourceMap().entrySet()) {
            String i_className = i_classEntry.getKey();
            String classSourceName = i_classEntry.getValue();
            String i_superClassName = classTable.i_getSuperclassName(i_className);
            String[] i_interfaces = classTable.i_getInterfaceNames(i_className);
            Integer modifiers = classTable.i_getModifiers(i_className);
            this.writeClass(classSourceName, i_className, i_superClassName, i_interfaces, modifiers);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeClasses");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeClass(String classSourceName, String className, String superClassName, String[] interfaceNames, Integer modifiers) throws IOException {
        int modifiersValue;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeClass", new Object[]{classSourceName, className, superClassName, interfaceNames, modifiers});
        }
        this.writeValue("Class", className);
        this.writeSubValue("Class Source", classSourceName);
        if (superClassName != null) {
            this.writeSubValue("Superclass", superClassName);
        }
        if (interfaceNames != null) {
            for (String interfaceName : interfaceNames) {
                this.writeSubValue("Interface", interfaceName);
            }
        }
        if (modifiers != null && (modifiersValue = modifiers.intValue()) != 0) {
            String modifiersText = "0x" + Integer.toHexString(modifiersValue) + " " + OpcodeTag.asText(modifiersValue);
            this.writeSubValue("Modifiers", modifiersText);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeClass");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void write(TargetsTableAnnotationsImpl targetTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "write", new Object[]{targetTable});
        }
        this.writeHeader("Annotation Targets", "1.0");
        this.writePackageTargets(targetTable);
        this.writeClassTargets(targetTable);
        this.writeTrailer();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "write");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writePackageTargets(TargetsTableAnnotationsImpl targetTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writePackageTargets", new Object[]{targetTable});
        }
        this.writeComment("============================================================");
        this.writeComment("Package Annotation Targets:");
        UtilImpl_BidirectionalMap targetMap = targetTable.i_getPackageAnnotations();
        for (String i_packageName : targetMap.getHolderSet()) {
            Set<String> i_annotationClassNames = targetMap.selectHeldOf(i_packageName);
            if (i_annotationClassNames.isEmpty()) continue;
            this.writeValue("Package", i_packageName);
            for (String i_annotationClassName : i_annotationClassNames) {
                this.writeSubValue("Package Annotation", i_annotationClassName);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writePackageTargets");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeClassTargets(TargetsTableAnnotationsImpl targetTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeClassTargets", new Object[]{targetTable});
        }
        this.writeComment("============================================================");
        this.writeComment("Class Annotation Targets:");
        IdentityHashMap<String, String> i_annotatedClassNames = new IdentityHashMap<String, String>();
        UtilImpl_BidirectionalMap classTargetMap = targetTable.i_getClassAnnotations();
        UtilImpl_BidirectionalMap fieldTargetMap = targetTable.i_getFieldAnnotations();
        UtilImpl_BidirectionalMap methodTargetMap = targetTable.i_getMethodAnnotations();
        for (String i_annotationClassName : classTargetMap.getHolderSet()) {
            i_annotatedClassNames.put(i_annotationClassName, i_annotationClassName);
        }
        for (String i_annotationClassName : fieldTargetMap.getHolderSet()) {
            i_annotatedClassNames.put(i_annotationClassName, i_annotationClassName);
        }
        for (String i_annotationClassName : methodTargetMap.getHolderSet()) {
            i_annotatedClassNames.put(i_annotationClassName, i_annotationClassName);
        }
        for (String i_className : i_annotatedClassNames.keySet()) {
            this.writeValue("Class", i_className);
            for (String i_annotationClassName : classTargetMap.selectHeldOf(i_className)) {
                this.writeSubValue("Class Annotation", i_annotationClassName);
            }
            for (String i_annotationClassName : fieldTargetMap.selectHeldOf(i_className)) {
                this.writeSubValue("Field Annotation", i_annotationClassName);
            }
            for (String i_annotationClassName : methodTargetMap.selectHeldOf(i_className)) {
                this.writeSubValue("Method Annotation", i_annotationClassName);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeClassTargets");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeTargets(UtilImpl_BidirectionalMap targetMap, String targetTag, String annotationTag) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeTargets", new Object[]{targetMap, targetTag, annotationTag});
        }
        for (String i_packageName : targetMap.getHolderSet()) {
            Set<String> i_annotationClassNames = targetMap.selectHeldOf(i_packageName);
            if (i_annotationClassNames.isEmpty()) continue;
            this.writeValue(targetTag, i_packageName);
            for (String i_annotationClassName : i_annotationClassNames) {
                this.writeSubValue(annotationTag, i_annotationClassName);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeTargets");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeHeader(String tableTag, String tableVersion) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeHeader", new Object[]{tableTag, tableVersion});
        }
        this.writeComment("============================================================");
        this.writeValue("Encoding", this.getEncoding(), 60);
        this.writeValue("Table", tableTag, 60);
        this.writeValue("Version", tableVersion, 60);
        this.writeValue("Written", TargetCacheImpl_Writer.getTimeStamp(), 60);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeHeader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeTrailer() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeTrailer", new Object[0]);
        }
        this.writeComment("X==========================================================X");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeTrailer");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeComment(String commentText) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeComment", new Object[]{commentText});
        }
        String methodName = "writeComment";
        String commentLine = "# " + commentText;
        this.writeLine(methodName, commentLine);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeComment");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeComment(String commentName, String commentValue) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeComment", new Object[]{commentName, commentValue});
        }
        String commentText = commentName + ":" + " " + commentValue;
        this.writeComment(commentText);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeComment");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeValue(String name, String value) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeValue", new Object[]{name, value});
        }
        String methodName = "writeValue";
        String valueText = name + ":" + " " + value;
        this.writeLine(methodName, valueText);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeValue");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeValue(String name, String value, int width) throws IOException {
        String valueText;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeValue", new Object[]{name, value, width});
        }
        String methodName = "writeValue";
        int missingSpaces = width - (name.length() + 2 + value.length());
        if (missingSpaces > 0) {
            if (missingSpaces > 80) {
                missingSpaces = 80;
            }
            valueText = name + ":" + " " + SPACES.substring(0, missingSpaces) + value;
        } else if (missingSpaces == 0) {
            valueText = name + ":" + " " + value;
        } else {
            throw new IllegalArgumentException("Name [ " + name + " ] and value [ " + value + " ] are too large for width [ " + Integer.toString(width) + " ]");
        }
        this.writeLine(methodName, valueText);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeValue");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeSubValue(String name, String value) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeSubValue", new Object[]{name, value});
        }
        String methodName = "writeSubValue";
        String valueText = "  " + name + ":" + " " + value;
        this.writeLine(methodName, valueText);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeSubValue");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeSubComment(String commentText) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeSubComment", new Object[]{commentText});
        }
        commentText = "  " + commentText;
        this.writeComment(commentText);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeSubComment");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void writeSubSubValue(String name, String value) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeSubSubValue", new Object[]{name, value});
        }
        String methodName = "writeSubSubValue";
        String valueText = "    " + name + ":" + " " + value;
        this.writeLine(methodName, valueText);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeSubSubValue");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeQueryHeader() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeQueryHeader", new Object[0]);
        }
        this.writeHeader("Annotation Queries", "1.0");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeQueryHeader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeQuery(String className, String methodName, String title, int policies, String type, Collection<String> specificClasses, String annotationClass, Collection<String> resultClasses) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeQuery", new Object[]{className, methodName, title, policies, type, specificClasses, annotationClass, resultClasses});
        }
        this.writeQuery(className, methodName, title, TargetCacheImpl_Writer.getTimeStamp(), policies, type, specificClasses, annotationClass, resultClasses);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeQuery");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeQuery(String className, String methodName, String title, String timeStamp, int policies, String type, Collection<String> specificClasses, String annotationClass, Collection<String> resultClasses) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeQuery", new Object[]{className, methodName, title, timeStamp, policies, type, specificClasses, annotationClass, resultClasses});
        }
        this.writeComment("============================================================");
        this.writeValue("Query", title);
        this.writeValue("Query Class", className);
        this.writeValue("Query Method", methodName);
        this.writeValue("Timestamp", timeStamp);
        this.writeValue("Policies", TargetCacheImpl_Writer.policiesText(policies));
        this.writeValue("Type", type);
        if (specificClasses != null) {
            for (String specificClass : specificClasses) {
                this.writeSubValue("Specific", specificClass);
            }
        }
        this.writeValue("Annotation", annotationClass);
        for (String resultClass : resultClasses) {
            this.writeSubValue("Result", resultClass);
        }
        this.flush();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeQuery");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeQuery(String className, String methodName, String title, Collection<String> sources, String type, Collection<String> specificClasses, String annotationClass, Collection<String> resultClasses) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeQuery", new Object[]{className, methodName, title, sources, type, specificClasses, annotationClass, resultClasses});
        }
        this.writeQuery(className, methodName, title, TargetCacheImpl_Writer.getTimeStamp(), sources, type, specificClasses, annotationClass, resultClasses);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeQuery");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeQuery(String className, String methodName, String title, String timeStamp, Collection<String> sources, String type, Collection<String> specificClasses, String annotationClass, Collection<String> resultClasses) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeQuery", new Object[]{className, methodName, title, timeStamp, sources, type, specificClasses, annotationClass, resultClasses});
        }
        this.writeComment("============================================================");
        this.writeValue("Query", title);
        this.writeValue("Query Class", className);
        this.writeValue("Query Method", methodName);
        this.writeValue("Timestamp", timeStamp);
        for (String source : sources) {
            this.writeValue("Source", source);
        }
        this.writeValue("Type", type);
        if (specificClasses != null) {
            for (String specificClass : specificClasses) {
                this.writeSubValue("Specific", specificClass);
            }
        }
        this.writeValue("Annotation", annotationClass);
        for (String resultClass : resultClasses) {
            this.writeSubValue("Result", resultClass);
        }
        this.flush();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeQuery");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeQuery(String className, String methodName, String title, int policies, Collection<String> sources, String type, Collection<String> specificClasses, String annotationClass, Collection<String> resultClasses) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeQuery", new Object[]{className, methodName, title, policies, sources, type, specificClasses, annotationClass, resultClasses});
        }
        this.writeQuery(className, methodName, title, TargetCacheImpl_Writer.getTimeStamp(), policies, sources, type, specificClasses, annotationClass, resultClasses);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeQuery");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeQuery(String className, String methodName, String title, String timeStamp, int policies, Collection<String> sources, String type, Collection<String> specificClasses, String annotationClass, Collection<String> resultClasses) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeQuery", new Object[]{className, methodName, title, timeStamp, policies, sources, type, specificClasses, annotationClass, resultClasses});
        }
        this.writeComment("============================================================");
        this.writeValue("Query", title);
        this.writeValue("Query Class", className);
        this.writeValue("Query Method", methodName);
        this.writeValue("Timestamp", timeStamp);
        this.writeValue("Policies", TargetCacheImpl_Writer.policiesText(policies));
        for (String source : sources) {
            this.writeValue("Source", source);
        }
        this.writeValue("Type", type);
        if (specificClasses != null) {
            for (String specificClass : specificClasses) {
                this.writeSubValue("Specific", specificClass);
            }
        }
        this.writeValue("Annotation", annotationClass);
        for (String resultClass : resultClasses) {
            this.writeSubValue("Result", resultClass);
        }
        this.flush();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "writeQuery");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void write(Index jandexIndex) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "write", new Object[]{jandexIndex});
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "write", "Jandex write [ " + this.getPath() + " ] [ " + jandexIndex.getKnownClasses().size() + " ]");
        }
        Jandex_Utils.basicWriteIndex(this.getStream(), jandexIndex, "Jandex write [ " + this.getPath() + " ]");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Writer", "write");
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static void logLine(StringBuilder builder, String outputLine) {
        builder.append(outputLine);
        builder.append("/n");
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static void logComment(StringBuilder builder, String commentText) {
        String commentLine = "# " + commentText;
        TargetCacheImpl_Writer.logLine(builder, commentLine);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static void logComment(StringBuilder builder, String commentName, String commentValue) {
        String commentText = commentName + ":" + " " + commentValue;
        TargetCacheImpl_Writer.logComment(builder, commentText);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static void logValue(StringBuilder builder, String name, String value) {
        String valueText = name + ":" + " " + value;
        TargetCacheImpl_Writer.logLine(builder, valueText);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected static void logSubValue(StringBuilder builder, String name, String value) {
        String valueText = "  " + name + ":" + " " + value;
        TargetCacheImpl_Writer.logLine(builder, valueText);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void logQuery(StringBuilder builder, String title, int policies, String type, Collection<String> specificClasses, String annotationClass, Collection<String> resultClasses) {
        TargetCacheImpl_Writer.logQuery(builder, title, TargetCacheImpl_Writer.getTimeStamp(), policies, type, specificClasses, annotationClass, resultClasses);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void logQuery(StringBuilder builder, String title, String timeStamp, int policies, String type, Collection<String> specificClasses, String annotationClass, Collection<String> resultClasses) {
        TargetCacheImpl_Writer.logComment(builder, "============================================================");
        TargetCacheImpl_Writer.logValue(builder, "Query", title);
        TargetCacheImpl_Writer.logValue(builder, "Timestamp", timeStamp);
        TargetCacheImpl_Writer.logValue(builder, "Policies", TargetCacheImpl_Writer.policiesText(policies));
        TargetCacheImpl_Writer.logValue(builder, "Type", type);
        if (specificClasses != null) {
            for (String specificClass : specificClasses) {
                TargetCacheImpl_Writer.logSubValue(builder, "Specific", specificClass);
            }
        }
        TargetCacheImpl_Writer.logValue(builder, "Annotation", annotationClass);
        for (String resultClass : resultClasses) {
            TargetCacheImpl_Writer.logSubValue(builder, "Result", resultClass);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void logQuery(StringBuilder builder, String title, Collection<String> sources, String type, Collection<String> specificClasses, String annotationClass, Collection<String> resultClasses) {
        TargetCacheImpl_Writer.logQuery(builder, title, TargetCacheImpl_Writer.getTimeStamp(), sources, type, specificClasses, annotationClass, resultClasses);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void logQuery(StringBuilder builder, String title, String timeStamp, Collection<String> sources, String type, Collection<String> specificClasses, String annotationClass, Collection<String> resultClasses) {
        TargetCacheImpl_Writer.logComment(builder, "============================================================");
        TargetCacheImpl_Writer.logValue(builder, "Query", title);
        TargetCacheImpl_Writer.logValue(builder, "Timestamp", timeStamp);
        for (String source : sources) {
            TargetCacheImpl_Writer.logValue(builder, "Source", source);
        }
        TargetCacheImpl_Writer.logValue(builder, "Type", type);
        if (specificClasses != null) {
            for (String specificClass : specificClasses) {
                TargetCacheImpl_Writer.logSubValue(builder, "Specific", specificClass);
            }
        }
        TargetCacheImpl_Writer.logValue(builder, "Annotation", annotationClass);
        for (String resultClass : resultClasses) {
            TargetCacheImpl_Writer.logSubValue(builder, "Result", resultClass);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void logQuery(StringBuilder builder, String title, int policies, Collection<String> sources, String type, Collection<String> specificClasses, String annotationClass, Collection<String> resultClasses) {
        TargetCacheImpl_Writer.logQuery(builder, title, TargetCacheImpl_Writer.getTimeStamp(), policies, sources, type, specificClasses, annotationClass, resultClasses);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void logQuery(StringBuilder builder, String title, String timeStamp, int policies, Collection<String> sources, String type, Collection<String> specificClasses, String annotationClass, Collection<String> resultClasses) {
        TargetCacheImpl_Writer.logComment(builder, "============================================================");
        TargetCacheImpl_Writer.logValue(builder, "Query", title);
        TargetCacheImpl_Writer.logValue(builder, "Timestamp", timeStamp);
        TargetCacheImpl_Writer.logValue(builder, "Policies", TargetCacheImpl_Writer.policiesText(policies));
        for (String source : sources) {
            TargetCacheImpl_Writer.logValue(builder, "Source", source);
        }
        TargetCacheImpl_Writer.logValue(builder, "Type", type);
        if (specificClasses != null) {
            for (String specificClass : specificClasses) {
                TargetCacheImpl_Writer.logSubValue(builder, "Specific", specificClass);
            }
        }
        TargetCacheImpl_Writer.logValue(builder, "Annotation", annotationClass);
        for (String resultClass : resultClasses) {
            TargetCacheImpl_Writer.logSubValue(builder, "Result", resultClass);
        }
    }

    private static enum OpcodeTag {
        ACC_PUBLIC(1, "public"),
        ACC_PRIVATE(2, "private"),
        ACC_PROTECTED(4, "protected"),
        ACC_STATIC(8, "static"),
        ACC_FINAL(16, "final"),
        ACC_SUPER(32, "super"),
        ACC_SYNCHRONIZED(32, "synchronized"),
        ACC_VOLATILE(64, "volatile"),
        ACC_BRIDGE(64, "bridge"),
        ACC_VARARGS(128, "varargs"),
        ACC_TRANSIENT(128, "transient"),
        ACC_NATIVE(256, "native"),
        ACC_INTERFACE(512, "interface"),
        ACC_ABSTRACT(1024, "abstract"),
        ACC_STRICT(2048, "strict"),
        ACC_SYNTHETIC(4096, "synthetic"),
        ACC_ANNOTATION(8192, "annotation"),
        ACC_ENUM(16384, "enum"),
        ACC_DEPRECATED(131072, "deprecated");

        private final int opcode;
        private final String tag;

        @Trivial
        private OpcodeTag(int opcode, String tag) {
            this.opcode = opcode;
            this.tag = tag;
        }

        @Trivial
        public int getOpcode() {
            return this.opcode;
        }

        @Trivial
        public String getTag() {
            return this.tag;
        }

        @Trivial
        public static String asText(int modifiers) {
            String text;
            if (modifiers == 0) {
                return null;
            }
            String singleTag = null;
            StringBuilder multiTag = null;
            for (OpcodeTag modifiersText : OpcodeTag.values()) {
                int opcode = modifiersText.getOpcode();
                if ((modifiers & opcode) == 0) continue;
                modifiers &= ~opcode;
                String modifierTag = modifiersText.getTag();
                if (singleTag == null) {
                    singleTag = modifierTag;
                    continue;
                }
                if (multiTag == null) {
                    multiTag = new StringBuilder(singleTag);
                }
                multiTag.append(" ");
                multiTag.append(modifierTag);
            }
            String unknownText = modifiers != 0 ? "UNKNOWN(" + Integer.toHexString(modifiers) : null;
            if (singleTag == null) {
                text = unknownText;
            } else if (multiTag == null) {
                text = unknownText == null ? singleTag : singleTag + " " + unknownText;
            } else {
                if (unknownText != null) {
                    multiTag.append(" ");
                    multiTag.append(unknownText);
                }
                text = multiTag.toString();
            }
            return text;
        }
    }
}

