/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics.internal.monitor.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics.internal.monitor.internal.MonitorCounter;
import io.openliberty.microprofile.metrics.internal.monitor.internal.MonitorGauge;
import io.openliberty.microprofile.metrics50.SharedMetricRegistries;
import io.openliberty.microprofile.metrics50.helper.Util;
import io.openliberty.smallrye.metrics.adapters.SRMetricRegistryAdapter;
import java.lang.management.ManagementFactory;
import java.security.AccessController;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.management.MBeanServer;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MonitorMetrics {
    private static final TraceComponent tc = Tr.register(MonitorMetrics.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    protected String objectName;
    protected String mbeanStatsName;
    protected MBeanServer mbs = AccessController.doPrivileged(() -> ManagementFactory.getPlatformMBeanServer());
    protected Set<MetricID> vendorMetricIDs;
    protected Set<MetricID> baseMetricIDs;
    protected String mpAppName = null;
    static final long serialVersionUID = -9160352422240599873L;

    public MonitorMetrics(String objectName) {
        this.objectName = objectName;
        this.vendorMetricIDs = new HashSet<MetricID>();
        this.baseMetricIDs = new HashSet<MetricID>();
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void createMetrics(SharedMetricRegistries sharedMetricRegistry, String[][] data) {
        MetricRegistry metricRegistry;
        block15: {
            block17: {
                block16: {
                    metricRegistry = sharedMetricRegistry.getOrCreate("vendor");
                    this.resolveMPAppNameFromMPConfig();
                    if (metricRegistry != null) break block15;
                    if (tc.isDebugEnabled()) break block16;
                    if (!tc.isAnyTracingEnabled()) break block17;
                }
                Tr.debug((TraceComponent)tc, (String)"MetricRegistry obtained from SharedMetricRegistries was null. No metrics will be registered.", (Object[])new Object[0]);
            }
            return;
        }
        Set<MetricID> metricIDSet = null;
        for (String[] metricData : data) {
            String metricName = metricData[1];
            String metricTagName = metricData[8];
            Tag metricTag = null;
            if (metricTagName != null) {
                metricTag = new Tag(metricTagName, this.getMBeanStatsString());
            }
            MetricID metricID = new MetricID(metricName, new Tag[]{metricTag});
            String metricType = metricData[4];
            metricIDSet = this.vendorMetricIDs;
            String description = Tr.formatMessage((TraceComponent)tc, (String)metricData[3], (Object[])new Object[0]);
            String unit = metricData[5];
            Map.Entry<String, Double> conversionMap = this.resolveBaseUnitAndConversionFactor(unit);
            double conversionFactor = conversionMap.getValue();
            unit = conversionMap.getKey();
            Metadata metadata = Metadata.builder().withName(metricName).withDescription(description).withUnit(unit).build();
            if ("COUNTER".equalsIgnoreCase(metricType)) {
                MonitorCounter mc;
                MonitorCounter monitorCounter = mc = metricData[7] == null ? new MonitorCounter(this.mbs, this.objectName, metricData[6]) : new MonitorCounter(this.mbs, this.objectName, metricData[6], metricData[7]);
                if (Util.SR_LEGACY_METRIC_REGISTRY_CLASS.isInstance(metricRegistry)) {
                    try {
                        Object cast = Util.SR_LEGACY_METRIC_REGISTRY_CLASS.cast(metricRegistry);
                        SRMetricRegistryAdapter srMetricRegistry = new SRMetricRegistryAdapter(cast);
                        if (metricTag == null) {
                            srMetricRegistry.functionCounter(metadata, (Object)mc, x -> (double)x.getCount() * conversionFactor, new Tag[0]);
                        } else {
                            srMetricRegistry.functionCounter(metadata, (Object)mc, x -> (double)x.getCount() * conversionFactor, new Tag[]{metricTag});
                        }
                    }
                    catch (ClassCastException cast) {
                        FFDCFilter.processException((Throwable)cast, (String)"io.openliberty.microprofile.metrics.internal.monitor.internal.MonitorMetrics", (String)"128", (Object)this, (Object[])new Object[]{sharedMetricRegistry, data});
                        Tr.debug((TraceComponent)tc, (String)("Incompatible Metric Registries. Coud not cast " + metricRegistry + " to " + Util.SR_LEGACY_METRIC_REGISTRY_CLASS), (Object[])new Object[0]);
                    }
                }
                metricIDSet.add(metricID);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Registered " + metricID.toString()), (Object[])new Object[0]);
                continue;
            }
            if ("GAUGE".equalsIgnoreCase(metricType)) {
                MonitorGauge mg;
                MonitorGauge monitorGauge = mg = metricData[7] == null ? new MonitorGauge(this.mbs, this.objectName, metricData[6]) : new MonitorGauge(this.mbs, this.objectName, metricData[6], metricData[7]);
                if (metricTag == null) {
                    metricRegistry.gauge(metadata, mg, x -> ((Number)x.getValue()).doubleValue() * conversionFactor, new Tag[0]);
                } else {
                    metricRegistry.gauge(metadata, mg, x -> ((Number)x.getValue()).doubleValue() * conversionFactor, new Tag[]{metricTag});
                }
                metricIDSet.add(metricID);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Registered " + metricID.toString()), (Object[])new Object[0]);
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Failed to register " + metricName + " because of invalid type " + metricType), (Object[])new Object[0]);
        }
    }

    protected String[] getRESTMBeanStatsTags() {
        String[] mbeanNameProperty = new String[3];
        for (String subString : this.objectName.split(",")) {
            if (!(subString = subString.trim()).contains("name=")) continue;
            mbeanNameProperty = subString.split("/");
            mbeanNameProperty[0] = mbeanNameProperty[0].substring(mbeanNameProperty[0].indexOf("=") + 1, mbeanNameProperty[0].length());
            mbeanNameProperty[2] = mbeanNameProperty[2].replaceAll("\\(\\)", "");
            mbeanNameProperty[2] = mbeanNameProperty[2].replaceAll("\\(", "_");
            mbeanNameProperty[2] = mbeanNameProperty[2].replaceAll("\\)", "");
            break;
        }
        return mbeanNameProperty;
    }

    protected String getMBeanStatsString() {
        if (this.mbeanStatsName == null) {
            String serviceName = null;
            String serviceURL = null;
            String portName = null;
            String mbeanObjName = null;
            StringBuffer sb = new StringBuffer();
            for (String subString : this.objectName.split(",")) {
                if ((subString = subString.trim()).contains("service=")) {
                    serviceName = this.getMBeanStatsServiceName(subString);
                    serviceURL = this.getMBeanStatsServiceURL(subString);
                    continue;
                }
                if (subString.contains("port=")) {
                    portName = this.getMBeanStatsPortName(subString);
                    continue;
                }
                if (!subString.contains("name=")) continue;
                mbeanObjName = this.getMBeanStatsName(subString);
                break;
            }
            if (serviceURL != null && serviceName != null && portName != null) {
                sb.append(serviceURL);
                sb.append(".");
                sb.append(serviceName);
                sb.append(".");
                sb.append(portName);
            } else if (mbeanObjName != null) {
                sb.append(mbeanObjName);
            } else {
                sb.append("unknown");
            }
            this.mbeanStatsName = sb.toString();
        }
        return this.mbeanStatsName;
    }

    private String getMBeanStatsName(String nameStr) {
        String mbeanName = nameStr.split("=")[1];
        mbeanName = mbeanName.replaceAll(" ", "_");
        mbeanName = mbeanName.replaceAll("/", "_");
        mbeanName = mbeanName.replaceAll("[^a-zA-Z0-9_]", "_");
        return mbeanName;
    }

    private String getMBeanStatsServiceName(String serviceStr) {
        serviceStr = serviceStr.split("=")[1];
        serviceStr = serviceStr.replaceAll("\"", "");
        String serviceName = serviceStr.substring(serviceStr.indexOf("}") + 1);
        return serviceName;
    }

    private String getMBeanStatsServiceURL(String serviceStr) {
        serviceStr = serviceStr.split("=")[1];
        serviceStr = serviceStr.replaceAll("\"", "");
        String serviceURL = serviceStr.substring(serviceStr.indexOf("{") + 1, serviceStr.indexOf("}"));
        serviceURL = serviceURL.replace("http://", "").replace("https://", "").replace("/", ".");
        return serviceURL;
    }

    private String getMBeanStatsPortName(String portStr) {
        portStr = portStr.split("=")[1];
        String portName = portStr.replaceAll("\"", "");
        return portName;
    }

    public void unregisterMetrics(SharedMetricRegistries sharedMetricRegistry) {
        MetricRegistry vendorRegistry = sharedMetricRegistry.getOrCreate("vendor");
        for (MetricID metricID : this.vendorMetricIDs) {
            boolean rc = vendorRegistry.remove(this.withMPAppNameTag(metricID));
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Unregistered " + metricID.toString() + " " + (rc ? "successfully" : "unsuccessfully")), (Object[])new Object[0]);
        }
        this.vendorMetricIDs.clear();
    }

    public Set<MetricID> getVendorMetricIDSet() {
        return this.vendorMetricIDs;
    }

    protected void resolveMPAppNameFromMPConfig() {
        Optional applicationName = null;
        applicationName = ConfigProvider.getConfig().getOptionalValue("mp.metrics.appName", String.class);
        if (applicationName.isPresent() && !((String)applicationName.get()).isEmpty()) {
            this.mpAppName = (String)applicationName.get();
        } else {
            applicationName = ConfigProvider.getConfig().getOptionalValue("mp.metrics.defaultAppName", String.class);
            if (applicationName.isPresent() && !((String)applicationName.get()).isEmpty()) {
                this.mpAppName = (String)applicationName.get();
            }
        }
    }

    protected MetricID withMPAppNameTag(MetricID mid) {
        if (this.mpAppName != null && !this.mpAppName.isEmpty()) {
            return this.mergeMPAppTag(mid, this.mpAppName);
        }
        return mid;
    }

    private MetricID mergeMPAppTag(MetricID mid, String appNameValue) {
        Tag appTag = new Tag("mp_app", appNameValue);
        Tag[] tempArr = Arrays.copyOf(mid.getTagsAsArray(), mid.getTagsAsArray().length + 1);
        tempArr[tempArr.length - 1] = appTag;
        return new MetricID(mid.getName(), tempArr);
    }

    public String getMpAppName() {
        return this.mpAppName;
    }

    protected Map.Entry<String, Double> resolveBaseUnitAndConversionFactor(String unit) {
        if (unit == null || unit.trim().isEmpty() || unit.equals("none")) {
            return new AbstractMap.SimpleEntry<String, Double>(unit, 1.0);
        }
        if (unit.equals("nanoseconds")) {
            return new AbstractMap.SimpleEntry<String, Double>("seconds", 1.0E-9);
        }
        if (unit.equals("microseconds")) {
            return new AbstractMap.SimpleEntry<String, Double>("seconds", 1.0E-6);
        }
        if (unit.equals("seconds")) {
            return new AbstractMap.SimpleEntry<String, Double>("seconds", 1.0);
        }
        if (unit.equals("minutes")) {
            return new AbstractMap.SimpleEntry<String, Double>("seconds", 60.0);
        }
        if (unit.equals("hours")) {
            return new AbstractMap.SimpleEntry<String, Double>("seconds", 3600.0);
        }
        if (unit.equals("days")) {
            return new AbstractMap.SimpleEntry<String, Double>("seconds", 86400.0);
        }
        if (unit.equals("percent")) {
            return new AbstractMap.SimpleEntry<String, Double>("_percent", Double.NaN);
        }
        if (unit.equals("bytes")) {
            return new AbstractMap.SimpleEntry<String, Double>("bytes", 1.0);
        }
        if (unit.equals("kilobytes")) {
            return new AbstractMap.SimpleEntry<String, Double>("bytes", 1024.0);
        }
        if (unit.equals("megabytes")) {
            return new AbstractMap.SimpleEntry<String, Double>("bytes", 1048576.0);
        }
        if (unit.equals("gigabytes")) {
            return new AbstractMap.SimpleEntry<String, Double>("bytes", 1.073741824E9);
        }
        if (unit.equals("kilobits")) {
            return new AbstractMap.SimpleEntry<String, Double>("bytes", 125.0);
        }
        if (unit.equals("megabits")) {
            return new AbstractMap.SimpleEntry<String, Double>("bytes", 125000.0);
        }
        if (unit.equals("gigabits")) {
            return new AbstractMap.SimpleEntry<String, Double>("bytes", 1.25E8);
        }
        if (unit.equals("kibibits")) {
            return new AbstractMap.SimpleEntry<String, Double>("bytes", 128.0);
        }
        if (unit.equals("mebibits")) {
            return new AbstractMap.SimpleEntry<String, Double>("bytes", 131072.0);
        }
        if (unit.equals("gibibits")) {
            return new AbstractMap.SimpleEntry<String, Double>("bytes", 1.342E8);
        }
        if (unit.equals("milliseconds")) {
            return new AbstractMap.SimpleEntry<String, Double>("seconds", 0.001);
        }
        return null;
    }
}

