/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.outbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.http.channel.h2internal.exceptions.FlowControlException;
import com.ibm.ws.http.channel.h2internal.exceptions.StreamClosedException;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundServiceContextImpl;
import com.ibm.ws.http.channel.outstream.HttpOutputStreamConnectWeb;
import com.ibm.ws.http.channel.outstream.HttpOutputStreamObserver;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.exception.WriteBeyondContentLengthException;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class HttpOutputStreamImpl
extends HttpOutputStreamConnectWeb {
    private static final TraceComponent tc = Tr.register(HttpOutputStreamImpl.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    protected HttpInboundServiceContext isc = null;
    protected VirtualConnection vc = null;
    protected boolean ignoreFlush = true;
    private int bbSize;
    protected int amountToBuffer = 0;
    protected int bufferedCount = 0;
    protected WsByteBuffer[] output = null;
    protected int outputIndex = 0;
    protected boolean writing = false;
    protected boolean closed = false;
    protected IOException error = null;
    protected long bytesWritten = 0L;
    protected boolean contentLengthSet = false;
    protected long bytesRemaining = -1L;
    protected boolean isClosing = false;
    protected boolean hasFinished = false;
    protected HttpOutputStreamObserver obs = null;
    protected boolean WCheadersWritten = false;

    public HttpOutputStreamImpl(HttpInboundServiceContext context) {
        this.isc = context;
    }

    @Override
    public void setIsClosing(boolean b) {
        this.isClosing = b;
    }

    public void setVirtualConnection(VirtualConnection inVC) {
        this.vc = inVC;
    }

    public VirtualConnection getVc() {
        return this.vc;
    }

    @Override
    public int getBufferSize() {
        return this.amountToBuffer;
    }

    @Override
    public void setBufferSize(int size) {
        if (this.writing || this.isClosed()) {
            throw new IllegalStateException("Stream unable to set size");
        }
        this.amountToBuffer = size;
        this.bbSize = 49152 < size ? 32768 : 8192;
        Integer h2size = (Integer)this.getVc().getStateMap().get("h2_frame_size");
        if (h2size != null && h2size < this.bbSize) {
            this.bbSize = h2size;
        }
        int numBuffers = size / this.bbSize;
        if (0 == size || 0 != size % this.bbSize) {
            ++numBuffers;
        }
        this.output = new WsByteBuffer[numBuffers];
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setBufferSize=" + size + "; " + this), (Object[])new Object[0]);
        }
    }

    @Override
    public void clear() {
        if (null != this.output) {
            for (int i = 0; i < this.output.length; ++i) {
                if (null == this.output[i]) continue;
                this.output[i].release();
                this.output[i] = null;
            }
        }
        this.outputIndex = 0;
        this.bufferedCount = 0;
        this.bytesWritten = 0L;
        this.isClosing = false;
    }

    @Override
    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public long getBufferedCount() {
        return this.bufferedCount;
    }

    @Override
    public final boolean hasBufferedContent() {
        return 0 < this.bufferedCount;
    }

    protected void validate() throws IOException {
        if (null != this.error) {
            throw this.error;
        }
        if (this.isClosed()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("validate - is closed: hc: " + this.hashCode() + " details: " + this), (Object[])new Object[0]);
            }
            throw new IOException("Stream is closed");
        }
        if (this.isc != null && this.isc instanceof HttpInboundServiceContextImpl && null == this.isc.getResponse()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("validate response is cleaned up hc: " + this.hashCode() + " details: " + this), (Object[])new Object[0]);
            }
            throw new IOException("Response already destroyed on error condition or close request from the client");
        }
        if (null == this.output) {
            this.setBufferSize(32768);
        }
    }

    protected WsByteBuffer getBuffer() {
        WsByteBuffer buffer = this.output[this.outputIndex];
        if (null == buffer) {
            buffer = HttpDispatcher.getBufferManager().allocate(this.bbSize);
            buffer.clear();
            this.output[this.outputIndex] = buffer;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getBuffer, buffer -->" + buffer + " ,outputIndex -->" + this.outputIndex), (Object[])new Object[0]);
            }
        } else if (!buffer.hasRemaining()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getBuffer, buffer  -->" + buffer + " ,outputIndex -->" + this.outputIndex + " output length -->" + this.output.length), (Object[])new Object[0]);
            }
            buffer.flip();
            ++this.outputIndex;
            if (null == this.output[this.outputIndex]) {
                this.output[this.outputIndex] = HttpDispatcher.getBufferManager().allocate(this.bbSize);
            }
            buffer = this.output[this.outputIndex];
            buffer.clear();
        }
        return buffer;
    }

    private void writeToBuffers(byte[] value, int start, int len) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Writing " + len + ", buffered=" + this.bufferedCount), (Object[])new Object[0]);
        }
        if (value.length < start + len) {
            throw new IllegalArgumentException("Length outside value range");
        }
        this.writing = true;
        int remaining = len;
        int offset = start;
        while (0 < remaining) {
            WsByteBuffer buffer = this.getBuffer();
            int avail = buffer.remaining();
            if (this.contentLengthSet && this.bytesRemaining < (long)(this.bufferedCount + remaining)) {
                int numberToWrite = (int)this.bytesRemaining - this.bufferedCount;
                boolean throwExceptionThisTime = true;
                if (numberToWrite > avail) {
                    numberToWrite = avail;
                    throwExceptionThisTime = false;
                }
                this.bufferedCount += numberToWrite;
                buffer.put(value, offset, numberToWrite);
                remaining -= numberToWrite;
                if (throwExceptionThisTime) {
                    throw new WriteBeyondContentLengthException();
                }
            }
            if (avail >= remaining) {
                this.bufferedCount += remaining;
                buffer.put(value, offset, remaining);
                remaining = 0;
            } else {
                this.bufferedCount += avail;
                buffer.put(value, offset, avail);
                offset += avail;
                remaining -= avail;
            }
            if (this.bufferedCount < this.amountToBuffer) continue;
            this.ignoreFlush = false;
            this.flushBuffers();
        }
    }

    @FFDCIgnore(value={IOException.class})
    private void convertFile(FileChannel fc) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Converting FileChannel to buffers", (Object[])new Object[0]);
        }
        WsByteBuffer[] body = new WsByteBuffer[1];
        WsByteBufferPoolManager mgr = HttpDispatcher.getBufferManager();
        long max = fc.size();
        long blocksize = 0x100000L < max ? 0x100000L : max;
        long offset = 0L;
        while (offset < max) {
            WsByteBuffer wsbb;
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, offset, blocksize);
            offset += blocksize;
            body[0] = wsbb = mgr.wrap((ByteBuffer)bb);
            try {
                this.isc.sendResponseBody(body);
            }
            catch (MessageSentException mse) {
                FFDCFilter.processException((Throwable)mse, (String)this.getClass().getName(), (String)"convertFile", (Object[])new Object[]{this, this.isc});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Invalid state, message-sent-exception received; " + this.isc), (Object[])new Object[0]);
                }
                this.error = new IOException("Invalid state");
                throw this.error;
            }
            catch (IOException ioe) {
                this.error = ioe;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Received exception during write: " + ioe), (Object[])new Object[0]);
                }
                throw ioe;
            }
            finally {
                wsbb.release();
            }
        }
    }

    private boolean cannotWriteFC() {
        if (null == this.vc) {
            return true;
        }
        return !this.vc.isFileChannelCapable();
    }

    @Override
    @FFDCIgnore(value={IOException.class})
    public void writeFile(FileChannel fc) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("writeFile: " + fc), (Object[])new Object[0]);
        }
        if (this.cannotWriteFC()) {
            this.convertFile(fc);
            return;
        }
        this.flushHeaders();
        WsByteBuffer fb = HttpDispatcher.getBufferManager().allocateFileChannelBuffer(fc);
        try {
            this.isc.sendResponseBody(new WsByteBuffer[]{fb});
            this.bytesWritten += fc.size();
        }
        catch (MessageSentException mse) {
            FFDCFilter.processException((Throwable)mse, (String)this.getClass().getName(), (String)"writeFile", (Object[])new Object[]{this, this.isc});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Invalid state, message-sent-exception received; " + this.isc), (Object[])new Object[0]);
            }
            this.error = new IOException("Invalid state");
            throw this.error;
        }
        catch (IOException ioe) {
            this.error = ioe;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Received exception during write: " + ioe), (Object[])new Object[0]);
            }
            throw ioe;
        }
        finally {
            fb.release();
        }
    }

    @Override
    @FFDCIgnore(value={IOException.class})
    public void flushHeaders() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (null == this.isc) {
                Tr.debug((TraceComponent)tc, (String)"flushHeaders: isc is null", (Object[])new Object[0]);
            } else if (null == this.isc.getResponse()) {
                Tr.debug((TraceComponent)tc, (String)("flushHeaders: isc.getResponse() is null, isc is " + this.isc), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)("flushHeaders: committed=" + this.isc.getResponse().isCommitted()), (Object[])new Object[]{this.isc, this.isc.getResponse()});
            }
        }
        this.validate();
        this.ignoreFlush = false;
        if (null == this.isc.getResponse() || this.isc.getResponse().isCommitted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Response headers already committed or response cleared; " + this.isc), (Object[])new Object[0]);
            }
            return;
        }
        this.isc.getResponse().setCommitted();
        try {
            this.isc.sendResponseHeaders();
        }
        catch (MessageSentException mse) {
            FFDCFilter.processException((Throwable)mse, (String)this.getClass().getName(), (String)"flushHeaders", (Object[])new Object[]{this, this.isc});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Invalid state, message-sent-exception received; " + this.isc), (Object[])new Object[0]);
            }
            this.error = new IOException("Invalid state");
            throw this.error;
        }
        catch (IOException ioe) {
            this.error = ioe;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Received exception during write: " + ioe), (Object[])new Object[0]);
            }
            throw ioe;
        }
    }

    @Override
    @FFDCIgnore(value={IOException.class})
    public void flushBuffers() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Flushing buffers: " + this), (Object[])new Object[0]);
        }
        if (this.isc.getResponse() == null) {
            IOException x = new IOException("response Object(s) (e.g. getObjectFactory()) are null");
            throw x;
        }
        if (!this.isc.getResponse().isCommitted()) {
            if (this.obs != null && !this.WCheadersWritten) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("obs  ->" + this.obs), (Object[])new Object[0]);
                }
                this.obs.alertOSFirstFlush();
            }
            this.isc.getResponse().setCommitted();
        }
        if (this.ignoreFlush) {
            this.ignoreFlush = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Ignoring first flush attempt", (Object[])new Object[0]);
            }
            return;
        }
        boolean writingBody = this.hasBufferedContent();
        if (writingBody && null != this.output[this.outputIndex]) {
            this.output[this.outputIndex].flip();
        }
        try {
            WsByteBuffer[] content;
            WsByteBuffer[] wsByteBufferArray = content = writingBody ? this.output : null;
            if (this.isClosed() || this.isClosing) {
                if (!this.hasFinished) {
                    this.isc.finishResponseMessage(content);
                    this.isClosing = false;
                    this.hasFinished = true;
                }
            } else {
                this.isc.sendResponseBody(content);
            }
        }
        catch (MessageSentException mse) {
            FFDCFilter.processException((Throwable)mse, (String)this.getClass().getName(), (String)"flushBuffers", (Object[])new Object[]{this, this.isc});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Invalid state, message-sent-exception received; " + this.isc), (Object[])new Object[0]);
            }
            this.error = new IOException("Invalid state");
            throw this.error;
        }
        catch (IOException ioe) {
            Throwable th;
            this.error = ioe;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Received exception during write: " + ioe), (Object[])new Object[0]);
            }
            if ((th = ioe.getCause()) instanceof FlowControlException || th instanceof StreamClosedException) {
                Tr.debug((TraceComponent)tc, (String)"HTTP/2 stream could not write; setting error on this output stream", (Object[])new Object[0]);
                return;
            }
            throw ioe;
        }
        finally {
            this.bytesWritten += (long)this.bufferedCount;
            if (this.contentLengthSet) {
                this.bytesRemaining -= (long)this.bufferedCount;
            }
            this.bufferedCount = 0;
            this.outputIndex = 0;
            if (writingBody) {
                this.output[0].clear();
                for (int i = 1; i < this.output.length; ++i) {
                    if (null == this.output[i]) continue;
                    this.output[i].limit(0);
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this.getClass().getSimpleName());
        sb.append('@').append(Integer.toHexString(this.hashCode()));
        sb.append(" writing=").append(this.writing);
        sb.append(" closed=").append(this.closed);
        sb.append(" bufferedCount=").append(this.bufferedCount);
        sb.append(" bytesWritten=").append(this.bytesWritten);
        sb.append(" error=").append(this.error);
        if (null != this.output) {
            sb.append(" outindex=").append(this.outputIndex);
            for (int i = 0; i < this.output.length; ++i) {
                sb.append("\r\n\t").append(this.output[i]);
            }
        }
        return sb.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Closing stream: hc: " + this.hashCode() + " details: " + this), (Object[])new Object[0]);
        }
        try {
            this.validate();
            this.closed = true;
            this.ignoreFlush = false;
            this.flushBuffers();
        }
        catch (IOException ioe) {
            this.closed = true;
            this.ignoreFlush = false;
            throw ioe;
        }
        finally {
            this.clear();
        }
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public void flush() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Flushing stream: " + this), (Object[])new Object[0]);
        }
        this.validate();
        if (!this.hasFinished) {
            this.flushBuffers();
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("flush hasFinished=true; skipping flushBuffers() on " + this.hashCode() + " details: " + this), (Object[])new Object[0]);
        }
    }

    @Override
    public void flush(boolean ignoreFlag) throws IOException {
        this.ignoreFlush = ignoreFlag;
        this.flush();
    }

    @Override
    public void setContentLength(long length) {
        this.contentLengthSet = true;
        this.bytesRemaining = length;
    }

    @Override
    public void write(byte[] value, int start, int len) throws IOException {
        this.validate();
        this.writeToBuffers(value, start, len);
    }

    @Override
    public void write(byte[] value) throws IOException {
        this.validate();
        this.writeToBuffers(value, 0, value.length);
    }

    @Override
    public void write(int value) throws IOException {
        this.validate();
        byte[] buf = new byte[]{(byte)value};
        this.writeToBuffers(buf, 0, 1);
    }

    @Override
    public void setObserver(HttpOutputStreamObserver obs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("obs  ->" + obs), (Object[])new Object[0]);
        }
        this.obs = obs;
    }

    @Override
    public void setWebC_headersWritten(boolean headersWritten) {
        this.WCheadersWritten = headersWritten;
    }

    @Override
    public void setWC_remoteUser(String remoteUser) {
        if (this.isc instanceof HttpInboundServiceContextImpl) {
            ((HttpInboundServiceContextImpl)this.isc).setRemoteUser(remoteUser);
        }
    }
}

