/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.internal.validation.OASValidationResult;
import io.openliberty.microprofile.openapi20.internal.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ValidationHelper;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ResponsesValidator
extends TypeValidator<APIResponses> {
    private static final TraceComponent tc = Tr.register(ResponsesValidator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final ResponsesValidator INSTANCE = new ResponsesValidator();
    static final long serialVersionUID = -7795811827198688801L;

    public static ResponsesValidator getInstance() {
        return INSTANCE;
    }

    private ResponsesValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, APIResponses t) {
        if (t != null) {
            Map responses = t.getAPIResponses();
            if (responses != null) {
                Object message;
                if (responses.size() == 0 && t.getDefaultValue() == null) {
                    message = Tr.formatMessage((TraceComponent)tc, (String)"responseMustContainOneCode", (Object[])new Object[0]);
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), (String)message));
                } else if (!responses.keySet().stream().anyMatch(this::isSuccessStatusCode)) {
                    message = Tr.formatMessage((TraceComponent)tc, (String)"responseShouldContainSuccess", (Object[])new Object[0]);
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), (String)message));
                }
                for (String k : responses.keySet()) {
                    if (responses.get(k) != null) continue;
                    String message2 = Tr.formatMessage((TraceComponent)tc, (String)"nullValueInMap", (Object[])new Object[]{k});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message2));
                }
            } else {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"responseMustContainOneCode", (Object[])new Object[0]);
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
        }
    }

    @FFDCIgnore(value={NumberFormatException.class})
    private boolean isSuccessStatusCode(String s) {
        if (s == null) {
            return false;
        }
        if ("2XX".equals(s) || "default".equals(s)) {
            return true;
        }
        if (s.length() != 3) {
            return false;
        }
        try {
            return Response.Status.Family.familyOf((int)Integer.parseInt(s)) == Response.Status.Family.SUCCESSFUL;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

