/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.processor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionConfigurationException;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.JNDIEnvironmentRefType;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import jakarta.enterprise.concurrent.ManagedThreadFactoryDefinition;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ManagedThreadFactoryDefinitionBinding
extends InjectionBinding<ManagedThreadFactoryDefinition> {
    private static final TraceComponent tc = Tr.register(ManagedThreadFactoryDefinitionBinding.class, (String)"concurrent", (String)"io.openliberty.concurrent.internal.resources.CWWKCMessages");
    private static final String KEY_CONTEXT = "context";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_PRIORITY = "priority";
    private static final String KEY_VIRTUAL = "virtual";
    private static final String KEY_QUALIFIERS = "qualifiers";
    private static final boolean DEFAULT_VIRTUAL = false;
    private static final String[] DEFAULT_QUALIFIERS = new String[0];
    private final int eeVersion;
    private String contextServiceJndiName;
    private boolean XMLContextServiceRef;
    private String description;
    private boolean XMLDescription;
    private Integer priority;
    private boolean XMLPriority;
    private Boolean virtual;
    private boolean XMLvirtual;
    private String[] qualifiers;
    private boolean XMLqualifers;
    private Map<String, String> properties;
    private final Set<String> XMLProperties = new HashSet<String>();
    static final long serialVersionUID = -7077473795634250643L;

    public ManagedThreadFactoryDefinitionBinding(String jndiName, ComponentNameSpaceConfiguration nameSpaceConfig, int eeVersion) {
        super(null, nameSpaceConfig);
        this.setJndiName(jndiName);
        this.eeVersion = eeVersion;
    }

    public Class<?> getAnnotationType() {
        return ManagedThreadFactoryDefinition.class;
    }

    protected JNDIEnvironmentRefType getJNDIEnvironmentRefType() {
        return JNDIEnvironmentRefType.ManagedThreadFactory;
    }

    @ManualTrace
    public void merge(ManagedThreadFactoryDefinition annotation, Class<?> instanceClass, Member member) throws InjectionException {
        boolean trace;
        boolean bl = trace = TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled();
        if (trace) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"merge", (Object[])new Object[]{ManagedThreadFactoryDefinitionBinding.toString(annotation, this.eeVersion), instanceClass, member, (this.XMLContextServiceRef ? "(xml)" : "     ") + "contextServiceRef: " + this.contextServiceJndiName + " << " + annotation.context(), (this.XMLPriority ? "         (xml)" : "              ") + "priority: " + this.priority + " << " + annotation.priority(), (this.XMLvirtual ? "          (xml)" : "               ") + "virtual: " + this.virtual + " << " + (Serializable)(this.eeVersion >= 11 ? Boolean.valueOf(annotation.virtual()) : "Unspecified"), (this.XMLqualifers ? "        (xml)" : "            ") + "qualifiers: " + ManagedThreadFactoryDefinitionBinding.toString(this.qualifiers) + " << " + (this.eeVersion >= 11 ? ManagedThreadFactoryDefinitionBinding.toString(annotation.qualifiers()) : "Unspecified")});
        }
        if (member != null) {
            throw new IllegalArgumentException(member.toString());
        }
        this.contextServiceJndiName = (String)this.mergeAnnotationValue(this.contextServiceJndiName, this.XMLContextServiceRef, annotation.context(), KEY_CONTEXT, "java:comp/DefaultContextService");
        this.description = (String)this.mergeAnnotationValue(this.description, this.XMLDescription, "", KEY_DESCRIPTION, "");
        this.priority = (Integer)this.mergeAnnotationValue(this.priority, this.XMLPriority, annotation.priority(), KEY_PRIORITY, 5);
        if (this.eeVersion >= 11) {
            this.virtual = this.mergeAnnotationBoolean(this.virtual, this.XMLvirtual, annotation.virtual(), KEY_VIRTUAL, false);
            this.qualifiers = (String[])this.mergeAnnotationValue(this.qualifiers, this.XMLqualifers, ManagedThreadFactoryDefinitionBinding.toQualifierStringArray(annotation.qualifiers()), KEY_QUALIFIERS, DEFAULT_QUALIFIERS);
        }
        this.properties = this.mergeAnnotationProperties(this.properties, this.XMLProperties, new String[0]);
        if (trace) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"merge", (Object)new String[]{(this.XMLContextServiceRef ? "(xml)" : "     ") + "contextServiceRef= " + this.contextServiceJndiName, (this.XMLPriority ? "         (xml)" : "              ") + "priority= " + this.priority, (this.XMLvirtual ? "          (xml)" : "               ") + "virtual= " + this.virtual, (this.XMLqualifers ? "        (xml)" : "            ") + "qualifiers= " + ManagedThreadFactoryDefinitionBinding.toString(this.qualifiers)});
        }
    }

    @ManualTrace
    void mergeXML(com.ibm.ws.javaee.dd.common.ManagedThreadFactory mtfd) throws InjectionConfigurationException {
        String[] qualifierValues;
        boolean trace;
        boolean bl = trace = TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled();
        if (trace) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"mergeXML", (Object[])new Object[]{mtfd, mtfd.getName(), (this.XMLContextServiceRef ? "(xml)" : "     ") + "contextServiceRef: " + this.contextServiceJndiName + " << " + mtfd.getContextServiceRef(), (this.XMLPriority ? "         (xml)" : "              ") + "priority: " + this.priority + " << " + mtfd.getPriority(), (this.XMLvirtual ? "          (xml)" : "               ") + "virtual: " + this.virtual + " << " + mtfd.isVirtual(), (this.XMLqualifers ? "        (xml)" : "            ") + "qualifiers: " + ManagedThreadFactoryDefinitionBinding.toString(this.qualifiers) + " << " + ManagedThreadFactoryDefinitionBinding.toString(mtfd.getQualifiers())});
        }
        List descriptionList = mtfd.getDescriptions();
        String contextServiceRefValue = mtfd.getContextServiceRef();
        if (contextServiceRefValue != null) {
            this.contextServiceJndiName = (String)this.mergeXMLValue(this.contextServiceJndiName, contextServiceRefValue, "context-service-ref", KEY_CONTEXT, null);
            this.XMLContextServiceRef = true;
        }
        if (this.description != null) {
            this.description = (String)this.mergeXMLValue(this.description, descriptionList.toString(), KEY_DESCRIPTION, KEY_DESCRIPTION, null);
            this.XMLDescription = true;
        }
        if (mtfd.isSetPriority()) {
            this.priority = (Integer)this.mergeXMLValue(this.priority, mtfd.getPriority(), KEY_PRIORITY, KEY_PRIORITY, null);
            this.XMLPriority = true;
        }
        if (mtfd.isSetVirtual()) {
            this.virtual = (Boolean)this.mergeXMLValue(this.virtual, mtfd.isVirtual(), KEY_VIRTUAL, KEY_VIRTUAL, null);
            this.XMLvirtual = true;
        }
        if ((qualifierValues = mtfd.getQualifiers()) == null || qualifierValues.length == 0) {
            if (this.qualifiers == null) {
                this.qualifiers = DEFAULT_QUALIFIERS;
            }
        } else if (qualifierValues.length == 1 && qualifierValues[0].isEmpty()) {
            this.qualifiers = DEFAULT_QUALIFIERS;
            this.XMLqualifers = true;
        } else {
            this.qualifiers = (String[])this.mergeXMLValue(this.qualifiers, qualifierValues, "qualifier", KEY_QUALIFIERS, null);
            this.XMLqualifers = true;
        }
        List mxdProps = mtfd.getProperties();
        this.properties = this.mergeXMLProperties(this.properties, this.XMLProperties, mxdProps);
        if (trace) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"mergeXML", (Object)new String[]{(this.XMLContextServiceRef ? "(xml)" : "     ") + "contextServiceRef= " + this.contextServiceJndiName, (this.XMLPriority ? "         (xml)" : "              ") + "priority= " + this.priority, (this.XMLvirtual ? "          (xml)" : "               ") + "virtual= " + this.virtual, (this.XMLqualifers ? "        (xml)" : "            ") + "qualifiers= " + ManagedThreadFactoryDefinitionBinding.toString(this.qualifiers)});
        }
    }

    public void mergeSaved(InjectionBinding<ManagedThreadFactoryDefinition> injectionBinding) throws InjectionException {
        ManagedThreadFactoryDefinitionBinding managedThreadFactoryBinding = (ManagedThreadFactoryDefinitionBinding)injectionBinding;
        this.mergeSavedValue(this.contextServiceJndiName, managedThreadFactoryBinding.contextServiceJndiName, "context-service-ref");
        this.mergeSavedValue(this.description, managedThreadFactoryBinding.description, KEY_DESCRIPTION);
        this.mergeSavedValue(this.priority, managedThreadFactoryBinding.priority, KEY_PRIORITY);
        this.mergeSavedValue(this.virtual, managedThreadFactoryBinding.virtual, KEY_VIRTUAL);
        this.mergeSavedValue(this.qualifiers, managedThreadFactoryBinding.qualifiers, "qualifier");
        this.mergeSavedValue(this.properties, managedThreadFactoryBinding.properties, "properties");
    }

    void resolve() throws InjectionException {
        HashMap<String, String> props = new HashMap<String, String>();
        if (this.properties != null) {
            props.putAll(this.properties);
        }
        ManagedThreadFactoryDefinitionBinding.addOrRemoveProperty(props, (Object)KEY_CONTEXT, (Object)this.contextServiceJndiName);
        ManagedThreadFactoryDefinitionBinding.addOrRemoveProperty(props, (Object)KEY_DESCRIPTION, (Object)this.description);
        ManagedThreadFactoryDefinitionBinding.addOrRemoveProperty(props, (Object)KEY_PRIORITY, (Object)this.priority);
        ManagedThreadFactoryDefinitionBinding.addOrRemoveProperty(props, (Object)KEY_VIRTUAL, (Object)this.virtual);
        ManagedThreadFactoryDefinitionBinding.addOrRemoveProperty(props, (Object)KEY_QUALIFIERS, (Object)this.qualifiers);
        this.setObjects(null, this.createDefinitionReference(null, ManagedThreadFactory.class.getName(), props));
    }

    @Trivial
    static final String toString(ManagedThreadFactoryDefinition anno, int eeVersion) {
        StringBuilder b = new StringBuilder();
        b.append("ManagedThreadFactoryDefinition@").append(Integer.toHexString(anno.hashCode())).append("#EE").append(eeVersion).append("(name=").append(anno.name()).append(", context=").append(anno.context()).append(", priority=").append(anno.priority());
        if (eeVersion >= 11) {
            b.append(", virtual=").append(anno.virtual());
            b.append(", qualifiers=").append(Arrays.toString(anno.qualifiers()));
        }
        b.append(")");
        return b.toString();
    }

    @Trivial
    private static final <T> String toString(T[] list) {
        if (list == null || list.length == 0) {
            return "Unspecified";
        }
        boolean none = true;
        for (int i = 0; none && i < list.length; none &= list[i] == null || list[i].toString().isEmpty(), ++i) {
        }
        return none ? "None" : Arrays.toString(list);
    }

    @Trivial
    private static final String[] toQualifierStringArray(Class<?>[] classList) {
        String[] qualifierNames = new String[classList.length];
        for (int i = 0; i < classList.length; ++i) {
            qualifierNames[i] = classList[i].getCanonicalName();
        }
        return qualifierNames;
    }
}

