/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.CacheOnDisk;
import com.ibm.ws.cache.HTODDynacache;
import com.ibm.ws.cache.Result;
import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class GarbageCollectorThread
implements Runnable {
    private static TraceComponent tc = Tr.register(GarbageCollectorThread.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    CacheOnDisk cod;
    HTODDynacache htod;
    int GCType;
    Future<?> currentThread;
    boolean processGC;
    final Object gcMonitor = new Object(){};
    long totalDeleted;
    long totalDeletedSize;

    public GarbageCollectorThread(CacheOnDisk cod) {
        this.cod = cod;
        this.htod = cod.htod;
        this.processGC = false;
        this.totalDeleted = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"run", (Object[])new Object[0]);
        }
        String methodName = "GarbageCollectorThread.run()";
        while (true) {
            Object object = this.gcMonitor;
            synchronized (object) {
                if (!this.processGC) {
                    this.currentThread = null;
                    break;
                }
                this.processGC = false;
            }
            if (this.cod.evictionPolicy == 0) continue;
            ArrayList evictionList = null;
            if (this.GCType == 1) {
                int deleteEntries = this.cod.getCacheIdsSize(true) - this.cod.htod.invalidationBuffer.size(3) - this.cod.diskCacheSizeInfo.diskCacheSizeLowLimit;
                evictionList = this.htod.walkEvictionTable(this.cod.evictionPolicy, deleteEntries, 0L);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("GarbageCollectorThread.run() cacheName=" + this.cod.cacheName + " size exceeding high threshold limit of " + this.cod.diskCacheSizeInfo.highThreshold + "%. Disk cache garbage collector evicting " + evictionList.size() + " entries;  Request entries=" + deleteEntries), (Object[])new Object[0]);
                } else {
                    this.traceDebug("GarbageCollectorThread.run()", "cacheName=" + this.cod.cacheName + " size exceeding high threshold limit of " + this.cod.diskCacheSizeInfo.highThreshold + "%. Disk cache garbage collector evicting " + evictionList.size() + " entries;  Request entries=" + deleteEntries);
                }
            } else if (this.GCType == 2) {
                int size;
                long deleteSize = this.cod.getCacheSizeInBytes() - this.cod.diskCacheSizeInfo.getDiskCacheSizeInBytesLowLimit();
                evictionList = this.htod.walkEvictionTable(this.cod.evictionPolicy, 0, deleteSize);
                int n = size = evictionList != null ? evictionList.size() : 0;
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("GarbageCollectorThread.run() cacheName=" + this.cod.cacheName + " size in GB exceeding high threshold limit of " + this.cod.diskCacheSizeInfo.highThreshold + "%. Disk cache garbage collector evicting " + size + " entries;  Request size=" + deleteSize + " bytes"), (Object[])new Object[0]);
                } else {
                    this.traceDebug("GarbageCollectorThread.run()", "cacheName=" + this.cod.cacheName + " size in GB exceeding high threshold limit of " + this.cod.diskCacheSizeInfo.highThreshold + "%. Disk cache garbage collector evicting " + size + " entries;  Request size=" + deleteSize + " bytes");
                }
            }
            if (evictionList != null && evictionList.size() > 0) {
                this.htod.invalidationBuffer.add(evictionList, 3);
            }
            long t = System.nanoTime();
            Result res = this.htod.deleteEntriesFromInvalidationBuffer(false);
            long currentDeleteTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t);
            this.totalDeleted += res.numExplicitDeleted + res.numScanDeleted + res.numGCDeleted;
            this.totalDeletedSize += res.deletedSize;
            StringBuffer dcmsg = new StringBuffer();
            dcmsg.append("  ReturnCode=");
            dcmsg.append(res.returnCode);
            dcmsg.append("  DeleteTime=");
            dcmsg.append(currentDeleteTime);
            dcmsg.append("  ExplicitEntriesDeleted=");
            dcmsg.append(res.numExplicitDeleted);
            dcmsg.append("  ScanEntriesDeleted=");
            dcmsg.append(res.numScanDeleted);
            dcmsg.append("  GCEntriesDeleted=");
            dcmsg.append(res.numGCDeleted);
            dcmsg.append("  DeletedSize=");
            dcmsg.append(res.deletedSize);
            dcmsg.append("  totalDeleted=");
            dcmsg.append(this.totalDeleted);
            dcmsg.append("  totalDeletedSize=");
            dcmsg.append(this.totalDeletedSize);
            this.htod.returnToResultPool(res);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("GarbageCollectorThread.run() The garbage collector finished for cache name \"" + this.cod.cacheName + "\". The statistics are: " + dcmsg.toString()), (Object[])new Object[0]);
                continue;
            }
            this.traceDebug("GarbageCollectorThread.run()", "The garbage collector finished for cache name \"" + this.cod.cacheName + "\". The statistics are: " + dcmsg.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"run");
        }
    }

    private void traceDebug(String methodName, String message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " " + message), (Object[])new Object[0]);
        }
    }
}

