/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ssl.Constants;
import com.ibm.websphere.ssl.SSLException;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;

public class ProtocolHelper {
    private static final TraceComponent tc = Tr.register(ProtocolHelper.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    private static final List<String> goodProtocols = new ArrayList<String>();
    private static final List<String> disabledList = new ArrayList<String>();
    private static boolean builtDisabledList = false;

    public void checkProtocolValueGood(String sslProtocol) throws SSLException, UnsupportedOperationException {
        String[] protocols;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkProtocolValueGood", (Object[])new Object[]{sslProtocol});
        }
        if ((protocols = sslProtocol.split(",")).length > 1) {
            for (String protocol : protocols) {
                if (Constants.MULTI_PROTOCOL_LIST.contains(protocol)) {
                    if (goodProtocols.contains(protocol)) continue;
                    this.checkProtocol(protocol);
                    goodProtocols.add(protocol);
                    continue;
                }
                Tr.error((TraceComponent)tc, (String)"ssl.protocol.error.CWPKI0832E", (Object[])new Object[]{protocol});
                throw new SSLException("Protocol provided is not appropriate for a protocol list.");
            }
        } else if (!goodProtocols.contains(protocols[0])) {
            this.checkProtocol(protocols[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkProtocolValueGood");
        }
    }

    private void checkProtocol(String protocol) throws SSLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkProtocol", (Object[])new Object[]{protocol});
        }
        try {
            SSLContext.getInstance(protocol);
        }
        catch (Throwable t) {
            String tMsg = t.getMessage();
            Tr.error((TraceComponent)tc, (String)"ssl.protocol.error.CWPKI0831E", (Object[])new Object[]{protocol, tMsg});
            throw new SSLException("Error checking checking for valid protocol: " + tMsg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkProtocol", (Object)protocol);
        }
    }

    private boolean isProtocolDisabled(String protocol) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isProtocolDisabled", (Object[])new Object[]{protocol});
        }
        boolean isDisabled = false;
        if (!builtDisabledList) {
            String[] algorithms;
            String disabled = Security.getProperty("jdk.tls.disabledAlgorithms");
            for (String algorithm : algorithms = disabled.split(",")) {
                if (!Constants.MULTI_PROTOCOL_LIST.contains(algorithm.trim())) continue;
                disabledList.add(algorithm.trim());
            }
            builtDisabledList = true;
        }
        if (!disabledList.isEmpty() && disabledList.contains(protocol)) {
            isDisabled = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isProtocolDisabled", (Object)protocol);
        }
        return isDisabled;
    }

    public String[] getSSLProtocol(String protocol) {
        String[] protocols;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSSLProtocol", (Object[])new Object[0]);
        }
        if ((protocols = protocol.split(",")).length == 1 && (protocols[0].equals("TLS") || protocols[0].equals("SSL"))) {
            protocols = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSSLProtocol " + protocols));
        }
        return protocols;
    }
}

