/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEProvider;
import com.ibm.ws.ssl.provider.IBMJSSEProvider;
import com.ibm.ws.ssl.provider.SunJSSEProvider;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.Hashtable;
import javax.net.ssl.SSLContext;

public class JSSEProviderFactory {
    protected static final TraceComponent tc = Tr.register(JSSEProviderFactory.class, (String)"SSL", (String)"com.ibm.ws.ssl.resources.ssl");
    private static JSSEProvider defaultProvider = null;
    private static final Hashtable<String, JSSEProvider> providerCache = new Hashtable();
    private static String trustManagerFactoryAlgorithm = null;
    private static String keyManagerFactoryAlgorithm = null;
    private static String defaultSSLSocketFactory = null;
    private static String defaultSSLServerSocketFactory = null;
    private static boolean fipsInitialized = false;
    private static String providerFromProviderList = null;

    public static JSSEProvider getInstance() {
        return JSSEProviderFactory.getInstance(null);
    }

    public static synchronized JSSEProvider getInstance(String inputProvider) {
        JSSEProvider cachedProvider;
        String contextProvider;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getInstance: " + inputProvider), (Object[])new Object[0]);
        }
        if ((contextProvider = inputProvider) == null) {
            if (null != defaultProvider) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("getInstance: " + defaultProvider));
                }
                return defaultProvider;
            }
            contextProvider = JSSEProviderFactory.getProviderFromProviderList();
        }
        if (contextProvider == null) {
            contextProvider = "IBMJSSE2";
        }
        if ((cachedProvider = providerCache.get(contextProvider)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getInstance(cached) " + cachedProvider));
            }
            return cachedProvider;
        }
        final String contextProviderPriv = contextProvider;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                block4: {
                    Provider provider = Security.getProvider(contextProviderPriv);
                    if (provider == null) {
                        try {
                            provider = contextProviderPriv.equalsIgnoreCase("IBMJSSE") ? (Provider)Class.forName("com.ibm.jsse2.IBMJSSEProvider2").newInstance() : (contextProviderPriv.equalsIgnoreCase("SunJSSE") ? (Provider)Class.forName("com.sun.net.ssl.internal.ssl.Provider").newInstance() : (Provider)Class.forName("com.ibm.jsse2.IBMJSSEProvider2").newInstance());
                            if (provider != null) {
                                Security.addProvider(provider);
                            }
                        }
                        catch (Exception e) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                            Tr.debug((TraceComponent)tc, (String)("Exception loading provider: " + contextProviderPriv + "; " + e), (Object[])new Object[0]);
                        }
                    }
                }
                return null;
            }
        });
        Provider[] providerList = Security.getProviders();
        for (int i = 0; i < providerList.length && null == cachedProvider; ++i) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Provider name [" + i + "]: " + providerList[i].getName()), (Object[])new Object[0]);
            }
            if (!providerList[i].getName().equalsIgnoreCase(contextProvider)) continue;
            if (contextProvider.equalsIgnoreCase("IBMJSSE2")) {
                cachedProvider = new IBMJSSEProvider();
                providerCache.put("IBMJSSE2", cachedProvider);
                providerCache.put(contextProvider, cachedProvider);
                continue;
            }
            if (contextProvider.equalsIgnoreCase("IBMJSSE")) {
                cachedProvider = new IBMJSSEProvider();
                providerCache.put("IBMJSSE", cachedProvider);
                providerCache.put(contextProvider, cachedProvider);
                continue;
            }
            if (contextProvider.equalsIgnoreCase("SunJSSE")) {
                cachedProvider = new SunJSSEProvider();
                providerCache.put("SunJSSE", cachedProvider);
                providerCache.put(contextProvider, cachedProvider);
                continue;
            }
            cachedProvider = new IBMJSSEProvider();
            providerCache.put("IBMJSSE", cachedProvider);
            providerCache.put(contextProvider, cachedProvider);
        }
        if (cachedProvider == null) {
            cachedProvider = new IBMJSSEProvider();
            providerCache.put("IBMJSSE", cachedProvider);
            providerCache.put(contextProvider, cachedProvider);
        }
        if (null == inputProvider) {
            defaultProvider = cachedProvider;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInstance: " + cachedProvider));
        }
        return cachedProvider;
    }

    private static boolean validateProvider(final String provider) {
        boolean success = true;
        try {
            try {
                String protocol = "SSL";
                AccessController.doPrivileged(new PrivilegedExceptionAction<SSLContext>(){

                    @Override
                    public SSLContext run() throws NoSuchAlgorithmException, NoSuchProviderException {
                        return SSLContext.getInstance("SSL", provider);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception ex = e.getException();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Error validating provider: " + provider + ", Exception: " + ex.getMessage()), (Object[])new Object[]{ex});
                }
                success = false;
            }
        }
        catch (Throwable e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error validating provider: " + provider + ", Exception: " + e.getMessage()), (Object[])new Object[]{e});
            }
            success = false;
        }
        return success;
    }

    public static String getDefaultSSLSocketFactory() {
        if (defaultSSLSocketFactory == null) {
            defaultSSLSocketFactory = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return Security.getProperty("ssl.SocketFactory.provider");
                }
            });
        }
        return defaultSSLSocketFactory;
    }

    public static String getDefaultSSLServerSocketFactory() {
        if (defaultSSLServerSocketFactory == null) {
            defaultSSLServerSocketFactory = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return Security.getProperty("ssl.ServerSocketFactory.provider");
                }
            });
        }
        return defaultSSLServerSocketFactory;
    }

    public static String getKeyManagerFactoryAlgorithm() {
        if (keyManagerFactoryAlgorithm == null) {
            keyManagerFactoryAlgorithm = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return Security.getProperty("ssl.KeyManagerFactory.algorithm");
                }
            });
        }
        return keyManagerFactoryAlgorithm;
    }

    public static String getTrustManagerFactoryAlgorithm() {
        if (trustManagerFactoryAlgorithm == null) {
            trustManagerFactoryAlgorithm = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return Security.getProperty("ssl.TrustManagerFactory.algorithm");
                }
            });
        }
        return trustManagerFactoryAlgorithm;
    }

    public static void initializeIBMCMSProvider() throws Exception {
        Provider provider;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeIBMCMSProvider", (Object[])new Object[0]);
        }
        if ((provider = Security.getProvider("IBMCMSProvider")) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initializeIBMCMSProvider (already present)");
            }
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                block3: {
                    try {
                        Provider cmsprovider = (Provider)Class.forName("com.ibm.security.cmskeystore.CMSProvider").newInstance();
                        if (cmsprovider != null) {
                            Security.addProvider(cmsprovider);
                        }
                    }
                    catch (Exception e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                        Tr.debug((TraceComponent)tc, (String)"Exception loading provider: com.ibm.security.cmskeystore.CMSProvider", (Object[])new Object[0]);
                    }
                }
                return null;
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeIBMCMSProvider (provider initialized)");
        }
    }

    public static void initializeFips() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializeFips", (Object[])new Object[0]);
        }
        if (!fipsInitialized) {
            int ibmjcefips_position = 0;
            int ibmjceplusfips_position = 0;
            Provider[] provider_list = null;
            Provider ibmjcefips = null;
            Provider ibmjceplusfips = null;
            Provider sun = null;
            try {
                block29: {
                    System.setProperty("com.ibm.jsse2.JSSEFIPS", "true");
                    provider_list = Security.getProviders();
                    for (int i = 0; i < provider_list.length; ++i) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Provider[" + i + "]: " + provider_list[i].getName()), (Object[])new Object[0]);
                        }
                        if (provider_list[i].getName().equals("IBMJCEPlusFIPS")) {
                            ibmjceplusfips_position = i;
                            ibmjceplusfips = provider_list[i];
                            continue;
                        }
                        if (provider_list[i].getName().equals("IBMJCEFIPS")) {
                            ibmjcefips_position = i;
                            ibmjcefips = provider_list[i];
                            continue;
                        }
                        if (!provider_list[i].getName().equals("SUN")) continue;
                        sun = provider_list[i];
                    }
                    if (ibmjceplusfips == null) {
                        provider_list = Security.getProviders();
                        try {
                            ibmjceplusfips = (Provider)Class.forName("com.ibm.crypto.fips.provider.IBMJCEPlusFIPS").newInstance();
                            if (sun != null) {
                                JSSEProviderFactory.insertProviderAt(sun, 1);
                                JSSEProviderFactory.insertProviderAt(ibmjceplusfips, 2);
                                break block29;
                            }
                            JSSEProviderFactory.insertProviderAt(ibmjceplusfips, 1);
                        }
                        catch (Exception e) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Exception loading provider: com.ibm.crypto.fips.provider.IBMJCEFIPS; " + e), (Object[])new Object[0]);
                            }
                            break block29;
                        }
                    }
                    if (ibmjceplusfips_position != 0) {
                        provider_list = Security.getProviders();
                        if (sun != null) {
                            JSSEProviderFactory.insertProviderAt(sun, 1);
                            JSSEProviderFactory.insertProviderAt(ibmjceplusfips, 2);
                        } else {
                            JSSEProviderFactory.insertProviderAt(ibmjceplusfips, 1);
                        }
                    } else {
                        if (ibmjcefips == null) {
                            provider_list = Security.getProviders();
                            try {
                                ibmjcefips = (Provider)Class.forName("com.ibm.crypto.fips.provider.IBMJCEFIPS").newInstance();
                                if (sun != null) {
                                    JSSEProviderFactory.insertProviderAt(sun, 1);
                                    JSSEProviderFactory.insertProviderAt(ibmjcefips, 2);
                                    break block29;
                                }
                                JSSEProviderFactory.insertProviderAt(ibmjcefips, 1);
                            }
                            catch (Exception e) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Exception loading provider: com.ibm.crypto.fips.provider.IBMJCEFIPS; " + e), (Object[])new Object[0]);
                                }
                                break block29;
                            }
                        }
                        if (ibmjcefips_position != 0) {
                            provider_list = Security.getProviders();
                            if (sun != null) {
                                JSSEProviderFactory.insertProviderAt(sun, 1);
                                JSSEProviderFactory.insertProviderAt(ibmjcefips, 2);
                            } else {
                                JSSEProviderFactory.insertProviderAt(ibmjcefips, 1);
                            }
                        }
                    }
                }
                provider_list = Security.getProviders();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    for (int i = 0; i < provider_list.length; ++i) {
                        Tr.debug((TraceComponent)tc, (String)("Provider[" + i + "]: " + provider_list[i].getName() + ", info: " + provider_list[i].getInfo()), (Object[])new Object[0]);
                    }
                }
                fipsInitialized = true;
            }
            catch (Exception e) {
                Tr.error((TraceComponent)tc, (String)"security.addprovider.error", (Object[])new Object[]{e});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception caught adding IBMJCEFIPS provider.", (Object[])new Object[]{e});
                }
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializeFips");
        }
    }

    public static void insertProviderAt(Provider newProvider, int slot) {
        Provider currentProvider;
        int i;
        Provider[] provider_list = Security.getProviders();
        if (null == provider_list || 0 == provider_list.length) {
            return;
        }
        Provider[] newList = new Provider[provider_list.length + 2];
        newList[slot] = newProvider;
        int newListIndex = 1;
        for (i = 0; i < provider_list.length; ++i) {
            currentProvider = provider_list[i];
            if (currentProvider == null || currentProvider.getName().equals(newProvider.getName())) continue;
            while (newList[newListIndex] != null) {
                ++newListIndex;
            }
            newList[newListIndex] = currentProvider;
            ++newListIndex;
        }
        JSSEProviderFactory.removeAllProviders();
        for (i = 0; i < newList.length; ++i) {
            currentProvider = newList[i];
            if (currentProvider == null) continue;
            int position = Security.insertProviderAt(currentProvider, i + 1);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)(currentProvider.getName() + " provider added at position " + position), (Object[])new Object[0]);
        }
    }

    public static void removeAllProviders() {
        Provider[] provider_list = Security.getProviders();
        for (int i = 0; i < provider_list.length; ++i) {
            String name;
            if (provider_list[i] == null || (name = provider_list[i].getName()) == null) continue;
            Security.removeProvider(name);
        }
    }

    private static String getProviderFromProviderList() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getProviderFromProviderList", (Object[])new Object[0]);
        }
        Provider[] providerList = Security.getProviders();
        for (int i = 0; i < providerList.length; ++i) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Provider name [" + i + "]: " + providerList[i].getName()), (Object[])new Object[0]);
            }
            if (providerList[i].getName().equalsIgnoreCase("IBMJCEPlusFIPS")) {
                providerFromProviderList = "IBMJCEPlusFIPS";
                break;
            }
            if (providerList[i].getName().equalsIgnoreCase("IBMJSSE2")) {
                providerFromProviderList = "IBMJSSE2";
                break;
            }
            if (providerList[i].getName().equalsIgnoreCase("IBMJSSE")) {
                providerFromProviderList = "IBMJSSE";
                break;
            }
            if (!providerList[i].getName().equalsIgnoreCase("SunJSSE")) continue;
            providerFromProviderList = "SunJSSE";
            break;
        }
        if (providerFromProviderList == null) {
            providerFromProviderList = "IBMJSSE2";
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getProviderFromProviderList -> " + providerFromProviderList));
        }
        return providerFromProviderList;
    }
}

