/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jboss.resteasy.core.ExceptionAdapter;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public final class TypeConverter {
    private static final String VALUE_OF_METHOD = "valueOf";
    private static final boolean java2SecurityEnabled;
    private static final Map<Class<?>, Class<?>> PRIMITIVES;
    static final long serialVersionUID = 7331538885450602187L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private TypeConverter() {
    }

    public static <T> T getType(Class<T> targetType, String source) {
        T result;
        if (String.class.equals(targetType)) {
            return targetType.cast(source);
        }
        if (Date.class.isAssignableFrom(targetType)) {
            throw new IllegalArgumentException(Messages.MESSAGES.dateInstancesNotSupported());
        }
        if (Character.class.equals(targetType)) {
            if (source.length() == 0) {
                return targetType.cast(Character.valueOf('\u0000'));
            }
            return targetType.cast(Character.valueOf(source.charAt(0)));
        }
        if (Character.TYPE.equals(targetType)) {
            Character c = null;
            c = source.length() == 0 ? Character.valueOf('\u0000') : Character.valueOf(source.charAt(0));
            try {
                return (T)Character.class.getMethod("charValue", new Class[0]).invoke((Object)c, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        if (Boolean.class.equals(targetType) || Boolean.TYPE.equals(targetType)) {
            Boolean booleanValue = TypeConverter.getBooleanValue(source);
            if (Boolean.class.equals(targetType)) {
                return targetType.cast(booleanValue);
            }
            try {
                return (T)Boolean.class.getMethod("booleanValue", new Class[0]).invoke((Object)booleanValue, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            result = TypeConverter.getTypeViaValueOfMethod(source, targetType);
        }
        catch (NoSuchMethodException e) {
            LogMessages.LOGGER.noValueOfMethodAvailable(targetType.getSimpleName());
            result = TypeConverter.getTypeViaStringConstructor(source, targetType);
        }
        return result;
    }

    public static boolean isConvertable(Class<?> targetType) {
        if (Boolean.class.equals(targetType)) {
            return true;
        }
        if (Character.class.equals(targetType)) {
            return true;
        }
        if (targetType.isPrimitive()) {
            return true;
        }
        try {
            TypeConverter.getDeclaredMethod(targetType, VALUE_OF_METHOD, String.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            try {
                TypeConverter.getDeclaredConstructor(targetType, String.class);
                return true;
            }
            catch (NoSuchMethodException e1) {
                return false;
            }
        }
    }

    public static Boolean getBooleanValue(String source) {
        if ("Y".equalsIgnoreCase(source) || "T".equalsIgnoreCase(source) || "Yes".equalsIgnoreCase(source) || "1".equalsIgnoreCase(source)) {
            return Boolean.TRUE;
        }
        if ("N".equals(source) || "F".equals(source) || "No".equals(source) || "0".equalsIgnoreCase(source)) {
            return Boolean.FALSE;
        }
        return Boolean.valueOf(source);
    }

    public static <T> T getTypeViaValueOfMethod(String source, Class<T> targetType) throws NoSuchMethodException {
        Class<Object> actualTarget = targetType;
        if (targetType.isPrimitive()) {
            actualTarget = PRIMITIVES.get(targetType);
        }
        Object result = null;
        try {
            Method valueOf = TypeConverter.getDeclaredMethod(actualTarget, VALUE_OF_METHOD, String.class);
            Object value = valueOf.invoke(null, source);
            if (actualTarget.equals(targetType) && targetType.isInstance(value)) {
                result = targetType.cast(value);
            } else if (!actualTarget.equals(targetType) && actualTarget.isInstance(value)) {
                result = value;
            }
        }
        catch (IllegalAccessException e) {
            throw new ExceptionAdapter(e);
        }
        catch (InvocationTargetException e) {
            throw new ExceptionAdapter(e);
        }
        return (T)result;
    }

    private static <T> T getTypeViaStringConstructor(String source, Class<T> targetType) {
        T result = null;
        Constructor<T> c = null;
        try {
            c = TypeConverter.getDeclaredConstructor(targetType, String.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(Messages.MESSAGES.hasNoStringConstructor(targetType.getName()), e);
        }
        try {
            result = c.newInstance(source);
        }
        catch (InstantiationException e) {
            throw new ExceptionAdapter(e);
        }
        catch (IllegalAccessException e) {
            throw new ExceptionAdapter(e);
        }
        catch (InvocationTargetException e) {
            throw new ExceptionAdapter(e);
        }
        return result;
    }

    private static Method getDeclaredMethod(Class<?> type, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        if (java2SecurityEnabled) {
            try {
                return AccessController.doPrivileged(() -> type.getDeclaredMethod(name, parameterTypes));
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof NoSuchMethodException) {
                    throw (NoSuchMethodException)cause;
                }
                throw new RuntimeException(cause);
            }
        }
        return type.getDeclaredMethod(name, parameterTypes);
    }

    private static <T> Constructor<T> getDeclaredConstructor(Class<T> type, Class<?> ... parameterTypes) throws NoSuchMethodException {
        if (java2SecurityEnabled) {
            try {
                return AccessController.doPrivileged(() -> type.getDeclaredConstructor(parameterTypes));
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof NoSuchMethodException) {
                    throw (NoSuchMethodException)cause;
                }
                throw new RuntimeException(cause);
            }
        }
        return type.getDeclaredConstructor(parameterTypes);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.util.TypeConverter", TypeConverter.class, null, null);
        java2SecurityEnabled = System.getSecurityManager() != null;
        PRIMITIVES = new HashMap();
        PRIMITIVES.put(Integer.TYPE, Integer.class);
        PRIMITIVES.put(Double.TYPE, Double.class);
        PRIMITIVES.put(Float.TYPE, Float.class);
        PRIMITIVES.put(Short.TYPE, Short.class);
        PRIMITIVES.put(Byte.TYPE, Byte.class);
        PRIMITIVES.put(Long.TYPE, Long.class);
    }
}

