/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.core.UriInfo;
import java.util.regex.Pattern;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class StringContextReplacement {
    private static final Pattern basepath;
    private static final Pattern absolutepath;
    private static final Pattern absoluteUri;
    private static final Pattern baseUri;
    private static final Pattern contextPath;
    static final long serialVersionUID = 5944235702750040491L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static String replace(String original) {
        UriInfo uriInfo = ResteasyContext.getContextData(UriInfo.class);
        if (uriInfo != null) {
            String base = uriInfo.getBaseUri().getRawPath();
            String abs = uriInfo.getAbsolutePath().getRawPath();
            String absU = uriInfo.getAbsolutePath().toString();
            String baseU = uriInfo.getBaseUri().toString();
            original = basepath.matcher(original).replaceAll(base);
            original = absolutepath.matcher(original).replaceAll(abs);
            original = absoluteUri.matcher(original).replaceAll(absU);
            original = baseUri.matcher(original).replaceAll(baseU);
            if (uriInfo instanceof ResteasyUriInfo) {
                original = contextPath.matcher(original).replaceAll(((ResteasyUriInfo)uriInfo).getContextPath());
            }
        }
        return original;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.util.StringContextReplacement", StringContextReplacement.class, null, null);
        basepath = Pattern.compile("\\$\\{basepath\\}");
        absolutepath = Pattern.compile("\\$\\{absolutepath\\}");
        absoluteUri = Pattern.compile("\\$\\{absoluteuri\\}");
        baseUri = Pattern.compile("\\$\\{baseuri\\}");
        contextPath = Pattern.compile("\\$\\{contextpath\\}");
    }
}

