/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.jboss.resteasy.spi.config.ConfigurationFactory;
import org.jboss.resteasy.spi.config.SizeUnit;
import org.jboss.resteasy.spi.config.Threshold;
import org.jboss.resteasy.spi.util.Functions;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class Options<T> {
    public static final Options<Boolean> ENABLE_DEFAULT_EXCEPTION_MAPPER;
    public static final Options<Threshold> ENTITY_MEMORY_THRESHOLD;
    public static final Options<Threshold> ENTITY_FILE_THRESHOLD;
    private final String key;
    private final Class<T> name;
    private final Supplier<T> dftValue;
    static final long serialVersionUID = -135904656550411975L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected Options(String key, Class<T> name, Supplier<T> dftValue) {
        this.key = key;
        this.name = name;
        this.dftValue = dftValue;
    }

    public T getValue() {
        return Options.getProperty(this.key, this.name, this.dftValue);
    }

    public String name() {
        return this.key;
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Options)) {
            return false;
        }
        Options other = (Options)obj;
        return Objects.equals(this.key, other.key);
    }

    public String toString() {
        return "Option[name=" + this.key + ", type=" + this.name.getName() + "]";
    }

    protected static <T> T getProperty(String name, Class<T> returnType, Supplier<T> dft) {
        return Options.getProperty(name, returnType).orElseGet(dft);
    }

    private static <T> Optional<T> getProperty(String name, Class<T> returnType) {
        return ConfigurationFactory.getInstance().getConfiguration().getOptionalValue(name, returnType);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.spi.config.Options", Options.class, null, null);
        ENABLE_DEFAULT_EXCEPTION_MAPPER = new Options<Boolean>("dev.resteasy.exception.mapper", Boolean.class, Functions.singleton(() -> true));
        ENTITY_MEMORY_THRESHOLD = new Options<Threshold>("dev.resteasy.entity.memory.threshold", Threshold.class, Functions.singleton(() -> Threshold.of(5L, SizeUnit.MEGABYTE)));
        ENTITY_FILE_THRESHOLD = new Options<Threshold>("dev.resteasy.entity.file.threshold", Threshold.class, Functions.singleton(() -> Threshold.of(50L, SizeUnit.MEGABYTE)));
    }
}

