/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInputImpl;
import org.jboss.resteasy.plugins.providers.multipart.i18n.Messages;
import org.jboss.resteasy.spi.util.Types;

@Provider
@Consumes(value={"multipart/form-data"})
public class MultipartEntityPartReader
implements MessageBodyReader<List<EntityPart>> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return List.class.isAssignableFrom(type) && genericType instanceof ParameterizedType && Types.isGenericTypeInstanceOf(EntityPart.class, genericType);
    }

    public List<EntityPart> readFrom(Class<List<EntityPart>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String boundary = (String)mediaType.getParameters().get("boundary");
        if (boundary == null) {
            throw new IOException(Messages.MESSAGES.unableToGetBoundary());
        }
        Providers providers = ResteasyContext.getRequiredContextData(Providers.class);
        MultipartFormDataInputImpl input = new MultipartFormDataInputImpl(mediaType, providers);
        input.parse(entityStream);
        return input.toEntityParts();
    }
}

