/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.request;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Variant;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jboss.resteasy.core.request.AcceptHeaders;
import org.jboss.resteasy.core.request.QualityValue;
import org.jboss.resteasy.core.request.VariantQuality;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ServerDrivenNegotiation {
    private Map<MediaType, QualityValue> requestedMediaTypes = null;
    private Map<String, QualityValue> requestedCharacterSets = null;
    private Map<String, QualityValue> requestedEncodings = null;
    private Map<Locale, QualityValue> requestedLanguages = null;
    private int mediaRadix = 1;
    static final long serialVersionUID = 3161726968405334150L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void setAcceptHeaders(List<String> headerValues) {
        this.requestedMediaTypes = null;
        if (headerValues == null) {
            return;
        }
        Map<MediaType, QualityValue> requested = null;
        for (String headerValue : headerValues) {
            Map<MediaType, QualityValue> mapping = AcceptHeaders.getMediaTypeQualityValues(headerValue);
            if (mapping == null) {
                return;
            }
            if (requested == null) {
                requested = mapping;
                continue;
            }
            requested.putAll(mapping);
        }
        this.requestedMediaTypes = requested;
        Iterator it = requested.keySet().iterator();
        while (it.hasNext()) {
            this.mediaRadix = Math.max(this.mediaRadix, ((MediaType)it.next()).getParameters().size());
        }
    }

    public void setAcceptCharsetHeaders(List<String> headerValues) {
        this.requestedCharacterSets = null;
        if (headerValues == null) {
            return;
        }
        Map<String, QualityValue> requested = null;
        for (String headerValue : headerValues) {
            Map<String, QualityValue> mapping = AcceptHeaders.getStringQualityValues(headerValue);
            if (mapping == null) {
                return;
            }
            if (requested == null) {
                requested = mapping;
                continue;
            }
            requested.putAll(mapping);
        }
        this.requestedCharacterSets = requested;
    }

    public void setAcceptEncodingHeaders(List<String> headerValues) {
        this.requestedEncodings = null;
        if (headerValues == null) {
            return;
        }
        Map<String, QualityValue> requested = null;
        for (String headerValue : headerValues) {
            Map<String, QualityValue> mapping = AcceptHeaders.getStringQualityValues(headerValue);
            if (mapping == null) {
                return;
            }
            if (requested == null) {
                requested = mapping;
                continue;
            }
            requested.putAll(mapping);
        }
        this.requestedEncodings = requested;
    }

    public void setAcceptLanguageHeaders(List<String> headerValues) {
        this.requestedLanguages = null;
        if (headerValues == null) {
            return;
        }
        Map<Locale, QualityValue> requested = null;
        for (String headerValue : headerValues) {
            Map<Locale, QualityValue> mapping = AcceptHeaders.getLocaleQualityValues(headerValue);
            if (mapping == null) {
                return;
            }
            if (requested == null) {
                requested = mapping;
                continue;
            }
            requested.putAll(mapping);
        }
        this.requestedLanguages = requested;
    }

    public Variant getBestMatch(List<Variant> available) {
        VariantQuality bestQuality = null;
        Variant bestOption = null;
        for (Variant option : available) {
            VariantQuality quality;
            if (!this.applyMediaType(option, quality = new VariantQuality()) || !this.applyCharacterSet(option, quality) || !this.applyEncoding(option, quality) || !this.applyLanguage(option, quality) || !ServerDrivenNegotiation.isBetterOption(bestQuality, bestOption, quality, option)) continue;
            bestQuality = quality;
            bestOption = option;
        }
        return bestOption;
    }

    private static boolean isBetterOption(VariantQuality bestQuality, Variant best, VariantQuality optionQuality, Variant option) {
        if (best == null) {
            return true;
        }
        int signum = bestQuality.getOverallQuality().compareTo(optionQuality.getOverallQuality());
        if (signum != 0) {
            return signum < 0;
        }
        MediaType bestRequestMediaType = bestQuality.getRequestMediaType();
        MediaType optionRequestMediaType = optionQuality.getRequestMediaType();
        if (bestRequestMediaType != null && optionRequestMediaType != null) {
            if (bestRequestMediaType.getType().equals(optionRequestMediaType.getType())) {
                if (bestRequestMediaType.getSubtype().equals(optionRequestMediaType.getSubtype())) {
                    int bestCount = bestRequestMediaType.getParameters().size();
                    int optionCount = optionRequestMediaType.getParameters().size();
                    if (optionCount > bestCount) {
                        return true;
                    }
                    if (optionCount < bestCount) {
                        return false;
                    }
                } else {
                    if (bestRequestMediaType.getSubtype().equals("*")) {
                        return true;
                    }
                    if (optionRequestMediaType.getSubtype().equals("*")) {
                        return false;
                    }
                }
            } else {
                if (bestRequestMediaType.getType().equals("*")) {
                    return true;
                }
                if (optionRequestMediaType.getType().equals("*")) {
                    return false;
                }
            }
        }
        MediaType bestType = best.getMediaType();
        MediaType optionType = option.getMediaType();
        if (bestType != null && optionType != null) {
            if (bestType.getType().equals(optionType.getType())) {
                if (bestType.getSubtype().equals(optionType.getSubtype())) {
                    int bestCount = bestType.getParameters().size();
                    int optionCount = optionType.getParameters().size();
                    if (optionCount > bestCount) {
                        return true;
                    }
                    if (optionCount < bestCount) {
                        return false;
                    }
                } else {
                    if ("*".equals(bestType.getSubtype())) {
                        return true;
                    }
                    if ("*".equals(optionType.getSubtype())) {
                        return false;
                    }
                }
            } else {
                if ("*".equals(bestType.getType())) {
                    return true;
                }
                if ("*".equals(optionType.getType())) {
                    return false;
                }
            }
        }
        return ServerDrivenNegotiation.getExplicitness(best) < ServerDrivenNegotiation.getExplicitness(option);
    }

    private static int getExplicitness(Variant variant) {
        int explicitness = 0;
        if (variant.getMediaType() != null) {
            ++explicitness;
        }
        if (variant.getEncoding() != null) {
            ++explicitness;
        }
        if (variant.getLanguage() != null) {
            ++explicitness;
        }
        return explicitness;
    }

    private boolean applyMediaType(Variant option, VariantQuality quality) {
        Map parameters;
        String subtype;
        if (this.requestedMediaTypes == null) {
            return true;
        }
        MediaType mediaType = option.getMediaType();
        if (mediaType == null) {
            return true;
        }
        String type = mediaType.getType();
        if ("*".equals(type)) {
            type = null;
        }
        if ("*".equals(subtype = mediaType.getSubtype())) {
            subtype = null;
        }
        if ((parameters = mediaType.getParameters()).isEmpty()) {
            parameters = null;
        }
        QualityValue bestQuality = QualityValue.NOT_ACCEPTABLE;
        int bestMatchCount = -1;
        MediaType bestRequestMediaType = null;
        for (MediaType requested : this.requestedMediaTypes.keySet()) {
            QualityValue qualityValue;
            Map requestedParameters;
            int matchCount = 0;
            if (type != null) {
                String requestedType = requested.getType();
                if (requestedType.equals(type)) {
                    matchCount += this.mediaRadix * 100;
                } else if (!"*".equals(requestedType)) continue;
            }
            if (subtype != null) {
                String requestedSubtype = requested.getSubtype();
                if (requestedSubtype.equals(subtype)) {
                    matchCount += this.mediaRadix * 10;
                } else if (!"*".equals(requestedSubtype)) continue;
            }
            if ((requestedParameters = requested.getParameters()) != null && requestedParameters.size() > 0) {
                if (!this.hasRequiredParameters(requestedParameters, parameters)) continue;
                matchCount += requestedParameters.size();
            }
            if (matchCount > bestMatchCount) {
                bestMatchCount = matchCount;
                bestQuality = this.requestedMediaTypes.get(requested);
                bestRequestMediaType = requested;
                continue;
            }
            if (matchCount != bestMatchCount || bestQuality.compareTo(qualityValue = this.requestedMediaTypes.get(requested)) >= 0) continue;
            bestQuality = qualityValue;
            bestRequestMediaType = requested;
        }
        if (!bestQuality.isAcceptable()) {
            return false;
        }
        quality.setMediaTypeQualityValue(bestQuality);
        quality.setRequestMediaType(bestRequestMediaType);
        return true;
    }

    private boolean hasRequiredParameters(Map<String, String> required, Map<String, String> available) {
        if (available == null) {
            return false;
        }
        for (Map.Entry<String, String> requiredEntry : required.entrySet()) {
            String name = requiredEntry.getKey();
            String value = requiredEntry.getValue();
            String availableValue = available.get(name);
            if (!(availableValue == null && "charset".equals(name) ? this.requestedCharacterSets != null && !this.requestedCharacterSets.containsKey(null) && !this.requestedCharacterSets.containsKey(value) : !value.equals(availableValue))) continue;
            return false;
        }
        return true;
    }

    private boolean applyCharacterSet(Variant option, VariantQuality quality) {
        if (this.requestedCharacterSets == null) {
            return true;
        }
        MediaType mediaType = option.getMediaType();
        if (mediaType == null) {
            return true;
        }
        String charsetParameter = (String)mediaType.getParameters().get("charset");
        if (charsetParameter == null) {
            return true;
        }
        QualityValue value = this.requestedCharacterSets.get(charsetParameter);
        if (value == null) {
            value = this.requestedCharacterSets.get(null);
        }
        if (value == null) {
            return false;
        }
        if (!value.isAcceptable()) {
            return false;
        }
        quality.setCharacterSetQualityValue(value);
        return true;
    }

    private boolean applyEncoding(Variant option, VariantQuality quality) {
        if (this.requestedEncodings == null) {
            return true;
        }
        String encoding = option.getEncoding();
        if (encoding == null) {
            return true;
        }
        QualityValue value = this.requestedEncodings.get(encoding);
        if (value == null) {
            value = this.requestedEncodings.get(null);
        }
        if (value == null) {
            return false;
        }
        if (!value.isAcceptable()) {
            return false;
        }
        quality.setEncodingQualityValue(value);
        return true;
    }

    private boolean hasCountry(Locale locale) {
        return locale.getCountry() != null && !"".equals(locale.getCountry().trim());
    }

    private boolean applyLanguage(Variant option, VariantQuality quality) {
        if (this.requestedLanguages == null) {
            return true;
        }
        Locale language = option.getLanguage();
        if (language == null) {
            return true;
        }
        QualityValue value = null;
        for (Map.Entry<Locale, QualityValue> entry : this.requestedLanguages.entrySet()) {
            Locale locale = entry.getKey();
            QualityValue qualityValue = entry.getValue();
            if (locale == null || !locale.getLanguage().equalsIgnoreCase(language.getLanguage())) continue;
            if (this.hasCountry(locale) && this.hasCountry(language)) {
                if (!locale.getCountry().equalsIgnoreCase(language.getCountry())) continue;
                value = qualityValue;
                break;
            }
            if (this.hasCountry(locale) == this.hasCountry(language)) {
                value = qualityValue;
                break;
            }
            value = qualityValue;
        }
        if (value == null) {
            value = this.requestedLanguages.get(null);
        }
        if (value == null) {
            return false;
        }
        if (!value.isAcceptable()) {
            return false;
        }
        quality.setLanguageQualityValue(value);
        return true;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.request.ServerDrivenNegotiation", ServerDrivenNegotiation.class, null, null);
    }
}

