/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.registry;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.registry.MatchCache;
import org.jboss.resteasy.core.registry.MethodExpression;
import org.jboss.resteasy.core.registry.SegmentNode;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResourceInvoker;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class RootNode {
    protected SegmentNode root = new SegmentNode("");
    protected int size = 0;
    protected MultivaluedMap<String, MethodExpression> bounded = new MultivaluedHashMap();
    protected ConcurrentHashMap<MatchCache.Key, MatchCache> cache = new ConcurrentHashMap();
    private static int CACHE_SIZE;
    private static boolean CACHE;
    static final long serialVersionUID = 3160831658823562901L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public int getSize() {
        return this.size;
    }

    public MultivaluedMap<String, ResourceInvoker> getBounded() {
        MultivaluedHashMap rtn = new MultivaluedHashMap();
        for (Map.Entry entry : this.bounded.entrySet()) {
            for (MethodExpression exp : (List)entry.getValue()) {
                rtn.add((Object)((String)entry.getKey()), (Object)exp.getInvoker());
            }
        }
        return rtn;
    }

    public ResourceInvoker match(HttpRequest request, int start) {
        if (!CACHE || request.getHttpHeaders().getMediaType() != null && !request.getHttpHeaders().getMediaType().getParameters().isEmpty()) {
            return this.root.match((HttpRequest)request, (int)start).invoker;
        }
        MatchCache.Key key = new MatchCache.Key(request, start);
        MatchCache match = this.cache.get(key);
        if (match != null) {
            request.setAttribute("RESTEASY_CHOSEN_ACCEPT", match.chosen);
        } else {
            match = this.root.match(request, start);
            if (match.match != null && match.match.expression.getNumGroups() == 0 && match.invoker instanceof ResourceMethodInvoker) {
                match.match = null;
                if (this.cache.size() >= CACHE_SIZE) {
                    this.cache.clear();
                }
                this.cache.putIfAbsent(key, match);
            }
        }
        return match.invoker;
    }

    public void removeBinding(String path, Method method) {
        List expressions = (List)this.bounded.get((Object)path);
        if (expressions == null) {
            return;
        }
        for (MethodExpression expression : expressions) {
            ResourceInvoker invoker = expression.getInvoker();
            if (!invoker.getMethod().equals(method)) continue;
            expression.parent.targets.remove(expression);
            expressions.remove(expression);
            if (expressions.size() == 0) {
                this.bounded.remove((Object)path);
            }
            --this.size;
            if (invoker instanceof ResourceMethodInvoker) {
                ((ResourceMethodInvoker)invoker).cleanup();
            }
            return;
        }
    }

    public void addInvoker(String path, ResourceInvoker invoker) {
        MethodExpression expression = this.addExpression(path, invoker);
        ++this.size;
        this.bounded.add((Object)path, (Object)expression);
    }

    protected MethodExpression addExpression(String path, ResourceInvoker invoker) {
        MethodExpression exp;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ("".equals(path)) {
            if (invoker instanceof ResourceMethodInvoker) {
                MethodExpression expression = new MethodExpression(this.root, "", invoker);
                this.root.addExpression(expression);
                return expression;
            }
            MethodExpression expression = new MethodExpression(this.root, "", invoker, "(.*)");
            this.root.addExpression(expression);
            return expression;
        }
        int expidx = path.indexOf(123);
        if (expidx > -1) {
            int i = expidx;
            while (i - 1 > -1 && path.charAt(i - 1) != '/') {
                --i;
            }
            String staticPath = null;
            if (i > 0) {
                staticPath = path.substring(0, i - 1);
            }
            SegmentNode node = this.root;
            if (staticPath != null) {
                String[] split;
                for (String segment : split = staticPath.split("/")) {
                    SegmentNode tmp = node.children.get(segment);
                    if (tmp == null) {
                        tmp = new SegmentNode(segment);
                        node.children.put(segment, tmp);
                    }
                    node = tmp;
                }
            }
            exp = invoker instanceof ResourceMethodInvoker ? new MethodExpression(node, path, invoker) : new MethodExpression(node, path, invoker, "(/.+)?");
            node.addExpression(exp);
        } else {
            String[] split = path.split("/");
            SegmentNode node = this.root;
            for (String segment : split) {
                SegmentNode tmp = node.children.get(segment);
                if (tmp == null) {
                    tmp = new SegmentNode(segment);
                    node.children.put(segment, tmp);
                }
                node = tmp;
            }
            if (invoker instanceof ResourceMethodInvoker) {
                exp = new MethodExpression(node, path, invoker);
                node.addExpression(exp);
            } else {
                exp = new MethodExpression(node, path, invoker, "(.*)");
                node.addExpression(exp);
            }
        }
        return exp;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.registry.RootNode", RootNode.class, null, null);
        CACHE_SIZE = 2048;
        CACHE = true;
        if (System.getSecurityManager() == null) {
            CACHE = Boolean.parseBoolean(System.getProperty("resteasy.match.cache.enabled", "true"));
            CACHE_SIZE = Integer.getInteger("resteasy.match.cache.size", 2048);
        } else {
            CACHE = AccessController.doPrivileged(() -> Boolean.parseBoolean(System.getProperty("resteasy.match.cache.enabled", "true")));
            CACHE_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("resteasy.match.cache.size", 2048));
        }
    }
}

