/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception.jaxrs;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.annotation.Priority;
import jakarta.ws.rs.NameBinding;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Application;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.interception.JaxrsInterceptorRegistry;
import org.jboss.resteasy.spi.interception.JaxrsInterceptorRegistryListener;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class JaxrsInterceptorRegistryImpl<T>
implements JaxrsInterceptorRegistry<T> {
    protected List<JaxrsInterceptorRegistry.InterceptorFactory> interceptors = new CopyOnWriteArrayList<JaxrsInterceptorRegistry.InterceptorFactory>();
    protected List<JaxrsInterceptorRegistryListener> listeners = new CopyOnWriteArrayList<JaxrsInterceptorRegistryListener>();
    protected ResteasyProviderFactory providerFactory;
    protected Class<T> intf;
    protected volatile T[] cachedPreMatch;
    protected volatile T[] cachedPostMatch;
    static final long serialVersionUID = 3320512697119440166L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected static List<Class<? extends Annotation>> getNameBound(Class<?> declaring) {
        ArrayList<Class<? extends Annotation>> nameBound = new ArrayList<Class<? extends Annotation>>();
        for (Annotation annotation : declaring.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(NameBinding.class)) continue;
            nameBound.add(annotation.annotationType());
        }
        return nameBound;
    }

    public static int getPriority(Class<?> declaring) {
        Priority priority = declaring.getAnnotation(Priority.class);
        if (priority != null) {
            return priority.value();
        }
        return 5000;
    }

    public JaxrsInterceptorRegistryImpl(ResteasyProviderFactory providerFactory, Class<T> intf) {
        this.providerFactory = providerFactory;
        this.intf = intf;
    }

    @Override
    public JaxrsInterceptorRegistry<T> clone(ResteasyProviderFactory factory) {
        JaxrsInterceptorRegistryImpl<T> clone = new JaxrsInterceptorRegistryImpl<T>(factory, this.intf);
        clone.interceptors.addAll(this.interceptors);
        clone.cachedPreMatch = this.cachedPreMatch;
        clone.cachedPostMatch = this.cachedPostMatch;
        return clone;
    }

    @Override
    public Class<T> getIntf() {
        return this.intf;
    }

    @Override
    public List<JaxrsInterceptorRegistryListener> getListeners() {
        return this.listeners;
    }

    @Override
    public T[] preMatch() {
        T[] currentPreMatch = this.cachedPreMatch;
        if (currentPreMatch == null) {
            ArrayList<JaxrsInterceptorRegistry.Match> matches = new ArrayList<JaxrsInterceptorRegistry.Match>();
            for (JaxrsInterceptorRegistry.InterceptorFactory factory : this.interceptors) {
                JaxrsInterceptorRegistry.Match match = factory.preMatch();
                if (match == null) continue;
                matches.add(match);
            }
            this.cachedPreMatch = currentPreMatch = this.createArray(matches);
        }
        return currentPreMatch;
    }

    @Override
    public T[] postMatch(Class declaring, AccessibleObject target) {
        T[] currentPostMatch;
        if (declaring == null && target == null && (currentPostMatch = this.cachedPostMatch) != null) {
            return currentPostMatch;
        }
        ArrayList<JaxrsInterceptorRegistry.Match> matches = new ArrayList<JaxrsInterceptorRegistry.Match>();
        for (JaxrsInterceptorRegistry.InterceptorFactory factory : this.interceptors) {
            JaxrsInterceptorRegistry.Match match = factory.postMatch(declaring, target);
            if (match == null) continue;
            matches.add(match);
        }
        T[] array = this.createArray(matches);
        if (declaring == null && target == null) {
            this.cachedPostMatch = array;
        }
        return array;
    }

    private T[] createArray(List<JaxrsInterceptorRegistry.Match> matches) {
        this.sort(matches);
        Object[] array = (Object[])Array.newInstance(this.intf, matches.size());
        for (int i = 0; i < array.length; ++i) {
            array[i] = matches.get((int)i).interceptor;
        }
        return array;
    }

    protected void sort(List<JaxrsInterceptorRegistry.Match> matches) {
        Collections.sort(matches, new JaxrsInterceptorRegistry.AscendingPrecedenceComparator());
    }

    @Override
    public synchronized void register(JaxrsInterceptorRegistry.InterceptorFactory factory) {
        this.interceptors.add(factory);
        this.cachedPreMatch = null;
        this.cachedPostMatch = null;
        for (JaxrsInterceptorRegistryListener listener : this.listeners) {
            listener.registryUpdated(this, factory);
        }
    }

    @Override
    public synchronized void registerClass(Class<? extends T> declaring) {
        this.register(new OnDemandInterceptorFactory(declaring));
    }

    @Override
    public synchronized void registerClass(Class<? extends T> declaring, int priority) {
        OnDemandInterceptorFactory factory = new OnDemandInterceptorFactory(declaring);
        factory.setOrder(priority);
        this.register(factory);
    }

    @Override
    public synchronized void registerSingleton(T interceptor) {
        this.register(new SingletonInterceptorFactory(interceptor.getClass(), interceptor));
    }

    @Override
    public synchronized void registerSingleton(T interceptor, int priority) {
        SingletonInterceptorFactory factory = new SingletonInterceptorFactory(interceptor.getClass(), interceptor);
        factory.setOrder(priority);
        this.register(factory);
    }

    private Class<?> getNonSyntheticClass(Class<?> clazz) {
        while (clazz.isSynthetic()) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.interception.jaxrs.JaxrsInterceptorRegistryImpl", JaxrsInterceptorRegistryImpl.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    protected class SingletonInterceptorFactory
    extends AbstractInterceptorFactory {
        protected Object interceptor;
        static final long serialVersionUID = 2939621652409813355L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public SingletonInterceptorFactory(Class declaring, Object interceptor) {
            super(declaring);
            this.interceptor = interceptor;
            this.setPrecedence(declaring);
        }

        @Override
        protected void initialize() {
            JaxrsInterceptorRegistryImpl.this.providerFactory.injectProperties(this.interceptor);
        }

        @Override
        protected Object getInterceptor() {
            this.checkInitialize();
            return this.interceptor;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.interception.jaxrs.JaxrsInterceptorRegistryImpl$SingletonInterceptorFactory", SingletonInterceptorFactory.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    protected class OnDemandInterceptorFactory
    extends AbstractInterceptorFactory {
        private Object interceptor;
        static final long serialVersionUID = 6579408520100064993L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public OnDemandInterceptorFactory(Class declaring) {
            super(declaring);
            this.setPrecedence(declaring);
        }

        @Override
        protected void initialize() {
            Object currentInterceptor = this.createInterceptor();
            JaxrsInterceptorRegistryImpl.this.providerFactory.injectProperties(currentInterceptor);
            this.interceptor = currentInterceptor;
            this.initialized = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void checkInitialize() {
            if (!this.initialized) {
                OnDemandInterceptorFactory onDemandInterceptorFactory = this;
                synchronized (onDemandInterceptorFactory) {
                    if (!this.initialized) {
                        this.initialize();
                    }
                }
            }
        }

        @Override
        protected Object getInterceptor() {
            this.checkInitialize();
            return this.interceptor;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.interception.jaxrs.JaxrsInterceptorRegistryImpl$OnDemandInterceptorFactory", OnDemandInterceptorFactory.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    public abstract class AbstractInterceptorFactory
    implements JaxrsInterceptorRegistry.InterceptorFactory {
        protected final Class declaring;
        protected int order = 5000;
        protected List<Class<? extends Annotation>> nameBound;
        protected volatile boolean initialized;
        protected boolean ignorePrematch;
        static final long serialVersionUID = 4865012498539661747L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public AbstractInterceptorFactory(Class declaring) {
            this.declaring = JaxrsInterceptorRegistryImpl.this.getNonSyntheticClass(declaring);
        }

        protected void setPrecedence(Class<?> declaring) {
            this.nameBound = JaxrsInterceptorRegistryImpl.getNameBound(declaring);
            this.order = JaxrsInterceptorRegistryImpl.getPriority(declaring);
        }

        protected abstract void initialize();

        protected abstract Object getInterceptor();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkInitialize() {
            boolean isInitialized = this.initialized;
            if (!isInitialized) {
                AbstractInterceptorFactory abstractInterceptorFactory = this;
                synchronized (abstractInterceptorFactory) {
                    isInitialized = this.initialized;
                    if (isInitialized) {
                        return;
                    }
                    this.initialized = true;
                    isInitialized = true;
                    this.initialize();
                }
            }
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public void setIgnorePrematch(boolean ignorePrematch) {
            this.ignorePrematch = ignorePrematch;
        }

        @Override
        public JaxrsInterceptorRegistry.Match preMatch() {
            if (this.declaring.isAnnotationPresent(PreMatching.class)) {
                return new JaxrsInterceptorRegistry.Match(this.getInterceptor(), this.order);
            }
            return null;
        }

        @Override
        public JaxrsInterceptorRegistry.Match postMatch(Class targetClass, AccessibleObject target) {
            if (!this.ignorePrematch && this.declaring.isAnnotationPresent(PreMatching.class)) {
                return null;
            }
            if (targetClass != null && target != null) {
                if (this.nameBound.size() > 0) {
                    Application application = ResteasyContext.getContextData(Application.class);
                    for (Class<? extends Annotation> annotation : this.nameBound) {
                        if (targetClass.isAnnotationPresent(annotation) || target.isAnnotationPresent(annotation) || application != null && JaxrsInterceptorRegistryImpl.this.getNonSyntheticClass(application.getClass()).isAnnotationPresent(annotation)) continue;
                        return null;
                    }
                    Object intercept = this.getInterceptor();
                    if (intercept == null) {
                        throw new NullPointerException(Messages.MESSAGES.interceptorNullFromClass(this.getClass().getName()));
                    }
                    return new JaxrsInterceptorRegistry.Match(intercept, this.order);
                }
                Object intercept = this.getInterceptor();
                if (intercept == null) {
                    throw new NullPointerException(Messages.MESSAGES.interceptorNullFromClass(this.getClass().getName()));
                }
                return new JaxrsInterceptorRegistry.Match(intercept, this.order);
            }
            if (this.nameBound.size() == 0) {
                Object intercept = this.getInterceptor();
                if (intercept == null) {
                    throw new NullPointerException(Messages.MESSAGES.interceptorNullFromClass(this.getClass().getName()));
                }
                return new JaxrsInterceptorRegistry.Match(intercept, this.order);
            }
            return null;
        }

        protected Object createInterceptor() {
            return JaxrsInterceptorRegistryImpl.this.providerFactory.injectedInstance(this.declaring);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.interception.jaxrs.JaxrsInterceptorRegistryImpl$AbstractInterceptorFactory", AbstractInterceptorFactory.class, null, null);
        }
    }
}

