/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.annotation.Priority;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import org.jboss.resteasy.core.ResteasyContext;

@Priority(value=2000)
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class RoleBasedSecurityFilter
implements ContainerRequestFilter {
    protected String[] rolesAllowed;
    protected boolean denyAll;
    protected boolean permitAll;
    static final long serialVersionUID = -4723931004244966002L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public RoleBasedSecurityFilter(String[] rolesAllowed, boolean denyAll, boolean permitAll) {
        this.rolesAllowed = rolesAllowed;
        this.denyAll = denyAll;
        this.permitAll = permitAll;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        SecurityContext context;
        if (this.denyAll) {
            throw new ForbiddenException(Response.status((int)403).entity((Object)"Access forbidden: role not allowed").type("text/html;charset=UTF-8").build());
        }
        if (this.permitAll) {
            return;
        }
        if (this.rolesAllowed != null && (context = ResteasyContext.getContextData(SecurityContext.class)) != null) {
            for (String role : this.rolesAllowed) {
                if (!context.isUserInRole(role)) continue;
                return;
            }
            throw new ForbiddenException(Response.status((int)403).entity((Object)"Access forbidden: role not allowed").type("text/html;charset=UTF-8").build());
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.interceptors.RoleBasedSecurityFilter", RoleBasedSecurityFilter.class, null, null);
    }
}

