/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.providerfactory;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.ExceptionMapper;
import org.jboss.logging.Logger;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
class DefaultExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final LogMessages LOGGER;
    static final DefaultExceptionMapper INSTANCE;
    static final long serialVersionUID = -5245071514450947482L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    DefaultExceptionMapper() {
    }

    public Response toResponse(Throwable exception) {
        Throwable cause;
        if (exception instanceof ApplicationException && (cause = exception.getCause()) != null) {
            return this.process(cause);
        }
        return this.process(exception);
    }

    private Response process(Throwable exception) {
        if (LOGGER.isEnabled(Logger.Level.ERROR)) {
            ResteasyProviderFactory providerFactory = ResteasyProviderFactory.getInstance();
            Request request = providerFactory.getContextData(Request.class);
            ResourceInfo resourceInfo = providerFactory.getContextData(ResourceInfo.class);
            UriInfo uriInfo = providerFactory.getContextData(UriInfo.class);
            StringBuilder info = new StringBuilder();
            if (request != null) {
                info.append(request.getMethod());
                if (uriInfo != null || resourceInfo != null) {
                    info.append(' ');
                }
            }
            if (uriInfo != null) {
                info.append(uriInfo.getRequestUri().getPath());
                if (resourceInfo != null) {
                    info.append(" - ");
                }
            }
            if (resourceInfo != null) {
                info.append(resourceInfo.getResourceClass().getName()).append('.').append(resourceInfo.getResourceMethod().getName());
            }
            if (info.length() == 0) {
                LOGGER.defaultExceptionMapper(exception);
            } else {
                LOGGER.defaultExceptionMapper(exception, info);
            }
        }
        if (exception instanceof WebApplicationException) {
            return ((WebApplicationException)exception).getResponse();
        }
        return Response.serverError().entity((Object)exception.getLocalizedMessage()).build();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.providerfactory.DefaultExceptionMapper", DefaultExceptionMapper.class, (String)"RESTfulWS", (String)"io.openliberty.org.jboss.resteasy.common.nls.RESTfulWSServer");
        LOGGER = (LogMessages)Logger.getMessageLogger(LogMessages.class, (String)DefaultExceptionMapper.class.getName());
        INSTANCE = new DefaultExceptionMapper();
    }
}

