/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.health.internal;

import com.ibm.websphere.jsonsupport.JSON;
import com.ibm.websphere.jsonsupport.JSONFactory;
import com.ibm.websphere.jsonsupport.JSONSettings;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.health.internal.AppTracker;
import com.ibm.ws.microprofile.health.internal.HealthCheckHttpResponseBuilder;
import com.ibm.ws.microprofile.health.internal.HealthCheckService;
import com.ibm.ws.microprofile.health.services.HealthCheckBeanCallException;
import com.ibm.ws.microprofile.health.services.HealthExecutor;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={HealthCheckService.class}, property={"service.vendor=IBM"})
public class HealthCheckServiceImpl
implements HealthCheckService {
    private static final TraceComponent tc = Tr.register(HealthCheckServiceImpl.class, (String)"HEALTH", (String)"com.ibm.ws.microprofile.health.resources.Health");
    private AppTracker appTracker;
    private HealthExecutor hcExecutor;
    JSON json = null;
    static final long serialVersionUID = -8261330169128119738L;

    @Reference(service=AppTracker.class)
    protected void setAppTracker(AppTracker service) {
        this.appTracker = service;
        this.appTracker.setHealthCheckService(this);
    }

    protected void unsetAppTracker(AppTracker service) {
        if (this.appTracker == service) {
            this.appTracker = null;
        }
    }

    @Reference(service=HealthExecutor.class)
    protected void setHealthExecutor(HealthExecutor service) {
        this.hcExecutor = service;
    }

    protected void unsetHealthExecutor(HealthExecutor service) {
        if (this.hcExecutor == service) {
            this.hcExecutor = null;
        }
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> properties) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"HealthCheckServiceImpl is activated", (Object[])new Object[0]);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc, int reason) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"HealthCheckServiceImpl is deactivated", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void performHealthCheck(HttpServletRequest request, HttpServletResponse httpResponse) {
        Set<HealthCheckResponse> hcResponses = null;
        Set<String> apps = this.appTracker.getAppNames();
        Iterator<String> appsIt = apps.iterator();
        HealthCheckHttpResponseBuilder hcHttpResponseBuilder = new HealthCheckHttpResponseBuilder(this.getJSON());
        while (appsIt.hasNext()) {
            String appName = appsIt.next();
            Set<String> modules = this.appTracker.getModuleNames(appName);
            for (String moduleName : modules) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): appName = " + appName + ", moduleName = " + moduleName), (Object[])new Object[0]);
                }
                try {
                    hcResponses = this.hcExecutor.runHealthChecks(appName, moduleName);
                }
                catch (HealthCheckBeanCallException healthCheckBeanCallException) {
                    FFDCFilter.processException((Throwable)healthCheckBeanCallException, (String)"com.ibm.ws.microprofile.health.internal.HealthCheckServiceImpl", (String)"115", (Object)this, (Object[])new Object[]{request, httpResponse});
                    if (tc.isDebugEnabled()) {
                        void e;
                        Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): Caught the exception " + e + " for appName = " + appName + ", moduleName = " + moduleName), (Object[])new Object[0]);
                    }
                    hcHttpResponseBuilder.handleUndeterminedResponse(httpResponse);
                    return;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("In performHealthCheck(): hcResponses = " + hcResponses), (Object[])new Object[0]);
                }
                if (hcResponses.isEmpty()) continue;
                hcHttpResponseBuilder.addResponses(hcResponses);
            }
        }
        hcHttpResponseBuilder.setHttpResponse(httpResponse);
    }

    @Override
    public void removeModuleReferences(String appName, String moduleName) {
        if (this.hcExecutor != null) {
            this.hcExecutor.removeModuleReferences(appName, moduleName);
        }
    }

    private JSON getJSON() {
        if (this.json == null) {
            JSONSettings settings = new JSONSettings(JSONSettings.Include.NON_NULL);
            this.json = JSONFactory.newInstance((JSONSettings)settings);
        }
        return this.json;
    }
}

