/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.health.internal;

import com.ibm.websphere.jsonsupport.JSON;
import com.ibm.websphere.jsonsupport.JSONMarshallException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.health.HealthCheckResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HealthCheckHttpResponseBuilder {
    private static final TraceComponent tc = Tr.register(HealthCheckHttpResponseBuilder.class, (String)"HEALTH", (String)"com.ibm.ws.microprofile.health.resources.Health");
    private static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    private static final String MEDIA_TYPE_APPLICATION_JSON = "application/json; charset=UTF-8";
    private static final String HEALTH_CHECK_PAYLOAD_OUTCOME = "outcome";
    private static final String HEALTH_CHECK_PAYLOAD_CHECKS = "checks";
    private static final String HEALTH_CHECK_PAYLOAD_NAME = "name";
    private static final String HEALTH_CHECK_PAYLOAD_STATE = "state";
    private static final String HEALTH_CHECK_PAYLOAD_DATA = "data";
    protected HealthCheckResponse.State overallState = HealthCheckResponse.State.UP;
    protected final ArrayList<Map<String, Object>> checks = new ArrayList();
    private final JSON json;
    static final long serialVersionUID = 5081632419727002003L;

    public HealthCheckHttpResponseBuilder(JSON json) {
        this.json = json;
    }

    public void addResponses(Set<HealthCheckResponse> hcResponseSet) {
        for (HealthCheckResponse hcResponse : hcResponseSet) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("addResponsek(): hcResponse = " + hcResponse), (Object[])new Object[0]);
            }
            this.setChecks(hcResponse);
        }
    }

    public void setHttpResponse(HttpServletResponse httpResponse) {
        httpResponse.setHeader(HTTP_HEADER_CONTENT_TYPE, MEDIA_TYPE_APPLICATION_JSON);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        if (this.checks.isEmpty()) {
            httpResponse.setStatus(200);
            payload.put(HEALTH_CHECK_PAYLOAD_OUTCOME, HealthCheckResponse.State.UP);
        } else {
            payload.put(HEALTH_CHECK_PAYLOAD_OUTCOME, this.overallState);
            httpResponse.setStatus(this.overallState == HealthCheckResponse.State.UP ? 200 : 503);
        }
        payload.put(HEALTH_CHECK_PAYLOAD_CHECKS, this.checks.toArray());
        this.setJSONPayload(payload, httpResponse);
    }

    public void handleUndeterminedResponse(HttpServletResponse httpResponse) {
        httpResponse.setStatus(500);
    }

    protected void setChecks(HealthCheckResponse response) {
        Optional data;
        HashMap<String, String> check = new HashMap<String, String>();
        check.put(HEALTH_CHECK_PAYLOAD_NAME, response.getName());
        HealthCheckResponse.State checkState = response.getState();
        check.put(HEALTH_CHECK_PAYLOAD_STATE, (String)checkState);
        if (checkState != null) {
            if (checkState.equals((Object)HealthCheckResponse.State.DOWN)) {
                this.overallState = HealthCheckResponse.State.DOWN;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setChecks(): checkState is null", (Object[])new Object[0]);
            }
            this.overallState = HealthCheckResponse.State.DOWN;
        }
        if ((data = response.getData()) != null && data.isPresent()) {
            check.put(HEALTH_CHECK_PAYLOAD_DATA, (String)data.get());
        }
        this.checks.add(check);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setChecks(): checks = " + this.checks), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setJSONPayload(Map<String, Object> payload, HttpServletResponse httpResponse) {
        try {
            httpResponse.getOutputStream().write(this.json.asBytes(payload));
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.microprofile.health.internal.HealthCheckHttpResponseBuilder", (String)"127", (Object)this, (Object[])new Object[]{payload, httpResponse});
            if (tc.isEventEnabled()) {
                void e;
                Tr.event((TraceComponent)tc, (String)"Unexpected IOException while writing out POJO response", (Object[])new Object[]{e});
            }
            httpResponse.setStatus(500);
        }
        catch (JSONMarshallException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.health.internal.HealthCheckHttpResponseBuilder", (String)"132", (Object)this, (Object[])new Object[]{payload, httpResponse});
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unexpected JSONMarshallException while getting the JSON service", (Object[])new Object[]{e});
            }
            httpResponse.setStatus(500);
        }
    }

    public void setOverallState(HealthCheckResponse.State state) {
        this.overallState = state;
    }
}

