/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.jakartasec;

import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.javaeesec.identitystore.ELHelper;
import io.openliberty.security.jakartasec.ClaimsDefinitionWrapper;
import io.openliberty.security.jakartasec.LogoutDefinitionWrapper;
import io.openliberty.security.jakartasec.OpenIdProviderMetadataWrapper;
import io.openliberty.security.jakartasec.el.ELUtils;
import io.openliberty.security.oidcclientcore.client.ClaimsMappingConfig;
import io.openliberty.security.oidcclientcore.client.LogoutConfig;
import io.openliberty.security.oidcclientcore.client.OidcClientConfig;
import io.openliberty.security.oidcclientcore.client.OidcProviderMetadata;
import jakarta.security.enterprise.authentication.mechanism.http.OpenIdAuthenticationMechanismDefinition;
import jakarta.security.enterprise.authentication.mechanism.http.openid.DisplayType;
import jakarta.security.enterprise.authentication.mechanism.http.openid.PromptType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenIdAuthenticationMechanismDefinitionWrapper
implements OidcClientConfig {
    private static final TraceComponent tc = Tr.register(OpenIdAuthenticationMechanismDefinitionWrapper.class, (String)"OpenIdConnect", (String)"io.openliberty.security.jakartasec.internal.resources.JakartaSecurity30Messages");
    private final OpenIdAuthenticationMechanismDefinition oidcMechanismDefinition;
    private final String providerURI;
    private final OpenIdProviderMetadataWrapper providerMetadataWrapper;
    private final String clientId;
    private final ProtectedString clientSecret;
    private final ClaimsDefinitionWrapper claimsDefinitionWrapper;
    private final LogoutDefinitionWrapper logoutDefinitionWrapper;
    private final String redirectURI;
    private final Boolean redirectToOriginalResource;
    private final String[] scope;
    private final String responseType;
    private final String responseMode;
    private final PromptType[] prompt;
    private final DisplayType display;
    private final Boolean useNonce;
    private final Boolean useSession;
    private final String[] extraParameters;
    private final Integer jwksConnectTimeout;
    private final Integer jwksReadTimeout;
    private final Boolean tokenAutoRefresh;
    private final Integer tokenMinValidity;
    private final ELHelper elHelper;
    private final String constructedBaseURL;
    static final long serialVersionUID = 4706711177895842197L;

    @Sensitive
    public OpenIdAuthenticationMechanismDefinitionWrapper(OpenIdAuthenticationMechanismDefinition oidcMechanismDefinition, String baseURL) {
        if (oidcMechanismDefinition == null) {
            throw new IllegalArgumentException("The OpenIdAuthenticationMechanismDefinition cannot be null.");
        }
        this.oidcMechanismDefinition = oidcMechanismDefinition;
        this.elHelper = new ELHelper();
        this.constructedBaseURL = baseURL;
        this.providerURI = this.evaluateProviderURI(true);
        this.providerMetadataWrapper = new OpenIdProviderMetadataWrapper(oidcMechanismDefinition.providerMetadata());
        this.clientId = this.evaluateClientId(true);
        this.clientSecret = this.evaluateClientSecret(true);
        this.claimsDefinitionWrapper = new ClaimsDefinitionWrapper(oidcMechanismDefinition.claimsDefinition());
        this.logoutDefinitionWrapper = new LogoutDefinitionWrapper(oidcMechanismDefinition.logout());
        this.redirectURI = this.evaluateRedirectURI(true);
        this.redirectToOriginalResource = this.evaluateRedirectToOriginalResource(true);
        this.scope = this.evaluateScope(true);
        this.responseType = this.evaluateResponseType(true);
        this.responseMode = this.evaluateResponseMode(true);
        this.prompt = this.evaluatePrompt(true);
        this.display = this.evaluateDisplay(true);
        this.useNonce = this.evaluateUseNonce(true);
        this.useSession = this.evaluateUseSession(true);
        this.extraParameters = this.evaluateExtraParameters(true);
        this.jwksConnectTimeout = this.evaluateJwksConnectTimeout(true);
        this.jwksReadTimeout = this.evaluateJwksReadTimeout(true);
        this.tokenAutoRefresh = this.evaluateTokenAutoRefresh(true);
        this.tokenMinValidity = this.evaluateTokenMinValidity(true);
    }

    private String evaluateProviderURI(boolean immediateOnly) {
        return ELUtils.evaluateStringAttribute("providerURI", this.oidcMechanismDefinition.providerURI(), "", immediateOnly);
    }

    private String evaluateClientId(boolean immediateOnly) {
        return ELUtils.evaluateStringAttribute("clientId", this.oidcMechanismDefinition.clientId(), "", immediateOnly);
    }

    @Sensitive
    @FFDCIgnore(value={IllegalArgumentException.class})
    private ProtectedString evaluateClientSecret(boolean immediateOnly) {
        String result;
        String clientSecret = this.oidcMechanismDefinition.clientSecret();
        try {
            result = this.elHelper.processString("clientSecret", clientSecret, immediateOnly, true);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression((String)clientSecret)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"clientSecret", (Object[])new Object[]{"Returning null since clientSecret is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            this.issueWarningMessage("clientSecret", "******", "");
            result = "";
        }
        return result == null ? null : new ProtectedString(result.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String evaluateRedirectURI(boolean immediateOnly) {
        try {
            this.elHelper.addValue("baseURL", this.constructedBaseURL, false);
            String redirectUri = ELUtils.evaluateStringAttribute("redirectURI", this.oidcMechanismDefinition.redirectURI(), "${baseURL}/Callback", immediateOnly);
            if (redirectUri != null && redirectUri.contains("baseURL")) {
                redirectUri = ELUtils.evaluateStringAttribute("redirectURI", redirectUri, "${baseURL}/Callback", immediateOnly);
            }
            String string = redirectUri;
            return string;
        }
        finally {
            this.elHelper.removeValue("baseURL");
        }
    }

    private Boolean evaluateRedirectToOriginalResource(boolean immediateOnly) {
        return ELUtils.evaluateBooleanAttribute("redirectToOriginalResourceExpression", this.oidcMechanismDefinition.redirectToOriginalResource(), false, this.oidcMechanismDefinition.redirectToOriginalResourceExpression(), immediateOnly);
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String[] evaluateScope(boolean immediateOnly) {
        String scopeExpression = this.oidcMechanismDefinition.scopeExpression();
        try {
            return this.elHelper.processStringArray("scopeExpression", scopeExpression, this.oidcMechanismDefinition.scope(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression((String)scopeExpression)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"scopeExpression", (Object[])new Object[]{"Returning null since scopeExpression is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            Object[] defaultScope = new String[]{"openid", "email", "profile"};
            this.issueWarningMessage("scopeExpression", scopeExpression, Arrays.toString(defaultScope));
            return defaultScope;
        }
    }

    private String evaluateResponseType(boolean immediateOnly) {
        return ELUtils.evaluateStringAttribute("responseType", this.oidcMechanismDefinition.responseType(), "code", immediateOnly);
    }

    private String evaluateResponseMode(boolean immediateOnly) {
        return ELUtils.evaluateStringAttribute("responseMode", this.oidcMechanismDefinition.responseMode(), "", immediateOnly);
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private PromptType[] evaluatePrompt(boolean immediateOnly) {
        String promptExpression = this.oidcMechanismDefinition.promptExpression();
        PromptType[] promptArray = this.oidcMechanismDefinition.prompt();
        try {
            return this.processPrompt(promptExpression, promptArray, immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression((String)promptExpression)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"promptExpression", (Object[])new Object[]{"Returning null since promptExpression is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            this.issueWarningMessage("promptExpression", promptExpression, "");
            return new PromptType[0];
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private DisplayType evaluateDisplay(boolean immediateOnly) {
        String displayExpression = this.oidcMechanismDefinition.displayExpression();
        try {
            return this.processDisplay(displayExpression, this.oidcMechanismDefinition.display(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression((String)displayExpression)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"displayExpression", (Object[])new Object[]{"Returning null since displayExpression is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            this.issueWarningMessage("displayExpression", displayExpression, DisplayType.PAGE.toString());
            return DisplayType.PAGE;
        }
    }

    private Boolean evaluateUseNonce(boolean immediateOnly) {
        return ELUtils.evaluateBooleanAttribute("useNonceExpression", this.oidcMechanismDefinition.useNonce(), true, this.oidcMechanismDefinition.useNonceExpression(), immediateOnly);
    }

    private Boolean evaluateUseSession(boolean immediateOnly) {
        return ELUtils.evaluateBooleanAttribute("useSessionExpression", this.oidcMechanismDefinition.useSession(), true, this.oidcMechanismDefinition.useSessionExpression(), immediateOnly);
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String[] evaluateExtraParameters(boolean immediateOnly) {
        String extraParametersExpression = this.oidcMechanismDefinition.extraParametersExpression();
        try {
            return this.elHelper.processStringArray("extraParametersExpression", extraParametersExpression, this.oidcMechanismDefinition.extraParameters(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression((String)extraParametersExpression)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"extraParametersExpression", (Object[])new Object[]{"Returning null since extraParametersExpression is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAKARTASEC_WARNING_OIDC_MECH_CONFIG", (Object[])new Object[]{"extraParametersExpression", ""});
            }
            return new String[0];
        }
    }

    private Integer evaluateJwksConnectTimeout(boolean immediateOnly) {
        return this.evaluateNonNegativeInteger("jwksConnectTimeout", this.oidcMechanismDefinition.jwksConnectTimeout(), 500, "jwksConnectTimeoutExpression", this.oidcMechanismDefinition.jwksConnectTimeoutExpression(), immediateOnly);
    }

    private Integer evaluateJwksReadTimeout(boolean immediateOnly) {
        return this.evaluateNonNegativeInteger("jwksReadTimeout", this.oidcMechanismDefinition.jwksReadTimeout(), 500, "jwksReadTimeoutExpression", this.oidcMechanismDefinition.jwksReadTimeoutExpression(), immediateOnly);
    }

    private Boolean evaluateTokenAutoRefresh(boolean immediateOnly) {
        return ELUtils.evaluateBooleanAttribute("tokenAutoRefreshExpression", this.oidcMechanismDefinition.tokenAutoRefresh(), false, this.oidcMechanismDefinition.tokenAutoRefreshExpression(), immediateOnly);
    }

    private Integer evaluateTokenMinValidity(boolean immediateOnly) {
        return this.evaluateNonNegativeInteger("tokenMinValidity", this.oidcMechanismDefinition.tokenMinValidity(), 10000, "tokenMinValidityExpression", this.oidcMechanismDefinition.tokenMinValidityExpression(), immediateOnly);
    }

    private Integer evaluateNonNegativeInteger(String attributeName, int attribute, int attributeDefault, String attributeExpressionName, String attributeExpression, boolean immediateOnly) {
        Integer value = ELUtils.evaluateIntegerAttribute(attributeExpressionName, attribute, attributeDefault, attributeExpression, immediateOnly);
        if (value != null && value < 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                String attributeNameForWarning = attributeExpression.isEmpty() ? attributeName : attributeExpressionName;
                Tr.warning((TraceComponent)tc, (String)"JAKARTASEC_WARNING_OIDC_MECH_CONFIG_NEGATIVE_INT", (Object[])new Object[]{attributeNameForWarning, value, attributeDefault});
            }
            value = attributeDefault;
        }
        return value;
    }

    private void issueWarningMessage(String attributeName, Object valueProvided, Object attributeDefault) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
            Tr.warning((TraceComponent)tc, (String)"JAKARTASEC_WARNING_OIDC_MECH_CONFIG", (Object[])new Object[]{attributeName, valueProvided, attributeDefault});
        }
    }

    public String getProviderURI() {
        return this.providerURI != null ? this.providerURI : this.evaluateProviderURI(false);
    }

    public OidcProviderMetadata getProviderMetadata() {
        return this.providerMetadataWrapper;
    }

    public String getClientId() {
        return this.clientId != null ? this.clientId : this.evaluateClientId(false);
    }

    @Sensitive
    public ProtectedString getClientSecret() {
        return this.clientSecret != null ? this.clientSecret : this.evaluateClientSecret(false);
    }

    public ClaimsMappingConfig getClaimsMappingConfig() {
        return this.claimsDefinitionWrapper;
    }

    public LogoutConfig getLogoutConfig() {
        return this.logoutDefinitionWrapper;
    }

    public String getRedirectURI() {
        return this.redirectURI != null ? this.redirectURI : this.evaluateRedirectURI(false);
    }

    public boolean isRedirectToOriginalResource() {
        return this.redirectToOriginalResource != null ? this.redirectToOriginalResource : this.evaluateRedirectToOriginalResource(false);
    }

    public Set<String> getScope() {
        String[] tempScopes;
        LinkedHashSet<String> scopeSet = new LinkedHashSet<String>();
        for (String tempScope : tempScopes = this.scope != null ? this.scope : this.evaluateScope(false)) {
            scopeSet.add(tempScope);
        }
        return scopeSet;
    }

    public String getResponseType() {
        return this.responseType != null ? this.responseType : this.evaluateResponseType(false);
    }

    public String getResponseMode() {
        return this.responseMode != null ? this.responseMode : this.evaluateResponseMode(false);
    }

    public String getPromptParameter() {
        PromptType[] promptTypes = this.prompt != null ? this.prompt : this.evaluatePrompt(false);
        StringBuffer sb = new StringBuffer();
        for (PromptType promptType : promptTypes) {
            if (sb.length() != 0) {
                sb.append(" ").append(promptType.toString().toLowerCase());
                continue;
            }
            sb.append(promptType.toString().toLowerCase());
        }
        return sb.toString();
    }

    public String getDisplayParameter() {
        return this.display != null ? this.display.name().toLowerCase() : this.evaluateDisplay(false).name().toLowerCase();
    }

    public boolean isUseNonce() {
        return this.useNonce != null ? this.useNonce : this.evaluateUseNonce(false);
    }

    public boolean isUseSession() {
        return this.useSession != null ? this.useSession : this.evaluateUseSession(false);
    }

    public String[] getExtraParameters() {
        return this.extraParameters != null ? this.extraParameters : this.evaluateExtraParameters(false);
    }

    public int getJwksConnectTimeout() {
        return this.jwksConnectTimeout != null ? this.jwksConnectTimeout : this.evaluateJwksConnectTimeout(false);
    }

    public int getJwksReadTimeout() {
        return this.jwksReadTimeout != null ? this.jwksReadTimeout : this.evaluateJwksReadTimeout(false);
    }

    public boolean isTokenAutoRefresh() {
        return this.tokenAutoRefresh != null ? this.tokenAutoRefresh : this.evaluateTokenAutoRefresh(false);
    }

    public int getTokenMinValidity() {
        return this.tokenMinValidity != null ? this.tokenMinValidity : this.evaluateTokenMinValidity(false);
    }

    protected PromptType[] processPrompt(String promptExpression, PromptType[] prompt, boolean immediateOnly) {
        PromptType[] result = null;
        boolean immediate = false;
        if (promptExpression == null || promptExpression.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"promptExpression not provided, return promptType", (Object[])new Object[0]);
            }
            result = prompt;
            immediate = true;
        } else {
            Object obj = this.elHelper.evaluateElExpression(promptExpression);
            if (obj instanceof PromptType[]) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processPrompt (promptType): " + obj), (Object[])new Object[0]);
                }
                result = (PromptType[])obj;
                immediate = ELHelper.isImmediateExpression((String)promptExpression);
            } else if (obj instanceof String) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"processPrompt", (Object[])new Object[]{"promptExpression evaluated to a String, attempt to split and compare to PromptType enum options: " + obj});
                }
                String[] splitReturn = ((String)obj).split(" ");
                HashSet<PromptType> types = new HashSet<PromptType>(splitReturn.length);
                block6: for (String split : splitReturn) {
                    switch (PromptType.fromString((String)split)) {
                        case CONSENT: {
                            types.add(PromptType.CONSENT);
                            continue block6;
                        }
                        case LOGIN: {
                            types.add(PromptType.LOGIN);
                            continue block6;
                        }
                        case SELECT_ACCOUNT: {
                            types.add(PromptType.SELECT_ACCOUNT);
                            continue block6;
                        }
                        case NONE: {
                            types.add(PromptType.NONE);
                            continue block6;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid value provided in the promptExpression: " + split);
                        }
                    }
                }
                result = types.toArray(new PromptType[types.size()]);
                immediate = ELHelper.isImmediateExpression((String)promptExpression);
            } else {
                throw new IllegalArgumentException("Expected 'promptExpression' to evaluate to an array of PromptType enum values: " + promptExpression);
            }
        }
        return immediateOnly && !immediate ? null : result;
    }

    protected DisplayType processDisplay(String displayExpression, DisplayType display, boolean immediateOnly) {
        DisplayType result = null;
        boolean immediate = false;
        if (displayExpression == null || displayExpression.isEmpty()) {
            result = display;
            immediate = true;
        } else {
            Object obj = this.elHelper.evaluateElExpression(displayExpression);
            if (obj instanceof DisplayType) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processPrompt (promptType): " + obj), (Object[])new Object[0]);
                }
                result = (DisplayType)obj;
                immediate = ELHelper.isImmediateExpression((String)displayExpression);
            } else if (obj instanceof String) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"processDisplay", (Object[])new Object[]{"displayExpression evaluated to a String, compare to DisplayType enum options: " + obj});
                }
                String displayReturn = (String)obj;
                switch (DisplayType.fromString((String)displayReturn)) {
                    case PAGE: {
                        result = DisplayType.PAGE;
                        break;
                    }
                    case POPUP: {
                        result = DisplayType.POPUP;
                        break;
                    }
                    case TOUCH: {
                        result = DisplayType.TOUCH;
                        break;
                    }
                    case WAP: {
                        result = DisplayType.WAP;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid value provided in the displayExpression: " + displayReturn);
                    }
                }
                immediate = ELHelper.isImmediateExpression((String)displayExpression);
            } else {
                throw new IllegalArgumentException("Expected 'displayExpression' to evaluate to a DisplayType enum value: " + displayExpression);
            }
        }
        return immediateOnly && !immediate ? null : result;
    }
}

