/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.introspect;

import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.internal.introspect.TraceObjectFieldAnnotationVisitor;
import com.ibm.ws.ras.instrument.internal.introspect.TraceOptionsAnnotationVisitor;
import com.ibm.ws.ras.instrument.internal.model.ClassInfo;
import com.ibm.ws.ras.instrument.internal.model.FieldInfo;
import com.ibm.ws.ras.instrument.internal.model.MethodInfo;
import io.openliberty.asm.ASMHelper;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class TraceConfigClassVisitor
extends ClassVisitor {
    protected static final Type SENSITIVE_TYPE = Type.getType(Sensitive.class);
    protected static final Type TRACE_OPTIONS_TYPE = Type.getType(TraceOptions.class);
    protected static final Type TRIVIAL_TYPE = Type.getType(Trivial.class);
    protected static final Type FFDC_IGNORE_TYPE = Type.getType(FFDCIgnore.class);
    protected static final Type TRACE_OBJECT_FIELD_TYPE = Type.getType(TraceObjectField.class);
    protected ClassInfo classInfo;
    protected TraceOptionsAnnotationVisitor traceOptionsAnnotationVisitor;
    protected TraceObjectFieldAnnotationVisitor traceObjectFieldAnnotationVisitor;

    public TraceConfigClassVisitor(ClassVisitor cv) {
        super(ASMHelper.getCurrentASM(), cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.classInfo = new ClassInfo(name);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(desc, visible);
        if (TRACE_OPTIONS_TYPE.getDescriptor().equals(desc)) {
            this.traceOptionsAnnotationVisitor = new TraceOptionsAnnotationVisitor(av);
            av = this.traceOptionsAnnotationVisitor;
        } else if (TRIVIAL_TYPE.getDescriptor().equals(desc)) {
            this.classInfo.setTrivial(true);
        } else if (SENSITIVE_TYPE.getDescriptor().equals(desc)) {
            this.classInfo.setSensitive(true);
        } else if (TRACE_OBJECT_FIELD_TYPE.getDescriptor().equals(desc)) {
            this.traceObjectFieldAnnotationVisitor = new TraceObjectFieldAnnotationVisitor(av);
            av = this.traceObjectFieldAnnotationVisitor;
        }
        return av;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldVisitor fv = super.visitField(access, name, desc, signature, value);
        if ((access & 8) != 0) {
            FieldInfo fieldInfo = new FieldInfo(name, desc);
            this.classInfo.addFieldInfo(fieldInfo);
        }
        return fv;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        MethodInfo methodInfo = new MethodInfo(name, desc);
        this.classInfo.addMethodInfo(methodInfo);
        return new MethodInfoMethodVisitor(mv, methodInfo);
    }

    public void visitEnd() {
        super.visitEnd();
        if (this.traceOptionsAnnotationVisitor != null) {
            this.classInfo.setTraceOptionsData(this.traceOptionsAnnotationVisitor.getTraceOptionsData());
        }
        if (this.traceObjectFieldAnnotationVisitor != null) {
            FieldInfo fi = this.classInfo.getDeclaredLoggerField();
            if (fi == null) {
                fi = this.classInfo.getDeclaredFieldByName(this.traceObjectFieldAnnotationVisitor.getFieldName());
            }
            if (fi != null) {
                fi.setLoggerField(true);
            }
        }
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    private static final class MethodInfoMethodVisitor
    extends MethodVisitor {
        private final MethodInfo methodInfo;

        private MethodInfoMethodVisitor(MethodVisitor mv, MethodInfo methodInfo) {
            super(ASMHelper.getCurrentASM(), mv);
            this.methodInfo = methodInfo;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationVisitor av = super.visitAnnotation(desc, visible);
            if (FFDC_IGNORE_TYPE.getDescriptor().equals(desc)) {
                av = new FFDCIgnoreAnnotationVisitor(av, this.methodInfo);
            } else if (SENSITIVE_TYPE.getDescriptor().equals(desc)) {
                this.methodInfo.setResultSensitive(true);
            } else if (TRIVIAL_TYPE.getDescriptor().equals(desc)) {
                this.methodInfo.setTrivial(true);
            }
            return av;
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            if (SENSITIVE_TYPE.getDescriptor().equals(desc)) {
                this.methodInfo.setArgIsSensitive(parameter, true);
            }
            return super.visitParameterAnnotation(parameter, desc, visible);
        }

        private static final class FFDCIgnoreAnnotationVisitor
        extends AnnotationVisitor {
            private final MethodInfo methodInfo;

            private FFDCIgnoreAnnotationVisitor(AnnotationVisitor av, MethodInfo methodInfo) {
                super(ASMHelper.getCurrentASM(), av);
                this.methodInfo = methodInfo;
            }

            public AnnotationVisitor visitArray(String name) {
                AnnotationVisitor av = super.visitArray(name);
                if (name.equals("value")) {
                    av = new FFDCIgnoreValueArrayVisitor(av, this.methodInfo);
                }
                return av;
            }
        }

        private static final class FFDCIgnoreValueArrayVisitor
        extends AnnotationVisitor {
            private final MethodInfo methodInfo;

            private FFDCIgnoreValueArrayVisitor(AnnotationVisitor av, MethodInfo methodInfo) {
                super(ASMHelper.getCurrentASM(), av);
                this.methodInfo = methodInfo;
            }

            public void visit(String name, Object value) {
                if (value instanceof Type) {
                    this.methodInfo.addFFDCIgnoreException((Type)Type.class.cast(value));
                }
                super.visit(name, value);
            }
        }
    }
}

