/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.webcontainer60.osgi.response;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.request.IRequest;
import com.ibm.ws.webcontainer40.osgi.response.IResponse40Impl;
import com.ibm.wsspi.http.HttpCookie;
import com.ibm.wsspi.http.HttpInboundConnection;
import jakarta.servlet.http.Cookie;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;

public class IResponse60Impl
extends IResponse40Impl {
    private static final TraceComponent tc = Tr.register(IResponse60Impl.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    private Map<String, String> cookieAttrs;

    public IResponse60Impl(IRequest req, HttpInboundConnection connection) {
        super(req, connection);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("constructor , req [" + req + "] , inboundConnection [" + connection + "]"), (Object[])new Object[0]);
        }
    }

    public void addCookie(Cookie cookie) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addCookie , cookie [" + cookie.getName() + "] , this [" + this + "]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)cookie.toString(), (Object[])new Object[0]);
        }
        HttpCookie hc = super.addCookieHelper(cookie);
        this.cookieAttrs = cookie.getAttributes();
        ArrayList<String> preDefinedAttList = new ArrayList<String>(Arrays.asList("DOMAIN", "MAX-AGE", "PATH", "SECURE", "HTTPONLY"));
        if (this.cookieAttrs != null) {
            for (Map.Entry<String, String> entry : this.cookieAttrs.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (preDefinedAttList.contains(key.toUpperCase(Locale.ENGLISH))) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("addCookie , setAttribute (" + key + " , " + value + ")"), (Object[])new Object[0]);
                }
                hc.setAttribute(key, value);
            }
        }
        this.response.addCookie(hc);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addCookie " + cookie.getName()));
        }
    }
}

