/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.webcontainer60.osgi.container.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.container.service.config.ServletConfigurator;
import com.ibm.ws.javaee.dd.web.common.AttributeValue;
import com.ibm.ws.javaee.dd.web.common.CookieConfig;
import com.ibm.ws.javaee.dd.web.common.SessionConfig;
import com.ibm.ws.resource.ResourceRefConfigFactory;
import com.ibm.ws.webcontainer40.osgi.container.config.WebAppConfiguratorHelper40;
import io.openliberty.session.impl.SessionCookieConfigImpl60;
import jakarta.servlet.SessionCookieConfig;
import java.util.List;
import java.util.Map;

public class WebAppConfiguratorHelper60
extends WebAppConfiguratorHelper40 {
    private static final TraceComponent tc = Tr.register(WebAppConfiguratorHelper60.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.LShimMessages");

    public WebAppConfiguratorHelper60(ServletConfigurator configurator, ResourceRefConfigFactory resourceRefConfigFactory, List<Class<?>> listenerInterfaces) {
        super(configurator, resourceRefConfigFactory, listenerInterfaces);
        WebModuleInfo moduleInfo = (WebModuleInfo)configurator.getFromModuleCache(WebModuleInfo.class);
        String moduleName = moduleInfo.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WebAppConfiguratorHelper60 Constructor , web module--> " + moduleName), (Object[])new Object[0]);
        }
    }

    protected void configureSessionConfig(SessionConfig sessionConfig) {
        CookieConfig cookieConfig;
        if (sessionConfig == null) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"WebAppConfiguratorHelper60 configureSessionConfig", (Object[])new Object[]{""});
        }
        if ((cookieConfig = sessionConfig.getCookieConfig()) != null) {
            SessionCookieConfig sessionCookieConfigImpl = this.webAppConfiguration.getSessionCookieConfig();
            if (sessionCookieConfigImpl == null) {
                sessionCookieConfigImpl = new SessionCookieConfigImpl60();
                this.webAppConfiguration.setSessionCookieConfig(sessionCookieConfigImpl);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)" Created sessionCookieConfig [{0}]", (Object[])new Object[]{sessionCookieConfigImpl});
                }
            }
            super.configureSessionConfig(sessionConfig);
            Map sessionConfigItemMap = this.configurator.getConfigItemMap("session-config");
            List attributes = cookieConfig.getAttributes();
            if (attributes != null) {
                for (AttributeValue attribute : attributes) {
                    ServletConfigurator.ConfigItem existedAttValue;
                    String attName = attribute.getAttributeName();
                    String attValue = attribute.getAttributeValue();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)" configureSessionConfig , attribute name [{0}] , attribute value [{1}]", (Object[])new Object[]{attName, attValue});
                    }
                    if ((existedAttValue = (ServletConfigurator.ConfigItem)sessionConfigItemMap.get(attName)) == null) {
                        ((SessionCookieConfigImpl60)sessionCookieConfigImpl).setAttribute(attName, attValue, false);
                        sessionConfigItemMap.put(attName, this.createConfigItem(attValue));
                        continue;
                    }
                    this.validateDuplicateConfiguration("cookie-config", attName, attValue, existedAttValue);
                }
            }
        } else {
            super.configureSessionConfig(sessionConfig);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"configureSessionConfig");
        }
    }

    public void finish() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)" finish", (Object[])new Object[0]);
        }
        super.finish();
        this.webAppConfiguration.setSkipEncodedCharVerification();
    }
}

