/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry11.internal.rest;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import io.openliberty.microprofile.telemetry.internal.common.AgentDetection;
import io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryInfo;
import io.openliberty.microprofile.telemetry.internal.common.rest.AbstractTelemetryClientFilter;
import io.openliberty.microprofile.telemetry.internal.interfaces.OpenTelemetryAccessor;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.ext.Provider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@Provider
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TelemetryClientFilter
extends AbstractTelemetryClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private Instrumenter<ClientRequestContext, ClientResponseContext> instrumenter;
    private volatile boolean lazyCreate = false;
    private final AtomicReference<Instrumenter<ClientRequestContext, ClientResponseContext>> lazyInstrumenter = new AtomicReference();
    private final String configString = "otel.span.client.";
    private static final HttpClientAttributesGetterImpl HTTP_CLIENT_ATTRIBUTES_GETTER;
    static final long serialVersionUID = 6542451646919719674L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public TelemetryClientFilter() {
        if (!CheckpointPhase.getPhase().restored()) {
            this.lazyCreate = true;
        } else {
            this.instrumenter = this.createInstrumenter();
        }
    }

    private Instrumenter<ClientRequestContext, ClientResponseContext> getInstrumenter() {
        if (this.instrumenter != null) {
            return this.instrumenter;
        }
        if (this.lazyCreate) {
            this.instrumenter = this.lazyInstrumenter.updateAndGet(i -> {
                if (i == null) {
                    return this.createInstrumenter();
                }
                return i;
            });
            this.lazyCreate = false;
        }
        return this.instrumenter;
    }

    private Instrumenter<ClientRequestContext, ClientResponseContext> createInstrumenter() {
        OpenTelemetryInfo openTelemetryInfo = OpenTelemetryAccessor.getOpenTelemetryInfo();
        if (openTelemetryInfo.getEnabled() && !AgentDetection.isAgentActive()) {
            InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetryInfo.getOpenTelemetry(), (String)"Client filter", (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)HTTP_CLIENT_ATTRIBUTES_GETTER));
            Instrumenter result = builder.setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesGetter)HTTP_CLIENT_ATTRIBUTES_GETTER)).addAttributesExtractor(HttpClientAttributesExtractor.create((HttpClientAttributesGetter)HTTP_CLIENT_ATTRIBUTES_GETTER)).buildClientInstrumenter((TextMapSetter)new ClientRequestContextTextMapSetter());
            return result;
        }
        return null;
    }

    public void filter(final ClientRequestContext request) {
        final Instrumenter<ClientRequestContext, ClientResponseContext> currentInstrumenter = this.getInstrumenter();
        if (currentInstrumenter != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                static final long serialVersionUID = -1238461768409299591L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() {
                    Context parentContext = Context.current();
                    if (currentInstrumenter.shouldStart(parentContext, (Object)request)) {
                        Context spanContext = currentInstrumenter.start(parentContext, (Object)request);
                        request.setProperty("otel.span.client.context", (Object)spanContext);
                        request.setProperty("otel.span.client.parentContext", (Object)parentContext);
                    }
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry11.internal.rest.TelemetryClientFilter$1", 1.class, (String)"TELEMETRY", null);
                }
            });
        }
    }

    public void filter(final ClientRequestContext request, final ClientResponseContext response) {
        final Instrumenter<ClientRequestContext, ClientResponseContext> currentInstrumenter = this.getInstrumenter();
        if (currentInstrumenter != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){
                static final long serialVersionUID = 588167317961432179L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() {
                    Context spanContext = (Context)request.getProperty("otel.span.client.context");
                    if (spanContext == null) {
                        return null;
                    }
                    try {
                        currentInstrumenter.end(spanContext, (Object)request, (Object)response, null);
                    }
                    finally {
                        request.removeProperty("otel.span.client.context");
                        request.removeProperty("otel.span.client.parentContext");
                    }
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry11.internal.rest.TelemetryClientFilter$2", 2.class, (String)"TELEMETRY", null);
                }
            });
        }
    }

    public boolean isEnabled() {
        if (!CheckpointPhase.getPhase().restored()) {
            return true;
        }
        return this.getInstrumenter() != null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry11.internal.rest.TelemetryClientFilter", TelemetryClientFilter.class, (String)"TELEMETRY", null);
        HTTP_CLIENT_ATTRIBUTES_GETTER = new HttpClientAttributesGetterImpl();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class HttpClientAttributesGetterImpl
    implements HttpClientAttributesGetter<ClientRequestContext, ClientResponseContext> {
        static final long serialVersionUID = -1355886350595534811L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private HttpClientAttributesGetterImpl() {
        }

        public String getHttpRequestMethod(ClientRequestContext request) {
            return request.getMethod();
        }

        public Integer getHttpResponseStatusCode(ClientRequestContext request, ClientResponseContext response, Throwable error) {
            return response.getStatus();
        }

        public String getUrlFull(ClientRequestContext request) {
            return request.getUri().toString();
        }

        public List<String> getHttpRequestHeader(ClientRequestContext request, String name) {
            return (List)request.getStringHeaders().getOrDefault((Object)name, Collections.emptyList());
        }

        public List<String> getHttpResponseHeader(ClientRequestContext request, ClientResponseContext response, String name) {
            return (List)response.getHeaders().getOrDefault((Object)name, Collections.emptyList());
        }

        public String getServerAddress(ClientRequestContext request) {
            return request.getUri().getHost();
        }

        public Integer getServerPort(ClientRequestContext request) {
            return request.getUri().getPort();
        }

        public String getTransport(ClientRequestContext request, ClientResponseContext response) {
            return "ip_tcp";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry11.internal.rest.TelemetryClientFilter$HttpClientAttributesGetterImpl", HttpClientAttributesGetterImpl.class, (String)"TELEMETRY", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ClientRequestContextTextMapSetter
    implements TextMapSetter<ClientRequestContext> {
        static final long serialVersionUID = -1912801902110821065L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ClientRequestContextTextMapSetter() {
        }

        public void set(ClientRequestContext carrier, String key, String value) {
            if (carrier != null) {
                carrier.getHeaders().put((Object)key, Collections.singletonList(value));
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry11.internal.rest.TelemetryClientFilter$ClientRequestContextTextMapSetter", ClientRequestContextTextMapSetter.class, (String)"TELEMETRY", null);
        }
    }
}

