/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.http.channel.values;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.KeyMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class HttpHeaderKeys
extends HeaderKeys {
    private static final AtomicInteger NEXT_ORDINAL = new AtomicInteger(0);
    private static final List<HttpHeaderKeys> allKeys = new ArrayList<HttpHeaderKeys>(100);
    private static final KeyMatcher myMatcher = new KeyMatcher(false);
    public static final HttpHeaderKeys HDR_ACCEPT = new HttpHeaderKeys("Accept");
    public static final HttpHeaderKeys HDR_ACCEPT_ENCODING = new HttpHeaderKeys("Accept-Encoding");
    public static final HttpHeaderKeys HDR_ACCEPT_LANGUAGE = new HttpHeaderKeys("Accept-Language");
    public static final HttpHeaderKeys HDR_ACCEPT_CHARSET = new HttpHeaderKeys("Accept-Charset");
    public static final HttpHeaderKeys HDR_ACCEPT_RANGES = new HttpHeaderKeys("Accept-Ranges");
    public static final HttpHeaderKeys HDR_AGE = new HttpHeaderKeys("Age", true, true);
    public static final HttpHeaderKeys HDR_ALLOW = new HttpHeaderKeys("Allow");
    public static final HttpHeaderKeys HDR_AUTHORIZATION = new HttpHeaderKeys("Authorization", false, false);
    public static final HttpHeaderKeys HDR_ACCEPT_FEATURES = new HttpHeaderKeys("Accept-Features");
    public static final HttpHeaderKeys HDR_ALTERNATES = new HttpHeaderKeys("Alternates");
    public static final HttpHeaderKeys HDR_CONNECTION = new HttpHeaderKeys("Connection", true, true);
    public static final HttpHeaderKeys HDR_CONTENT_LENGTH = new HttpHeaderKeys("Content-Length", true, true);
    public static final HttpHeaderKeys HDR_CONTENT_TYPE = new HttpHeaderKeys("Content-Type");
    public static final HttpHeaderKeys HDR_CONTENT_ENCODING = new HttpHeaderKeys("Content-Encoding", true, true);
    public static final HttpHeaderKeys HDR_COOKIE = new HttpHeaderKeys("Cookie");
    public static final HttpHeaderKeys HDR_COOKIE2 = new HttpHeaderKeys("Cookie2");
    public static final HttpHeaderKeys HDR_CONTENT_LANGUAGE = new HttpHeaderKeys("Content-Language");
    public static final HttpHeaderKeys HDR_CACHE_CONTROL = new HttpHeaderKeys("Cache-Control");
    public static final HttpHeaderKeys HDR_CONTENT_DISPOSITION = new HttpHeaderKeys("Content-Disposition");
    public static final HttpHeaderKeys HDR_CONTENT_LOCATION = new HttpHeaderKeys("Content-Location");
    public static final HttpHeaderKeys HDR_CONTENT_MD5 = new HttpHeaderKeys("Content-MD5");
    public static final HttpHeaderKeys HDR_CONTENT_RANGE = new HttpHeaderKeys("Content-Range");
    public static final HttpHeaderKeys HDR_DATE = new HttpHeaderKeys("Date");
    public static final HttpHeaderKeys HDR_ETAG = new HttpHeaderKeys("ETag");
    public static final HttpHeaderKeys HDR_EXPECT = new HttpHeaderKeys("Expect", true, true);
    public static final HttpHeaderKeys HDR_EXPIRES = new HttpHeaderKeys("Expires");
    public static final HttpHeaderKeys HDR_FROM = new HttpHeaderKeys("From");
    public static final HttpHeaderKeys HDR_HOST = new HttpHeaderKeys("Host");
    public static final HttpHeaderKeys HDR_HTTP2_SETTINGS = new HttpHeaderKeys("HTTP2-Settings");
    public static final HttpHeaderKeys HDR_IF_MATCH = new HttpHeaderKeys("If-Match");
    public static final HttpHeaderKeys HDR_IF_MODIFIED_SINCE = new HttpHeaderKeys("If-Modified-Since");
    public static final HttpHeaderKeys HDR_IF_NONE_MATCH = new HttpHeaderKeys("If-None-Match");
    public static final HttpHeaderKeys HDR_IF_RANGE = new HttpHeaderKeys("If-Range");
    public static final HttpHeaderKeys HDR_IF_UNMODIFIED_SINCE = new HttpHeaderKeys("If-Unmodified-Since");
    public static final HttpHeaderKeys HDR_KEEP_ALIVE = new HttpHeaderKeys("Keep-Alive");
    public static final HttpHeaderKeys HDR_LOCATION = new HttpHeaderKeys("Location");
    public static final HttpHeaderKeys HDR_LAST_MODIFIED = new HttpHeaderKeys("Last-Modified");
    public static final HttpHeaderKeys HDR_MAX_FORWARDS = new HttpHeaderKeys("Max-Forwards", true, true);
    public static final HttpHeaderKeys HDR_NEGOTIATE = new HttpHeaderKeys("Negotiate");
    public static final HttpHeaderKeys HDR_PRAGMA = new HttpHeaderKeys("Pragma");
    public static final HttpHeaderKeys HDR_P3P = new HttpHeaderKeys("P3P");
    public static final HttpHeaderKeys HDR_PROXY_AUTHENTICATE = new HttpHeaderKeys("Proxy-Authenticate");
    public static final HttpHeaderKeys HDR_PROXY_AUTHORIZATION = new HttpHeaderKeys("Proxy-Authorization", false, false);
    public static final HttpHeaderKeys HDR_PROXY_CONNECTION = new HttpHeaderKeys("Proxy-Connection");
    public static final HttpHeaderKeys HDR_REFERER = new HttpHeaderKeys("Referer");
    public static final HttpHeaderKeys HDR_RANGE = new HttpHeaderKeys("Range");
    public static final HttpHeaderKeys HDR_RETRY_AFTER = new HttpHeaderKeys("Retry-After");
    public static final HttpHeaderKeys HDR_SERVER = new HttpHeaderKeys("Server");
    public static final HttpHeaderKeys HDR_SET_COOKIE = new HttpHeaderKeys("Set-Cookie");
    public static final HttpHeaderKeys HDR_SET_COOKIE2 = new HttpHeaderKeys("Set-Cookie2");
    public static final HttpHeaderKeys HDR_SOAPACTION = new HttpHeaderKeys("SOAPAction");
    public static final HttpHeaderKeys HDR_SURROGATE_CAPABILITY = new HttpHeaderKeys("Surrogate-Capability");
    public static final HttpHeaderKeys HDR_SURROGATE_CONTROL = new HttpHeaderKeys("Surrogate-Control");
    public static final HttpHeaderKeys HDR_TRANSFER_ENCODING = new HttpHeaderKeys("Transfer-Encoding", true, true);
    public static final HttpHeaderKeys HDR_TE = new HttpHeaderKeys("TE");
    public static final HttpHeaderKeys HDR_TRAILER = new HttpHeaderKeys("Trailer");
    public static final HttpHeaderKeys HDR_TCN = new HttpHeaderKeys("TCN");
    public static final HttpHeaderKeys HDR_USER_AGENT = new HttpHeaderKeys("User-Agent");
    public static final HttpHeaderKeys HDR_UPGRADE = new HttpHeaderKeys("Upgrade");
    public static final HttpHeaderKeys HDR_VARY = new HttpHeaderKeys("Vary");
    public static final HttpHeaderKeys HDR_VIA = new HttpHeaderKeys("Via");
    public static final HttpHeaderKeys HDR_VARIANT_VARY = new HttpHeaderKeys("Variant-Vary");
    public static final HttpHeaderKeys HDR_WARNING = new HttpHeaderKeys("Warning");
    public static final HttpHeaderKeys HDR_WWW_AUTHENTICATE = new HttpHeaderKeys("WWW-Authenticate");
    public static final HttpHeaderKeys HDR_$WSAT = new HttpHeaderKeys("$WSAT");
    public static final HttpHeaderKeys HDR_$WSCC = new HttpHeaderKeys("$WSCC");
    public static final HttpHeaderKeys HDR_$WSCS = new HttpHeaderKeys("$WSCS");
    public static final HttpHeaderKeys HDR_$WSIS = new HttpHeaderKeys("$WSIS");
    public static final HttpHeaderKeys HDR_$WSSC = new HttpHeaderKeys("$WSSC");
    public static final HttpHeaderKeys HDR_$WSPR = new HttpHeaderKeys("$WSPR");
    public static final HttpHeaderKeys HDR_$WSRA = new HttpHeaderKeys("$WSRA");
    public static final HttpHeaderKeys HDR_$WSRH = new HttpHeaderKeys("$WSRH");
    public static final HttpHeaderKeys HDR_$WSRU = new HttpHeaderKeys("$WSRU");
    public static final HttpHeaderKeys HDR_$WSSN = new HttpHeaderKeys("$WSSN");
    public static final HttpHeaderKeys HDR_$WSSP = new HttpHeaderKeys("$WSSP");
    public static final HttpHeaderKeys HDR_$WSSI = new HttpHeaderKeys("$WSSI");
    public static final HttpHeaderKeys HDR_$WSZIP = new HttpHeaderKeys("$WSZIP");
    public static final HttpHeaderKeys HDR_$WSPT = new HttpHeaderKeys("$WSPT");
    public static final HttpHeaderKeys HDR_$WSEP = new HttpHeaderKeys("$WSEP");
    public static final HttpHeaderKeys HDR_PMIRM_CORRELATOR = new HttpHeaderKeys("rmcorrelator");
    public static final HttpHeaderKeys HDR_PARTITION_VERSION = new HttpHeaderKeys("_WS_HAPRT_WLMVERSION");
    public static final HttpHeaderKeys HDR_UA_CPU = new HttpHeaderKeys("UA-CPU");
    public static final HttpHeaderKeys HDR_ARM_CORRELATOR = new HttpHeaderKeys("ARM_CORRELATOR");
    public static final HttpHeaderKeys HDR_$WSATO = new HttpHeaderKeys("$WSATO");
    public static final HttpHeaderKeys HDR_$WSORIGCL = new HttpHeaderKeys("$WSORIGCL");
    public static final HttpHeaderKeys HDR_MIME_VERSION = new HttpHeaderKeys("MIME-Version");
    public static final HttpHeaderKeys HDR_CONTENT_TRANSFER_ENCODING = new HttpHeaderKeys("Content-Transfer-Encoding");
    public static final HttpHeaderKeys HDR_CONTENT_ID = new HttpHeaderKeys("Content-ID");
    public static final HttpHeaderKeys HDR_CONTENT_DESCRIPTION = new HttpHeaderKeys("Content-Description");
    public static final HttpHeaderKeys HDR_ZOS_TRAN_XID = new HttpHeaderKeys("ZOS_TRAN_XID");
    public static final HttpHeaderKeys HDR_$WSPC = new HttpHeaderKeys("$WSPC");
    public static final HttpHeaderKeys HDR_$WSODRINFO = new HttpHeaderKeys("$WSODRINFO");
    public static final HttpHeaderKeys HDR_EDGE_CONTROL = new HttpHeaderKeys("Edge-control");
    public static final HttpHeaderKeys HDR_X_FORWARDED_PROTO = new HttpHeaderKeys("X-Forwarded-Proto");
    public static final HttpHeaderKeys HDR_$WSFO = new HttpHeaderKeys("$WSFO");
    public static final HttpHeaderKeys HDR_HSTS = new HttpHeaderKeys("Strict-Transport-Security");
    public static final HttpHeaderKeys HDR_AUTHORIZATION_ENCODING = new HttpHeaderKeys("Authorization-Encoding");
    public static final HttpHeaderKeys HDR_ORIGIN = new HttpHeaderKeys("Origin");
    public static final int ORD_MAX = 1024;
    private static final HashSet<String> sensitiveHeaderList = new HashSet<String>(Arrays.asList(HDR_$WSCC.getName(), HDR_$WSRA.getName(), HDR_$WSRH.getName(), HDR_$WSAT.getName(), HDR_$WSRU.getName()));
    private static final HashSet<String> privateHeaderList = new HashSet<String>(Arrays.asList(HDR_$WSAT.getName(), HDR_$WSCC.getName(), HDR_$WSCS.getName(), HDR_$WSIS.getName(), HDR_$WSSC.getName(), HDR_$WSPR.getName(), HDR_$WSRA.getName(), HDR_$WSRH.getName(), HDR_$WSRU.getName(), HDR_$WSSN.getName(), HDR_$WSSP.getName(), HDR_$WSSI.getName(), HDR_$WSZIP.getName(), HDR_$WSEP.getName(), HDR_$WSPT.getName(), HDR_$WSATO.getName(), HDR_$WSORIGCL.getName(), HDR_$WSPC.getName(), HDR_$WSODRINFO.getName(), HDR_$WSFO.getName()));

    private HttpHeaderKeys(String name) {
        super(name, HttpHeaderKeys.generateNextOrdinal());
        if (NEXT_ORDINAL.get() <= 1024) {
            allKeys.add(this);
            myMatcher.add(this);
        }
    }

    private HttpHeaderKeys(String name, boolean undefined) {
        super(name, HttpHeaderKeys.generateNextOrdinal());
        this.setUndefined(undefined);
        if (NEXT_ORDINAL.get() <= 1024) {
            allKeys.add(this);
            myMatcher.add(this);
        }
    }

    private HttpHeaderKeys(String name, boolean shouldLog, boolean shouldFilter) {
        super(name, HttpHeaderKeys.generateNextOrdinal());
        super.setShouldLogValue(shouldLog);
        super.setUseFilters(shouldFilter);
        if (NEXT_ORDINAL.get() <= 1024) {
            allKeys.add(this);
            myMatcher.add(this);
        }
    }

    @Override
    public Object getEnumByOrdinal(int i) {
        return allKeys.get(i);
    }

    public static HttpHeaderKeys match(String name, int offset, int length) {
        if (null == name) {
            return null;
        }
        return (HttpHeaderKeys)myMatcher.match(name, offset, length);
    }

    public static HttpHeaderKeys match(byte[] name, int offset, int length) {
        if (null == name) {
            return null;
        }
        return (HttpHeaderKeys)myMatcher.match(name, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpHeaderKeys find(byte[] name, int offset, int length, boolean returnNullForInvalidName) {
        HttpHeaderKeys key = (HttpHeaderKeys)myMatcher.match(name, offset, length);
        if (null != key) return key;
        Class<HttpHeaderKeys> clazz = HttpHeaderKeys.class;
        synchronized (HttpHeaderKeys.class) {
            key = (HttpHeaderKeys)myMatcher.match(name, offset, length);
            if (null != key) return key;
            String headerName = new String(name, offset, length);
            if (!HttpHeaderKeys.validateHeaderName(headerName, returnNullForInvalidName)) return key;
            return new HttpHeaderKeys(headerName, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpHeaderKeys find(String name, boolean returnNullForInvalidName) {
        HttpHeaderKeys key = (HttpHeaderKeys)myMatcher.match(name, 0, name.length());
        if (null != key) return key;
        Class<HttpHeaderKeys> clazz = HttpHeaderKeys.class;
        synchronized (HttpHeaderKeys.class) {
            key = (HttpHeaderKeys)myMatcher.match(name, 0, name.length());
            if (null != key) return key;
            if (!HttpHeaderKeys.validateHeaderName(name, returnNullForInvalidName)) return key;
            return new HttpHeaderKeys(name, true);
        }
    }

    private static boolean validateHeaderName(String name, boolean returnFalseForInvalidName) {
        int size = name.length();
        for (int i = 0; i < size; ++i) {
            char c = name.charAt(i);
            if (HttpHeaderKeys.isValidTchar(c)) continue;
            if (returnFalseForInvalidName) {
                return false;
            }
            IllegalArgumentException iae = new IllegalArgumentException("Header name contained an invalid character " + i);
            FFDCFilter.processException((Throwable)iae, (String)(HttpHeaderKeys.class.getName() + ".validateHeaderName(String)"), (String)"1", (Object)name);
            throw iae;
        }
        return true;
    }

    public static boolean isValidTchar(char c) {
        boolean valid = c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '!' || c == '#' || c == '$' || c == '%' || c == '&' || c == '\'' || c == '*' || c == '+' || c == '-' || c == '.' || c == '^' || c == '_' || c == '`' || c == '|' || c == '~';
        return valid;
    }

    public static boolean isSensitivePrivateHeader(String headerName) {
        if (headerName == null) {
            return false;
        }
        return headerName.length() > 0 && headerName.charAt(0) == '$' && sensitiveHeaderList.contains(headerName);
    }

    public static boolean isWasPrivateHeader(String headerName) {
        if (headerName == null) {
            return false;
        }
        return headerName.length() > 0 && headerName.charAt(0) == '$' && privateHeaderList.contains(headerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int generateNextOrdinal() {
        Class<HttpHeaderKeys> clazz = HttpHeaderKeys.class;
        synchronized (HttpHeaderKeys.class) {
            if (Integer.MAX_VALUE == NEXT_ORDINAL.get()) {
                NEXT_ORDINAL.set(1024);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return NEXT_ORDINAL.getAndIncrement();
        }
    }
}

