/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.custom.jdbc.impl;

import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.util.Utils;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLNonTransactionalDataSource;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLRetriableLog;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLRetry;
import com.ibm.ws.recoverylog.spi.CustomLogProperties;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LeaseInfo;
import com.ibm.ws.recoverylog.spi.LeaseLogImpl;
import com.ibm.ws.recoverylog.spi.PeerLeaseData;
import com.ibm.ws.recoverylog.spi.PeerLeaseTable;
import com.ibm.ws.recoverylog.spi.RecoveryFailedException;
import com.ibm.ws.recoverylog.spi.SharedServerLeaseLog;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import jakarta.resource.spi.ResourceAllocationException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.DataSource;

public class SQLSharedServerLeaseLog
extends LeaseLogImpl
implements SharedServerLeaseLog,
SQLRetriableLog {
    private static final TraceComponent tc = Tr.register(SQLSharedServerLeaseLog.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private DataSource _theDS;
    private final CustomLogProperties _customLogProperties;
    boolean _determineDBType;
    private volatile boolean _isOracle;
    private volatile boolean _isPostgreSQL;
    private volatile boolean _isSQLServer;
    private volatile boolean _isDB2;
    private volatile boolean _isNonStandard;
    private volatile boolean _leaseTableExists;
    private boolean _sqlTransientErrorHandlingEnabled = true;
    private boolean _logRetriesEnabled;
    private int _leaseTimeout;
    private final String _leaseTableName = "WAS_LEASES_LOG";
    private boolean isolationFailureReported;
    private final String genericTablePreString = "CREATE TABLE ";
    private final String genericTablePostString = "( SERVER_IDENTITY VARCHAR(128) NOT NULL UNIQUE, RECOVERY_GROUP VARCHAR(128), LEASE_OWNER VARCHAR(128), LEASE_TIME BIGINT) ";
    private final String oracleTablePreString = "CREATE TABLE ";
    private final String oracleTablePostString = "( SERVER_IDENTITY VARCHAR(128) NOT NULL UNIQUE, RECOVERY_GROUP VARCHAR(128), LEASE_OWNER VARCHAR(128), LEASE_TIME NUMBER(19)) ";
    private final String postgreSQLTablePreString = "CREATE TABLE ";
    private final String postgreSQLTablePostString = "( SERVER_IDENTITY VARCHAR (128) UNIQUE NOT NULL, RECOVERY_GROUP VARCHAR (128) NOT NULL, LEASE_OWNER VARCHAR (128) NOT NULL, LEASE_TIME BIGINT);";
    private static final Object _CreateTableLock = new Object();
    private ResultSet _updatelockingRS;
    private Statement _lockingStmt;
    private Statement _deleteStmt;
    private Statement _peerLockingStmt;
    private ResultSet _peerLockingRS;
    private Statement _claimPeerlockingStmt;
    private PreparedStatement _claimPeerUpdateStmt;
    private ResultSet _claimPeerLockingRS;

    public SQLSharedServerLeaseLog(CustomLogProperties logProperties) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SQLSharedServerStatusLog", (Object[])new Object[]{logProperties, this});
        }
        this._customLogProperties = logProperties;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SQLSharedServerStatusLog", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={SQLException.class, SQLRecoverableException.class})
    public synchronized void getLeasesForPeers(PeerLeaseTable peerLeaseTable, String recoveryGroup) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLeasesForPeers", (Object[])new Object[]{recoveryGroup, this});
        }
        boolean getPeerSuccess = false;
        Throwable nonTransientException = null;
        SQLException currentSqlEx = null;
        if (FrameworkState.isStopping()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getLeasesForPeers", (Object)"server stopping");
            }
            return;
        }
        Connection conn = null;
        try {
            conn = this.getConnection();
            if (conn == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getLeasesForPeers", (Object)"Null connection InternalLogException");
                }
                throw new InternalLogException("Failed to get JDBC Connection", null);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Set autocommit FALSE on the connection", (Object[])new Object[0]);
            }
            conn.setAutoCommit(false);
            this.getPeerLeasesFromTable(peerLeaseTable, recoveryGroup, conn);
            conn.commit();
            getPeerSuccess = true;
        }
        catch (SQLException sqlex) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The server is stopping, lease retrieval failed with exception: " + sqlex), (Object[])new Object[0]);
                }
            } else {
                Tr.audit((TraceComponent)tc, (String)("WTRN0107W: Caught SQLException when retrieving peer leases, exc: " + sqlex), (Object[])new Object[0]);
            }
            currentSqlEx = sqlex;
        }
        catch (Throwable exc) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The server is stopping, lease retrieval failed with exception: " + exc), (Object[])new Object[0]);
                }
            } else {
                Tr.audit((TraceComponent)tc, (String)("WTRN0107W: Caught non-SQLException Throwable when retrieving peer leases, exc: " + exc), (Object[])new Object[0]);
            }
            nonTransientException = exc;
        }
        finally {
            if (!getPeerSuccess) {
                try {
                    if (this._peerLockingRS != null && !this._peerLockingRS.isClosed()) {
                        this._peerLockingRS.close();
                    }
                    if (this._peerLockingStmt != null && !this._peerLockingStmt.isClosed()) {
                        this._peerLockingStmt.close();
                    }
                    if (conn != null) {
                        conn.rollback();
                        conn.close();
                    }
                }
                catch (Throwable exc) {
                    if (FrameworkState.isStopping()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("The server is stopping. Tidy up failed, after lease retrieval failure, with exception: " + exc), (Object[])new Object[0]);
                        }
                    }
                    Tr.audit((TraceComponent)tc, (String)("WTRN0107W: Tidy up failed, after lease retrieval failure, with exception: " + exc), (Object[])new Object[0]);
                }
                if (FrameworkState.isStopping()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getLeasesForPeers", (Object)"server stopping");
                    }
                    return;
                }
                boolean failAndReport = true;
                if (currentSqlEx != null) {
                    nonTransientException = currentSqlEx;
                    GetPeerLeaseRetry getPeerLeaseRetry = new GetPeerLeaseRetry(peerLeaseTable, recoveryGroup);
                    getPeerLeaseRetry.setNonTransientException(currentSqlEx);
                    if (this._sqlTransientErrorHandlingEnabled && (failAndReport = getPeerLeaseRetry.retryAfterSQLException(this, currentSqlEx, SQLRetry.getLightweightRetryAttempts(), SQLRetry.getLightweightRetrySleepTime()))) {
                        nonTransientException = getPeerLeaseRetry.getNonTransientException();
                    }
                }
                if (failAndReport) {
                    Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Cannot recover from SQLException when retrieving server leases for recoverygroup " + recoveryGroup + " Exception: " + nonTransientException), (Object[])new Object[0]);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getLeasesForPeers", (Object)"InternalLogException");
                    }
                    throw new InternalLogException(nonTransientException);
                }
                Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Have recovered from SQLException when retrieving server leases for recoverygroup " + recoveryGroup), (Object[])new Object[0]);
            }
            if (this._peerLockingRS != null && !this._peerLockingRS.isClosed()) {
                this._peerLockingRS.close();
            }
            if (this._peerLockingStmt != null && !this._peerLockingStmt.isClosed()) {
                this._peerLockingStmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLeasesForPeers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPeerLeasesFromTable(PeerLeaseTable peerLeaseTable, String recoveryGroup, Connection conn) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPeerLeasesFromTable", (Object[])new Object[]{recoveryGroup, conn, this});
        }
        peerLeaseTable.clear();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"create a statement", (Object[])new Object[0]);
        }
        this._peerLockingStmt = conn.createStatement();
        if (recoveryGroup == null) {
            recoveryGroup = "";
        }
        boolean newTable = true;
        Exception currentEx = null;
        Object object = _CreateTableLock;
        synchronized (object) {
            try {
                String queryString = "SELECT SERVER_IDENTITY, LEASE_TIME FROM WAS_LEASES_LOG WHERE RECOVERY_GROUP = '" + recoveryGroup + "'";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Attempt to select from the lease table - " + queryString), (Object[])new Object[0]);
                }
                this._peerLockingRS = this._peerLockingStmt.executeQuery(queryString);
                newTable = false;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Query failed with exception: " + e), (Object[])new Object[0]);
                }
                currentEx = e;
                if (!this._leaseTableExists) {
                    try {
                        this.createLeaseTable(conn);
                        conn.commit();
                        newTable = true;
                    }
                    catch (Exception ine) {
                        Tr.audit((TraceComponent)tc, (String)("WTRN0107W: In response to an error, attempted to create lease table but caught Exception: " + ine), (Object[])new Object[0]);
                        throw currentEx;
                    }
                }
                throw currentEx;
            }
            this._leaseTableExists = true;
        }
        if (newTable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Table Creation succeeded", (Object[])new Object[0]);
            }
        } else {
            while (this._peerLockingRS.next()) {
                String recoveryId = this._peerLockingRS.getString(1);
                long leaseTime = this._peerLockingRS.getLong(2);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Lease Table: read recoveryId: " + recoveryId), (Object[])new Object[0]);
                    Tr.event((TraceComponent)tc, (String)("Lease Table: read leaseTime: " + Utils.traceTime((long)leaseTime)), (Object[])new Object[0]);
                }
                PeerLeaseData pld = new PeerLeaseData(recoveryId, leaseTime, this._leaseTimeout);
                peerLeaseTable.addPeerEntry(pld);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPeerLeasesFromTable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={SQLException.class, SQLRecoverableException.class})
    public synchronized void updateServerLease(String recoveryIdentity, String recoveryGroup, boolean isServerStartup) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateServerLease", (Object[])new Object[]{recoveryIdentity, recoveryGroup, isServerStartup, this});
        }
        boolean updateSuccess = false;
        Connection conn = null;
        this._updatelockingRS = null;
        Throwable nonTransientException = null;
        SQLException currentSqlEx = null;
        if (FrameworkState.isStopping()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"updateServerLease", (Object)"server stopping");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Work with recoveryIdentity - ", (Object[])new Object[]{recoveryIdentity});
        }
        if (recoveryGroup == null) {
            recoveryGroup = "";
        }
        try {
            conn = this.getConnection();
            if (conn == null) {
                if (!FrameworkState.isStopping()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"updateServerLease", (Object)"Null connection InternalLogException");
                    }
                    throw new InternalLogException("Failed to get JDBC Connection", null);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"updateServerLease", (Object)"null connection");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Set autocommit FALSE on the connection", (Object[])new Object[0]);
            }
            conn.setAutoCommit(false);
            boolean newTable = this.queryLeaseTable(recoveryIdentity, conn, isServerStartup);
            if (FrameworkState.isStopping()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"updateServerLease", (Object)this);
                }
                return;
            }
            boolean needInsert = true;
            if (!newTable) {
                needInsert = this.updateLeaseTable(recoveryIdentity, recoveryGroup, conn, isServerStartup);
            }
            if (needInsert) {
                if (!FrameworkState.isStopping()) {
                    this.insertNewLease(recoveryIdentity, recoveryGroup, conn);
                } else {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"updateServerLease", (Object)"skip insert server is stopping");
                    }
                    return;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"COMMIT the change", (Object[])new Object[0]);
            }
            conn.commit();
            updateSuccess = true;
        }
        catch (SQLException sqlex) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The server is stopping, lease update failed with exception: " + sqlex), (Object[])new Object[0]);
                }
            } else {
                Tr.audit((TraceComponent)tc, (String)("WTRN0107W: Caught SQLException when updating server lease, exc: " + sqlex), (Object[])new Object[0]);
            }
            currentSqlEx = sqlex;
        }
        catch (Throwable exc) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The server is stopping, lease update failed with exception: " + exc), (Object[])new Object[0]);
                }
            } else {
                Tr.audit((TraceComponent)tc, (String)("WTRN0107W: Caught non-SQLException Throwable when updating server lease, exception: " + exc), (Object[])new Object[0]);
            }
            nonTransientException = exc;
        }
        finally {
            if (!updateSuccess) {
                try {
                    if (this._updatelockingRS != null && !this._updatelockingRS.isClosed()) {
                        this._updatelockingRS.close();
                    }
                    if (this._lockingStmt != null && !this._lockingStmt.isClosed()) {
                        this._lockingStmt.close();
                    }
                    if (conn != null) {
                        conn.rollback();
                        conn.close();
                    }
                }
                catch (Throwable exc) {
                    if (FrameworkState.isStopping()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("The server is stopping. Tidy up failed, after lease update failure, with exception: " + exc), (Object[])new Object[0]);
                        }
                    }
                    Tr.audit((TraceComponent)tc, (String)("WTRN0107W: Tidy up failed, after lease update failure, with exception: " + exc), (Object[])new Object[0]);
                }
                if (FrameworkState.isStopping()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"updateServerLease", (Object)"server stopping");
                    }
                    return;
                }
                boolean failAndReport = true;
                if (currentSqlEx != null) {
                    nonTransientException = currentSqlEx;
                    UpdateServerLeaseRetry updateServerLeaseRetry = new UpdateServerLeaseRetry(recoveryIdentity, recoveryGroup, isServerStartup);
                    updateServerLeaseRetry.setNonTransientException(currentSqlEx);
                    if (this._sqlTransientErrorHandlingEnabled && (failAndReport = updateServerLeaseRetry.retryAfterSQLException(this, currentSqlEx, SQLRetry.getTransientRetryAttempts(), SQLRetry.getTransientRetrySleepTime()))) {
                        nonTransientException = updateServerLeaseRetry.getNonTransientException();
                    }
                }
                if (failAndReport) {
                    Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Cannot recover from SQLException when updating server lease for server with identity " + recoveryIdentity + " Exception: " + nonTransientException), (Object[])new Object[0]);
                    if (nonTransientException instanceof RecoveryFailedException) {
                        RecoveryFailedException rex = (RecoveryFailedException)nonTransientException;
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"updateServerLease", (Object)"RecoveryFailedException");
                        }
                        throw rex;
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"updateServerLease", (Object)"InternalLogException");
                    }
                    throw new InternalLogException(nonTransientException);
                }
                Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Have recovered from SQLException when updating server lease for server with identity " + recoveryIdentity), (Object[])new Object[0]);
            }
            if (this._updatelockingRS != null && !this._updatelockingRS.isClosed()) {
                this._updatelockingRS.close();
            }
            if (this._lockingStmt != null && !this._lockingStmt.isClosed()) {
                this._lockingStmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateServerLease");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queryLeaseTable(String recoveryIdentity, Connection conn, boolean isServerStartup) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"queryLeaseTable", (Object[])new Object[]{recoveryIdentity, conn, this._updatelockingRS, isServerStartup, this});
        }
        boolean newTable = true;
        Exception currentEx = null;
        this._lockingStmt = conn.createStatement();
        try {
            String queryString = "SELECT LEASE_TIME, LEASE_OWNER FROM WAS_LEASES_LOG" + (this._isSQLServer ? " WITH (ROWLOCK, UPDLOCK, HOLDLOCK)" : "") + " WHERE SERVER_IDENTITY='" + recoveryIdentity + "'" + (this._isSQLServer ? "" : " FOR UPDATE") + (this._isPostgreSQL || this._isSQLServer ? "" : " OF LEASE_TIME");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Attempt to select the row for UPDATE using - " + queryString), (Object[])new Object[0]);
            }
            this._updatelockingRS = this._lockingStmt.executeQuery(queryString);
            newTable = false;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Query failed with exception: " + e), (Object[])new Object[0]);
            }
            currentEx = e;
        }
        if (currentEx != null) {
            if (!FrameworkState.isStopping()) {
                if (isServerStartup && !this._leaseTableExists) {
                    Object object = _CreateTableLock;
                    synchronized (object) {
                        try {
                            Tr.audit((TraceComponent)tc, (String)"WTRN0108I: Create Shared Lease Table", (Object[])new Object[0]);
                            this.createLeaseTable(conn);
                            conn.commit();
                            newTable = true;
                        }
                        catch (Exception ine) {
                            Tr.audit((TraceComponent)tc, (String)("WTRN0107W: In response to an error, attempted to create lease table but caught Exception: " + ine), (Object[])new Object[0]);
                            throw currentEx;
                        }
                        this._leaseTableExists = true;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Lease select update failed with exception: " + currentEx), (Object[])new Object[0]);
                }
                throw currentEx;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Lease select update failed but server is stopping, exception: " + currentEx), (Object[])new Object[0]);
            }
        } else {
            this._leaseTableExists = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"queryLeaseTable", (Object)newTable);
        }
        return newTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateLeaseTable(String recoveryIdentity, String recoveryGroup, Connection conn, boolean isServerStartup) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateLeaseTable", (Object[])new Object[]{recoveryIdentity, recoveryGroup, conn, this._updatelockingRS, isServerStartup, this});
        }
        boolean needInsert = true;
        Statement updateStmt = null;
        try {
            if (this._updatelockingRS.next()) {
                int commaPos;
                long storedLease = this._updatelockingRS.getLong(1);
                String storedLeaseOwner = "";
                String columnString = this._updatelockingRS.getString(2);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Lease_owner column contained " + columnString), (Object[])new Object[0]);
                }
                storedLeaseOwner = (commaPos = columnString.indexOf(",")) > 0 ? columnString.substring(0, commaPos) : columnString;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Acquired lock row, stored lease value is: " + Utils.traceTime((long)storedLease) + ", stored owner is: " + storedLeaseOwner), (Object[])new Object[0]);
                }
                if (isServerStartup) {
                    PeerLeaseData pld = new PeerLeaseData(recoveryIdentity, storedLease, this._leaseTimeout);
                    if (pld.isExpired()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Lease has expired, we should update lease and recover", (Object[])new Object[0]);
                        }
                    } else if (!storedLeaseOwner.equals(recoveryIdentity)) {
                        if (ConfigurationProviderManager.getConfigurationProvider().peerRecoveryPrecedence()) {
                            String dbg = storedLeaseOwner + " is recovering our logs and the peerRecoveryPrcedence flag has been set, we will fail our recovery";
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)dbg, (Object[])new Object[0]);
                            }
                            RecoveryFailedException rex = new RecoveryFailedException(dbg);
                            throw rex;
                        }
                        String dbg = storedLeaseOwner + " is recovering our logs. But we will update the lease and aggressively take over recovery";
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)dbg, (Object[])new Object[0]);
                        }
                    }
                }
                String updateString = "UPDATE WAS_LEASES_LOG SET LEASE_TIME = ?, RECOVERY_GROUP = ?, LEASE_OWNER = ? WHERE SERVER_IDENTITY='" + recoveryIdentity + "'";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("update lease for " + recoveryIdentity), (Object[])new Object[0]);
                }
                updateStmt = conn.prepareStatement(updateString);
                long fir1 = System.currentTimeMillis();
                updateStmt.setLong(1, fir1);
                updateStmt.setString(2, recoveryGroup);
                columnString = recoveryIdentity + "," + this.getBackendURL();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Update combined string " + columnString + " into LEASE_OWNER column"), (Object[])new Object[0]);
                }
                updateStmt.setString(3, columnString);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Ready to UPDATE using string - " + updateString + " and time: " + Utils.traceTime((long)fir1)), (Object[])new Object[0]);
                }
                int ret = updateStmt.executeUpdate();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Have updated Server row with return: " + ret), (Object[])new Object[0]);
                }
                needInsert = false;
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not find row", (Object[])new Object[0]);
            }
        }
        finally {
            if (updateStmt != null && !updateStmt.isClosed()) {
                updateStmt.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateLeaseTable", (Object)needInsert);
        }
        return needInsert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNewLease(String recoveryIdentity, String recoveryGroup, Connection conn) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"insertNewLease", (Object[])new Object[]{this});
        }
        String insertString = "INSERT INTO WAS_LEASES_LOG (SERVER_IDENTITY, RECOVERY_GROUP, LEASE_OWNER, LEASE_TIME) VALUES (?,?,?,?)";
        Statement specStatement = null;
        long fir1 = System.currentTimeMillis();
        Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Insert New Lease for server with recovery identity " + recoveryIdentity), (Object[])new Object[0]);
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Need to setup new row using - " + insertString + ", and time: " + Utils.traceTime((long)fir1)), (Object[])new Object[0]);
            }
            specStatement = conn.prepareStatement(insertString);
            specStatement.setString(1, recoveryIdentity);
            specStatement.setString(2, recoveryGroup);
            String columnString = recoveryIdentity + "," + this.getBackendURL();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Insert combined string " + columnString + " into LEASE_OWNER column"), (Object[])new Object[0]);
            }
            specStatement.setString(3, columnString);
            specStatement.setLong(4, fir1);
            int ret = specStatement.executeUpdate();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Have inserted Server row with return: " + ret), (Object[])new Object[0]);
            }
        }
        finally {
            if (specStatement != null && !specStatement.isClosed()) {
                specStatement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"insertNewLease");
        }
    }

    private DataSource getDataSourceFromProperties() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDataSourceFromProperties", (Object[])new Object[]{this});
        }
        DataSource dataSource = null;
        Properties internalLogProperties = this._customLogProperties.properties();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Recovery log internal properties are " + internalLogProperties), (Object[])new Object[0]);
        }
        String fullLogDirectory = internalLogProperties.getProperty("LOG_DIRECTORY");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("fullLogDirectory = " + fullLogDirectory), (Object[])new Object[0]);
        }
        StringTokenizer st = new StringTokenizer(fullLogDirectory, "?");
        String cname = st.nextToken();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cname = " + cname), (Object[])new Object[0]);
        }
        Properties dbStringProps = new Properties();
        String dbPropertiesString = st.nextToken();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dbPropertiesString = " + dbPropertiesString), (Object[])new Object[0]);
        }
        dbStringProps.load(new StringReader(dbPropertiesString.replace(',', '\n')));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dbStringProps = " + dbStringProps), (Object[])new Object[0]);
        }
        String dsName = dbStringProps.getProperty("datasource");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Extracted Data Source name = " + dsName), (Object[])new Object[0]);
        }
        SQLNonTransactionalDataSource sqlNonTranDS = new SQLNonTransactionalDataSource(dsName, this._customLogProperties);
        dataSource = sqlNonTranDS.getDataSource();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDataSourceFromProperties", (Object)dataSource);
        }
        return dataSource;
    }

    @Override
    public Connection getConnection() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConnection", (Object[])new Object[]{this});
        }
        Connection conn = null;
        boolean retryOnRAExc = false;
        if (ConfigurationProviderManager.getConfigurationProvider().enableLogRetries()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Set the logRetriesEnabled flag to true", (Object[])new Object[0]);
            }
            this._logRetriesEnabled = true;
            SQLRetry.setLogRetriesEnabled(true);
            this._sqlTransientErrorHandlingEnabled = true;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Set the logRetriesEnabled flag to false", (Object[])new Object[0]);
            }
            if (this._logRetriesEnabled && this._isNonStandard) {
                this._sqlTransientErrorHandlingEnabled = false;
            }
            this._logRetriesEnabled = false;
            SQLRetry.setLogRetriesEnabled(false);
        }
        if (this._theDS == null) {
            this._theDS = this.getDataSourceFromProperties();
        }
        try {
            if (this._theDS != null) {
                conn = this._theDS.getConnection();
            }
        }
        catch (SQLException sqlex) {
            Throwable cause = sqlex.getCause();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught SQLException with cause: " + cause), (Object[])new Object[0]);
            }
            if (cause instanceof ResourceAllocationException) {
                retryOnRAExc = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getConnection", (Object)"SQLException");
            }
            throw sqlex;
        }
        if (retryOnRAExc) {
            this._theDS = this.getDataSourceFromProperties();
            try {
                if (this._theDS != null) {
                    conn = this._theDS.getConnection();
                    Tr.audit((TraceComponent)tc, (String)"WTRN0108I: Have recovered from ResourceAllocationException in connection to SQL Lease Log", (Object[])new Object[0]);
                }
            }
            catch (Throwable exc) {
                SQLException newsqlex = exc instanceof SQLException ? (SQLException)exc : new SQLException(exc);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getConnection", (Object)"new SQLException");
                }
                throw newsqlex;
            }
        }
        if (conn != null && !this._determineDBType) {
            String dbName;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got connection: " + conn), (Object[])new Object[0]);
            }
            DatabaseMetaData mdata = conn.getMetaData();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got metadata: " + mdata), (Object[])new Object[0]);
            }
            if ((dbName = mdata.getDatabaseProductName()).toLowerCase().contains("oracle")) {
                this._isOracle = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"This is an Oracle Database", (Object[])new Object[0]);
                }
            } else if (dbName.toLowerCase().contains("postgresql")) {
                this._isPostgreSQL = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"This is a PostgreSQL Database", (Object[])new Object[0]);
                }
            } else if (dbName.toLowerCase().contains("db2")) {
                this._isDB2 = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"This is a DB2 Database", (Object[])new Object[0]);
                }
            } else if (dbName.toLowerCase().contains("microsoft sql")) {
                this._isSQLServer = true;
                int tranIsolation = mdata.getDefaultTransactionIsolation();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("This is a Microsoft SQL Server Database with default isolation - " + tranIsolation), (Object[])new Object[0]);
                }
            } else if (dbName.toLowerCase().contains("derby")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"This is a Derby Database", (Object[])new Object[0]);
                }
            } else {
                this._isNonStandard = true;
                if (!this._logRetriesEnabled) {
                    this._sqlTransientErrorHandlingEnabled = false;
                }
            }
            String dbVersion = mdata.getDatabaseProductVersion();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("You are now connected to " + dbName + ", version " + dbVersion), (Object[])new Object[0]);
            }
            this._determineDBType = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConnection", (Object)conn);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLeaseTable(Connection conn) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createLeaseTable", (Object[])new Object[]{conn, this});
        }
        Statement createTableStmt = null;
        try {
            createTableStmt = conn.createStatement();
            if (this._isOracle) {
                String oracleTableString = "CREATE TABLE WAS_LEASES_LOG( SERVER_IDENTITY VARCHAR(128) NOT NULL UNIQUE, RECOVERY_GROUP VARCHAR(128), LEASE_OWNER VARCHAR(128), LEASE_TIME NUMBER(19)) ";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create Oracle Table using: " + oracleTableString), (Object[])new Object[0]);
                }
                createTableStmt.executeUpdate(oracleTableString);
            } else if (this._isPostgreSQL) {
                String postgreSQLTableString = "CREATE TABLE WAS_LEASES_LOG( SERVER_IDENTITY VARCHAR (128) UNIQUE NOT NULL, RECOVERY_GROUP VARCHAR (128) NOT NULL, LEASE_OWNER VARCHAR (128) NOT NULL, LEASE_TIME BIGINT);";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create PostgreSQL Table using: " + postgreSQLTableString), (Object[])new Object[0]);
                }
                conn.rollback();
                createTableStmt.execute(postgreSQLTableString);
                String postgresqlIndexString = "CREATE INDEX IXWS_LEASE ON WAS_LEASES_LOG( SERVER_IDENTITY ASC) ";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create SQL Server index using: " + postgresqlIndexString), (Object[])new Object[0]);
                }
                createTableStmt.execute(postgresqlIndexString);
            } else {
                String genericTableString = "CREATE TABLE WAS_LEASES_LOG( SERVER_IDENTITY VARCHAR(128) NOT NULL UNIQUE, RECOVERY_GROUP VARCHAR(128), LEASE_OWNER VARCHAR(128), LEASE_TIME BIGINT) ";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create Generic Table using: " + genericTableString), (Object[])new Object[0]);
                }
                createTableStmt.executeUpdate(genericTableString);
                String genericIndexString = "CREATE INDEX IXWS_LEASE ON WAS_LEASES_LOG( \"SERVER_IDENTITY\" ASC) ";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create SQL Server index using: " + genericIndexString), (Object[])new Object[0]);
                }
                createTableStmt.execute(genericIndexString);
            }
        }
        finally {
            if (createTableStmt != null && !createTableStmt.isClosed()) {
                createTableStmt.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createLeaseTable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int dropLeaseTableIfEmpty() throws SQLException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"dropLeaseTableIfEmpty", (Object[])new Object[]{this});
        }
        Connection conn = null;
        Statement dropTableStmt = null;
        Exception currentEx = null;
        int rowCount = 99;
        int dropReturn = 0;
        try {
            try {
                conn = this.getConnection();
                if (conn == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"dropLeaseTableIfEmpty", (Object[])new Object[]{"Null connection for table drop"});
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Set autocommit FALSE on the connection", (Object[])new Object[0]);
                    }
                    conn.setAutoCommit(false);
                    dropTableStmt = conn.createStatement();
                    String queryString = "SELECT COUNT(*) AS recordCount FROM WAS_LEASES_LOG";
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Attempt to check for an empty table using - " + queryString), (Object[])new Object[0]);
                    }
                    this._updatelockingRS = dropTableStmt.executeQuery(queryString);
                    this._updatelockingRS.next();
                    rowCount = this._updatelockingRS.getInt("recordCount");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Number of rows in table is " + rowCount), (Object[])new Object[0]);
                    }
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Query failed with exception: " + e), (Object[])new Object[0]);
                }
                currentEx = e;
            }
            if (rowCount == 0 && currentEx == null) {
                if (this._updatelockingRS != null) {
                    this._updatelockingRS.close();
                }
                if (dropTableStmt != null && !dropTableStmt.isClosed()) {
                    dropTableStmt.close();
                }
                if (conn != null) {
                    conn.commit();
                    conn.close();
                }
                if ((conn = this.getConnection()) == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"dropLeaseTableIfEmpty", (Object[])new Object[]{"Null connection for table drop"});
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Set autocommit FALSE on the connection", (Object[])new Object[0]);
                    }
                    conn.setAutoCommit(false);
                    dropTableStmt = conn.createStatement();
                    String dropTableString = "DROP TABLE WAS_LEASES_LOG";
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Drop table using: " + dropTableString), (Object[])new Object[0]);
                    }
                    dropReturn = dropTableStmt.executeUpdate(dropTableString);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Commit the change", (Object[])new Object[0]);
                    }
                    conn.commit();
                }
            }
        }
        finally {
            if (this._updatelockingRS != null) {
                this._updatelockingRS.close();
            }
            if (dropTableStmt != null && !dropTableStmt.isClosed()) {
                dropTableStmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"dropLeaseTableIfEmpty", (Object)dropReturn);
        }
        return dropReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={SQLException.class, SQLRecoverableException.class})
    public synchronized void deleteServerLease(String recoveryIdentity, boolean isPeerServer) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteServerLease", (Object[])new Object[]{recoveryIdentity, isPeerServer, this});
        }
        Connection conn = null;
        boolean deleteSuccess = false;
        Throwable nonTransientException = null;
        SQLException currentSqlEx = null;
        try {
            conn = this.getConnection();
            if (conn == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"deleteServerLease", (Object)"Null connection InternalLogException");
                }
                throw new InternalLogException("Failed to get JDBC Connection", null);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Set autocommit FALSE on the connection", (Object[])new Object[0]);
            }
            conn.setAutoCommit(false);
            int ret = this.deleteLeaseFromTable(recoveryIdentity, conn);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Have deleted row with return: " + ret + ", commit the change"), (Object[])new Object[0]);
            }
            conn.commit();
            deleteSuccess = true;
        }
        catch (SQLException sqlex) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The server is stopping, lease delete failed for server with identity: " + recoveryIdentity + ", exception: " + sqlex), (Object[])new Object[0]);
                }
            } else {
                Tr.audit((TraceComponent)tc, (String)("WTRN0107W: Caught SQLException when deleting lease for server with identity: " + recoveryIdentity + ", exception: " + sqlex), (Object[])new Object[0]);
            }
            currentSqlEx = sqlex;
        }
        catch (Throwable exc) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The server is stopping, lease delete failed for server with identity: " + recoveryIdentity + ", exception: " + exc), (Object[])new Object[0]);
                }
            } else {
                Tr.audit((TraceComponent)tc, (String)("WTRN0107W: Caught non-SQLException Throwable when deleting lease for server with identity: " + recoveryIdentity + ", exception: " + exc), (Object[])new Object[0]);
            }
            nonTransientException = exc;
        }
        finally {
            if (!deleteSuccess) {
                try {
                    if (this._deleteStmt != null && !this._deleteStmt.isClosed()) {
                        this._deleteStmt.close();
                    }
                    if (conn != null) {
                        conn.rollback();
                        conn.close();
                    }
                }
                catch (Throwable exc) {
                    if (FrameworkState.isStopping()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("The server is stopping. Tidy up failed, after lease delete failure, with exception: " + exc), (Object[])new Object[0]);
                        }
                    }
                    Tr.audit((TraceComponent)tc, (String)("WTRN0107W: Tidy up failed, after lease delete failure, with exception: " + exc), (Object[])new Object[0]);
                }
                if (FrameworkState.isStopping()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"deleteServerLease", (Object)"server stopping");
                    }
                    return;
                }
                boolean failAndReport = true;
                if (currentSqlEx != null) {
                    nonTransientException = currentSqlEx;
                    DeleteServerLeaseRetry deleteServerLeaseRetry = new DeleteServerLeaseRetry(recoveryIdentity);
                    deleteServerLeaseRetry.setNonTransientException(currentSqlEx);
                    if (this._sqlTransientErrorHandlingEnabled && (failAndReport = deleteServerLeaseRetry.retryAfterSQLException(this, currentSqlEx, SQLRetry.getLightweightRetryAttempts(), SQLRetry.getLightweightRetrySleepTime()))) {
                        nonTransientException = deleteServerLeaseRetry.getNonTransientException();
                    }
                }
                if (failAndReport) {
                    Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Cannot recover from SQLException when deleting server lease for server with identity " + recoveryIdentity + " Exception: " + nonTransientException), (Object[])new Object[0]);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"deleteServerLease", (Object)"InternalLogException");
                    }
                    throw new InternalLogException(nonTransientException);
                }
                Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Have recovered from SQLException when deleting server lease for server with identity " + recoveryIdentity), (Object[])new Object[0]);
                if (!isPeerServer) {
                    int dropReturn = this.dropLeaseTableIfEmpty();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Have dropped table with return: " + dropReturn), (Object[])new Object[0]);
                    }
                }
            } else if (!isPeerServer) {
                if (this._deleteStmt != null && !this._deleteStmt.isClosed()) {
                    this._deleteStmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
                int dropReturn = this.dropLeaseTableIfEmpty();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Have dropped table with return: " + dropReturn), (Object[])new Object[0]);
                }
            }
            if (this._deleteStmt != null && !this._deleteStmt.isClosed()) {
                this._deleteStmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteServerLease");
        }
    }

    private int deleteLeaseFromTable(String recoveryIdentity, Connection conn) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteLeaseFromTable", (Object[])new Object[]{recoveryIdentity, conn, this});
        }
        this._deleteStmt = conn.createStatement();
        String deleteString = "DELETE FROM WAS_LEASES_LOG" + (this._isSQLServer ? " WITH (ROWLOCK, UPDLOCK, HOLDLOCK)" : "") + " WHERE SERVER_IDENTITY='" + recoveryIdentity + "'";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("delete server lease for " + recoveryIdentity + "using string " + deleteString), (Object[])new Object[0]);
        }
        int ret = this._deleteStmt.executeUpdate(deleteString);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteLeaseFromTable", (Object)ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={SQLException.class, SQLRecoverableException.class})
    public synchronized boolean claimPeerLeaseForRecovery(String recoveryIdentityToRecover, String myRecoveryIdentity, LeaseInfo leaseInfo) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"claimPeerLeaseForRecovery", (Object[])new Object[]{recoveryIdentityToRecover, myRecoveryIdentity, leaseInfo, this});
        }
        boolean peerClaimed = false;
        boolean peerClaimSuccess = false;
        Connection conn = null;
        Throwable nonTransientException = null;
        SQLException currentSqlEx = null;
        if (FrameworkState.isStopping()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"claimPeerLeaseForRecovery", (Object)"server stopping");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Recovering server with recoveryIdentity - ", (Object[])new Object[]{recoveryIdentityToRecover});
        }
        try {
            conn = this.getConnection();
            if (conn == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"claimPeerLeaseForRecovery", (Object)"Null connection InternalLogException");
                }
                throw new InternalLogException("Failed to get JDBC Connection", null);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Set autocommit FALSE on the connection", (Object[])new Object[0]);
            }
            conn.setAutoCommit(false);
            peerClaimed = this.claimPeerLeaseFromTable(recoveryIdentityToRecover, myRecoveryIdentity, leaseInfo, conn);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"COMMIT the change", (Object[])new Object[0]);
            }
            conn.commit();
            peerClaimSuccess = true;
        }
        catch (SQLException sqlex) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The server is stopping, caught SQLException for server with recovery identity " + myRecoveryIdentity + " when claiming peer lease for server with recovery identity " + recoveryIdentityToRecover + ", exception: " + sqlex), (Object[])new Object[0]);
                }
            } else {
                Tr.audit((TraceComponent)tc, (String)("WTRN0107W: Caught SQLException for server with recovery identity " + myRecoveryIdentity + " when claiming peer lease for server with recovery identity " + recoveryIdentityToRecover + ", exception: " + sqlex), (Object[])new Object[0]);
            }
            currentSqlEx = sqlex;
        }
        catch (Throwable exc) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The server is stopping, caught non-SQLException Throwable for server with recovery identity " + myRecoveryIdentity + " when claiming peer lease for server with recovery identity " + recoveryIdentityToRecover + ", exception: " + exc), (Object[])new Object[0]);
                }
            } else {
                Tr.audit((TraceComponent)tc, (String)("WTRN0107W: Caught non-SQLException Throwable for server with recovery identity " + myRecoveryIdentity + " when claiming peer lease for server with recovery identity " + recoveryIdentityToRecover + ", exception: " + exc), (Object[])new Object[0]);
            }
            nonTransientException = exc;
        }
        finally {
            if (!peerClaimSuccess) {
                try {
                    if (this._claimPeerLockingRS != null && !this._claimPeerLockingRS.isClosed()) {
                        this._claimPeerLockingRS.close();
                    }
                    if (this._claimPeerlockingStmt != null && !this._claimPeerlockingStmt.isClosed()) {
                        this._claimPeerlockingStmt.close();
                    }
                    if (this._claimPeerUpdateStmt != null && !this._claimPeerUpdateStmt.isClosed()) {
                        this._claimPeerUpdateStmt.close();
                    }
                    if (conn != null) {
                        conn.rollback();
                        conn.close();
                    }
                }
                catch (Throwable exc) {
                    if (FrameworkState.isStopping()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("The server is stopping. Tidy up failed, after lease claim failure, with exception: " + exc), (Object[])new Object[0]);
                        }
                    }
                    Tr.audit((TraceComponent)tc, (String)("WTRN0107W: Tidy up failed, after lease claim failure, with exception: " + exc), (Object[])new Object[0]);
                }
                if (FrameworkState.isStopping()) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"claimPeerLeaseForRecovery", (Object)"server stopping");
                    }
                    return false;
                }
                boolean failAndReport = true;
                if (currentSqlEx != null) {
                    nonTransientException = currentSqlEx;
                    ClaimPeerLeaseRetry claimPeerLeaseRetry = new ClaimPeerLeaseRetry(recoveryIdentityToRecover, myRecoveryIdentity, leaseInfo);
                    claimPeerLeaseRetry.setNonTransientException(currentSqlEx);
                    if (this._sqlTransientErrorHandlingEnabled && (failAndReport = claimPeerLeaseRetry.retryAfterSQLException(this, currentSqlEx, SQLRetry.getLightweightRetryAttempts(), SQLRetry.getLightweightRetrySleepTime()))) {
                        nonTransientException = claimPeerLeaseRetry.getNonTransientException();
                    }
                    peerClaimed = claimPeerLeaseRetry.getPeerClaimed();
                }
                if (failAndReport) {
                    Tr.audit((TraceComponent)tc, (String)("WTRN0100E: Cannot recover from SQLException for server with recovery identity " + myRecoveryIdentity + "when claiming peer lease for server with recovery identity " + recoveryIdentityToRecover + ", Exception: " + nonTransientException), (Object[])new Object[0]);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getLeasesForPeers", (Object)"InternalLogException");
                    }
                    throw new InternalLogException(nonTransientException);
                }
                Tr.audit((TraceComponent)tc, (String)("WTRN0108I: Have recovered from SQLException for server with recovery identity " + myRecoveryIdentity + "when claiming peer lease for server with recovery identity " + recoveryIdentityToRecover + ", was peer claimed: " + peerClaimed), (Object[])new Object[0]);
            }
            if (this._claimPeerLockingRS != null && !this._claimPeerLockingRS.isClosed()) {
                this._claimPeerLockingRS.close();
            }
            if (this._claimPeerlockingStmt != null && !this._claimPeerlockingStmt.isClosed()) {
                this._claimPeerlockingStmt.close();
            }
            if (this._claimPeerUpdateStmt != null && !this._claimPeerUpdateStmt.isClosed()) {
                this._claimPeerUpdateStmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"claimPeerLeaseForRecovery");
        }
        return peerClaimed;
    }

    private boolean claimPeerLeaseFromTable(String recoveryIdentityToRecover, String myRecoveryIdentity, LeaseInfo leaseInfo, Connection conn) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"claimPeerLeaseFromTable", (Object[])new Object[]{recoveryIdentityToRecover, myRecoveryIdentity, leaseInfo, conn, this});
        }
        boolean peerClaimed = false;
        this._claimPeerlockingStmt = conn.createStatement();
        try {
            String queryString = "SELECT LEASE_TIME FROM WAS_LEASES_LOG" + (this._isSQLServer ? " WITH (ROWLOCK, UPDLOCK, HOLDLOCK)" : "") + " WHERE SERVER_IDENTITY='" + recoveryIdentityToRecover + "'" + (this._isSQLServer ? "" : " FOR UPDATE") + (this._isPostgreSQL || this._isSQLServer ? "" : " OF LEASE_TIME");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Attempt to select the row for UPDATE using - " + queryString), (Object[])new Object[0]);
            }
            this._claimPeerLockingRS = this._claimPeerlockingStmt.executeQuery(queryString);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Query failed with exception: " + e), (Object[])new Object[0]);
            }
            throw new InternalLogException("Failed to query the lease time, exc: " + e, null);
        }
        if (this._claimPeerLockingRS.next()) {
            PeerLeaseData pld;
            long storedLease = this._claimPeerLockingRS.getLong(1);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Acquired server row, stored lease value is: " + Utils.traceTime((long)storedLease)), (Object[])new Object[0]);
            }
            if ((pld = new PeerLeaseData(recoveryIdentityToRecover, storedLease, this._leaseTimeout)).isExpired()) {
                String updateString = "UPDATE WAS_LEASES_LOG SET LEASE_TIME = ?, LEASE_OWNER = ? WHERE SERVER_IDENTITY='" + recoveryIdentityToRecover + "'";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("update lease for " + recoveryIdentityToRecover), (Object[])new Object[0]);
                }
                this._claimPeerUpdateStmt = conn.prepareStatement(updateString);
                long fir1 = System.currentTimeMillis();
                this._claimPeerUpdateStmt.setLong(1, fir1);
                String columnString = myRecoveryIdentity + "," + this.getBackendURL();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Insert combined string " + columnString + " into LEASE_OWNER column"), (Object[])new Object[0]);
                }
                this._claimPeerUpdateStmt.setString(2, columnString);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Ready to UPDATE using string - " + updateString + " and time: " + Utils.traceTime((long)fir1)), (Object[])new Object[0]);
                }
                int ret = this._claimPeerUpdateStmt.executeUpdate();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Have updated server row with return: " + ret), (Object[])new Object[0]);
                }
                peerClaimed = true;
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Could not find lease in table", (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"claimPeerLeaseFromTable");
        }
        return peerClaimed;
    }

    public void setPeerRecoveryLeaseTimeout(int leaseTimeout) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setPeerRecoveryLeaseTimeout", (Object[])new Object[]{leaseTimeout});
        }
        this._leaseTimeout = leaseTimeout;
    }

    @Override
    public int prepareConnectionForBatch(Connection conn) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepareConnectionForBatch", (Object[])new Object[]{conn});
        }
        conn.setAutoCommit(false);
        int initialIsolation = 4;
        if (this._isDB2) {
            try {
                initialIsolation = conn.getTransactionIsolation();
                if (4 != initialIsolation && 8 != initialIsolation) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Transaction isolation level was " + initialIsolation + " , setting to TRANSACTION_REPEATABLE_READ"), (Object[])new Object[0]);
                    }
                    conn.setTransactionIsolation(4);
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("setTransactionIsolation to RR threw Exception. Transaction isolation level was " + initialIsolation + " "), (Object[])new Object[]{e});
                }
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.prepareConnectionForBatch", (String)"3668", (Object)this);
                if (!this.isolationFailureReported) {
                    this.isolationFailureReported = true;
                    Tr.warning((TraceComponent)tc, (String)"CWRLS0024_EXC_DURING_RECOVERY", (Object[])new Object[]{e});
                }
                initialIsolation = 4;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepareConnectionForBatch", (Object)initialIsolation);
        }
        return initialIsolation;
    }

    @Override
    public void closeConnectionAfterBatch(Connection conn, int initialIsolation) throws SQLException {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"closeConnectionAfterBatch", (Object[])new Object[]{conn, initialIsolation});
            }
            if (this._isDB2 && 4 != initialIsolation && 8 != initialIsolation) {
                try {
                    conn.setTransactionIsolation(initialIsolation);
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("setTransactionIsolation threw Exception. Specified transaction isolation level was " + initialIsolation + " "), (Object[])new Object[]{e});
                    }
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.SQLMultiScopeRecoveryLog.closeConnectionAfterBatch", (String)"3696", (Object)this);
                    if (this.isolationFailureReported) break block6;
                    this.isolationFailureReported = true;
                    Tr.warning((TraceComponent)tc, (String)"CWRLS0024_EXC_DURING_RECOVERY", (Object[])new Object[]{e});
                }
            }
        }
        conn.setAutoCommit(true);
        conn.close();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeConnectionAfterBatch");
        }
    }

    public String getBackendURL(String recoveryId) throws Exception {
        String URLString = null;
        try (Connection conn = this.getConnection();
             Statement stmt = conn.createStatement();){
            String queryString = "SELECT LEASE_OWNER FROM WAS_LEASES_LOG WHERE SERVER_IDENTITY = '" + recoveryId + "'";
            ResultSet rs = stmt.executeQuery(queryString);
            while (rs.next()) {
                int commaPos;
                String columnString = rs.getString(1);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Lease_owner column contained " + columnString), (Object[])new Object[0]);
                }
                if ((commaPos = columnString.indexOf(",")) > 0) {
                    URLString = columnString.substring(commaPos + 1);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("URLString is " + URLString), (Object[])new Object[0]);
            }
        }
        return URLString;
    }

    class GetPeerLeaseRetry
    extends SQLRetry {
        String _recoveryGroup;
        PeerLeaseTable _peerLeaseTable;

        public GetPeerLeaseRetry(PeerLeaseTable peerLeaseTable, String recoveryGroup) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"GetPeerLeaseRetry", (Object[])new Object[]{recoveryGroup, this});
            }
            this._recoveryGroup = recoveryGroup;
            this._peerLeaseTable = peerLeaseTable;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"GetPeerLeaseRetry", (Object)this);
            }
        }

        @Override
        public void retryCode(Connection conn) throws SQLException, Exception {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"GetPeerLeaseRetry.retryCode", (Object[])new Object[]{conn});
            }
            if (FrameworkState.isStopping()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"GetPeerLeaseRetry.retryCode", (Object)"server stopping");
                }
                return;
            }
            if (conn == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"GetPeerLeaseRetry.retryCode", (Object)"Null connection InternalLogException");
                }
                throw new InternalLogException("Failed to get JDBC Connection", null);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Set autocommit FALSE on the connection", (Object[])new Object[0]);
            }
            conn.setAutoCommit(false);
            SQLSharedServerLeaseLog.this.getPeerLeasesFromTable(this._peerLeaseTable, this._recoveryGroup, conn);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"GetPeerLeaseRetry.retryCode");
            }
        }

        @Override
        public String getOperationDescription() {
            return "get peer lease";
        }
    }

    class UpdateServerLeaseRetry
    extends SQLRetry {
        String _recoveryIdentity;
        String _recoveryGroup;
        boolean _isServerStartup;

        public UpdateServerLeaseRetry(String recoveryIdentity, String recoveryGroup, boolean isServerStartup) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"UpdateServerLeaseRetry", (Object[])new Object[]{recoveryIdentity, recoveryGroup, isServerStartup, this});
            }
            this._recoveryIdentity = recoveryIdentity;
            this._recoveryGroup = recoveryGroup;
            this._isServerStartup = isServerStartup;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"UpdateServerLeaseRetry", (Object)this);
            }
        }

        @Override
        public void retryCode(Connection conn) throws SQLException, Exception {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"UpdateServerLeaseRetry.retryCode", (Object[])new Object[]{conn});
            }
            if (FrameworkState.isStopping()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"UpdateServerLeaseRetry.retryCode", (Object)"server stopping");
                }
                return;
            }
            if (conn == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"UpdateServerLeaseRetry.retryCode", (Object)"Null connection InternalLogException");
                }
                throw new InternalLogException("Failed to get JDBC Connection", null);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Set autocommit FALSE on the connection", (Object[])new Object[0]);
            }
            conn.setAutoCommit(false);
            boolean newTable = SQLSharedServerLeaseLog.this.queryLeaseTable(this._recoveryIdentity, conn, this._isServerStartup);
            if (FrameworkState.isStopping()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"UpdateServerLeaseRetry.retryCode", (Object)this);
                }
                return;
            }
            boolean needInsert = true;
            if (!newTable) {
                needInsert = SQLSharedServerLeaseLog.this.updateLeaseTable(this._recoveryIdentity, this._recoveryGroup, conn, this._isServerStartup);
            }
            if (needInsert) {
                if (!FrameworkState.isStopping()) {
                    SQLSharedServerLeaseLog.this.insertNewLease(this._recoveryIdentity, this._recoveryGroup, conn);
                } else {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"UpdateServerLeaseRetry.retryCode", (Object)"skip insert server is stopping");
                    }
                    return;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"UpdateServerLeaseRetry.retryCode");
            }
        }

        @Override
        public String getOperationDescription() {
            return "updating server lease";
        }
    }

    class DeleteServerLeaseRetry
    extends SQLRetry {
        String _recoveryIdentity;

        public DeleteServerLeaseRetry(String recoveryIdentity) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"DeleteServerLeaseRetry", (Object[])new Object[]{recoveryIdentity, this});
            }
            this._recoveryIdentity = recoveryIdentity;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"DeleteServerLeaseRetry", (Object)this);
            }
        }

        @Override
        public void retryCode(Connection conn) throws SQLException, Exception {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"DeleteServerLeaseRetry.retryCode", (Object[])new Object[]{conn});
            }
            if (FrameworkState.isStopping()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"DeleteServerLeaseRetry.retryCode", (Object)"server stopping");
                }
                return;
            }
            if (conn == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"DeleteServerLeaseRetry.retryCode", (Object)"Null connection InternalLogException");
                }
                throw new InternalLogException("Failed to get JDBC Connection", null);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Set autocommit FALSE on the connection", (Object[])new Object[0]);
            }
            conn.setAutoCommit(false);
            int ret = SQLSharedServerLeaseLog.this.deleteLeaseFromTable(this._recoveryIdentity, conn);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Have deleted row with return: " + ret + ", commit the change"), (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"DeleteServerLeaseRetry.retryCode");
            }
        }

        @Override
        public String getOperationDescription() {
            return "delete server lease";
        }
    }

    class ClaimPeerLeaseRetry
    extends SQLRetry {
        String _recoveryIdentityToRecover;
        String _myRecoveryIdentity;
        LeaseInfo _leaseInfo;
        boolean _peerClaimed = false;

        public ClaimPeerLeaseRetry(String recoveryIdentityToRecover, String myRecoveryIdentity, LeaseInfo leaseInfo) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"ClaimPeerLeaseRetry", (Object[])new Object[]{recoveryIdentityToRecover, myRecoveryIdentity, leaseInfo, this});
            }
            this._recoveryIdentityToRecover = recoveryIdentityToRecover;
            this._myRecoveryIdentity = myRecoveryIdentity;
            this._leaseInfo = leaseInfo;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ClaimPeerLeaseRetry", (Object)this);
            }
        }

        @Override
        public void retryCode(Connection conn) throws SQLException, Exception {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"ClaimPeerLeaseRetry.retryCode", (Object[])new Object[]{conn});
            }
            if (FrameworkState.isStopping()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"ClaimPeerLeaseRetry.retryCode", (Object)"server stopping");
                }
                return;
            }
            if (conn == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"ClaimPeerLeaseRetry.retryCode", (Object)"Null connection InternalLogException");
                }
                throw new InternalLogException("Failed to get JDBC Connection", null);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Set autocommit FALSE on the connection", (Object[])new Object[0]);
            }
            conn.setAutoCommit(false);
            this._peerClaimed = SQLSharedServerLeaseLog.this.claimPeerLeaseFromTable(this._recoveryIdentityToRecover, this._myRecoveryIdentity, this._leaseInfo, conn);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"ClaimPeerLeaseRetry.retryCode");
            }
        }

        boolean getPeerClaimed() {
            return this._peerClaimed;
        }

        @Override
        public String getOperationDescription() {
            return "claim peer server lease";
        }
    }
}

